/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiIntAttributeKey;
import com.maplesoft.mathdoc.model.math.WmiMathAttributeSet;
import com.maplesoft.util.WmiStringParseTools;
import java.awt.Color;
import java.util.regex.Pattern;

public abstract class WmiColorAttributeKey
extends WmiIntAttributeKey {
    private static Pattern hex = Pattern.compile("0?[#xX][0-9a-fA-F]{6}");

    public WmiColorAttributeKey(String string, int n) {
        super(string, n);
    }

    public WmiColorAttributeKey(String string, int n, int n2) {
        super(string, n, n2);
    }

    public String getStringValue(WmiAttributeSet wmiAttributeSet) {
        int n = this.getIntValue(wmiAttributeSet);
        return WmiColorAttributeKey.createRGBStringFromColorIndex(n);
    }

    public Object getValue(WmiAttributeSet wmiAttributeSet) {
        return this.getStringValue(wmiAttributeSet);
    }

    public void setStringValue(WmiAttributeSet wmiAttributeSet, String string) {
        int n = WmiColorAttributeKey.createColorIndexFromRGBString(string);
        if (n == -1) {
            n = WmiColorAttributeKey.createColorIndexFromHexString(string);
        }
        if (n == -1) {
            n = WmiColorAttributeKey.createColorIndexFromColorName(string);
        }
        if (n == -1) {
            n = this.getDefaultValue();
        }
        this.setIntValue(wmiAttributeSet, n);
    }

    public void setValue(WmiAttributeSet wmiAttributeSet, Object object) {
        if (object instanceof Color) {
            this.setIntValue(wmiAttributeSet, ((Color)object).getRGB());
        } else {
            super.setValue(wmiAttributeSet, object);
        }
    }

    public static int createColorIndexFromRGBString(String string) {
        int n = -1;
        try {
            int n2 = 1;
            int n3 = string.indexOf(44);
            if (n3 > 0) {
                int n4 = WmiStringParseTools.parseInt(string, n2, n3);
                n2 = n3 + 1;
                if ((n3 = string.indexOf(44, n2)) > 0) {
                    int n5 = WmiStringParseTools.parseInt(string, n2, n3);
                    n2 = n3 + 1;
                    if ((n3 = string.indexOf(93, n2)) > 0) {
                        int n6 = WmiStringParseTools.parseInt(string, n2, n3);
                        n = (n4 << 16) + (n5 << 8) + n6;
                    }
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            WmiErrorLog.log(numberFormatException);
        }
        return n;
    }

    public static int createColorIndexFromColorName(String string) {
        String string2 = WmiMathAttributeSet.getColour(string);
        if (string2.equals("")) {
            return -1;
        }
        return WmiColorAttributeKey.createColorIndexFromHexString(string2);
    }

    public static int createColorIndexFromHexString(String string) {
        int n = -1;
        if (hex.matcher(string = string.toUpperCase()).matches()) {
            int n2 = 1;
            if (string.startsWith("0")) {
                // empty if block
            }
            int n3 = ++n2;
            int n4 = ++n2;
            int n5 = WmiColorAttributeKey.hexToDec(string.charAt(n3)) * 16 + WmiColorAttributeKey.hexToDec(string.charAt(n4));
            int n6 = ++n2;
            int n7 = ++n2;
            int n8 = WmiColorAttributeKey.hexToDec(string.charAt(n6)) * 16 + WmiColorAttributeKey.hexToDec(string.charAt(n7));
            int n9 = ++n2;
            int n10 = ++n2;
            ++n2;
            int n11 = WmiColorAttributeKey.hexToDec(string.charAt(n9)) * 16 + WmiColorAttributeKey.hexToDec(string.charAt(n10));
            n = (n5 << 16) + (n8 << 8) + n11;
        }
        return n;
    }

    private static int hexToDec(char c) {
        int n = 0;
        if (c >= '0' && c <= '9') {
            n = c - 48;
        } else if (c >= 'a' && c <= 'f') {
            c = (char)97;
            n = 97 + 10;
        } else if (c >= 'A' && c <= 'F') {
            n = c - 65 + 10;
        }
        return n;
    }

    public static String createRGBHexStringFromColor(Color color) {
        return WmiColorAttributeKey.createRGBHexStringFromColorTriplet(color.getRed(), color.getGreen(), color.getBlue());
    }

    public static String createRGBHexStringFromColorIndex(int n) {
        return WmiColorAttributeKey.createRGBHexStringFromColorTriplet(n >> 16 & 0xFF, n >> 8 & 0xFF, n & 0xFF);
    }

    public static String createRGBHexStringFromColorTriplet(int n, int n2, int n3) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = Integer.toHexString(n);
        if (string.length() == 1) {
            stringBuffer.append('0');
        }
        stringBuffer.append(string);
        String string2 = Integer.toHexString(n2);
        if (string2.length() == 1) {
            stringBuffer.append('0');
        }
        stringBuffer.append(string2);
        String string3 = Integer.toHexString(n3);
        if (string3.length() == 1) {
            stringBuffer.append('0');
        }
        stringBuffer.append(string3);
        return stringBuffer.toString();
    }

    public static String createRGBStringFromColorIndex(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        stringBuffer.append(n >> 16 & 0xFF);
        stringBuffer.append(",");
        stringBuffer.append(n >> 8 & 0xFF);
        stringBuffer.append(",");
        stringBuffer.append(n & 0xFF);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public static String createRGBStringFromColor(Color color) {
        StringBuffer stringBuffer = new StringBuffer("[");
        stringBuffer.append(color.getRed());
        stringBuffer.append("," + color.getGreen());
        stringBuffer.append("," + color.getBlue() + "]");
        return stringBuffer.toString();
    }
}

