/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model;

import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.graphics.AbstractInheritedAttributeKey;

public abstract class WmiBooleanAttributeKey
extends AbstractInheritedAttributeKey {
    public static final String SET = "true";
    public static final String RESET = "false";
    private String name;
    protected boolean defaultValue;

    public WmiBooleanAttributeKey(String string, boolean bl) {
        this.name = string;
        this.defaultValue = bl;
    }

    public WmiBooleanAttributeKey(String string, boolean bl, int n) {
        super(n);
        this.name = string;
        this.defaultValue = bl;
    }

    public abstract boolean getBooleanValue(WmiAttributeSet var1);

    public boolean getDefaultValue() {
        return this.defaultValue;
    }

    public int getIntValue(WmiAttributeSet wmiAttributeSet) {
        return this.getBooleanValue(wmiAttributeSet) ? 1 : 0;
    }

    public float getFloatValue(WmiAttributeSet wmiAttributeSet) {
        return this.getBooleanValue(wmiAttributeSet) ? 1.0f : 0.0f;
    }

    public String getStringValue(WmiAttributeSet wmiAttributeSet) {
        return this.getBooleanValue(wmiAttributeSet) ? SET : RESET;
    }

    public Object getValue(WmiAttributeSet wmiAttributeSet) {
        return this.getBooleanValue(wmiAttributeSet) ? SET : RESET;
    }

    public abstract void setBooleanValue(WmiAttributeSet var1, boolean var2);

    public void setIntValue(WmiAttributeSet wmiAttributeSet, int n) {
        this.setBooleanValue(wmiAttributeSet, n != 0);
    }

    public void setFloatValue(WmiAttributeSet wmiAttributeSet, float f) {
        this.setBooleanValue(wmiAttributeSet, f != 0.0f);
    }

    public void setStringValue(WmiAttributeSet wmiAttributeSet, String string) {
        boolean bl = string == null ? this.defaultValue : string.compareToIgnoreCase(SET) == 0;
        this.setBooleanValue(wmiAttributeSet, bl);
    }

    public void setValue(WmiAttributeSet wmiAttributeSet, Object object) {
        if (object instanceof Boolean) {
            this.setBooleanValue(wmiAttributeSet, object.equals(Boolean.TRUE));
        } else if (object instanceof Integer) {
            this.setIntValue(wmiAttributeSet, (Integer)object);
        } else if (object instanceof Float) {
            this.setFloatValue(wmiAttributeSet, ((Float)object).floatValue());
        } else if (object != null) {
            this.setStringValue(wmiAttributeSet, object.toString());
        } else {
            this.setBooleanValue(wmiAttributeSet, this.defaultValue);
        }
    }

    public String getAttributeName() {
        return this.name;
    }

    public int getAttributeType() {
        return 0;
    }

    public String toString() {
        return this.getAttributeName();
    }
}

