/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoUpdateAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiGenericAttributeSet;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelLock;
import com.maplesoft.mathdoc.model.WmiModelObserver;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiUndoManager;
import com.maplesoft.mathdoc.model.WmiUndoableEdit;

public abstract class WmiAbstractModel
implements WmiModel,
Cloneable {
    private static boolean enableDiagnostic = false;
    protected WmiCompositeModel parent = null;
    protected WmiAbstractModel pending = null;
    protected WmiMathDocumentModel document = null;
    protected WmiAttributeSet attributes = null;
    private WmiModelObserver observer;

    protected WmiAbstractModel() {
    }

    protected WmiAbstractModel(WmiMathDocumentModel wmiMathDocumentModel) {
        this.document = wmiMathDocumentModel;
        this.pending = this;
        this.attributes = this.createCompatibleAttributeSet();
    }

    public static void scanForPendingModel(WmiModel wmiModel) throws WmiNoReadAccessException {
        if (wmiModel instanceof WmiAbstractModel && ((WmiAbstractModel)wmiModel).pending != null) {
            WmiErrorLog.log(new Exception("found model with pending update: " + wmiModel));
        }
        if (wmiModel instanceof WmiCompositeModel) {
            WmiCompositeModel wmiCompositeModel = (WmiCompositeModel)wmiModel;
            int n = wmiCompositeModel.getChildCount();
            for (int i = 0; i < n; ++i) {
                WmiAbstractModel.scanForPendingModel(wmiCompositeModel.getChild(i));
            }
        }
    }

    public void addObserver(WmiModelObserver wmiModelObserver) {
        if (this.observer == null) {
            this.observer = wmiModelObserver;
            wmiModelObserver.setNextObserver(null);
        } else if (!this.containsObserver(wmiModelObserver)) {
            wmiModelObserver.setNextObserver(this.observer);
            this.observer = wmiModelObserver;
        }
    }

    public boolean containsObserver(WmiModelObserver wmiModelObserver) {
        boolean bl = false;
        for (WmiModelObserver wmiModelObserver2 = this.observer; wmiModelObserver2 != null; wmiModelObserver2 = wmiModelObserver2.getNextObserver()) {
            if (wmiModelObserver2 != wmiModelObserver) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public void releaseObserver(WmiModelObserver wmiModelObserver) {
        if (this.observer == wmiModelObserver) {
            this.observer = wmiModelObserver.getNextObserver();
        } else {
            for (WmiModelObserver wmiModelObserver2 = this.observer; wmiModelObserver2 != null; wmiModelObserver2 = wmiModelObserver2.getNextObserver()) {
                WmiModelObserver wmiModelObserver3 = wmiModelObserver2.getNextObserver();
                if (wmiModelObserver3 != wmiModelObserver) continue;
                wmiModelObserver3 = wmiModelObserver3.getNextObserver();
                wmiModelObserver2.setNextObserver(wmiModelObserver3);
                break;
            }
        }
    }

    public WmiModelObserver getObserver() {
        return this.observer;
    }

    public void addAttribute(Object object, Object object2) throws WmiNoWriteAccessException {
        this.prepareForAttributeAddition();
        this.pending.attributes.addAttribute(object, object2);
    }

    public void addAttributes(WmiAttributeSet wmiAttributeSet) throws WmiNoWriteAccessException {
        this.prepareForAttributeAddition();
        this.pending.attributes.addAttributes(wmiAttributeSet);
    }

    protected void prepareForAttributeAddition() throws WmiNoWriteAccessException {
        this.verifyWriteLock();
        this.createPendingModel();
        if (this.pending != null) {
            if (this.pending.attributes == null) {
                this.pending.attributes = this.createCompatibleAttributeSet();
            } else if (this.pending.attributes == this.attributes) {
                this.pending.attributes = this.attributes.copyAttributes();
            }
        } else {
            throw new WmiNoWriteAccessException(this);
        }
    }

    public WmiAttributeSet getAttributes() throws WmiNoReadAccessException {
        this.verifyReadLock();
        boolean bl = WmiModelLock.ownsWriteLock(this);
        WmiAttributeSet wmiAttributeSet = bl && this.pending != null ? this.pending.attributes : this.attributes;
        WmiAttributeSet wmiAttributeSet2 = null;
        if (wmiAttributeSet == null && bl) {
            try {
                this.createPendingModel();
            }
            catch (WmiNoWriteAccessException wmiNoWriteAccessException) {
                WmiErrorLog.log(wmiNoWriteAccessException);
            }
            if (this.pending != null) {
                if (this.pending.attributes == null) {
                    this.pending.attributes = this.createCompatibleAttributeSet();
                }
                wmiAttributeSet = this.pending.attributes;
            }
        }
        if (wmiAttributeSet != null) {
            wmiAttributeSet2 = wmiAttributeSet.copyAttributes();
        }
        return wmiAttributeSet2;
    }

    public WmiAttributeSet getAttributesForRead() throws WmiNoReadAccessException {
        WmiAttributeSet wmiAttributeSet = this.attributes;
        this.verifyReadLock();
        if (this.usePending() && this.pending.attributes != null) {
            wmiAttributeSet = this.pending.attributes;
        }
        return wmiAttributeSet;
    }

    public void setAttributes(WmiAttributeSet wmiAttributeSet) throws WmiNoWriteAccessException {
        this.verifyWriteLock();
        this.createPendingModel();
        if (this.pending != null) {
            this.pending.attributes = this.createCompatibleAttributeSet();
            this.pending.attributes.addAttributes(wmiAttributeSet);
        }
    }

    public void update(String string) throws WmiNoUpdateAccessException {
        this.verifyUpdateLock();
        if (this.pending != null) {
            WmiAbstractModelEdit wmiAbstractModelEdit = null;
            if (string != null) {
                this.getDocument().getUndoManager();
                wmiAbstractModelEdit = (WmiAbstractModelEdit)this.createUndoableEdit();
                wmiAbstractModelEdit.setPreupdateProperties(this.parent, this.attributes);
            }
            if (this.parent != this.pending.parent) {
                this.parent = this.pending.parent;
            }
            if (this.attributes != this.pending.attributes) {
                this.attributes = this.pending.attributes;
            }
            this.pending = null;
            if (wmiAbstractModelEdit != null) {
                wmiAbstractModelEdit.setPostupdateProperties(this.parent, this.attributes);
                WmiUndoManager wmiUndoManager = this.getDocument().getUndoManager();
                wmiUndoManager.addEdit(wmiAbstractModelEdit);
            }
        }
    }

    public void revert() throws WmiNoWriteAccessException {
        this.verifyWriteLock();
        this.pending = null;
    }

    public WmiUndoableEdit createUndoableEdit() {
        return new WmiAbstractModelEdit(this);
    }

    public void release() throws WmiNoWriteAccessException {
        this.parent = null;
        this.pending = null;
        this.document = null;
        this.attributes = null;
    }

    public WmiCompositeModel getParent() throws WmiNoReadAccessException {
        this.verifyReadLock();
        WmiCompositeModel wmiCompositeModel = this.usePending() ? this.pending.parent : this.parent;
        return wmiCompositeModel;
    }

    public void setParent(WmiCompositeModel wmiCompositeModel) throws WmiNoWriteAccessException {
        if (this.parent == null && this.pending == null) {
            this.parent = wmiCompositeModel;
        } else {
            this.verifyWriteLock();
            this.createPendingModel();
            if (this.pending == null) {
                throw new WmiNoWriteAccessException(this);
            }
            this.pending.parent = wmiCompositeModel;
        }
    }

    public WmiMathDocumentModel getDocument() {
        return this.document;
    }

    public boolean isCrossBoundarySubselectable() {
        return true;
    }

    public boolean isSubselectable() {
        return this.isCrossBoundarySubselectable();
    }

    public boolean isComposite() {
        return false;
    }

    protected final void verifyUpdateLock() throws WmiNoUpdateAccessException {
        if (enableDiagnostic && !WmiModelLock.hasLock(this, 2)) {
            throw new WmiNoUpdateAccessException(this);
        }
    }

    protected final void verifyWriteLock() throws WmiNoWriteAccessException {
        if (enableDiagnostic && this.pending != this && !WmiModelLock.ownsWriteLock(this)) {
            throw new WmiNoWriteAccessException(this);
        }
    }

    protected final void verifyReadLock() throws WmiNoReadAccessException {
        if (enableDiagnostic && this.pending != this) {
            boolean bl = WmiModelLock.ownsWriteLock(this);
            boolean bl2 = false;
            if (!bl) {
                bl2 = WmiModelLock.hasLock(this, 0);
            }
            if (!bl && !bl2) {
                throw new WmiNoReadAccessException(this);
            }
        }
    }

    protected final boolean usePending() {
        return this.pending != null && WmiModelLock.ownsWriteLock(this);
    }

    protected void createPendingModel() throws WmiNoWriteAccessException {
        if (this.pending == null) {
            boolean bl = false;
            WmiMathDocumentModel wmiMathDocumentModel = this.getDocument();
            if (wmiMathDocumentModel != null) {
                wmiMathDocumentModel.markDirty(this);
            }
            try {
                Object object = this.clone();
                if (object instanceof WmiAbstractModel) {
                    this.pending = (WmiAbstractModel)object;
                    bl = true;
                }
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                WmiErrorLog.log(cloneNotSupportedException);
            }
            if (!bl) {
                throw new WmiNoWriteAccessException(this);
            }
        }
    }

    protected WmiAttributeSet createCompatibleAttributeSet() {
        return new WmiGenericAttributeSet();
    }

    public String toString() {
        WmiModelTag wmiModelTag = this.getTag();
        return wmiModelTag == null ? this.getClass().getName() : wmiModelTag.toString();
    }

    public boolean isDeletionBoundary() throws WmiNoReadAccessException {
        return false;
    }

    public int kerningPoints() throws WmiNoReadAccessException {
        return 0;
    }

    protected static class WmiAbstractModelEdit
    implements WmiUndoableEdit {
        private WmiAbstractModel model;
        private WmiCompositeModel oldParent = null;
        private WmiCompositeModel newParent = null;
        private WmiAttributeSet oldAttributes = null;
        private WmiAttributeSet newAttributes = null;

        protected WmiAbstractModelEdit(WmiAbstractModel wmiAbstractModel) {
            this.model = wmiAbstractModel;
        }

        protected void setPreupdateProperties(WmiCompositeModel wmiCompositeModel, WmiAttributeSet wmiAttributeSet) {
            this.oldParent = wmiCompositeModel;
            this.oldAttributes = wmiAttributeSet;
        }

        protected void setPostupdateProperties(WmiCompositeModel wmiCompositeModel, WmiAttributeSet wmiAttributeSet) {
            this.newParent = wmiCompositeModel;
            this.newAttributes = wmiAttributeSet;
        }

        public void undo() throws WmiNoUpdateAccessException {
            this.model.verifyUpdateLock();
            this.model.parent = this.oldParent;
            this.model.attributes = this.oldAttributes;
            try {
                this.model.getDocument().notifyModelListeners(this.model, 0);
            }
            catch (WmiNoReadAccessException wmiNoReadAccessException) {
                WmiErrorLog.log(wmiNoReadAccessException);
            }
        }

        public void redo() throws WmiNoUpdateAccessException {
            this.model.verifyUpdateLock();
            this.model.parent = this.newParent;
            this.model.attributes = this.newAttributes;
            try {
                this.model.getDocument().notifyModelListeners(this.model, 0);
            }
            catch (WmiNoReadAccessException wmiNoReadAccessException) {
                WmiErrorLog.log(wmiNoReadAccessException);
            }
        }

        public WmiModel getModel() {
            return this.model;
        }

        public boolean containsAttributeEdit() {
            return this.oldAttributes != this.newAttributes;
        }
    }
}

