/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiInvalidModelInitializationException;
import com.maplesoft.mathdoc.exception.WmiModelIndexOutOfBoundsException;
import com.maplesoft.mathdoc.exception.WmiModelNoSuchChildException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiAbstractArrayCompositeModel;
import com.maplesoft.mathdoc.model.WmiCandidateModel;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiDeleteHandler;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelLock;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;

public abstract class WmiAbstractArrayCandidateModel
extends WmiAbstractArrayCompositeModel
implements WmiCandidateModel,
Cloneable {
    public static final float DEFAULT_CONFIDENCE = 1.0f;
    private static final boolean STRICT_CHILD_CHECKING = false;
    private CandidateComparator comparator = new CandidateComparator();
    private boolean sorted = true;
    private WmiModel selected = null;
    private HashMap confidences = new HashMap();

    protected WmiAbstractArrayCandidateModel(WmiMathDocumentModel wmiMathDocumentModel) {
        super(wmiMathDocumentModel);
    }

    protected WmiAbstractArrayCandidateModel(WmiMathDocumentModel wmiMathDocumentModel, WmiModel[] wmiModelArray) throws WmiInvalidModelInitializationException {
        super(wmiMathDocumentModel, wmiModelArray);
        this.sorted = false;
    }

    public void addChild(WmiModel wmiModel, float f) throws WmiNoWriteAccessException {
        this.setConfidence(wmiModel, f);
        super.appendChild(wmiModel);
        this.sorted = false;
    }

    public void changeConfidence(WmiModel wmiModel, float f) throws WmiNoWriteAccessException, WmiModelNoSuchChildException {
        this.verifyWriteLock();
        this.verifyModelInChildren(wmiModel);
        this.setConfidence(wmiModel, f);
        this.sorted = false;
    }

    public WmiModel getBestCandidate() throws WmiNoReadAccessException {
        this.verifyReadLock();
        if (this.selected != null) {
            return this.selected;
        }
        this.verifyChildrenSorted();
        return this.getChild(0);
    }

    public float getConfidence(WmiModel wmiModel) throws WmiNoReadAccessException, WmiModelNoSuchChildException {
        this.verifyModelInChildren(wmiModel);
        this.verifyReadLock();
        Object v = this.confidences.get(wmiModel);
        if (v instanceof Float) {
            return ((Float)v).floatValue();
        }
        return 0.0f;
    }

    public WmiCandidateModel merge(WmiCandidateModel wmiCandidateModel) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiCandidateModel wmiCandidateModel2 = null;
        try {
            wmiCandidateModel2 = (WmiCandidateModel)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException("error: subclasses of WmiAbstractArrayCandidateModel must be Cloneable in order to merge");
        }
        try {
            for (int i = 0; i < wmiCandidateModel.getChildCount(); ++i) {
                WmiModel wmiModel = wmiCandidateModel.getChild(i);
                wmiCandidateModel2.addChild(wmiModel, wmiCandidateModel.getConfidence(wmiModel));
            }
        }
        catch (WmiModelNoSuchChildException wmiModelNoSuchChildException) {
            WmiErrorLog.log(wmiModelNoSuchChildException);
        }
        return wmiCandidateModel2;
    }

    public void removeChildrenBelowConfidence(float f) throws WmiNoWriteAccessException {
        try {
            this.verifyWriteLock();
            this.verifyChildrenSorted();
            int n = -1;
            for (int i = 0; i < this.getChildCount(); ++i) {
                float f2 = this.getConfidence(this.getChild(i));
                if (!(f2 < f)) continue;
                n = i - 1;
                break;
            }
            this.removeChildrenBelowRank(n);
        }
        catch (WmiNoReadAccessException wmiNoReadAccessException) {
            WmiErrorLog.log(wmiNoReadAccessException);
        }
        catch (WmiModelNoSuchChildException wmiModelNoSuchChildException) {
            WmiErrorLog.log(wmiModelNoSuchChildException);
        }
    }

    public void removeChildrenBelowRank(int n) throws WmiNoWriteAccessException {
        try {
            this.verifyWriteLock();
            this.verifyChildrenSorted();
            int n2 = this.getChildCount();
            if (n >= 0 && n < n2) {
                this.replaceChildren(new WmiModel[0], n + 1, n2 - (n + 1));
            }
        }
        catch (WmiNoReadAccessException wmiNoReadAccessException) {
            WmiErrorLog.log(wmiNoReadAccessException);
        }
        catch (WmiModelIndexOutOfBoundsException wmiModelIndexOutOfBoundsException) {
            WmiErrorLog.log(wmiModelIndexOutOfBoundsException);
        }
    }

    public void replaceChild(WmiModel wmiModel, float f, WmiModel wmiModel2) throws WmiNoWriteAccessException, WmiModelNoSuchChildException {
        try {
            this.verifyWriteLock();
            this.verifyModelInChildren(wmiModel2);
            int n = this.indexOf(wmiModel2);
            this.setConfidence(wmiModel, f);
            this.replaceChild(wmiModel, n);
        }
        catch (WmiNoReadAccessException wmiNoReadAccessException) {
            WmiErrorLog.log(wmiNoReadAccessException);
        }
        catch (WmiModelIndexOutOfBoundsException wmiModelIndexOutOfBoundsException) {
            throw new WmiModelNoSuchChildException(this, wmiModel2);
        }
    }

    public void selectCandidate(WmiModel wmiModel) throws WmiNoWriteAccessException, WmiModelNoSuchChildException {
        this.verifyWriteLock();
        if (wmiModel != null) {
            this.verifyModelInChildren(wmiModel);
        }
        this.selected = wmiModel;
    }

    public void selectCandidate(int n) throws WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        try {
            this.verifyWriteLock();
            this.selected = this.getChild(n);
        }
        catch (WmiNoReadAccessException wmiNoReadAccessException) {
            WmiErrorLog.log(wmiNoReadAccessException);
        }
    }

    public void replaceChildren(WmiModel[] wmiModelArray, int n, int n2) throws WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        block6: {
            this.sorted = false;
            try {
                int n3;
                boolean bl = false;
                if (wmiModelArray != null) {
                    for (n3 = 0; n3 < wmiModelArray.length; ++n3) {
                        Object v;
                        if (wmiModelArray[n3] != null && !((v = this.confidences.get(wmiModelArray[n3])) instanceof Float)) {
                            this.setConfidence(wmiModelArray[n3], 1.0f);
                        }
                        if (this.selected == null || wmiModelArray[n3] != this.selected) continue;
                        bl = true;
                    }
                }
                if (n2 <= 0 || this.selected == null || bl) break block6;
                this.verifyChildrenSorted();
                n3 = Math.min(n + n2, this.getChildCount() - 1);
                for (int i = n; i < n3; ++i) {
                    if (this.getChild(i) != this.selected) continue;
                    this.selected = null;
                    break;
                }
            }
            catch (WmiNoReadAccessException wmiNoReadAccessException) {
                WmiErrorLog.log(wmiNoReadAccessException);
            }
        }
        super.replaceChildren(wmiModelArray, n, n2);
    }

    public WmiModel getChild(int n) throws WmiNoReadAccessException {
        this.verifyChildrenSorted();
        return super.getChild(n);
    }

    public void groupChildren(WmiCompositeModel wmiCompositeModel, int n, int n2) throws WmiModelIndexOutOfBoundsException, WmiNoWriteAccessException {
        this.groupChildren(wmiCompositeModel, 1.0f, n, n2);
    }

    public void groupChildren(WmiCompositeModel wmiCompositeModel, float f, int n, int n2) throws WmiModelIndexOutOfBoundsException, WmiNoWriteAccessException {
        try {
            this.verifyChildrenSorted();
        }
        catch (WmiNoReadAccessException wmiNoReadAccessException) {
            WmiErrorLog.log(wmiNoReadAccessException);
        }
        this.setConfidence(wmiCompositeModel, f);
        super.groupChildren(wmiCompositeModel, n, n2);
    }

    public int indexOf(WmiModel wmiModel) throws WmiNoReadAccessException {
        this.verifyChildrenSorted();
        return super.indexOf(wmiModel);
    }

    public void promoteChild(int n) throws WmiNoWriteAccessException {
        try {
            this.verifyChildrenSorted();
        }
        catch (WmiNoReadAccessException wmiNoReadAccessException) {
            WmiErrorLog.log(wmiNoReadAccessException);
        }
        super.promoteChild(n);
    }

    public void removeChild(int n) throws WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        try {
            this.verifyChildrenSorted();
        }
        catch (WmiNoReadAccessException wmiNoReadAccessException) {
            WmiErrorLog.log(wmiNoReadAccessException);
        }
        super.removeChild(n);
    }

    public void removeChildren(int n, int n2) throws WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        try {
            this.verifyChildrenSorted();
        }
        catch (WmiNoReadAccessException wmiNoReadAccessException) {
            WmiErrorLog.log(wmiNoReadAccessException);
        }
        super.removeChildren(n, n2);
    }

    public void replaceChild(WmiModel wmiModel, int n) throws WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        try {
            this.verifyChildrenSorted();
        }
        catch (WmiNoReadAccessException wmiNoReadAccessException) {
            WmiErrorLog.log(wmiNoReadAccessException);
        }
        super.replaceChild(wmiModel, n);
    }

    public void splitChild(int n, int n2) throws WmiNoWriteAccessException {
        try {
            this.verifyChildrenSorted();
        }
        catch (WmiNoReadAccessException wmiNoReadAccessException) {
            WmiErrorLog.log(wmiNoReadAccessException);
        }
        super.splitChild(n, n2);
    }

    protected void verifyChildrenSorted() throws WmiNoReadAccessException {
        if (!this.sorted) {
            this.sortChildren();
        }
    }

    protected void sortChildren() throws WmiNoReadAccessException {
        this.verifyReadLock();
        WmiModel[] wmiModelArray = this.getChildren();
        Arrays.sort(wmiModelArray, this.comparator);
        this.sorted = true;
    }

    protected void setConfidence(WmiModel wmiModel, float f) throws WmiNoWriteAccessException {
        this.verifyWriteLock();
        this.confidences.put(wmiModel, new Float(f));
    }

    protected void verifyModelInChildren(WmiModel wmiModel) throws WmiModelNoSuchChildException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object clone() throws CloneNotSupportedException {
        WmiAbstractArrayCandidateModel wmiAbstractArrayCandidateModel = null;
        RuntimeException runtimeException = null;
        try {
            Class<?> clazz = this.getClass();
            Constructor<?> constructor = clazz.getConstructor(WmiMathDocumentModel.class);
            wmiAbstractArrayCandidateModel = (WmiAbstractArrayCandidateModel)constructor.newInstance(this.getDocument());
            WmiModelLock.writeLock(this, true);
            int n = this.getChildCount();
            if (n > 0) {
                WmiModel[] wmiModelArray = this.getChildren();
                WmiModel[] wmiModelArray2 = new WmiModel[n];
                if (wmiModelArray != null) {
                    System.arraycopy(wmiModelArray, 0, wmiModelArray2, 0, n);
                    wmiAbstractArrayCandidateModel.addChildren(wmiModelArray2, 0);
                }
                wmiAbstractArrayCandidateModel.confidences = (HashMap)this.confidences.clone();
            }
        }
        catch (WmiNoReadAccessException wmiNoReadAccessException) {
            wmiNoReadAccessException.printStackTrace();
        }
        catch (WmiNoWriteAccessException wmiNoWriteAccessException) {
            wmiNoWriteAccessException.printStackTrace();
        }
        catch (WmiModelIndexOutOfBoundsException wmiModelIndexOutOfBoundsException) {
            wmiModelIndexOutOfBoundsException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            runtimeException = new RuntimeException("caught this exception in WmiAbArrCandidateModel.clone:" + exception + "\nEnsure that subclasses have a one-argument constructor " + "of the form: <init>( WmiMathDocumentModel model ).");
        }
        finally {
            WmiModelLock.writeUnlock(this);
        }
        if (runtimeException != null) {
            throw runtimeException;
        }
        return wmiAbstractArrayCandidateModel;
    }

    public WmiDeleteHandler getDeleteHandler() {
        return null;
    }

    public boolean isVisible() throws WmiNoReadAccessException {
        return true;
    }

    private class CandidateComparator
    implements Comparator {
        private CandidateComparator() {
        }

        public int compare(Object object, Object object2) {
            if (object == null && object2 == null) {
                return 0;
            }
            if (object == null && object2 instanceof WmiModel) {
                return 1;
            }
            if (object2 == null && object instanceof WmiModel) {
                return -1;
            }
            if (!(object instanceof WmiModel) || !(object2 instanceof WmiModel)) {
                throw new RuntimeException("trying to compare something that isn't a WmiModel:" + object + " and " + object2);
            }
            try {
                float f = WmiAbstractArrayCandidateModel.this.getConfidence((WmiModel)object);
                float f2 = WmiAbstractArrayCandidateModel.this.getConfidence((WmiModel)object2);
                if (f == f2) {
                    return 0;
                }
                if (f > f2) {
                    return -1;
                }
                return 1;
            }
            catch (WmiNoReadAccessException wmiNoReadAccessException) {
                throw new RuntimeException("caught a WmiNoReadAccessException during comparison");
            }
            catch (WmiModelNoSuchChildException wmiModelNoSuchChildException) {
                throw new RuntimeException("caught a WmiModelNoSuchChildException during comparison");
            }
        }

        public boolean equals(Object object) {
            return object instanceof CandidateComparator;
        }
    }
}

