/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.io.xml;

import com.maplesoft.mathdoc.exception.WmiModelException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.io.WmiImportAction;
import com.maplesoft.mathdoc.io.xml.WmiXMLImportParser;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class WmiXMLModelBuilder
implements ContentHandler {
    protected WmiXMLImportParser importParser;
    protected StringBuffer textBuffer = new StringBuffer();
    protected Stack openElements = new Stack();

    public WmiXMLModelBuilder(WmiXMLImportParser wmiXMLImportParser) {
        this.importParser = wmiXMLImportParser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flushCharacterBuffer() throws WmiNoReadAccessException, WmiNoWriteAccessException {
        if (this.textBuffer.length() > 0) {
            try {
                if (this.importParser != null) {
                    this.importParser.defineTextContent(this.textBuffer.toString());
                }
            }
            finally {
                this.textBuffer = new StringBuffer();
            }
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (n2 > 0 && !this.openElements.isEmpty()) {
            Object e = this.openElements.peek();
            if (this.importParser != null && this.importParser.getParseAction(e.toString()) != null) {
                this.textBuffer.append(cArray, n, n2);
            }
        }
    }

    public void endDocument() throws SAXException {
        try {
            this.flushCharacterBuffer();
            if (this.importParser != null) {
                this.importParser.closeRootModel();
            }
            this.openElements.clear();
        }
        catch (WmiModelException wmiModelException) {
            throw new SAXException(wmiModelException);
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        try {
            WmiImportAction wmiImportAction;
            this.flushCharacterBuffer();
            if (this.importParser != null && (wmiImportAction = this.importParser.getParseAction(string3)) != null) {
                wmiImportAction.endAction(this.importParser, string3);
            }
            if (!this.openElements.isEmpty()) {
                this.openElements.pop();
            }
        }
        catch (WmiModelException wmiModelException) {
            throw new SAXException(wmiModelException);
        }
    }

    public void endPrefixMapping(String string) throws SAXException {
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
    }

    public void processingInstruction(String string, String string2) throws SAXException {
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void skippedEntity(String string) throws SAXException {
    }

    public void startDocument() throws SAXException {
        this.textBuffer.setLength(0);
        this.openElements.clear();
        if (this.importParser != null) {
            this.importParser.openRootModel();
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        try {
            this.flushCharacterBuffer();
            if (this.importParser != null) {
                WmiImportAction wmiImportAction = this.importParser.getParseAction(string3);
                if (wmiImportAction == null) {
                    this.importParser.reportUnrecognizedTag(string3, attributes);
                } else {
                    wmiImportAction.beginAction(this.importParser, attributes);
                }
            }
            this.openElements.push(string3);
        }
        catch (WmiModelException wmiModelException) {
            throw new SAXException(wmiModelException);
        }
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
    }
}

