/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.io.mathml;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiInvalidModelInitializationException;
import com.maplesoft.mathdoc.exception.WmiModelIndexOutOfBoundsException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoUpdateAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.exception.WmiParseException;
import com.maplesoft.mathdoc.io.mathml.WmiMathMLEntityResolver;
import com.maplesoft.mathdoc.io.mathml.WmiMathMLModelBuilder;
import com.maplesoft.mathdoc.io.mathml.WmiMathMLParserModelBuilder;
import com.maplesoft.mathdoc.io.xml.WmiXMLImportParser;
import com.maplesoft.mathdoc.model.WmiAbstractArrayAttributeSet;
import com.maplesoft.mathdoc.model.WmiAbstractArrayCompositeMathModel;
import com.maplesoft.mathdoc.model.WmiAbstractArrayCompositeModel;
import com.maplesoft.mathdoc.model.WmiAbstractModel;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiFontAttributeSet;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiMathMLParagraphModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelLock;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiModelUtil;
import com.maplesoft.mathdoc.model.WmiParagraphModel;
import com.maplesoft.mathdoc.model.math.WmiAbstractMathTokenModel;
import com.maplesoft.mathdoc.model.math.WmiFractionModel;
import com.maplesoft.mathdoc.model.math.WmiIdentifierModel;
import com.maplesoft.mathdoc.model.math.WmiInlineMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathAlignGroupModel;
import com.maplesoft.mathdoc.model.math.WmiMathAlignMarkModel;
import com.maplesoft.mathdoc.model.math.WmiMathAttributeSet;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathEncloseModel;
import com.maplesoft.mathdoc.model.math.WmiMathErrorModel;
import com.maplesoft.mathdoc.model.math.WmiMathFactory;
import com.maplesoft.mathdoc.model.math.WmiMathFencedModel;
import com.maplesoft.mathdoc.model.math.WmiMathGlyphModel;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathOperatorDictionary;
import com.maplesoft.mathdoc.model.math.WmiMathOperatorModel;
import com.maplesoft.mathdoc.model.math.WmiMathPaddedModel;
import com.maplesoft.mathdoc.model.math.WmiMathPhantomModel;
import com.maplesoft.mathdoc.model.math.WmiMathSpaceModel;
import com.maplesoft.mathdoc.model.math.WmiMathStringModel;
import com.maplesoft.mathdoc.model.math.WmiMathStyleModel;
import com.maplesoft.mathdoc.model.math.WmiMathTableModel;
import com.maplesoft.mathdoc.model.math.WmiMathTokenModel;
import com.maplesoft.mathdoc.model.math.WmiMathWrapperModel;
import com.maplesoft.mathdoc.model.math.WmiNumericModel;
import com.maplesoft.mathdoc.model.math.WmiOverModel;
import com.maplesoft.mathdoc.model.math.WmiRootModel;
import com.maplesoft.mathdoc.model.math.WmiSubSupModel;
import com.maplesoft.mathdoc.model.math.WmiSubscriptModel;
import com.maplesoft.mathdoc.model.math.WmiSuperscriptModel;
import com.maplesoft.mathdoc.model.math.WmiUnderModel;
import com.maplesoft.mathdoc.model.math.WmiUnderOverModel;
import com.maplesoft.mathdoc.model.mathml.WmiMathMLTag;
import com.maplesoft.util.WmiMathEntityNameMapper;
import com.maplesoft.util.WmiXMLParserImplementation;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WmiMathMLImportParser
extends WmiXMLImportParser {
    private static final int DEFAULT_FONT_SIZE = 12;
    private static final Color DEFAULT_FOREGROUND_COLOR = Color.BLACK;
    public boolean captureApplyFunction = false;
    private Stack applyStack = new Stack();
    private HashMap declarationMap = new HashMap();
    public static String[][] functionNameList = new String[][]{{"lambda", "lambda"}, {"max", "max"}, {"min", "min"}, {"gcd", "gcd"}, {"arg", "arg"}, {"real", "&real;"}, {"imaginary", "imaginary"}, {"lcm", "lcm"}, {"sin", "sin"}, {"cos", "cos"}, {"tan", "tan"}, {"sec", "sec"}, {"csc", "csc"}, {"cot", "cot"}, {"sinh", "sinh"}, {"cosh", "cosh"}, {"tanh", "tanh"}, {"sech", "sech"}, {"csch", "csch"}, {"coth", "coth"}, {"arcsin", "arcsin"}, {"arccos", "arccos"}, {"arctan", "arctan"}, {"arccosh", "arccosh"}, {"arccot", "arccot"}, {"arccoth", "arccoth"}, {"arccsc", "arccsc"}, {"arccsch", "arccsch"}, {"arcsec", "arcsec"}, {"arcsech", "arcsech"}, {"arcsinh", "arcsinh"}, {"arctanh", "arctanh"}, {"ln", "ln"}, {"mean", "mean"}, {"median", "median"}, {"mode", "model"}, {"sdev", "sdev"}, {"variance", "variance"}};
    public static String[][] infixOperatorList = new String[][]{{"compose", "&compfn;"}, {"minus", "&minus;"}, {"plus", "&plus;"}, {"times", "&InvisibleTimes;"}, {"and", "&and;"}, {"or", "&or;"}, {"implies", "&Implies;"}, {"eq", "&equals;"}, {"neq", "&NotEqual;"}, {"gt", "&gt;"}, {"lt", "&lt;"}, {"geq", "&geq;"}, {"leq", "&leq;"}, {"equivalent", "&equiv;"}, {"approx", "&approx;"}, {"factorof", "&verbar;"}, {"union", "&Union;"}, {"intersect", "&Intersection;"}, {"in", "&in;"}, {"notin", "&notin;"}, {"subset", "&subseteq;"}, {"prsubset", "&subset;"}, {"notsubset", "&NotSubsetEqual;"}, {"notprsubset", "&nsub;"}, {"setdiff", "&Backslash;"}, {"cartesianproduct", "&times;"}, {"vectorproduct", "&times;"}, {"scalarproduct", "&period;"}, {"outerproduct", "&CircleTimes;"}, {"rem", "mod"}, {"xor", "xor"}};
    public static String[][] postfixOperatorList = new String[][]{{"factorial", "!"}};
    public static String[][] prefixOperatorList = new String[][]{{"not", "&not;"}, {"minus", "&minus;"}, {"grad", "&Del;"}};
    public static String[][] constantList = new String[][]{{"ident", "id"}, {"integers", "&integers;"}, {"reals", "&reals;"}, {"rationals", "&rationals;"}, {"naturalnumbers", "&naturals;"}, {"complexes", "&complexes;"}, {"primes", "&primes;"}, {"exponentiale", "&ExponentialE;"}, {"imaginaryi", "&ImaginaryI;"}, {"notanumber", "NaN"}, {"true", "true"}, {"false", "false"}, {"emptyset", "&empty;"}, {"pi", "&pi;"}, {"eulergamma", "&Gamma;"}, {"infinity", "&infin;"}};
    private static HashMap modelFactoryMap = new HashMap();

    public WmiMathMLImportParser() {
        this.xmlContentHandler = new WmiMathMLModelBuilder(this);
        this.parser = new WmiXMLParserImplementation(this.xmlContentHandler);
        this.parser.getXMLReader().setEntityResolver(new WmiMathMLEntityResolver());
    }

    protected void hashActions() {
        String string = "com.maplesoft.mathdoc.io.mathml";
        this.addAction(WmiMathMLTag.MATH, string, "WmiMathMLPresentationMathImportAction");
        this.addAction(WmiMathMLTag.MI, string, "WmiMathMLPresentationMiImportAction");
        this.addAction(WmiMathMLTag.MN, string, "WmiMathMLPresentationMnImportAction");
        this.addAction(WmiMathMLTag.MO, string, "WmiMathMLPresentationMoImportAction");
        this.addAction(WmiMathMLTag.MTEXT, string, "WmiMathMLPresentationMtextImportAction");
        this.addAction(WmiMathMLTag.MSPACE, string, "WmiMathMLPresentationMspaceImportAction");
        this.addAction(WmiMathMLTag.MS, string, "WmiMathMLPresentationMsImportAction");
        this.addAction(WmiMathMLTag.MGLYPH, string, "WmiMathMLPresentationMglyphImportAction");
        this.addAction(WmiMathMLTag.MROW, string, "WmiMathMLPresentationMrowImportAction");
        this.addAction(WmiMathMLTag.MENCLOSE, string, "WmiMathMLPresentationMencloseImportAction");
        this.addAction(WmiMathMLTag.MFRAC, string, "WmiMathMLPresentationMfracImportAction");
        this.addAction(WmiMathMLTag.MSQRT, string, "WmiMathMLPresentationMsqrtImportAction");
        this.addAction(WmiMathMLTag.MROOT, string, "WmiMathMLPresentationMrootImportAction");
        this.addAction(WmiMathMLTag.MSTYLE, string, "WmiMathMLPresentationMstyleImportAction");
        this.addAction(WmiMathMLTag.MERROR, string, "WmiMathMLPresentationMerrorImportAction");
        this.addAction(WmiMathMLTag.MPADDED, string, "WmiMathMLPresentationMpaddedImportAction");
        this.addAction(WmiMathMLTag.MPHANTOM, string, "WmiMathMLPresentationMphantomImportAction");
        this.addAction(WmiMathMLTag.MFENCED, string, "WmiMathMLPresentationMfencedImportAction");
        this.addAction(WmiMathMLTag.MSUB, string, "WmiMathMLPresentationMsubImportAction");
        this.addAction(WmiMathMLTag.MSUP, string, "WmiMathMLPresentationMsupImportAction");
        this.addAction(WmiMathMLTag.MSUBSUP, string, "WmiMathMLPresentationMsubsupImportAction");
        this.addAction(WmiMathMLTag.MUNDER, string, "WmiMathMLPresentationMunderImportAction");
        this.addAction(WmiMathMLTag.MOVER, string, "WmiMathMLPresentationMoverImportAction");
        this.addAction(WmiMathMLTag.MUNDEROVER, string, "WmiMathMLPresentationMunderoverImportAction");
        this.addAction(WmiMathMLTag.MMULTISCRIPTS, string, "WmiMathMLPresentationMmultiscriptsImportAction");
        this.addAction(WmiMathMLTag.MSCRIPTS, string, "WmiMathMLPresentationMmultiscriptsImportAction");
        this.addAction(WmiMathMLTag.MPRESCRIPTS, string, "WmiMathMLPresentationMmultiscriptsImportAction$WmiMathMLPresentationMprescriptsImportAction");
        this.addAction(WmiMathMLTag.MNONE, string, "WmiMathMLPresentationMmultiscriptsImportAction$WmiMathMLPresentationMnoneImportAction");
        this.addAction(WmiMathMLTag.MTABLE, string, "WmiMathMLPresentationMtableImportAction");
        this.addAction(WmiMathMLTag.MTR, string, "WmiMathMLPresentationMtableImportAction$WmiMathMLPresentationMtrImportAction");
        this.addAction(WmiMathMLTag.MLABELEDTR, string, "WmiMathMLPresentationMtableImportAction$WmiMathMLPresentationMlabeledtrImportAction");
        this.addAction(WmiMathMLTag.MTD, string, "WmiMathMLPresentationMtableImportAction$WmiMathMLPresentationMtdImportAction");
        this.addAction(WmiMathMLTag.MALIGNGROUP, string, "WmiMathMLPresentationMaligngroupImportAction");
        this.addAction(WmiMathMLTag.MALIGNMARK, string, "WmiMathMLPresentationMalignmarkImportAction");
        this.addAction(WmiMathMLTag.MACTION, string, "WmiMathMLPresentationMactionImportAction");
        this.addAction(WmiMathMLTag.CN, string, "WmiMathMLContentCnImportAction");
        this.addAction(WmiMathMLTag.SEP, string, "WmiMathMLContentSepImportAction");
        this.addAction(WmiMathMLTag.CI, string, "WmiMathMLContentCiImportAction");
        this.addAction(WmiMathMLTag.CSYMBOL, string, "WmiMathMLContentCsymbolImportAction");
        this.addAction(WmiMathMLTag.DECLARE, string, "WmiMathMLContentDeclareImportAction");
        this.addAction(WmiMathMLTag.APPLY, string, "WmiMathMLContentApplyImportAction");
        this.addAction(WmiMathMLTag.RELN, string, "WmiMathMLContentApplyImportAction");
        this.addAction(WmiMathMLTag.LAMBDA, string, "WmiMathMLContentLambdaImportAction");
        this.addAction(WmiMathMLTag.BVAR, string, "WmiMathMLContentBvarImportAction");
        this.addAction(WmiMathMLTag.DEGREE, string, "WmiMathMLContentDegreeImportAction");
        this.addAction("GenericFunction", string, "WmiMathMLContentFunctionImportAction");
        this.addAction(WmiMathMLTag.MAX, string, "WmiMathMLContentFunctionImportAction");
        this.addAction(WmiMathMLTag.MIN, string, "WmiMathMLContentFunctionImportAction");
        this.addAction(WmiMathMLTag.REM, string, "WmiMathMLContentFunctionImportAction");
        this.addAction(WmiMathMLTag.GCD, string, "WmiMathMLContentFunctionImportAction");
        this.addAction(WmiMathMLTag.ARG, string, "WmiMathMLContentFunctionImportAction");
        this.addAction(WmiMathMLTag.REAL, string, "WmiMathMLContentFunctionImportAction");
        this.addAction(WmiMathMLTag.IMAGINARY, string, "WmiMathMLContentFunctionImportAction");
        this.addAction(WmiMathMLTag.LCM, string, "WmiMathMLContentFunctionImportAction");
        this.addAction(WmiMathMLTag.INT, string, "WmiMathMLContentFunctionImportAction");
        this.addAction(WmiMathMLTag.SIN, string, "WmiMathMLContentFunctionImportAction");
        this.addAction(WmiMathMLTag.COS, string, "WmiMathMLContentFunctionImportAction");
        this.addAction(WmiMathMLTag.TAN, string, "WmiMathMLContentFunctionImportAction");
        this.addAction(WmiMathMLTag.SEC, string, "WmiMathMLContentFunctionImportAction");
        this.addAction(WmiMathMLTag.CSC, string, "WmiMathMLContentFunctionImportAction");
        this.addAction(WmiMathMLTag.COT, string, "WmiMathMLContentFunctionImportAction");
        this.addAction(WmiMathMLTag.SINH, string, "WmiMathMLContentFunctionImportAction");
        this.addAction(WmiMathMLTag.COSH, string, "WmiMathMLContentFunctionImportAction");
        this.addAction(WmiMathMLTag.TANH, string, "WmiMathMLContentFunctionImportAction");
        this.addAction(WmiMathMLTag.SECH, string, "WmiMathMLContentFunctionImportAction");
        this.addAction(WmiMathMLTag.CSCH, string, "WmiMathMLContentFunctionImportAction");
        this.addAction(WmiMathMLTag.COTH, string, "WmiMathMLContentFunctionImportAction");
        this.addAction(WmiMathMLTag.ARCSIN, string, "WmiMathMLContentFunctionImportAction");
        this.addAction(WmiMathMLTag.ARCCOS, string, "WmiMathMLContentFunctionImportAction");
        this.addAction(WmiMathMLTag.ARCTAN, string, "WmiMathMLContentFunctionImportAction");
        this.addAction(WmiMathMLTag.ARCCOSH, string, "WmiMathMLContentFunctionImportAction");
        this.addAction(WmiMathMLTag.ARCCOT, string, "WmiMathMLContentFunctionImportAction");
        this.addAction(WmiMathMLTag.ARCCOTH, string, "WmiMathMLContentFunctionImportAction");
        this.addAction(WmiMathMLTag.ARCCSC, string, "WmiMathMLContentFunctionImportAction");
        this.addAction(WmiMathMLTag.ARCCSCH, string, "WmiMathMLContentFunctionImportAction");
        this.addAction(WmiMathMLTag.ARCSEC, string, "WmiMathMLContentFunctionImportAction");
        this.addAction(WmiMathMLTag.ARCSECH, string, "WmiMathMLContentFunctionImportAction");
        this.addAction(WmiMathMLTag.ARCSINH, string, "WmiMathMLContentFunctionImportAction");
        this.addAction(WmiMathMLTag.ARCTANH, string, "WmiMathMLContentFunctionImportAction");
        this.addAction(WmiMathMLTag.LN, string, "WmiMathMLContentFunctionImportAction");
        this.addAction(WmiMathMLTag.CURL, string, "WmiMathMLContentFunctionImportAction");
        this.addAction(WmiMathMLTag.DIVERGENCE, string, "WmiMathMLContentFunctionImportAction");
        this.addAction(WmiMathMLTag.GRAD, string, "WmiMathMLContentFunctionImportAction");
        this.addAction(WmiMathMLTag.LAPLACIAN, string, "WmiMathMLContentFunctionImportAction");
        this.addAction(WmiMathMLTag.PLUS, string, "WmiMathMLContentOperatorImportAction");
        this.addAction(WmiMathMLTag.COMPOSE, string, "WmiMathMLContentOperatorImportAction");
        this.addAction(WmiMathMLTag.MINUS, string, "WmiMathMLContentOperatorImportAction");
        this.addAction(WmiMathMLTag.PLUS, string, "WmiMathMLContentOperatorImportAction");
        this.addAction(WmiMathMLTag.TIMES, string, "WmiMathMLContentOperatorImportAction");
        this.addAction(WmiMathMLTag.AND, string, "WmiMathMLContentOperatorImportAction");
        this.addAction(WmiMathMLTag.OR, string, "WmiMathMLContentOperatorImportAction");
        this.addAction(WmiMathMLTag.XOR, string, "WmiMathMLContentOperatorImportAction");
        this.addAction(WmiMathMLTag.IMPLIES, string, "WmiMathMLContentOperatorImportAction");
        this.addAction(WmiMathMLTag.EQ, string, "WmiMathMLContentOperatorImportAction");
        this.addAction(WmiMathMLTag.NEQ, string, "WmiMathMLContentOperatorImportAction");
        this.addAction(WmiMathMLTag.GT, string, "WmiMathMLContentOperatorImportAction");
        this.addAction(WmiMathMLTag.LT, string, "WmiMathMLContentOperatorImportAction");
        this.addAction(WmiMathMLTag.GEQ, string, "WmiMathMLContentOperatorImportAction");
        this.addAction(WmiMathMLTag.LEQ, string, "WmiMathMLContentOperatorImportAction");
        this.addAction(WmiMathMLTag.EQUIVALENT, string, "WmiMathMLContentOperatorImportAction");
        this.addAction(WmiMathMLTag.APPROX, string, "WmiMathMLContentOperatorImportAction");
        this.addAction(WmiMathMLTag.FACTOROF, string, "WmiMathMLContentOperatorImportAction");
        this.addAction(WmiMathMLTag.UNION, string, "WmiMathMLContentOperatorImportAction");
        this.addAction(WmiMathMLTag.INTERSECT, string, "WmiMathMLContentOperatorImportAction");
        this.addAction(WmiMathMLTag.IN, string, "WmiMathMLContentOperatorImportAction");
        this.addAction(WmiMathMLTag.NOTIN, string, "WmiMathMLContentOperatorImportAction");
        this.addAction(WmiMathMLTag.SUBSET, string, "WmiMathMLContentOperatorImportAction");
        this.addAction(WmiMathMLTag.PRSUBSET, string, "WmiMathMLContentOperatorImportAction");
        this.addAction(WmiMathMLTag.NOTSUBSET, string, "WmiMathMLContentOperatorImportAction");
        this.addAction(WmiMathMLTag.NOTPRSUBSET, string, "WmiMathMLContentOperatorImportAction");
        this.addAction(WmiMathMLTag.SETDIFF, string, "WmiMathMLContentOperatorImportAction");
        this.addAction(WmiMathMLTag.CARTESIANPRODUCT, string, "WmiMathMLContentOperatorImportAction");
        this.addAction(WmiMathMLTag.FACTORIAL, string, "WmiMathMLContentOperatorImportAction");
        this.addAction(WmiMathMLTag.IDENTITY, string, "WmiMathMLContentConstantImportAction");
        this.addAction(WmiMathMLTag.INTEGERS, string, "WmiMathMLContentConstantImportAction");
        this.addAction(WmiMathMLTag.REALS, string, "WmiMathMLContentConstantImportAction");
        this.addAction(WmiMathMLTag.RATIONALS, string, "WmiMathMLContentConstantImportAction");
        this.addAction(WmiMathMLTag.NATURALNUMBERS, string, "WmiMathMLContentConstantImportAction");
        this.addAction(WmiMathMLTag.COMPLEXES, string, "WmiMathMLContentConstantImportAction");
        this.addAction(WmiMathMLTag.PRIMES, string, "WmiMathMLContentConstantImportAction");
        this.addAction(WmiMathMLTag.EXPONENTIALE, string, "WmiMathMLContentConstantImportAction");
        this.addAction(WmiMathMLTag.IMAGINARYI, string, "WmiMathMLContentConstantImportAction");
        this.addAction(WmiMathMLTag.NOTANUMBER, string, "WmiMathMLContentConstantImportAction");
        this.addAction(WmiMathMLTag.TRUE, string, "WmiMathMLContentConstantImportAction");
        this.addAction(WmiMathMLTag.FALSE, string, "WmiMathMLContentConstantImportAction");
        this.addAction(WmiMathMLTag.EMPTYSET, string, "WmiMathMLContentConstantImportAction");
        this.addAction(WmiMathMLTag.PI, string, "WmiMathMLContentConstantImportAction");
        this.addAction(WmiMathMLTag.EULERGAMMA, string, "WmiMathMLContentConstantImportAction");
        this.addAction(WmiMathMLTag.INFINITY, string, "WmiMathMLContentConstantImportAction");
        this.addAction(WmiMathMLTag.INTERVAL, string, "WmiMathMLContentIntervalImportAction");
        this.addAction(WmiMathMLTag.LIST, string, "WmiMathMLContentListImportAction");
        this.addAction(WmiMathMLTag.SET, string, "WmiMathMLContentSetImportAction");
        this.addAction(WmiMathMLTag.ABS, string, "WmiMathMLContentFenceImportAction");
        this.addAction(WmiMathMLTag.CARD, string, "WmiMathMLContentFenceImportAction");
        this.addAction(WmiMathMLTag.FLOOR, string, "WmiMathMLContentFenceImportAction");
        this.addAction(WmiMathMLTag.CEILING, string, "WmiMathMLContentFenceImportAction");
        this.addAction(WmiMathMLTag.QUOTIENT, string, "WmiMathMLContentFenceImportAction");
        this.addAction(WmiMathMLTag.INVERSE, string, "WmiMathMLContentSuperscriptImportAction");
        this.addAction(WmiMathMLTag.POWER, string, "WmiMathMLContentSuperscriptImportAction");
        this.addAction(WmiMathMLTag.EXP, string, "WmiMathMLContentSuperscriptImportAction");
        this.addAction(WmiMathMLTag.TRANSPOSE, string, "WmiMathMLContentSuperscriptImportAction");
        this.addAction(WmiMathMLTag.CONDITION, string, "WmiMathMLContentConditionImportAction");
        this.addAction(WmiMathMLTag.DIVIDE, string, "WmiMathMLContentDivideImportAction");
        this.addAction(WmiMathMLTag.ROOT, string, "WmiMathMLContentRootImportAction");
        this.addAction(WmiMathMLTag.EXISTS, string, "WmiMathMLContentOperatorImportAction");
        this.addAction(WmiMathMLTag.FORALL, string, "WmiMathMLContentOperatorImportAction");
        this.addAction(WmiMathMLTag.NOT, string, "WmiMathMLContentOperatorImportAction");
        this.addAction(WmiMathMLTag.CONJUGATE, string, "WmiMathMLContentConjugateImportAction");
        this.addAction(WmiMathMLTag.DIFF, string, "WmiMathMLContentDiffImportAction");
        this.addAction(WmiMathMLTag.PARTIALDIFF, string, "WmiMathMLContentDiffImportAction");
        this.addAction(WmiMathMLTag.LOWLIMIT, string, "WmiMathMLContentLowLimitImportAction");
        this.addAction(WmiMathMLTag.UPLIMIT, string, "WmiMathMLContentUpLimitImportAction");
        this.addAction(WmiMathMLTag.LIMIT, string, "WmiMathMLContentLargeOpImportAction");
        this.addAction(WmiMathMLTag.TENDSTO, string, "WmiMathMLContentTendsToImportAction");
        this.addAction(WmiMathMLTag.PRODUCT, string, "WmiMathMLContentLargeOpImportAction");
        this.addAction(WmiMathMLTag.SUM, string, "WmiMathMLContentLargeOpImportAction");
        this.addAction(WmiMathMLTag.LOG, string, "WmiMathMLContentFunctionImportAction");
        this.addAction(WmiMathMLTag.LOGBASE, string, "WmiMathMLContentLogbaseImportAction");
        this.addAction(WmiMathMLTag.MEAN, string, "WmiMathMLContentFunctionImportAction");
        this.addAction(WmiMathMLTag.SDEV, string, "WmiMathMLContentFunctionImportAction");
        this.addAction(WmiMathMLTag.VARIANCE, string, "WmiMathMLContentFunctionImportAction");
        this.addAction(WmiMathMLTag.MEDIAN, string, "WmiMathMLContentFunctionImportAction");
        this.addAction(WmiMathMLTag.MODE, string, "WmiMathMLContentFunctionImportAction");
        this.addAction(WmiMathMLTag.MOMENT, string, "WmiMathMLContentFunctionImportAction");
        this.addAction(WmiMathMLTag.MOMENTABOUT, string, "WmiMathMLContentMomentAboutImportAction");
        this.addAction(WmiMathMLTag.VECTOR, string, "WmiMathMLContentMatrixImportAction");
        this.addAction(WmiMathMLTag.MATRIX, string, "WmiMathMLContentMatrixImportAction");
        this.addAction(WmiMathMLTag.MATRIXROW, string, "WmiMathMLContentMatrixRowImportAction");
        this.addAction(WmiMathMLTag.DETERMINANT, string, "WmiMathMLContentFunctionImportAction");
        this.addAction(WmiMathMLTag.VECTORPRODUCT, string, "WmiMathMLContentFunctionImportAction");
        this.addAction(WmiMathMLTag.SCALARPRODUCT, string, "WmiMathMLContentFunctionImportAction");
        this.addAction(WmiMathMLTag.OUTERPRODUCT, string, "WmiMathMLContentFunctionImportAction");
        this.addAction(WmiMathMLTag.SELECTOR, string, "WmiMathMLContentSelectorImportAction");
        this.addAction(WmiMathMLTag.FN, string, "WmiMathMLContentFnImportAction");
        this.addAction(WmiMathMLTag.SEMANTICS, string, "WmiMathMLContentSemanticsImportAction");
        this.addAction(WmiMathMLTag.ANNOTATION, string, "WmiMathMLContentAnnotationImportAction");
        this.addAction(WmiMathMLTag.ANNOTATION_XML, string, "WmiMathMLContentAnnotationImportAction");
    }

    public static String formatInput(String string, Color color, int n) {
        int n2;
        StringBuffer stringBuffer = new StringBuffer(string);
        int n3 = stringBuffer.indexOf("<math");
        int n4 = -1;
        while (n3 != -1) {
            if ((n3 = stringBuffer.indexOf("<math", n3 + "<math".length())) == -1) continue;
            n2 = stringBuffer.indexOf(">", n3);
            stringBuffer.delete(n3, n2 + 1);
            n4 = stringBuffer.indexOf("</math>", n3);
            if (n4 == -1) continue;
            stringBuffer.delete(n4, n4 + "</math>".length());
        }
        n2 = -1;
        Pattern pattern = Pattern.compile("<math[^>]*> *<semantics>");
        Matcher matcher = pattern.matcher(stringBuffer.toString());
        if (matcher.find()) {
            n2 = matcher.end();
        } else {
            pattern = Pattern.compile("<math[^>]*>");
            matcher = pattern.matcher(stringBuffer.toString());
            if (matcher.find()) {
                n2 = matcher.end();
            }
        }
        if ((color != null && color != DEFAULT_FOREGROUND_COLOR || n != 0 && n != 12) && n2 != -1) {
            stringBuffer.insert(n2, "<mstyle mathcolor='#" + Integer.toHexString(color.getRGB()).substring(2) + "' mathsize='" + n + "'>");
            int n5 = -1;
            pattern = Pattern.compile("</semantics> *</math>");
            matcher = pattern.matcher(stringBuffer.toString());
            if (matcher.find()) {
                n5 = matcher.start();
            } else {
                pattern = Pattern.compile("</math>");
                matcher = pattern.matcher(stringBuffer.toString());
                if (matcher.find()) {
                    n5 = matcher.start();
                }
            }
            if (n5 != -1) {
                stringBuffer.insert(n5, "</mstyle>");
            }
        }
        stringBuffer.insert(0, "<?xml version=\"1.0\" standalone=\"no\" ?>");
        return stringBuffer.toString();
    }

    public static boolean isOperator(String[][] stringArray, String string) {
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = stringArray[i];
            if (!stringArray2[0].equals(string)) continue;
            return true;
        }
        return false;
    }

    public static String getOperatorEntity(String[][] stringArray, String string) {
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = stringArray[i];
            if (!stringArray2[0].equals(string)) continue;
            return stringArray2[1];
        }
        return null;
    }

    public static String getOperatorName(String[][] stringArray, String string) {
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = stringArray[i];
            if (!stringArray2[1].equals(string)) continue;
            return stringArray2[0];
        }
        return null;
    }

    public void addDeclaration(String string, WmiMathMLDeclaration wmiMathMLDeclaration) {
        this.declarationMap.put(string, wmiMathMLDeclaration);
    }

    public void startApply() {
        this.captureApplyFunction = true;
    }

    public void pushApplyFunction(Object object) {
        if (this.captureApplyFunction) {
            this.applyStack.push(object);
            this.captureApplyFunction = false;
        }
    }

    public Object popApplyFunction() {
        return this.applyStack.pop();
    }

    public void openModel(WmiModel wmiModel) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        if (wmiModel != null) {
            WmiModel wmiModel2 = this.getActiveModel();
            if (wmiModel2 instanceof WmiCompositeModel) {
                wmiModel.setParent((WmiCompositeModel)wmiModel2);
                this.setActiveModel(wmiModel);
            } else if (wmiModel.getTag() == WmiMathMLTag.MATH_GLYPH && wmiModel2 instanceof WmiAbstractMathTokenModel) {
                ((WmiMathGlyphModel)wmiModel).setGlyphParent((WmiAbstractMathTokenModel)wmiModel2);
                this.setActiveModel(wmiModel);
                ((WmiAbstractMathTokenModel)wmiModel2).addGlyph((WmiMathGlyphModel)wmiModel);
            } else {
                this.reportObjectError(wmiModel.toString(), null, wmiModel2, "Active model is not a valid parent.");
            }
        }
    }

    public void closeModel(WmiModel wmiModel) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiModel wmiModel2 = this.getActiveModel();
        super.closeModel(wmiModel);
        if (wmiModel2.getTag() == WmiMathMLTag.MATH_GLYPH && ((WmiMathGlyphModel)wmiModel2).getGlyphParent() != null) {
            this.setActiveModel(((WmiMathGlyphModel)wmiModel2).getGlyphParent());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTokenElement(String string, WmiModel wmiModel, WmiModelTag wmiModelTag) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiModel[] wmiModelArray;
        int n;
        WmiMathModel wmiMathModel = null;
        WmiCompositeModel wmiCompositeModel = wmiModel.getParent();
        ArrayList<WmiMathModel> arrayList = new ArrayList<WmiMathModel>();
        WmiAttributeSet wmiAttributeSet = wmiModel.getAttributes();
        WmiMathContext wmiMathContext = new WmiMathContext((WmiFontAttributeSet)wmiAttributeSet);
        StringBuffer stringBuffer = new StringBuffer(string);
        int n2 = 0;
        while (stringBuffer.indexOf("ent_", n2) != -1) {
            n2 = stringBuffer.indexOf("ent_");
            stringBuffer.replace(n2, n2 + 4, "&");
        }
        string = stringBuffer.toString();
        String string2 = "";
        String string3 = "";
        String[] stringArray = string.trim().split("&");
        ArrayList<String> arrayList2 = new ArrayList<String>();
        StringBuffer stringBuffer2 = new StringBuffer();
        for (n = 0; n < stringArray.length; ++n) {
            if (stringArray[n].indexOf(";") != -1 && !stringArray[n].equals(";")) {
                string2 = stringArray[n].substring(0, stringArray[n].indexOf(";"));
                if (!WmiMathEntityNameMapper.isNonMarkingEntity(string2)) {
                    stringBuffer2.append("&" + stringArray[n]);
                    continue;
                }
                if (stringBuffer2.length() > 0) {
                    arrayList2.add(stringBuffer2.toString());
                }
                if (string2.length() > 0) {
                    arrayList2.add("&" + string2 + ";");
                }
                if (string2.length() + 1 < stringArray[n].length()) {
                    arrayList2.add(stringArray[n].substring(string2.length() + 1));
                }
                stringBuffer2 = new StringBuffer();
                continue;
            }
            if (n > 0) {
                stringBuffer2.append("&");
            }
            stringBuffer2.append(stringArray[n]);
        }
        if (stringBuffer2.length() > 0) {
            arrayList2.add(stringBuffer2.toString());
        }
        stringArray = arrayList2.toArray(new String[arrayList2.size()]);
        for (n = 0; n < stringArray.length; ++n) {
            Object object;
            WmiAttributeSet wmiAttributeSet2;
            Object object2 = wmiModelArray = stringArray[n].length() > 2 && stringArray[n].indexOf(";") > 2 ? stringArray[n].substring(1, stringArray[n].indexOf(";")) : stringArray[n];
            if (WmiMathEntityNameMapper.isNonMarkingEntity((String)wmiModelArray)) {
                string2 = stringArray[n];
                wmiAttributeSet2 = new WmiMathSpaceModel.WmiMathSpaceAttributeSet();
                object = this.getMSpaceAttribute((String)wmiModelArray);
                for (int i = 0; i < ((ArrayList)object).size(); i += 2) {
                    wmiAttributeSet2.addAttribute(((ArrayList)object).get(i), ((ArrayList)object).get(i + 1));
                }
                WmiMathSpaceModel wmiMathSpaceModel = new WmiMathSpaceModel(wmiModel.getDocument(), "", wmiAttributeSet2);
                arrayList.add(wmiMathSpaceModel);
                continue;
            }
            string3 = stringArray[n];
            if (WmiModelTag.MATH_IDENTIFIER.equals(wmiModelTag)) {
                wmiMathModel = WmiMathFactory.createMathIdentifierToken(wmiModel.getDocument(), string3, wmiMathContext);
            } else if (WmiModelTag.MATH_NUMERIC.equals(wmiModelTag)) {
                wmiMathModel = WmiMathFactory.createMathNumericToken(wmiModel.getDocument(), string3, wmiMathContext);
            } else if (WmiModelTag.MATH_TEXT.equals(wmiModelTag)) {
                wmiMathModel = WmiMathFactory.createMathTextToken(wmiModel.getDocument(), string3, wmiMathContext);
            } else if (WmiModelTag.MATH_OPERATOR.equals(wmiModelTag)) {
                int n3 = 0;
                object = "";
                int n4 = -1;
                int n5 = -1;
                while (n3 < string3.length()) {
                    if (string3.charAt(n3) == '&') {
                        n4 = string3.indexOf("&", n3 + 1);
                        n5 = string3.indexOf(";", n3);
                        if (n5 != -1) {
                            if (n4 == -1 || n4 > n5) {
                                object = string3.substring(n3, n5 + 1);
                                n3 = n5 + 1;
                            } else {
                                object = string3.substring(n3, n4);
                                n3 = n4;
                            }
                        } else if (n4 == n3 + 1) {
                            object = string3.substring(n3, n3 + 1);
                            ++n3;
                        } else {
                            object = string3.substring(n3);
                            n3 = string3.length();
                        }
                    } else {
                        n4 = string3.indexOf("&", n3);
                        if (n4 == -1) {
                            object = string3.substring(n3);
                            n3 = string3.length();
                        } else {
                            n5 = string3.indexOf(";", n4);
                            if (n5 == -1) {
                                object = string3.substring(n3);
                                n3 = string3.length();
                            } else {
                                object = string3.substring(n3, n4);
                                n3 = n4;
                            }
                        }
                    }
                    wmiMathModel = WmiMathFactory.createMathOperatorToken(wmiModel.getDocument(), (String)object, wmiMathContext);
                    wmiMathModel.addAttributes(wmiAttributeSet);
                    if (n3 < string3.length()) {
                        arrayList.add(wmiMathModel);
                    }
                    if (!WmiModelLock.updateLock(wmiMathModel, true)) continue;
                    try {
                        wmiMathModel.update(null);
                    }
                    catch (WmiNoUpdateAccessException wmiNoUpdateAccessException) {
                        WmiErrorLog.log(wmiNoUpdateAccessException);
                    }
                    finally {
                        WmiModelLock.updateUnlock(wmiMathModel);
                    }
                }
            } else if (WmiModelTag.MATH_SPACE.equals(wmiModelTag)) {
                wmiMathModel = new WmiMathSpaceModel(wmiModel.getDocument(), string3, wmiAttributeSet);
            } else if (WmiModelTag.MATH_STRING.equals(wmiModelTag)) {
                wmiMathModel = new WmiMathStringModel(wmiModel.getDocument(), string3, wmiMathContext);
            } else if (WmiModelTag.MATH_ERROR.equals(wmiModelTag)) {
                wmiMathModel = new WmiMathErrorModel(wmiModel.getDocument(), string3);
            }
            if (wmiMathModel instanceof WmiAbstractMathTokenModel) {
                ((WmiAbstractMathTokenModel)wmiMathModel).setModified(((WmiAbstractMathTokenModel)this.getActiveModel()).getModified());
            }
            if ((wmiAttributeSet2 = wmiMathModel.getAttributes()) instanceof WmiFontAttributeSet) {
                ((WmiFontAttributeSet)wmiAttributeSet2).setExtendedStyle(wmiMathContext.getStyle().getExtendedStyle());
            }
            wmiMathModel.setAttributes(wmiAttributeSet2);
            arrayList.add(wmiMathModel);
        }
        try {
            if (arrayList.size() > 1) {
                WmiModel[] wmiModelArray2 = arrayList.toArray(new WmiModel[arrayList.size()]);
                wmiModelArray = new WmiModel[arrayList.size() - 1];
                System.arraycopy(wmiModelArray2, 0, wmiModelArray, 0, wmiModelArray2.length - 1);
                wmiCompositeModel.addChildren(wmiModelArray, wmiCompositeModel.getChildCount());
            }
            if (arrayList.size() > 0) {
                this.cancelActiveModel();
                this.openModel((WmiModel)arrayList.get(arrayList.size() - 1));
            }
        }
        catch (WmiModelIndexOutOfBoundsException wmiModelIndexOutOfBoundsException) {
            WmiErrorLog.log(wmiModelIndexOutOfBoundsException);
        }
    }

    public void defineTextContent(String string) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiModelTag wmiModelTag;
        WmiModel wmiModel;
        if (string.equals("&")) {
            string = "&amp;";
        }
        if ((wmiModel = this.getActiveModel()) != null && (WmiModelTag.MATH_IDENTIFIER.equals(wmiModelTag = wmiModel.getTag()) || WmiModelTag.MATH_NUMERIC.equals(wmiModelTag) || WmiModelTag.MATH_TEXT.equals(wmiModelTag) || WmiModelTag.MATH_OPERATOR.equals(wmiModelTag) || WmiModelTag.MATH_SPACE.equals(wmiModelTag) || WmiModelTag.MATH_STRING.equals(wmiModelTag) || WmiModelTag.MATH_ERROR.equals(wmiModelTag))) {
            this.updateTokenElement(string, wmiModel, wmiModelTag);
        }
    }

    protected void commitChild(WmiModel wmiModel) throws WmiNoWriteAccessException {
        try {
            Object object;
            WmiModel[] wmiModelArray;
            WmiModel[] wmiModelArray2;
            WmiAttributeSet wmiAttributeSet = wmiModel.getAttributesForRead();
            if (wmiAttributeSet.getAttribute("Typesetting:-msemantics") == "declare" || wmiModel instanceof WmiMathDocumentModel || wmiModel instanceof WmiMathGlyphModel && this.getActiveModel() == null) {
                return;
            }
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            WmiCompositeModel wmiCompositeModel = wmiModel.getParent();
            int n = wmiCompositeModel.getChildCount();
            WmiModel wmiModel2 = null;
            if (n > 0 && (wmiModel2 = wmiCompositeModel.getChild(n - 1)) != null) {
                if (wmiModel2.getTag() == WmiModelTag.MATH_ALIGN_GROUP) {
                    bl = true;
                } else if (wmiModel2.getTag() == WmiModelTag.MATH_ALIGN_MARK && (wmiModelArray2 = (WmiMathAlignMarkModel.WmiMathAlignMarkAttributeSet)wmiModel2.getAttributesForRead()).getEdge().equals("left")) {
                    bl = true;
                }
            }
            if (!bl && wmiModel.getTag() == WmiModelTag.MATH_ALIGN_MARK && (wmiModelArray2 = (WmiMathAlignMarkModel.WmiMathAlignMarkAttributeSet)wmiModel.getAttributesForRead()).getEdge().equals("right") && n > 1) {
                wmiModelArray = new WmiModel[]{wmiModel2, wmiModel};
                object = new WmiInlineMathModel(wmiModel2.getDocument(), wmiModelArray);
                WmiModel[] wmiModelArray3 = new WmiModel[]{object};
                wmiCompositeModel.replaceChildren(wmiModelArray3, wmiCompositeModel.indexOf(wmiModel2), 1);
                bl2 = true;
            }
            if (bl) {
                wmiModelArray2 = new WmiModel[]{wmiModel2, wmiModel};
                wmiModelArray = new WmiInlineMathModel(wmiModel2.getDocument(), wmiModelArray2);
                object = new WmiModel[]{wmiModelArray};
                wmiCompositeModel.replaceChildren((WmiModel[])object, wmiCompositeModel.indexOf(wmiModel2), 1);
            } else {
                if (wmiModel instanceof WmiCompositeModel && (wmiModelArray2 = WmiModelUtil.findLastDescendantLeaf((WmiCompositeModel)wmiModel)) != null && wmiModelArray2.getTag() == WmiModelTag.MATH_ALIGN_GROUP) {
                    wmiModelArray2.getParent().removeChild((WmiModel)wmiModelArray2);
                }
                if (!bl2 && !bl3) {
                    super.commitChild(wmiModel);
                }
            }
        }
        catch (WmiNoReadAccessException wmiNoReadAccessException) {
            WmiErrorLog.log(wmiNoReadAccessException);
        }
        catch (WmiInvalidModelInitializationException wmiInvalidModelInitializationException) {
            WmiErrorLog.log(wmiInvalidModelInitializationException);
        }
        catch (WmiNoWriteAccessException wmiNoWriteAccessException) {
            WmiErrorLog.log(wmiNoWriteAccessException);
        }
        catch (WmiModelIndexOutOfBoundsException wmiModelIndexOutOfBoundsException) {
            WmiErrorLog.log(wmiModelIndexOutOfBoundsException);
        }
    }

    private void processOperatorChildren(WmiCompositeModel wmiCompositeModel) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiMathOperatorModel wmiMathOperatorModel = (WmiMathOperatorModel)WmiModelUtil.findFirstDescendantOfTag((WmiModel)wmiCompositeModel, WmiModelTag.MATH_OPERATOR);
        while (wmiMathOperatorModel != null) {
            WmiCompositeModel wmiCompositeModel2 = wmiMathOperatorModel.getParent();
            if (wmiCompositeModel2.getChildCount() == 2 && (wmiCompositeModel2.getChild(0) instanceof WmiMathAlignGroupModel || wmiCompositeModel2.getChild(0) instanceof WmiMathAlignMarkModel)) {
                wmiCompositeModel2 = wmiCompositeModel2.getParent();
            }
            this.updateOperatorModelAttributes(wmiMathOperatorModel, wmiCompositeModel2);
            wmiMathOperatorModel = (WmiMathOperatorModel)WmiModelUtil.findNextModel((WmiModel)wmiCompositeModel, (WmiModel)wmiMathOperatorModel, WmiModelTag.MATH_OPERATOR);
        }
    }

    public void updateMathModel() throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        try {
            WmiParagraphModel wmiParagraphModel = this.getActiveModel() instanceof WmiParagraphModel ? (WmiParagraphModel)this.getActiveModel() : (WmiParagraphModel)WmiModelUtil.findFirstDescendantOfClass(this.getActiveModel(), WmiMathMLParagraphModel.class);
            WmiMathWrapperModel wmiMathWrapperModel = (WmiMathWrapperModel)wmiParagraphModel.getChild(0);
            for (int i = 1; i < wmiParagraphModel.getChildCount(); ++i) {
                WmiModel wmiModel = wmiParagraphModel.getChild(i);
                wmiMathWrapperModel.appendChild(wmiModel);
            }
            wmiParagraphModel.removeChildren(1, wmiParagraphModel.getChildCount() - 1);
            this.processOperatorChildren(wmiMathWrapperModel);
        }
        catch (Exception exception) {
            WmiErrorLog.log(exception);
        }
    }

    public void updateRowModel() throws WmiNoReadAccessException, WmiNoWriteAccessException {
        try {
            WmiInlineMathModel wmiInlineMathModel = (WmiInlineMathModel)this.getActiveModel();
            this.processOperatorChildren(wmiInlineMathModel);
        }
        catch (Exception exception) {
            WmiErrorLog.log(exception);
        }
    }

    public void updateEncloseModel() throws WmiNoReadAccessException, WmiNoWriteAccessException {
        try {
            WmiMathEncloseModel wmiMathEncloseModel = (WmiMathEncloseModel)this.getActiveModel();
            WmiMathEncloseModel.WmiMathEncloseAttributeSet wmiMathEncloseAttributeSet = (WmiMathEncloseModel.WmiMathEncloseAttributeSet)wmiMathEncloseModel.getAttributesForRead();
            if (wmiMathEncloseAttributeSet.isRadical()) {
                WmiCompositeModel wmiCompositeModel = wmiMathEncloseModel.getParent();
                WmiMathContext wmiMathContext = new WmiMathContext(new WmiMathAttributeSet());
                WmiMathDocumentModel wmiMathDocumentModel = wmiMathEncloseModel.getDocument();
                WmiRootModel wmiRootModel = new WmiRootModel(wmiMathDocumentModel, wmiMathEncloseModel, new WmiIdentifierModel(wmiMathDocumentModel, "", "", wmiMathContext, false), wmiMathContext);
                this.openModel(wmiRootModel);
                wmiRootModel.setParent(wmiCompositeModel);
            }
            this.processOperatorChildren(wmiMathEncloseModel);
        }
        catch (Exception exception) {
            WmiErrorLog.log(exception);
        }
    }

    public void updateStyleModel() throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiMathStyleModel wmiMathStyleModel = (WmiMathStyleModel)this.getActiveModel();
        try {
            WmiModelUtil.visitModels(wmiMathStyleModel, new WmiMathStyleModel.WmiApplyStyleVisitor(wmiMathStyleModel, wmiMathStyleModel.getAttributes(), false));
        }
        catch (WmiNoReadAccessException wmiNoReadAccessException) {
            WmiErrorLog.log(wmiNoReadAccessException);
        }
    }

    public void updateFractionModel() throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        try {
            WmiFractionModel wmiFractionModel = (WmiFractionModel)this.getActiveModel();
            WmiModel[] wmiModelArray = new WmiModel[]{wmiFractionModel.getChild(2), wmiFractionModel.getChild(3)};
            wmiFractionModel.replaceChildren(wmiModelArray, 0, 2);
            wmiFractionModel.replaceChildren(new WmiModel[0], 2, 2);
        }
        catch (Exception exception) {
            WmiErrorLog.log(exception);
        }
    }

    public void updateSquareRootModel() throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        try {
            WmiRootModel.WmiSquareRootModel wmiSquareRootModel = (WmiRootModel.WmiSquareRootModel)this.getActiveModel();
            WmiInlineMathModel wmiInlineMathModel = (WmiInlineMathModel)wmiSquareRootModel.getChild(0);
            int n = wmiSquareRootModel.getChildCountForParsing();
            for (int i = n - 2; i >= 1; --i) {
                wmiInlineMathModel.addChild(wmiSquareRootModel.getChild(i), n - 2 - i);
            }
            wmiSquareRootModel.removeChildren(1, n - 1);
            this.processOperatorChildren(wmiInlineMathModel);
        }
        catch (Exception exception) {
            WmiErrorLog.log(exception);
        }
    }

    public void updateRootModel() throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        try {
            WmiRootModel wmiRootModel = (WmiRootModel)this.getActiveModel();
            if (wmiRootModel.getChildCount() == 4) {
                WmiModel[] wmiModelArray = new WmiModel[]{wmiRootModel.getChild(2), wmiRootModel.getChild(3)};
                wmiRootModel.replaceChildren(wmiModelArray, 0, 2);
                wmiRootModel.replaceChildren(new WmiModel[0], 2, 2);
            } else {
                WmiMathErrorModel wmiMathErrorModel = new WmiMathErrorModel(wmiRootModel.getDocument(), "<mroot> must have two children");
                this.cancelActiveModel();
                this.openModel(wmiMathErrorModel);
            }
            this.processOperatorChildren(wmiRootModel);
        }
        catch (Exception exception) {
            WmiErrorLog.log(exception);
        }
    }

    public void updatePaddedModel() throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        try {
            WmiMathPaddedModel wmiMathPaddedModel = (WmiMathPaddedModel)this.getActiveModel();
            WmiInlineMathModel wmiInlineMathModel = (WmiInlineMathModel)wmiMathPaddedModel.getChild(0);
            int n = wmiMathPaddedModel.getChildCount();
            for (int i = 1; i < n; ++i) {
                wmiInlineMathModel.addChild(wmiMathPaddedModel.getChild(i), i - 1);
            }
            wmiMathPaddedModel.removeChildren(1, n - 1);
            this.processOperatorChildren(wmiInlineMathModel);
        }
        catch (Exception exception) {
            WmiErrorLog.log(exception);
        }
    }

    public void updatePhantomModel() throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        try {
            WmiMathPhantomModel wmiMathPhantomModel = (WmiMathPhantomModel)this.getActiveModel();
            WmiInlineMathModel wmiInlineMathModel = (WmiInlineMathModel)wmiMathPhantomModel.getChild(0);
            int n = wmiMathPhantomModel.getChildCount();
            for (int i = 1; i < n; ++i) {
                wmiInlineMathModel.addChild(wmiMathPhantomModel.getChild(i), i - 1);
            }
            wmiMathPhantomModel.removeChildren(1, n - 1);
            this.processOperatorChildren(wmiInlineMathModel);
        }
        catch (Exception exception) {
            WmiErrorLog.log(exception);
        }
    }

    public void updateSubscriptModel() throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        try {
            WmiSubscriptModel wmiSubscriptModel = (WmiSubscriptModel)this.getActiveModel();
            WmiModel[] wmiModelArray = new WmiModel[]{wmiSubscriptModel.getChild(2), wmiSubscriptModel.getChild(3)};
            wmiSubscriptModel.replaceChildren(wmiModelArray, 0, 2);
            wmiSubscriptModel.replaceChildren(new WmiModel[0], 2, 2);
            this.processOperatorChildren(wmiSubscriptModel);
        }
        catch (Exception exception) {
            WmiErrorLog.log(exception);
        }
    }

    public void updateSuperscriptModel() throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        try {
            WmiSuperscriptModel wmiSuperscriptModel = (WmiSuperscriptModel)this.getActiveModel();
            WmiModel[] wmiModelArray = new WmiModel[2];
            if (wmiSuperscriptModel.getChild(2) != null && wmiSuperscriptModel.getChild(3) != null) {
                wmiModelArray[0] = wmiSuperscriptModel.getChild(2);
                wmiModelArray[1] = wmiSuperscriptModel.getChild(3);
                wmiSuperscriptModel.replaceChildren(wmiModelArray, 0, 2);
                wmiSuperscriptModel.replaceChildren(new WmiModel[0], 2, 2);
            }
            this.processOperatorChildren(wmiSuperscriptModel);
        }
        catch (Exception exception) {
            WmiErrorLog.log(exception);
        }
    }

    public void updateSubSuperscriptModel() throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        try {
            WmiSubSupModel wmiSubSupModel = (WmiSubSupModel)this.getActiveModel();
            WmiModel[] wmiModelArray = new WmiModel[]{wmiSubSupModel.getChild(3), wmiSubSupModel.getChild(4), wmiSubSupModel.getChild(5)};
            wmiSubSupModel.replaceChildren(wmiModelArray, 0, 3);
            wmiSubSupModel.replaceChildren(new WmiModel[0], 3, 3);
            this.processOperatorChildren(wmiSubSupModel);
        }
        catch (Exception exception) {
            WmiErrorLog.log(exception);
        }
    }

    public void updateUnderModel() throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        try {
            WmiUnderModel wmiUnderModel = (WmiUnderModel)this.getActiveModel();
            WmiModel[] wmiModelArray = new WmiModel[]{wmiUnderModel.getChild(2), wmiUnderModel.getChild(3)};
            wmiUnderModel.replaceChildren(wmiModelArray, 0, 2);
            wmiUnderModel.replaceChildren(new WmiModel[0], 2, 2);
            this.processOperatorChildren(wmiUnderModel);
        }
        catch (Exception exception) {
            WmiErrorLog.log(exception);
        }
    }

    public void updateOverModel() throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        try {
            WmiOverModel wmiOverModel = (WmiOverModel)this.getActiveModel();
            WmiModel[] wmiModelArray = new WmiModel[]{wmiOverModel.getChild(2), wmiOverModel.getChild(3)};
            wmiOverModel.replaceChildren(wmiModelArray, 0, 2);
            wmiOverModel.replaceChildren(new WmiModel[0], 2, 2);
            this.processOperatorChildren(wmiOverModel);
        }
        catch (Exception exception) {
            WmiErrorLog.log(exception);
        }
    }

    public void updateUnderOverModel() throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        try {
            WmiUnderOverModel wmiUnderOverModel = (WmiUnderOverModel)this.getActiveModel();
            WmiAttributeSet wmiAttributeSet = wmiUnderOverModel.getAttributes();
            WmiMathContext wmiMathContext = new WmiMathContext((WmiFontAttributeSet)wmiAttributeSet);
            WmiModel[] wmiModelArray = new WmiModel[]{wmiUnderOverModel.getChild(3), wmiUnderOverModel.getChild(4) != null ? wmiUnderOverModel.getChild(4) : WmiMathFactory.createMathIdentifierToken(wmiUnderOverModel.getDocument(), "", wmiMathContext), wmiUnderOverModel.getChild(5) != null ? wmiUnderOverModel.getChild(5) : WmiMathFactory.createMathIdentifierToken(wmiUnderOverModel.getDocument(), "", wmiMathContext)};
            wmiUnderOverModel.replaceChildren(wmiModelArray, 0, 3);
            wmiUnderOverModel.replaceChildren(new WmiModel[0], 3, wmiUnderOverModel.getChildCount() - 3);
            this.processOperatorChildren(wmiUnderOverModel);
        }
        catch (Exception exception) {
            WmiErrorLog.log(exception);
        }
    }

    public void updateListModel() throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiMathFencedModel wmiMathFencedModel = (WmiMathFencedModel)this.getActiveModel();
        WmiMathDocumentModel wmiMathDocumentModel = wmiMathFencedModel.getDocument();
        WmiMathContext wmiMathContext = new WmiMathContext(new WmiMathAttributeSet());
        String string = (String)((WmiMathAttributeSet)wmiMathFencedModel.getAttributes()).getAttribute("Typesetting:-msemantics");
        wmiMathFencedModel.addAttribute("open", "[");
        wmiMathFencedModel.addAttribute("close", "]");
        if (string.equals("list-numeric") || string.equals("list-lexicographic")) {
            String string2 = "numeric";
            if (string.equals("list-lexicographic")) {
                string2 = "lexorder";
            }
            try {
                WmiCompositeModel wmiCompositeModel = wmiMathFencedModel.getParent();
                WmiInlineMathModel wmiInlineMathModel = new WmiInlineMathModel(wmiMathDocumentModel);
                WmiMathTokenModel wmiMathTokenModel = WmiMathFactory.createMathIdentifierToken(wmiMathDocumentModel, "sort", wmiMathContext);
                WmiMathTokenModel wmiMathTokenModel2 = WmiMathFactory.createMathOperatorToken(wmiMathDocumentModel, "&ApplyFunction;", wmiMathContext);
                WmiModel[] wmiModelArray = new WmiModel[]{wmiMathFencedModel, WmiMathFactory.createMathIdentifierToken(wmiMathDocumentModel, string2, wmiMathContext)};
                WmiMathFencedModel wmiMathFencedModel2 = new WmiMathFencedModel(wmiMathDocumentModel, wmiModelArray, wmiMathContext);
                wmiInlineMathModel.appendChild(wmiMathTokenModel);
                wmiInlineMathModel.appendChild(wmiMathTokenModel2);
                wmiInlineMathModel.appendChild(wmiMathFencedModel2);
                wmiInlineMathModel.setParent(wmiCompositeModel);
                this.setActiveModel(wmiInlineMathModel);
                wmiInlineMathModel.addAttribute("Typesetting:-msemantics", "list");
            }
            catch (WmiInvalidModelInitializationException wmiInvalidModelInitializationException) {
                WmiErrorLog.log(wmiInvalidModelInitializationException);
            }
        }
    }

    public void updateTableModel() throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        try {
            WmiModel[] wmiModelArray;
            int n;
            WmiMathTableModel wmiMathTableModel = (WmiMathTableModel)this.getActiveModel();
            ArrayList<WmiModel[]> arrayList = new ArrayList<WmiModel[]>();
            int n2 = -1;
            int n3 = 0;
            for (n = 0; n < wmiMathTableModel.getChildCount(); ++n) {
                wmiModelArray = wmiMathTableModel.getChild(n);
                if (!wmiModelArray.getTag().equals(WmiModelTag.MATH_TABLE_ROW) && !wmiModelArray.getTag().equals(WmiModelTag.MATH_TABLE_LABELED_ROW)) {
                    arrayList.add(wmiModelArray);
                    if (n2 != -1) continue;
                    n2 = n;
                    continue;
                }
                if (arrayList.isEmpty()) continue;
                n3 = n;
                try {
                    WmiMathTableModel.WmiMathTableRowModel wmiMathTableRowModel = new WmiMathTableModel.WmiMathTableRowModel(wmiMathTableModel.getDocument(), arrayList.toArray(new WmiModel[n3 - 1 - n2]));
                    WmiModel[] wmiModelArray2 = new WmiModel[]{wmiMathTableRowModel};
                    wmiMathTableModel.replaceChildren(wmiModelArray2, n2, n3 - n2);
                }
                catch (WmiInvalidModelInitializationException wmiInvalidModelInitializationException) {
                    WmiErrorLog.log(wmiInvalidModelInitializationException);
                }
                arrayList.clear();
                n2 = -1;
                n = -1;
            }
            if (!arrayList.isEmpty()) {
                n3 = wmiMathTableModel.getChildCount() - 1;
                try {
                    WmiMathTableModel.WmiMathTableRowModel wmiMathTableRowModel = new WmiMathTableModel.WmiMathTableRowModel(wmiMathTableModel.getDocument(), arrayList.toArray(new WmiModel[arrayList.size()]));
                    wmiModelArray = new WmiModel[]{wmiMathTableRowModel};
                    wmiMathTableModel.replaceChildren(wmiModelArray, n2, n3 - n2 + 1);
                }
                catch (WmiInvalidModelInitializationException wmiInvalidModelInitializationException) {
                    WmiErrorLog.log(wmiInvalidModelInitializationException);
                }
            }
            for (n = 0; n < wmiMathTableModel.getChildCount(); ++n) {
                this.updateTableRowModel((WmiMathTableModel.WmiMathTableRowModel)wmiMathTableModel.getChild(n));
            }
        }
        catch (Exception exception) {
            WmiErrorLog.log(exception);
        }
    }

    public void updateTableRowModel(WmiMathTableModel.WmiMathTableRowModel wmiMathTableRowModel) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        try {
            for (int i = 0; i < wmiMathTableRowModel.getChildCount(); ++i) {
                WmiModel wmiModel = wmiMathTableRowModel.getChild(i);
                if (wmiModel.getTag().equals(WmiModelTag.MATH_TABLE_CELL)) continue;
                WmiMathTableModel.WmiMathTableDataModel wmiMathTableDataModel = new WmiMathTableModel.WmiMathTableDataModel(wmiMathTableRowModel.getDocument(), wmiModel);
                WmiModel[] wmiModelArray = new WmiModel[]{wmiMathTableDataModel};
                wmiMathTableRowModel.replaceChildren(wmiModelArray, i, 1);
            }
        }
        catch (Exception exception) {
            WmiErrorLog.log(exception);
        }
    }

    public void updateTableDataModel() throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        try {
            WmiMathTableModel.WmiMathTableDataModel wmiMathTableDataModel = (WmiMathTableModel.WmiMathTableDataModel)this.getActiveModel();
            WmiInlineMathModel wmiInlineMathModel = (WmiInlineMathModel)wmiMathTableDataModel.getChild(0);
            for (int i = 1; i < wmiMathTableDataModel.getChildCount(); ++i) {
                wmiInlineMathModel.addChild(wmiMathTableDataModel.getChild(i), i - 1);
            }
            wmiMathTableDataModel.removeChildren(1, wmiMathTableDataModel.getChildCount() - 1);
            this.processOperatorChildren(wmiInlineMathModel);
        }
        catch (Exception exception) {
            WmiErrorLog.log(exception);
        }
    }

    public void updateAlignMarkModel(int n) throws WmiNoReadAccessException {
        if (this.getActiveModel() instanceof WmiAbstractMathTokenModel) {
            WmiAbstractMathTokenModel wmiAbstractMathTokenModel = (WmiAbstractMathTokenModel)this.getActiveModel();
            wmiAbstractMathTokenModel.alignmarkIndex = wmiAbstractMathTokenModel.getAllText().length() - 1;
            wmiAbstractMathTokenModel.alignmarkEdge = n;
        }
    }

    public void updateApplyModel() throws WmiNoReadAccessException {
        Object object;
        WmiInlineMathModel wmiInlineMathModel = (WmiInlineMathModel)this.getActiveModel();
        WmiCompositeModel wmiCompositeModel = wmiInlineMathModel.getParent();
        WmiMathDocumentModel wmiMathDocumentModel = wmiInlineMathModel.getDocument();
        WmiAttributeSet wmiAttributeSet = wmiInlineMathModel.getAttributes();
        WmiMathContext wmiMathContext = new WmiMathContext((WmiFontAttributeSet)wmiAttributeSet);
        Object object2 = null;
        String string = "";
        if (wmiInlineMathModel.getChild(0) instanceof WmiIdentifierModel && ((WmiAbstractArrayAttributeSet)(object = (WmiMathAttributeSet)((WmiIdentifierModel)(object2 = wmiInlineMathModel.getChild(0))).getAttributesForRead())).getAttribute("Typesetting:-msemantics") != null && ((WmiAbstractArrayAttributeSet)object).getAttribute("Typesetting:-msemantics") == "function") {
            string = ((WmiIdentifierModel)object2).getText();
        }
        if (string.equals("") && this.applyStack.size() > 0) {
            object2 = this.popApplyFunction();
            if (object2 instanceof WmiMathTokenModel) {
                string = ((WmiMathTokenModel)object2).getTokenContents();
            } else if (object2 instanceof String) {
                string = (String)object2;
            }
        }
        try {
            if (WmiMathMLImportParser.isOperator(functionNameList, string)) {
                if (!WmiMathMLImportParser.getOperatorEntity(functionNameList, string).equals("")) {
                    object = WmiMathMLImportParser.getOperatorEntity(functionNameList, string).toString();
                    String string2 = ((WmiAbstractMathTokenModel)wmiInlineMathModel.getChild(0)).getText();
                    ((WmiAbstractMathTokenModel)wmiInlineMathModel.getChild(0)).replaceText((String)object, 0, string2.length());
                }
                object = new ArrayList();
                for (int i = 1; i < wmiInlineMathModel.getChildCount(); ++i) {
                    ((ArrayList)object).add(wmiInlineMathModel.getChild(i));
                }
                WmiMathTokenModel wmiMathTokenModel = WmiMathFactory.createMathOperatorToken(wmiMathDocumentModel, "&ApplyFunction;", wmiMathContext);
                wmiInlineMathModel.addChild(wmiMathTokenModel, 1);
                WmiMathFencedModel wmiMathFencedModel = new WmiMathFencedModel(wmiMathDocumentModel, ((ArrayList)object).toArray(new WmiModel[0]), wmiMathContext);
                WmiModel[] wmiModelArray = new WmiModel[]{wmiMathFencedModel};
                wmiInlineMathModel.replaceChildren(wmiModelArray, 2, wmiInlineMathModel.getChildCount() - 2);
                wmiInlineMathModel.addAttribute("Typesetting:-msemantics", "function");
            } else if (WmiMathMLImportParser.isOperator(infixOperatorList, string) && wmiInlineMathModel.getChildCount() >= 3) {
                int n;
                object = WmiMathMLImportParser.getOperatorEntity(infixOperatorList, string).toString();
                WmiMathTokenModel wmiMathTokenModel = WmiMathFactory.createMathOperatorToken(wmiMathDocumentModel, (String)object, wmiMathContext);
                wmiInlineMathModel.removeChild(0);
                if (!string.equals(WmiMathMLTag.EQ.getName()) && !string.equals(WmiMathMLTag.EQUIVALENT.getName())) {
                    for (n = 0; n < wmiInlineMathModel.getChildCount(); ++n) {
                        WmiInlineMathModel wmiInlineMathModel2;
                        WmiModel wmiModel = wmiInlineMathModel.getChild(n);
                        if (!(wmiModel instanceof WmiInlineMathModel) || (wmiInlineMathModel2 = (WmiInlineMathModel)wmiModel).getChildCount() == 1 || wmiInlineMathModel2.getChildCount() == 2 && wmiInlineMathModel2.getChild(0) instanceof WmiMathOperatorModel && ((WmiMathOperatorModel)wmiInlineMathModel2.getChild(0)).getSemanticLabel().equals("&minus;") || wmiInlineMathModel2.getChildCount() == 3 && wmiInlineMathModel2.getChild(1) instanceof WmiMathOperatorModel && (((WmiMathOperatorModel)wmiInlineMathModel2.getChild(1)).getSemanticLabel().equals("&InvisibleTimes;") || ((WmiMathOperatorModel)wmiInlineMathModel2.getChild(1)).getSemanticLabel().equals("&ApplyFunction;"))) continue;
                        WmiModel[] wmiModelArray = new WmiModel[]{wmiModel};
                        WmiMathFencedModel wmiMathFencedModel = new WmiMathFencedModel(wmiMathDocumentModel, wmiModelArray, wmiMathContext);
                        wmiInlineMathModel.replaceChild(wmiMathFencedModel, n);
                    }
                }
                for (n = wmiInlineMathModel.getChildCount() - 1; n > 0; --n) {
                    wmiMathTokenModel = WmiMathFactory.createMathOperatorToken(wmiMathDocumentModel, (String)object, wmiMathContext);
                    wmiInlineMathModel.addChild(wmiMathTokenModel, n);
                }
                if (string.equals("cartesianproduct")) {
                    wmiInlineMathModel.addAttribute("Typesetting:-msemantics", "cartesianproduct");
                } else {
                    wmiInlineMathModel.addAttribute("Typesetting:-msemantics", "infix");
                }
            } else if (WmiMathMLImportParser.isOperator(postfixOperatorList, string)) {
                object = WmiMathMLImportParser.getOperatorEntity(postfixOperatorList, string).toString();
                WmiMathTokenModel wmiMathTokenModel = WmiMathFactory.createMathOperatorToken(wmiMathDocumentModel, (String)object, wmiMathContext);
                WmiMathModel wmiMathModel = (WmiMathModel)wmiInlineMathModel.getChild(1);
                if (wmiMathModel instanceof WmiCompositeModel && ((WmiCompositeModel)((Object)wmiMathModel)).getChildCount() > 1) {
                    WmiModel[] wmiModelArray = new WmiModel[]{wmiMathModel};
                    WmiMathFencedModel wmiMathFencedModel = new WmiMathFencedModel(wmiMathDocumentModel, wmiModelArray, wmiMathContext);
                    wmiInlineMathModel.replaceChild(wmiMathFencedModel, 1);
                }
                wmiInlineMathModel.removeChild(0);
                wmiInlineMathModel.addChild(wmiMathTokenModel, 1);
                wmiInlineMathModel.addAttribute("Typesetting:-msemantics", "postfix");
            } else if (WmiMathMLImportParser.isOperator(prefixOperatorList, string)) {
                WmiAbstractModel wmiAbstractModel;
                WmiInlineMathModel wmiInlineMathModel3;
                object = WmiMathMLImportParser.getOperatorEntity(prefixOperatorList, string).toString();
                WmiMathTokenModel wmiMathTokenModel = WmiMathFactory.createMathOperatorToken(wmiMathDocumentModel, (String)object, wmiMathContext);
                wmiInlineMathModel.replaceChild(wmiMathTokenModel, 0);
                boolean bl = false;
                if (string.equals("minus")) {
                    if (wmiInlineMathModel.getChildCount() > 1 && wmiInlineMathModel.getChild(1) instanceof WmiInlineMathModel && (wmiInlineMathModel3 = (WmiInlineMathModel)wmiInlineMathModel.getChild(1)).getChildCount() == 3 && wmiInlineMathModel3.getChild(1) instanceof WmiMathOperatorModel && !((WmiAbstractMathTokenModel)(wmiAbstractModel = (WmiMathOperatorModel)wmiInlineMathModel3.getChild(1))).getSemanticLabel().equals("&InvisibleTimes;")) {
                        bl = true;
                    }
                } else if (wmiInlineMathModel.getChildCount() > 2) {
                    bl = true;
                }
                if (bl) {
                    wmiInlineMathModel3 = new WmiMathFencedModel(wmiMathDocumentModel, new WmiModel[0], wmiMathContext);
                    wmiAbstractModel = new WmiInlineMathModel(wmiMathDocumentModel);
                    for (int i = 1; i < wmiInlineMathModel.getChildCount(); ++i) {
                        ((WmiAbstractArrayCompositeModel)wmiAbstractModel).appendChild(wmiInlineMathModel.getChild(i));
                    }
                    wmiInlineMathModel3.appendChild(wmiAbstractModel);
                    wmiInlineMathModel.replaceChild(wmiInlineMathModel3, 1);
                    wmiInlineMathModel.removeChildren(2, wmiInlineMathModel.getChildCount() - 2);
                }
                wmiInlineMathModel.addAttribute("Typesetting:-msemantics", "prefix");
            } else {
                object = (WmiMathMLParserModelBuilder)modelFactoryMap.get(string);
                if (object != null) {
                    this.setActiveModel(object.createModel(wmiMathDocumentModel, wmiMathContext, wmiCompositeModel, wmiInlineMathModel));
                } else {
                    ArrayList<WmiModel> arrayList = new ArrayList<WmiModel>();
                    for (int i = 1; i < wmiInlineMathModel.getChildCount(); ++i) {
                        arrayList.add(wmiInlineMathModel.getChild(i));
                    }
                    WmiMathTokenModel wmiMathTokenModel = WmiMathFactory.createMathOperatorToken(wmiMathDocumentModel, "&ApplyFunction;", wmiMathContext);
                    wmiInlineMathModel.addChild(wmiMathTokenModel, 1);
                    WmiMathFencedModel wmiMathFencedModel = new WmiMathFencedModel(wmiMathDocumentModel, arrayList.toArray(new WmiModel[0]), wmiMathContext);
                    WmiModel[] wmiModelArray = new WmiModel[]{wmiMathFencedModel};
                    wmiInlineMathModel.replaceChildren(wmiModelArray, 2, wmiInlineMathModel.getChildCount() - 2);
                    wmiInlineMathModel.addAttribute("Typesetting:-msemantics", "function");
                }
            }
        }
        catch (WmiNoWriteAccessException wmiNoWriteAccessException) {
            WmiErrorLog.log(wmiNoWriteAccessException);
        }
        catch (WmiModelIndexOutOfBoundsException wmiModelIndexOutOfBoundsException) {
            WmiErrorLog.log(wmiModelIndexOutOfBoundsException);
        }
        catch (WmiInvalidModelInitializationException wmiInvalidModelInitializationException) {
            WmiErrorLog.log(wmiInvalidModelInitializationException);
        }
    }

    public WmiModel updateFnModel() throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiInlineMathModel wmiInlineMathModel = (WmiInlineMathModel)this.getActiveModel();
        WmiMathDocumentModel wmiMathDocumentModel = wmiInlineMathModel.getDocument();
        WmiAttributeSet wmiAttributeSet = wmiInlineMathModel.getAttributes();
        WmiMathContext wmiMathContext = new WmiMathContext((WmiFontAttributeSet)wmiAttributeSet);
        try {
            WmiModel wmiModel;
            if (wmiInlineMathModel.getChild(0) instanceof WmiInlineMathModel) {
                wmiModel = (WmiInlineMathModel)wmiInlineMathModel.getChild(0);
                WmiModel[] wmiModelArray = new WmiModel[]{wmiModel};
                WmiMathFencedModel wmiMathFencedModel = new WmiMathFencedModel(wmiMathDocumentModel, wmiModelArray, wmiMathContext);
                wmiInlineMathModel.replaceChild(wmiMathFencedModel, 0);
            }
            wmiModel = WmiModelUtil.findFirstDescendantLeaf(wmiInlineMathModel);
            this.pushApplyFunction(wmiModel);
        }
        catch (WmiInvalidModelInitializationException wmiInvalidModelInitializationException) {
            WmiErrorLog.log(wmiInvalidModelInitializationException);
        }
        catch (WmiNoWriteAccessException wmiNoWriteAccessException) {
            WmiErrorLog.log(wmiNoWriteAccessException);
        }
        catch (WmiModelIndexOutOfBoundsException wmiModelIndexOutOfBoundsException) {
            WmiErrorLog.log(wmiModelIndexOutOfBoundsException);
        }
        wmiInlineMathModel.addAttribute("Typesetting:-msemantics", "fn");
        return wmiInlineMathModel;
    }

    public void updateVectorModel() {
        try {
            WmiMathFencedModel wmiMathFencedModel = (WmiMathFencedModel)this.getActiveModel();
            wmiMathFencedModel.addAttribute("open", "(");
            wmiMathFencedModel.addAttribute("close", ")");
            wmiMathFencedModel.removeChild(0);
            wmiMathFencedModel.addAttribute("Typesetting:-msemantics", "vector");
            this.setActiveModel(wmiMathFencedModel);
        }
        catch (WmiNoWriteAccessException wmiNoWriteAccessException) {
            WmiErrorLog.log(wmiNoWriteAccessException);
        }
        catch (WmiModelIndexOutOfBoundsException wmiModelIndexOutOfBoundsException) {
            WmiErrorLog.log(wmiModelIndexOutOfBoundsException);
        }
    }

    public void updateMatrixModel() {
        try {
            WmiMathFencedModel wmiMathFencedModel = (WmiMathFencedModel)this.getActiveModel();
            WmiMathTableModel wmiMathTableModel = (WmiMathTableModel)wmiMathFencedModel.getChild(0);
            WmiMathDocumentModel wmiMathDocumentModel = wmiMathTableModel.getDocument();
            for (int i = 1; i < wmiMathFencedModel.getChildCount(); ++i) {
                WmiMathTableModel.WmiMathTableRowModel wmiMathTableRowModel = new WmiMathTableModel.WmiMathTableRowModel(wmiMathDocumentModel);
                WmiInlineMathModel wmiInlineMathModel = (WmiInlineMathModel)wmiMathFencedModel.getChild(i);
                for (int j = 0; j < wmiInlineMathModel.getChildCount(); ++j) {
                    WmiMathTableModel.WmiMathTableDataModel wmiMathTableDataModel = new WmiMathTableModel.WmiMathTableDataModel(wmiMathDocumentModel, wmiInlineMathModel.getChild(j));
                    wmiMathTableRowModel.appendChild(wmiMathTableDataModel);
                    wmiMathTableRowModel.addAttribute("Typesetting:-msemantics", "matrixrow");
                }
                wmiMathTableModel.appendChild(wmiMathTableRowModel);
            }
            wmiMathTableModel.addAttribute("Typesetting:-msemantics", "matrix");
            wmiMathFencedModel.removeChildren(1, wmiMathFencedModel.getChildCount() - 1);
            this.setActiveModel(wmiMathFencedModel);
        }
        catch (WmiNoReadAccessException wmiNoReadAccessException) {
            WmiErrorLog.log(wmiNoReadAccessException);
        }
        catch (WmiNoWriteAccessException wmiNoWriteAccessException) {
            WmiErrorLog.log(wmiNoWriteAccessException);
        }
        catch (WmiModelIndexOutOfBoundsException wmiModelIndexOutOfBoundsException) {
            WmiErrorLog.log(wmiModelIndexOutOfBoundsException);
        }
    }

    public void updateLambdaModel() throws WmiNoReadAccessException {
        WmiInlineMathModel wmiInlineMathModel = (WmiInlineMathModel)this.getActiveModel();
        WmiCompositeModel wmiCompositeModel = wmiInlineMathModel.getParent();
        WmiMathDocumentModel wmiMathDocumentModel = wmiInlineMathModel.getDocument();
        WmiAttributeSet wmiAttributeSet = wmiInlineMathModel.getAttributes();
        WmiMathContext wmiMathContext = new WmiMathContext((WmiFontAttributeSet)wmiAttributeSet);
        try {
            WmiInlineMathModel wmiInlineMathModel2 = new WmiInlineMathModel(wmiMathDocumentModel);
            WmiMathTokenModel wmiMathTokenModel = WmiMathFactory.createMathIdentifierToken(wmiMathDocumentModel, "&lambda;", wmiMathContext);
            WmiMathTokenModel wmiMathTokenModel2 = WmiMathFactory.createMathOperatorToken(wmiMathDocumentModel, "&ApplyFunction;", wmiMathContext);
            ArrayList<WmiModel> arrayList = new ArrayList<WmiModel>();
            for (int i = 0; i < wmiInlineMathModel.getChildCount() - 1; ++i) {
                WmiInlineMathModel wmiInlineMathModel3 = (WmiInlineMathModel)wmiInlineMathModel.getChild(i);
                arrayList.add(wmiInlineMathModel3.getChild(0));
            }
            arrayList.add(wmiInlineMathModel.getChild(wmiInlineMathModel.getChildCount() - 1));
            WmiMathFencedModel wmiMathFencedModel = new WmiMathFencedModel(wmiMathDocumentModel, arrayList.toArray(new WmiModel[0]), wmiMathContext);
            wmiInlineMathModel2.appendChild(wmiMathTokenModel);
            wmiInlineMathModel2.appendChild(wmiMathTokenModel2);
            wmiInlineMathModel2.appendChild(wmiMathFencedModel);
            wmiInlineMathModel2.setParent(wmiCompositeModel);
            wmiInlineMathModel2.addAttribute("Typesetting:-msemantics", "lambda");
            this.setActiveModel(wmiInlineMathModel2);
        }
        catch (WmiNoReadAccessException wmiNoReadAccessException) {
            WmiErrorLog.log(wmiNoReadAccessException);
        }
        catch (WmiInvalidModelInitializationException wmiInvalidModelInitializationException) {
            WmiErrorLog.log(wmiInvalidModelInitializationException);
        }
        catch (WmiNoWriteAccessException wmiNoWriteAccessException) {
            WmiErrorLog.log(wmiNoWriteAccessException);
        }
    }

    public void updateOperatorModelAttributes(WmiMathOperatorModel wmiMathOperatorModel, WmiCompositeModel wmiCompositeModel) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        try {
            int n = 0;
            int n2 = 0;
            for (int i = 0; i < wmiCompositeModel.getChildCount(); ++i) {
                if (wmiCompositeModel.getChild(i) != wmiMathOperatorModel && !WmiModelUtil.isModelAncestorOfModel(wmiCompositeModel.getChild(i), wmiMathOperatorModel)) continue;
                n = i;
                break;
            }
            n2 = n == 0 ? 0 : (n == wmiCompositeModel.getChildCount() - 1 ? 2 : 1);
            WmiMathOperatorModel.WmiMathOperatorAttributeSet wmiMathOperatorAttributeSet = (WmiMathOperatorModel.WmiMathOperatorAttributeSet)wmiMathOperatorModel.getAttributes();
            WmiMathOperatorDictionary.installAttributes(wmiMathOperatorModel, n2);
        }
        catch (Exception exception) {
            WmiErrorLog.log(exception);
        }
    }

    public String getActiveModelTag() {
        WmiModelTag wmiModelTag = null;
        WmiModel wmiModel = this.getActiveModel();
        if (wmiModel != null) {
            wmiModelTag = wmiModel.getTag();
        }
        return wmiModelTag != null ? wmiModelTag.getName() : null;
    }

    private ArrayList getMSpaceAttribute(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            if (!string.equals("Tab")) {
                if (string.equals("NewLine")) {
                    arrayList.add("linebreak");
                    arrayList.add("newline");
                } else if (string.equals("IndentingNewLine")) {
                    arrayList.add("linebreak");
                    arrayList.add("indentingnewline");
                } else if (string.equals("NoBreak")) {
                    arrayList.add("linebreak");
                    arrayList.add("nobreak");
                } else if (string.equals("GoodBreak")) {
                    arrayList.add("linebreak");
                    arrayList.add("goodbreak");
                } else if (string.equals("BadBreak")) {
                    arrayList.add("linebreak");
                    arrayList.add("badbreak");
                } else if (string.equals("Space")) {
                    arrayList.add("width");
                    arrayList.add("1em");
                } else if (string.equals("NonBreakingSpace") || string.equals("nbsp")) {
                    arrayList.add("width");
                    arrayList.add("1em");
                    arrayList.add("linebreak");
                    arrayList.add("nobreak");
                } else if (string.equals("ZeroWidthSpace")) {
                    arrayList.add("width");
                    arrayList.add("0em");
                } else if (string.equals("VeryThinSpace")) {
                    arrayList.add("width");
                    arrayList.add("0.056em");
                } else if (string.equals("ThinSpace")) {
                    arrayList.add("width");
                    arrayList.add("0.167em");
                } else if (string.equals("MediumSpace")) {
                    arrayList.add("width");
                    arrayList.add("0.222em");
                } else if (string.equals("ThickSpace")) {
                    arrayList.add("width");
                    arrayList.add("0.278em");
                } else if (string.equals("NegativeVeryThinSpace")) {
                    arrayList.add("width");
                    arrayList.add("-0.056em");
                } else if (string.equals("NegativeThinSpace")) {
                    arrayList.add("width");
                    arrayList.add("-0.167em");
                } else if (string.equals("NegativeMediumSpace")) {
                    arrayList.add("width");
                    arrayList.add("-0.222em");
                } else if (string.equals("NegativeThickSpace")) {
                    arrayList.add("width");
                    arrayList.add("-0.278em");
                }
            }
        }
        catch (Exception exception) {
            WmiErrorLog.log(exception);
        }
        return arrayList;
    }

    public boolean parse(Reader reader, WmiCompositeModel wmiCompositeModel, int n) throws WmiParseException, WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        try {
            BufferedReader bufferedReader = new BufferedReader(reader);
            String string = bufferedReader.readLine();
            while (string != null) {
                stringBuffer.append(string);
                string = bufferedReader.readLine();
                if (string == null) continue;
                string = " " + string;
            }
            String string2 = stringBuffer.toString();
            string2 = string2.replaceAll("&", "&amp;");
            string2 = string2.replaceAll("&amp;amp;", "&amp;");
            if (stringBuffer != null) {
                reader = new StringReader(string2);
                bl = super.parse(reader, wmiCompositeModel, n);
            }
        }
        catch (IOException iOException) {
            WmiErrorLog.log(iOException);
        }
        return bl;
    }

    static {
        modelFactoryMap.put(WmiMathMLTag.ABS.getName(), new MathFencedBuilder());
        modelFactoryMap.put(WmiMathMLTag.FLOOR.getName(), new MathFencedBuilder());
        modelFactoryMap.put(WmiMathMLTag.CEILING.getName(), new MathFencedBuilder());
        modelFactoryMap.put(WmiMathMLTag.CARD.getName(), new MathFencedBuilder());
        modelFactoryMap.put(WmiMathMLTag.INVERSE.getName(), new MathInverseBuilder());
        modelFactoryMap.put(WmiMathMLTag.EXP.getName(), new MathExpBuilder());
        modelFactoryMap.put(WmiMathMLTag.TRANSPOSE.getName(), new MathTransposeBuilder());
        modelFactoryMap.put(WmiMathMLTag.POWER.getName(), new MathPowerBuilder());
        modelFactoryMap.put(WmiMathMLTag.DIVIDE.getName(), new MathDivideBuilder());
        modelFactoryMap.put(WmiMathMLTag.ROOT.getName(), new MathRootBuilder());
        modelFactoryMap.put(WmiMathMLTag.CONJUGATE.getName(), new MathConjugateBuilder());
        modelFactoryMap.put(WmiMathMLTag.DIFF.getName(), new MathDiffBuilder());
        modelFactoryMap.put(WmiMathMLTag.PARTIALDIFF.getName(), new MathPartialDiffBuilder());
        modelFactoryMap.put(WmiMathMLTag.LIMIT.getName(), new MathLargeOpBuilder());
        modelFactoryMap.put(WmiMathMLTag.PRODUCT.getName(), new MathLargeOpBuilder());
        modelFactoryMap.put(WmiMathMLTag.SUM.getName(), new MathLargeOpBuilder());
        modelFactoryMap.put(WmiMathMLTag.TENDSTO.getName(), new MathTendsToBuilder());
        modelFactoryMap.put(WmiMathMLTag.LOG.getName(), new MathLogBuilder());
        modelFactoryMap.put(WmiMathMLTag.MEAN.getName(), new MathStatisticsBuilder());
        modelFactoryMap.put(WmiMathMLTag.SDEV.getName(), new MathStatisticsBuilder());
        modelFactoryMap.put(WmiMathMLTag.VARIANCE.getName(), new MathStatisticsBuilder());
        modelFactoryMap.put(WmiMathMLTag.MEDIAN.getName(), new MathStatisticsBuilder());
        modelFactoryMap.put(WmiMathMLTag.MODE.getName(), new MathStatisticsBuilder());
        modelFactoryMap.put(WmiMathMLTag.MOMENT.getName(), new MathStatisticsBuilder());
        modelFactoryMap.put(WmiMathMLTag.DETERMINANT.getName(), new MathDeterminantBuilder());
        modelFactoryMap.put(WmiMathMLTag.SELECTOR.getName(), new MathSelectorBuilder());
        modelFactoryMap.put(WmiMathMLTag.FORALL.getName(), new MathForAllBuilder());
        modelFactoryMap.put(WmiMathMLTag.EXISTS.getName(), new MathExistsBuilder());
        modelFactoryMap.put(WmiMathMLTag.QUOTIENT.getName(), new MathQuotientBuilder());
        modelFactoryMap.put(WmiMathMLTag.INT.getName(), new MathIntegralBuilder());
        modelFactoryMap.put(WmiMathMLTag.CURL.getName(), new MathCurlBuilder());
        modelFactoryMap.put(WmiMathMLTag.DIVERGENCE.getName(), new MathDivergenceBuilder());
        modelFactoryMap.put(WmiMathMLTag.LAPLACIAN.getName(), new MathLaplacianBuilder());
    }

    protected static class MathLaplacianBuilder
    implements WmiMathMLParserModelBuilder {
        protected MathLaplacianBuilder() {
        }

        public WmiModel createModel(WmiMathDocumentModel wmiMathDocumentModel, WmiMathContext wmiMathContext, WmiCompositeModel wmiCompositeModel, WmiInlineMathModel wmiInlineMathModel) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
            WmiInlineMathModel wmiInlineMathModel2;
            WmiMathTokenModel wmiMathTokenModel = WmiMathFactory.createMathOperatorToken(wmiMathDocumentModel, "&Del;", wmiMathContext);
            WmiMathTokenModel wmiMathTokenModel2 = WmiMathFactory.createMathNumericToken(wmiMathDocumentModel, "2", wmiMathContext);
            WmiMathModel[] wmiMathModelArray = new WmiMathModel[]{wmiMathTokenModel, wmiMathTokenModel2};
            WmiSuperscriptModel wmiSuperscriptModel = new WmiSuperscriptModel(wmiMathDocumentModel, wmiMathModelArray, wmiMathContext);
            wmiMathTokenModel.setParent(wmiSuperscriptModel);
            wmiMathTokenModel2.setParent(wmiSuperscriptModel);
            wmiInlineMathModel.replaceChild(wmiSuperscriptModel, 0);
            if (wmiInlineMathModel.getChild(1) instanceof WmiInlineMathModel && (wmiInlineMathModel2 = (WmiInlineMathModel)wmiInlineMathModel.getChild(2)).getChildCount() > 1) {
                try {
                    WmiModel[] wmiModelArray = new WmiModel[]{wmiInlineMathModel2};
                    WmiMathFencedModel wmiMathFencedModel = new WmiMathFencedModel(wmiMathDocumentModel, wmiModelArray, wmiMathContext);
                    wmiInlineMathModel.replaceChild(wmiMathFencedModel, 2);
                }
                catch (WmiInvalidModelInitializationException wmiInvalidModelInitializationException) {
                    WmiErrorLog.log(wmiInvalidModelInitializationException);
                }
            }
            wmiInlineMathModel.addAttribute("Typesetting:-msemantics", "laplacian");
            return wmiInlineMathModel;
        }
    }

    protected static class MathDivergenceBuilder
    implements WmiMathMLParserModelBuilder {
        protected MathDivergenceBuilder() {
        }

        public WmiModel createModel(WmiMathDocumentModel wmiMathDocumentModel, WmiMathContext wmiMathContext, WmiCompositeModel wmiCompositeModel, WmiInlineMathModel wmiInlineMathModel) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
            WmiInlineMathModel wmiInlineMathModel2;
            WmiMathTokenModel wmiMathTokenModel = WmiMathFactory.createMathOperatorToken(wmiMathDocumentModel, "&Del;", wmiMathContext);
            WmiMathTokenModel wmiMathTokenModel2 = WmiMathFactory.createMathOperatorToken(wmiMathDocumentModel, "&sdot;", wmiMathContext);
            wmiInlineMathModel.replaceChild(wmiMathTokenModel, 0);
            wmiInlineMathModel.addChild(wmiMathTokenModel2, 1);
            if (wmiInlineMathModel.getChild(2) instanceof WmiInlineMathModel && (wmiInlineMathModel2 = (WmiInlineMathModel)wmiInlineMathModel.getChild(2)).getChildCount() > 1) {
                try {
                    WmiModel[] wmiModelArray = new WmiModel[]{wmiInlineMathModel2};
                    WmiMathFencedModel wmiMathFencedModel = new WmiMathFencedModel(wmiMathDocumentModel, wmiModelArray, wmiMathContext);
                    wmiInlineMathModel.replaceChild(wmiMathFencedModel, 2);
                }
                catch (WmiInvalidModelInitializationException wmiInvalidModelInitializationException) {
                    WmiErrorLog.log(wmiInvalidModelInitializationException);
                }
            }
            wmiInlineMathModel.addAttribute("Typesetting:-msemantics", "divergence");
            return wmiInlineMathModel;
        }
    }

    protected static class MathCurlBuilder
    implements WmiMathMLParserModelBuilder {
        protected MathCurlBuilder() {
        }

        public WmiModel createModel(WmiMathDocumentModel wmiMathDocumentModel, WmiMathContext wmiMathContext, WmiCompositeModel wmiCompositeModel, WmiInlineMathModel wmiInlineMathModel) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
            WmiInlineMathModel wmiInlineMathModel2;
            WmiMathTokenModel wmiMathTokenModel = WmiMathFactory.createMathOperatorToken(wmiMathDocumentModel, "&Del;", wmiMathContext);
            WmiMathTokenModel wmiMathTokenModel2 = WmiMathFactory.createMathOperatorToken(wmiMathDocumentModel, "&times;", wmiMathContext);
            wmiInlineMathModel.replaceChild(wmiMathTokenModel, 0);
            wmiInlineMathModel.addChild(wmiMathTokenModel2, 1);
            if (wmiInlineMathModel.getChild(2) instanceof WmiInlineMathModel && (wmiInlineMathModel2 = (WmiInlineMathModel)wmiInlineMathModel.getChild(2)).getChildCount() > 1) {
                try {
                    WmiModel[] wmiModelArray = new WmiModel[]{wmiInlineMathModel2};
                    WmiMathFencedModel wmiMathFencedModel = new WmiMathFencedModel(wmiMathDocumentModel, wmiModelArray, wmiMathContext);
                    wmiInlineMathModel.replaceChild(wmiMathFencedModel, 2);
                }
                catch (WmiInvalidModelInitializationException wmiInvalidModelInitializationException) {
                    WmiErrorLog.log(wmiInvalidModelInitializationException);
                }
            }
            wmiInlineMathModel.addAttribute("Typesetting:-msemantics", "curl");
            return wmiInlineMathModel;
        }
    }

    protected static class MathIntegralBuilder
    implements WmiMathMLParserModelBuilder {
        protected MathIntegralBuilder() {
        }

        public WmiModel createModel(WmiMathDocumentModel wmiMathDocumentModel, WmiMathContext wmiMathContext, WmiCompositeModel wmiCompositeModel, WmiInlineMathModel wmiInlineMathModel) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
            WmiInlineMathModel wmiInlineMathModel2;
            Object object;
            WmiInlineMathModel wmiInlineMathModel3 = (WmiInlineMathModel)WmiModelUtil.findFirstDescendantWithAttribute(wmiInlineMathModel, "Typesetting:-msemantics", "bound-variable");
            while (wmiInlineMathModel3 != null) {
                object = ((WmiMathTokenModel)wmiInlineMathModel3.getChild(0)).getTokenContents();
                wmiInlineMathModel2 = new WmiInlineMathModel(wmiMathDocumentModel);
                wmiInlineMathModel2.appendChild(WmiMathFactory.createMathOperatorToken(wmiMathDocumentModel, "&DifferentialD;", wmiMathContext));
                wmiInlineMathModel2.appendChild(WmiMathFactory.createMathIdentifierToken(wmiMathDocumentModel, (String)object, wmiMathContext));
                wmiInlineMathModel.appendChild(wmiInlineMathModel2);
                wmiInlineMathModel.removeChild(wmiInlineMathModel3);
                wmiInlineMathModel3 = (WmiInlineMathModel)WmiModelUtil.findNextModel(wmiInlineMathModel, wmiInlineMathModel3, "Typesetting:-msemantics", "bound-variable");
            }
            ((WmiAbstractMathTokenModel)wmiInlineMathModel.getChild(0)).replaceText("&int;", 0, "int".length());
            object = (WmiInlineMathModel)WmiModelUtil.findFirstDescendantWithAttribute(wmiInlineMathModel, "Typesetting:-msemantics", "lowlimit");
            wmiInlineMathModel2 = (WmiInlineMathModel)WmiModelUtil.findFirstDescendantWithAttribute(wmiInlineMathModel, "Typesetting:-msemantics", "uplimit");
            if (object != null || wmiInlineMathModel2 != null) {
                WmiInlineMathModel wmiInlineMathModel4 = new WmiInlineMathModel(wmiMathDocumentModel);
                WmiInlineMathModel wmiInlineMathModel5 = new WmiInlineMathModel(wmiMathDocumentModel);
                if (object != null) {
                    wmiInlineMathModel4.appendChild((WmiModel)object);
                    wmiInlineMathModel.removeChild((WmiModel)object);
                }
                if (wmiInlineMathModel2 != null) {
                    wmiInlineMathModel5.appendChild(wmiInlineMathModel2);
                    wmiInlineMathModel.removeChild(wmiInlineMathModel2);
                }
                WmiUnderOverModel wmiUnderOverModel = new WmiUnderOverModel(wmiMathDocumentModel, wmiInlineMathModel.getChild(0), wmiInlineMathModel4, wmiInlineMathModel5, wmiMathContext);
                wmiInlineMathModel.replaceChild(wmiUnderOverModel, 0);
            } else {
                WmiMathFencedModel wmiMathFencedModel = (WmiMathFencedModel)WmiModelUtil.findFirstDescendantWithAttribute(wmiInlineMathModel, "Typesetting:-msemantics", "interval");
                if (wmiMathFencedModel != null) {
                    WmiInlineMathModel wmiInlineMathModel6 = new WmiInlineMathModel(wmiMathDocumentModel);
                    WmiInlineMathModel wmiInlineMathModel7 = new WmiInlineMathModel(wmiMathDocumentModel);
                    wmiInlineMathModel6.appendChild(wmiMathFencedModel.getChild(0));
                    wmiInlineMathModel7.appendChild(wmiMathFencedModel.getChild(1));
                    WmiUnderOverModel wmiUnderOverModel = new WmiUnderOverModel(wmiMathDocumentModel, wmiInlineMathModel.getChild(0), wmiInlineMathModel6, wmiInlineMathModel7, wmiMathContext);
                    wmiInlineMathModel.replaceChild(wmiUnderOverModel, 0);
                    wmiInlineMathModel.removeChild(wmiMathFencedModel);
                } else {
                    WmiInlineMathModel wmiInlineMathModel8 = (WmiInlineMathModel)WmiModelUtil.findFirstDescendantWithAttribute(wmiInlineMathModel, "Typesetting:-msemantics", "condition");
                    if (wmiInlineMathModel8 != null) {
                        WmiInlineMathModel wmiInlineMathModel9 = new WmiInlineMathModel(wmiMathDocumentModel);
                        wmiInlineMathModel9.appendChild(wmiInlineMathModel8);
                        WmiUnderModel wmiUnderModel = new WmiUnderModel(wmiMathDocumentModel, wmiInlineMathModel.getChild(0), wmiInlineMathModel9, wmiMathContext);
                        wmiInlineMathModel.replaceChild(wmiUnderModel, 0);
                        wmiInlineMathModel.removeChild(wmiInlineMathModel8);
                    }
                }
            }
            wmiInlineMathModel.addAttribute("Typesetting:-msemantics", "integral");
            return wmiInlineMathModel;
        }
    }

    protected static class MathQuotientBuilder
    implements WmiMathMLParserModelBuilder {
        protected MathQuotientBuilder() {
        }

        public WmiModel createModel(WmiMathDocumentModel wmiMathDocumentModel, WmiMathContext wmiMathContext, WmiCompositeModel wmiCompositeModel, WmiInlineMathModel wmiInlineMathModel) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
            WmiMathFencedModel wmiMathFencedModel = (WmiMathFencedModel)wmiInlineMathModel.getChild(0);
            WmiInlineMathModel wmiInlineMathModel2 = new WmiInlineMathModel(wmiMathDocumentModel);
            wmiInlineMathModel2.appendChild(wmiInlineMathModel.getChild(1));
            WmiMathTokenModel wmiMathTokenModel = WmiMathFactory.createMathOperatorToken(wmiMathDocumentModel, "&sol;", wmiMathContext);
            wmiInlineMathModel2.appendChild(wmiMathTokenModel);
            wmiInlineMathModel2.appendChild(wmiInlineMathModel.getChild(2));
            wmiMathFencedModel.appendChild(wmiInlineMathModel2);
            wmiInlineMathModel.removeChildren(1, 2);
            return wmiInlineMathModel;
        }
    }

    protected static class MathExistsBuilder
    implements WmiMathMLParserModelBuilder {
        protected MathExistsBuilder() {
        }

        public WmiModel createModel(WmiMathDocumentModel wmiMathDocumentModel, WmiMathContext wmiMathContext, WmiCompositeModel wmiCompositeModel, WmiInlineMathModel wmiInlineMathModel) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
            WmiMathOperatorModel wmiMathOperatorModel = (WmiMathOperatorModel)wmiInlineMathModel.getChild(0);
            wmiMathOperatorModel.replaceText("&Exists;", 0, WmiMathMLTag.EXISTS.getName().length());
            for (int i = 1; i < wmiInlineMathModel.getChildCount() - 1; ++i) {
                WmiModel wmiModel = wmiInlineMathModel.getChild(i);
                WmiMathAttributeSet wmiMathAttributeSet = (WmiMathAttributeSet)wmiModel.getAttributesForRead();
                if (wmiMathAttributeSet.getAttribute("Typesetting:-msemantics") != "bound-variable") continue;
                WmiMathTokenModel wmiMathTokenModel = WmiMathFactory.createMathOperatorToken(wmiMathDocumentModel, ",", wmiMathContext);
                wmiInlineMathModel.addChild(wmiMathTokenModel, i + 1);
                ++i;
            }
            WmiMathTokenModel wmiMathTokenModel = WmiMathFactory.createMathOperatorToken(wmiMathDocumentModel, "&verbar;", wmiMathContext);
            wmiInlineMathModel.addChild(wmiMathTokenModel, wmiInlineMathModel.getChildCount() - 1);
            wmiInlineMathModel.addAttribute("Typesetting:-msemantics", "exists");
            return wmiInlineMathModel;
        }
    }

    protected static class MathForAllBuilder
    implements WmiMathMLParserModelBuilder {
        protected MathForAllBuilder() {
        }

        public WmiModel createModel(WmiMathDocumentModel wmiMathDocumentModel, WmiMathContext wmiMathContext, WmiCompositeModel wmiCompositeModel, WmiInlineMathModel wmiInlineMathModel) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
            WmiMathOperatorModel wmiMathOperatorModel = (WmiMathOperatorModel)wmiInlineMathModel.getChild(0);
            wmiMathOperatorModel.replaceText("&forall;", 0, "forall".length());
            for (int i = 1; i < wmiInlineMathModel.getChildCount() - 1; ++i) {
                WmiModel wmiModel = wmiInlineMathModel.getChild(i);
                WmiMathAttributeSet wmiMathAttributeSet = (WmiMathAttributeSet)wmiModel.getAttributesForRead();
                if (wmiMathAttributeSet.getAttribute("Typesetting:-msemantics") != "bound-variable") continue;
                WmiMathTokenModel wmiMathTokenModel = WmiMathFactory.createMathOperatorToken(wmiMathDocumentModel, ",", wmiMathContext);
                wmiInlineMathModel.addChild(wmiMathTokenModel, i + 1);
                ++i;
            }
            wmiInlineMathModel.addAttribute("Typesetting:-msemantics", "forall");
            return wmiInlineMathModel;
        }
    }

    protected static class MathSelectorBuilder
    implements WmiMathMLParserModelBuilder {
        protected MathSelectorBuilder() {
        }

        public WmiModel createModel(WmiMathDocumentModel wmiMathDocumentModel, WmiMathContext wmiMathContext, WmiCompositeModel wmiCompositeModel, WmiInlineMathModel wmiInlineMathModel) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
            WmiSubscriptModel wmiSubscriptModel = new WmiSubscriptModel(wmiMathDocumentModel);
            wmiSubscriptModel.addAttribute("Typesetting:-msemantics", "selector");
            wmiSubscriptModel.replaceChild(wmiInlineMathModel.getChild(1), 0);
            try {
                WmiMathFencedModel wmiMathFencedModel = new WmiMathFencedModel(wmiMathDocumentModel, new WmiModel[0], wmiMathContext);
                wmiMathFencedModel.addAttribute("open", "");
                wmiMathFencedModel.addAttribute("close", "");
                for (int i = 2; i < wmiInlineMathModel.getChildCount(); ++i) {
                    wmiMathFencedModel.appendChild(wmiInlineMathModel.getChild(i));
                }
                wmiSubscriptModel.replaceChild(wmiMathFencedModel, 1);
            }
            catch (WmiInvalidModelInitializationException wmiInvalidModelInitializationException) {
                WmiErrorLog.log(wmiInvalidModelInitializationException);
            }
            wmiInlineMathModel.replaceChild(wmiSubscriptModel, 0);
            wmiInlineMathModel.removeChildren(1, wmiInlineMathModel.getChildCount() - 1);
            return wmiInlineMathModel;
        }
    }

    protected static class MathDeterminantBuilder
    implements WmiMathMLParserModelBuilder {
        protected MathDeterminantBuilder() {
        }

        public WmiModel createModel(WmiMathDocumentModel wmiMathDocumentModel, WmiMathContext wmiMathContext, WmiCompositeModel wmiCompositeModel, WmiInlineMathModel wmiInlineMathModel) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
            WmiMathOperatorModel wmiMathOperatorModel = (WmiMathOperatorModel)wmiInlineMathModel.getChild(0);
            wmiMathOperatorModel.replaceText("det", 0, wmiMathOperatorModel.getText().length());
            WmiMathTokenModel wmiMathTokenModel = WmiMathFactory.createMathOperatorToken(wmiMathDocumentModel, "&ApplyFunction;", wmiMathContext);
            wmiInlineMathModel.addChild(wmiMathTokenModel, 1);
            try {
                WmiModel[] wmiModelArray = new WmiModel[]{wmiInlineMathModel.getChild(2)};
                WmiMathFencedModel wmiMathFencedModel = new WmiMathFencedModel(wmiMathDocumentModel, wmiModelArray, wmiMathContext);
                wmiInlineMathModel.replaceChild(wmiMathFencedModel, 2);
            }
            catch (WmiInvalidModelInitializationException wmiInvalidModelInitializationException) {
                WmiErrorLog.log(wmiInvalidModelInitializationException);
            }
            wmiInlineMathModel.addAttribute("Typesetting:-msemantics", "determinant");
            return wmiInlineMathModel;
        }
    }

    protected static class MathStatisticsBuilder
    implements WmiMathMLParserModelBuilder {
        protected MathStatisticsBuilder() {
        }

        public WmiModel createModel(WmiMathDocumentModel wmiMathDocumentModel, WmiMathContext wmiMathContext, WmiCompositeModel wmiCompositeModel, WmiInlineMathModel wmiInlineMathModel) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
            try {
                WmiMathOperatorModel wmiMathOperatorModel = (WmiMathOperatorModel)wmiInlineMathModel.getChild(0);
                String string = wmiMathOperatorModel.getText();
                ArrayList<WmiModel> arrayList = new ArrayList<WmiModel>();
                for (int i = 1; i < wmiInlineMathModel.getChildCount(); ++i) {
                    arrayList.add(wmiInlineMathModel.getChild(i));
                }
                WmiMathTokenModel wmiMathTokenModel = WmiMathFactory.createMathOperatorToken(wmiMathDocumentModel, "&ApplyFunction;", wmiMathContext);
                WmiMathFencedModel wmiMathFencedModel = new WmiMathFencedModel(wmiMathDocumentModel, arrayList.toArray(new WmiModel[0]), wmiMathContext);
                if (string.equals(WmiMathMLTag.MEAN.getName())) {
                    wmiMathFencedModel.addAttribute("open", "&lang;");
                    wmiMathFencedModel.addAttribute("close", "&rang;");
                    wmiInlineMathModel.replaceChild(wmiMathFencedModel, 0);
                    wmiInlineMathModel.removeChild(1);
                    wmiInlineMathModel.addAttribute("Typesetting:-msemantics", "mean");
                } else if (string.equals(WmiMathMLTag.SDEV.getName())) {
                    wmiMathOperatorModel.replaceText("&sigma;", 0, string.length());
                    wmiInlineMathModel.replaceChild(wmiMathTokenModel, 1);
                    wmiInlineMathModel.appendChild(wmiMathFencedModel);
                    wmiInlineMathModel.addAttribute("Typesetting:-msemantics", "sdev");
                } else if (string.equals(WmiMathMLTag.VARIANCE.getName())) {
                    WmiMathTokenModel wmiMathTokenModel2 = WmiMathFactory.createMathNumericToken(wmiMathDocumentModel, "2", wmiMathContext);
                    WmiMathModel[] wmiMathModelArray = new WmiMathModel[]{wmiMathFencedModel, wmiMathTokenModel2};
                    WmiSuperscriptModel wmiSuperscriptModel = new WmiSuperscriptModel(wmiMathDocumentModel, wmiMathModelArray, wmiMathContext);
                    wmiMathOperatorModel.replaceText("&sigma;", 0, string.length());
                    wmiInlineMathModel.replaceChild(wmiMathTokenModel, 1);
                    wmiInlineMathModel.appendChild(wmiSuperscriptModel);
                    wmiInlineMathModel.addAttribute("Typesetting:-msemantics", "variance");
                } else if (string.equals(WmiMathMLTag.MEDIAN.getName())) {
                    wmiInlineMathModel.replaceChild(wmiMathTokenModel, 1);
                    wmiInlineMathModel.appendChild(wmiMathFencedModel);
                    wmiInlineMathModel.addAttribute("Typesetting:-msemantics", "median");
                } else if (string.equals(WmiMathMLTag.MODE.getName())) {
                    wmiInlineMathModel.replaceChild(wmiMathTokenModel, 1);
                    wmiInlineMathModel.appendChild(wmiMathFencedModel);
                    wmiInlineMathModel.addAttribute("Typesetting:-msemantics", "mode");
                } else if (string.equals(WmiMathMLTag.MOMENT.getName())) {
                    wmiMathFencedModel.removeChildren(0, wmiMathFencedModel.getChildCount());
                    wmiMathFencedModel.addAttribute("open", "&lang;");
                    wmiMathFencedModel.addAttribute("close", "&rang;");
                    WmiSuperscriptModel wmiSuperscriptModel = new WmiSuperscriptModel(wmiMathDocumentModel);
                    WmiModel wmiModel = null;
                    for (int i = 1; i < wmiInlineMathModel.getChildCount(); ++i) {
                        WmiMathAttributeSet wmiMathAttributeSet = (WmiMathAttributeSet)wmiInlineMathModel.getChild(i).getAttributesForRead();
                        String string2 = (String)wmiMathAttributeSet.getAttribute("Typesetting:-msemantics");
                        if (string2 == "degree") {
                            wmiSuperscriptModel.replaceChild(wmiInlineMathModel.getChild(i), 1);
                            continue;
                        }
                        if (string2 == "momentabout") {
                            wmiModel = wmiInlineMathModel.getChild(i);
                            continue;
                        }
                        wmiSuperscriptModel.replaceChild(wmiInlineMathModel.getChild(i), 0);
                    }
                    wmiMathFencedModel.appendChild(wmiSuperscriptModel);
                    wmiInlineMathModel.replaceChild(wmiMathFencedModel, 0);
                    if (wmiModel != null) {
                        wmiInlineMathModel.replaceChild(wmiModel, 1);
                        wmiInlineMathModel.removeChildren(2, wmiInlineMathModel.getChildCount() - 2);
                    } else {
                        wmiInlineMathModel.removeChildren(1, wmiInlineMathModel.getChildCount() - 1);
                    }
                    wmiInlineMathModel.addAttribute("Typesetting:-msemantics", "moment");
                }
            }
            catch (WmiInvalidModelInitializationException wmiInvalidModelInitializationException) {
                WmiErrorLog.log(wmiInvalidModelInitializationException);
            }
            return wmiInlineMathModel;
        }
    }

    protected static class MathLogBuilder
    implements WmiMathMLParserModelBuilder {
        protected MathLogBuilder() {
        }

        public WmiModel createModel(WmiMathDocumentModel wmiMathDocumentModel, WmiMathContext wmiMathContext, WmiCompositeModel wmiCompositeModel, WmiInlineMathModel wmiInlineMathModel) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
            if (wmiInlineMathModel.getChildCount() == 3) {
                WmiSubscriptModel wmiSubscriptModel = new WmiSubscriptModel(wmiMathDocumentModel);
                wmiSubscriptModel.replaceChild(wmiInlineMathModel.getChild(0), 0);
                wmiSubscriptModel.replaceChild(wmiInlineMathModel.getChild(1), 1);
                wmiSubscriptModel.addAttribute("Typesetting:-msemantics", "log");
                wmiInlineMathModel.replaceChild(wmiSubscriptModel, 0);
                wmiInlineMathModel.removeChild(1);
            }
            wmiInlineMathModel.addAttribute("Typesetting:-msemantics", "log");
            return wmiInlineMathModel;
        }
    }

    protected static class MathTendsToBuilder
    implements WmiMathMLParserModelBuilder {
        protected MathTendsToBuilder() {
        }

        public WmiModel createModel(WmiMathDocumentModel wmiMathDocumentModel, WmiMathContext wmiMathContext, WmiCompositeModel wmiCompositeModel, WmiInlineMathModel wmiInlineMathModel) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
            WmiModel wmiModel = wmiInlineMathModel.getChild(1);
            wmiInlineMathModel.replaceChild(wmiInlineMathModel.getChild(0), 1);
            wmiInlineMathModel.replaceChild(wmiModel, 0);
            wmiInlineMathModel.addAttribute("Typesetting:-msemantics", "tendsto");
            return wmiInlineMathModel;
        }
    }

    protected static class MathLargeOpBuilder
    implements WmiMathMLParserModelBuilder {
        protected MathLargeOpBuilder() {
        }

        public WmiModel createModel(WmiMathDocumentModel wmiMathDocumentModel, WmiMathContext wmiMathContext, WmiCompositeModel wmiCompositeModel, WmiInlineMathModel wmiInlineMathModel) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
            WmiUnderOverModel wmiUnderOverModel = (WmiUnderOverModel)wmiInlineMathModel.getChild(0);
            WmiMathTokenModel wmiMathTokenModel = (WmiMathTokenModel)wmiUnderOverModel.getChild(0);
            String string = wmiMathTokenModel.getTokenContents();
            WmiInlineMathModel wmiInlineMathModel2 = new WmiInlineMathModel(wmiMathDocumentModel);
            if (string.equals("lim")) {
                WmiInlineMathModel wmiInlineMathModel3 = (WmiInlineMathModel)wmiInlineMathModel.getChild(2);
                if (wmiInlineMathModel3.getChildCount() == 1 && wmiInlineMathModel3.getChild(0) instanceof WmiNumericModel) {
                    WmiInlineMathModel wmiInlineMathModel4 = (WmiInlineMathModel)wmiInlineMathModel.getChild(1);
                    wmiInlineMathModel2.appendChild(wmiInlineMathModel4.getChild(0));
                    wmiInlineMathModel2.appendChild(WmiMathFactory.createMathOperatorToken(wmiMathDocumentModel, "&rightarrow;", wmiMathContext));
                    wmiInlineMathModel2.appendChild(((WmiInlineMathModel)wmiInlineMathModel.getChild(2)).getChild(0));
                    wmiUnderOverModel.replaceChild(wmiInlineMathModel2, 1);
                    wmiInlineMathModel.removeChildren(1, 2);
                } else {
                    wmiInlineMathModel2.appendChild(wmiInlineMathModel.getChild(2));
                    wmiUnderOverModel.replaceChild(wmiInlineMathModel2, 1);
                    wmiInlineMathModel.removeChildren(1, 2);
                }
                wmiInlineMathModel3.addAttribute("Typesetting:-msemantics", "condition");
                wmiInlineMathModel.getChild(0).addAttribute("Typesetting:-msemantics", "limit");
                wmiInlineMathModel.addAttribute("Typesetting:-msemantics", "limit");
            } else if (string.equals("\u03a3") || string.equals("\u03a0")) {
                WmiInlineMathModel wmiInlineMathModel5 = (WmiInlineMathModel)WmiModelUtil.findFirstDescendantWithAttribute(wmiInlineMathModel, "Typesetting:-msemantics", "bound-variable");
                WmiInlineMathModel wmiInlineMathModel6 = (WmiInlineMathModel)WmiModelUtil.findFirstDescendantWithAttribute(wmiInlineMathModel, "Typesetting:-msemantics", "lowlimit");
                WmiInlineMathModel wmiInlineMathModel7 = (WmiInlineMathModel)WmiModelUtil.findFirstDescendantWithAttribute(wmiInlineMathModel, "Typesetting:-msemantics", "uplimit");
                if (wmiInlineMathModel6 != null || wmiInlineMathModel7 != null) {
                    WmiInlineMathModel wmiInlineMathModel8 = new WmiInlineMathModel(wmiMathDocumentModel);
                    WmiInlineMathModel wmiInlineMathModel9 = new WmiInlineMathModel(wmiMathDocumentModel);
                    if (wmiInlineMathModel6 != null) {
                        wmiInlineMathModel8.appendChild(wmiInlineMathModel5.getChild(0));
                        wmiInlineMathModel8.appendChild(WmiMathFactory.createMathOperatorToken(wmiMathDocumentModel, "&equals;", wmiMathContext));
                        wmiInlineMathModel8.appendChild(wmiInlineMathModel6);
                        wmiInlineMathModel.removeChild(wmiInlineMathModel6);
                    }
                    if (wmiInlineMathModel7 != null) {
                        wmiInlineMathModel9.appendChild(wmiInlineMathModel7);
                        wmiInlineMathModel.removeChild(wmiInlineMathModel7);
                    }
                    wmiUnderOverModel.replaceChild(wmiInlineMathModel8, 1);
                    wmiUnderOverModel.replaceChild(wmiInlineMathModel9, 2);
                } else {
                    WmiInlineMathModel wmiInlineMathModel10 = (WmiInlineMathModel)WmiModelUtil.findFirstDescendantWithAttribute(wmiInlineMathModel, "Typesetting:-msemantics", "condition");
                    if (wmiInlineMathModel10 != null) {
                        WmiInlineMathModel wmiInlineMathModel11 = new WmiInlineMathModel(wmiMathDocumentModel);
                        wmiInlineMathModel11.appendChild(wmiInlineMathModel10);
                        wmiUnderOverModel.replaceChild(wmiInlineMathModel11, 1);
                        wmiInlineMathModel.removeChild(wmiInlineMathModel10);
                    }
                }
                wmiInlineMathModel.removeChild(wmiInlineMathModel5);
                if (string.equals("\u03a3")) {
                    wmiInlineMathModel.addAttribute("Typesetting:-msemantics", "sum");
                    wmiInlineMathModel.getChild(0).addAttribute("Typesetting:-msemantics", "sum");
                } else {
                    wmiInlineMathModel.addAttribute("Typesetting:-msemantics", "product");
                    wmiInlineMathModel.getChild(0).addAttribute("Typesetting:-msemantics", "product");
                }
            }
            return wmiInlineMathModel;
        }
    }

    protected static class MathPartialDiffBuilder
    implements WmiMathMLParserModelBuilder {
        protected MathPartialDiffBuilder() {
        }

        public WmiModel createModel(WmiMathDocumentModel wmiMathDocumentModel, WmiMathContext wmiMathContext, WmiCompositeModel wmiCompositeModel, WmiInlineMathModel wmiInlineMathModel) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
            WmiMathModel wmiMathModel;
            if (WmiModelUtil.findFirstDescendantWithAttribute(wmiInlineMathModel, "Typesetting:-msemantics", "bound-variable") == null) {
                try {
                    wmiMathModel = new WmiSubscriptModel(wmiMathDocumentModel);
                    ((WmiAbstractArrayCompositeModel)((Object)wmiMathModel)).replaceChild(WmiMathFactory.createMathOperatorToken(wmiMathDocumentModel, "D", wmiMathContext), 0);
                    WmiMathFencedModel wmiMathFencedModel = (WmiMathFencedModel)wmiInlineMathModel.getChild(1);
                    WmiMathFencedModel.WmiFencedAttributeSet wmiFencedAttributeSet = (WmiMathFencedModel.WmiFencedAttributeSet)wmiMathFencedModel.getAttributes();
                    wmiFencedAttributeSet.addAttribute("open", "");
                    wmiFencedAttributeSet.addAttribute("close", "");
                    wmiMathFencedModel.setAttributes(wmiFencedAttributeSet);
                    ((WmiAbstractArrayCompositeModel)((Object)wmiMathModel)).replaceChild(wmiMathFencedModel, 1);
                    ((WmiInlineMathModel)wmiInlineMathModel.getChild(0)).appendChild(wmiMathModel);
                    WmiModel[] wmiModelArray = new WmiModel[]{wmiInlineMathModel.getChild(2)};
                    WmiMathFencedModel wmiMathFencedModel2 = new WmiMathFencedModel(wmiMathDocumentModel, wmiModelArray, wmiMathContext);
                    ((WmiInlineMathModel)wmiInlineMathModel.getChild(0)).appendChild(wmiMathFencedModel2);
                    wmiInlineMathModel.removeChildren(1, 2);
                }
                catch (WmiInvalidModelInitializationException wmiInvalidModelInitializationException) {
                    WmiErrorLog.log(wmiInvalidModelInitializationException);
                }
            } else {
                WmiAbstractModel wmiAbstractModel;
                Cloneable cloneable;
                WmiMathModel wmiMathModel2;
                wmiMathModel = null;
                for (int i = 0; i < wmiInlineMathModel.getChildCount(); ++i) {
                    wmiMathModel2 = (WmiMathModel)wmiInlineMathModel.getChild(i);
                    cloneable = (WmiMathAttributeSet)wmiMathModel2.getAttributesForRead();
                    if (((WmiAbstractArrayAttributeSet)cloneable).getAttribute("Typesetting:-msemantics") != "degree") continue;
                    wmiMathModel = wmiMathModel2;
                }
                WmiFractionModel wmiFractionModel = new WmiFractionModel(wmiMathDocumentModel, wmiMathContext);
                wmiMathModel2 = new WmiInlineMathModel(wmiMathDocumentModel);
                cloneable = new WmiInlineMathModel(wmiMathDocumentModel);
                int n = 0;
                WmiInlineMathModel wmiInlineMathModel2 = (WmiInlineMathModel)WmiModelUtil.findFirstDescendantWithAttribute(wmiInlineMathModel, "Typesetting:-msemantics", "bound-variable");
                while (wmiInlineMathModel2 != null) {
                    ++n;
                    ((WmiAbstractArrayCompositeModel)cloneable).appendChild(WmiMathFactory.createMathOperatorToken(wmiMathDocumentModel, "&PartialD;", wmiMathContext));
                    wmiAbstractModel = (WmiIdentifierModel)WmiModelUtil.findFirstDescendantOfTag((WmiModel)wmiInlineMathModel2, WmiModelTag.MATH_IDENTIFIER);
                    WmiInlineMathModel wmiInlineMathModel3 = (WmiInlineMathModel)WmiModelUtil.findFirstDescendantWithAttribute(wmiInlineMathModel2, "Typesetting:-msemantics", "degree");
                    WmiSuperscriptModel wmiSuperscriptModel = new WmiSuperscriptModel(wmiMathDocumentModel);
                    wmiSuperscriptModel.replaceChild(wmiAbstractModel, 0);
                    if (wmiInlineMathModel3 == null) {
                        if (wmiMathModel != null) {
                            wmiSuperscriptModel.replaceChild(wmiMathModel, 1);
                        } else {
                            wmiSuperscriptModel.replaceChild(WmiMathFactory.createMathIdentifierToken(wmiMathDocumentModel, "", wmiMathContext), 1);
                        }
                    } else {
                        wmiSuperscriptModel.replaceChild(wmiInlineMathModel3, 1);
                    }
                    ((WmiAbstractArrayCompositeModel)cloneable).appendChild(wmiSuperscriptModel);
                    wmiInlineMathModel.removeChild(wmiInlineMathModel2);
                    wmiInlineMathModel2 = (WmiInlineMathModel)WmiModelUtil.findNextModel(wmiInlineMathModel, wmiInlineMathModel2, "Typesetting:-msemantics", "bound-variable");
                }
                wmiAbstractModel = new WmiSuperscriptModel(wmiMathDocumentModel);
                ((WmiAbstractArrayCompositeModel)wmiAbstractModel).replaceChild(WmiMathFactory.createMathOperatorToken(wmiMathDocumentModel, "&PartialD;", wmiMathContext), 0);
                if (wmiMathModel != null) {
                    ((WmiAbstractArrayCompositeModel)wmiAbstractModel).replaceChild(wmiMathModel, 1);
                } else {
                    ((WmiAbstractArrayCompositeModel)wmiAbstractModel).replaceChild(WmiMathFactory.createMathNumericToken(wmiMathDocumentModel, String.valueOf(n), wmiMathContext), 1);
                }
                ((WmiAbstractArrayCompositeModel)((Object)wmiMathModel2)).appendChild(wmiAbstractModel);
                wmiFractionModel.replaceChild(wmiMathModel2, 0);
                wmiFractionModel.replaceChild((WmiModel)((Object)cloneable), 1);
                wmiFractionModel.setParent(wmiInlineMathModel);
                ((WmiInlineMathModel)wmiInlineMathModel.getChild(0)).appendChild(wmiFractionModel);
            }
            wmiMathModel = (WmiInlineMathModel)WmiModelUtil.findFirstDescendantWithAttribute(wmiInlineMathModel, "Typesetting:-msemantics", "degree");
            if (wmiMathModel != null) {
                wmiInlineMathModel.removeChild(wmiMathModel);
            }
            wmiInlineMathModel.addAttribute("Typesetting:-msemantics", "partialdiff");
            return wmiInlineMathModel;
        }
    }

    protected static class MathDiffBuilder
    implements WmiMathMLParserModelBuilder {
        protected MathDiffBuilder() {
        }

        public WmiModel createModel(WmiMathDocumentModel wmiMathDocumentModel, WmiMathContext wmiMathContext, WmiCompositeModel wmiCompositeModel, WmiInlineMathModel wmiInlineMathModel) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
            WmiInlineMathModel wmiInlineMathModel2 = wmiInlineMathModel;
            if (wmiInlineMathModel.getChildCount() == 2) {
                WmiInlineMathModel wmiInlineMathModel3 = (WmiInlineMathModel)wmiInlineMathModel.getChild(0);
                wmiInlineMathModel3.appendChild(wmiInlineMathModel.getChild(1));
                wmiInlineMathModel3.appendChild(WmiMathFactory.createMathOperatorToken(wmiMathDocumentModel, "&prime;", wmiMathContext));
                wmiInlineMathModel3.setParent(wmiCompositeModel);
                wmiInlineMathModel2 = wmiInlineMathModel3;
            } else {
                WmiAbstractArrayCompositeMathModel wmiAbstractArrayCompositeMathModel;
                WmiFractionModel wmiFractionModel = new WmiFractionModel(wmiMathDocumentModel, wmiMathContext);
                String string = "";
                WmiInlineMathModel wmiInlineMathModel4 = (WmiInlineMathModel)WmiModelUtil.findFirstDescendantWithAttribute(wmiInlineMathModel, "Typesetting:-msemantics", "bound-variable");
                WmiInlineMathModel wmiInlineMathModel5 = null;
                if (wmiInlineMathModel4 != null && (wmiInlineMathModel5 = (WmiInlineMathModel)WmiModelUtil.findFirstDescendantWithAttribute(wmiInlineMathModel4, "Typesetting:-msemantics", "degree")) != null) {
                    string = ((WmiMathTokenModel)wmiInlineMathModel5.getChild(0)).getTokenContents();
                }
                WmiInlineMathModel wmiInlineMathModel6 = new WmiInlineMathModel(wmiMathDocumentModel);
                WmiMathTokenModel wmiMathTokenModel = WmiMathFactory.createMathOperatorToken(wmiMathDocumentModel, "&DifferentialD;", wmiMathContext);
                wmiInlineMathModel6.appendChild(wmiMathTokenModel);
                if (wmiInlineMathModel5 != null) {
                    wmiAbstractArrayCompositeMathModel = new WmiSuperscriptModel(wmiMathDocumentModel);
                    wmiAbstractArrayCompositeMathModel.replaceChild(wmiInlineMathModel4.getChild(0), 0);
                    wmiAbstractArrayCompositeMathModel.replaceChild(WmiMathFactory.createMathIdentifierToken(wmiMathDocumentModel, string, wmiMathContext), 1);
                    wmiInlineMathModel6.appendChild(wmiAbstractArrayCompositeMathModel);
                }
                wmiAbstractArrayCompositeMathModel = new WmiInlineMathModel(wmiMathDocumentModel);
                if (wmiInlineMathModel4 != null) {
                    WmiInlineMathModel wmiInlineMathModel7 = new WmiInlineMathModel(wmiMathDocumentModel);
                    wmiInlineMathModel7.appendChild(WmiMathFactory.createMathOperatorToken(wmiMathDocumentModel, "&DifferentialD;", wmiMathContext));
                    WmiSuperscriptModel wmiSuperscriptModel = new WmiSuperscriptModel(wmiMathDocumentModel);
                    if (wmiInlineMathModel5 == null) {
                        wmiInlineMathModel7.appendChild(wmiInlineMathModel4.getChild(0));
                    } else {
                        wmiSuperscriptModel.replaceChild(wmiInlineMathModel4.getChild(0), 0);
                        wmiSuperscriptModel.replaceChild(WmiMathFactory.createMathIdentifierToken(wmiMathDocumentModel, string, wmiMathContext), 1);
                        wmiInlineMathModel7.appendChild(wmiSuperscriptModel);
                    }
                    wmiAbstractArrayCompositeMathModel.appendChild(wmiInlineMathModel7);
                    wmiInlineMathModel.removeChild(wmiInlineMathModel4);
                }
                wmiFractionModel.replaceChild(wmiInlineMathModel6, 0);
                wmiFractionModel.replaceChild(wmiAbstractArrayCompositeMathModel, 1);
                wmiFractionModel.setParent(wmiInlineMathModel);
                wmiInlineMathModel.replaceChild(wmiFractionModel, 0);
            }
            wmiInlineMathModel2.addAttribute("Typesetting:-msemantics", "diff");
            return wmiInlineMathModel2;
        }
    }

    protected static class MathConjugateBuilder
    implements WmiMathMLParserModelBuilder {
        protected MathConjugateBuilder() {
        }

        public WmiModel createModel(WmiMathDocumentModel wmiMathDocumentModel, WmiMathContext wmiMathContext, WmiCompositeModel wmiCompositeModel, WmiInlineMathModel wmiInlineMathModel) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
            WmiOverModel wmiOverModel = null;
            WmiOverModel wmiOverModel2 = (WmiOverModel)wmiInlineMathModel.getChild(0);
            WmiModel wmiModel = wmiInlineMathModel.getChild(1);
            if (wmiModel != null) {
                wmiOverModel2.replaceChild(wmiModel, 0);
                wmiOverModel2.replaceChild(WmiMathFactory.createMathOperatorToken(wmiMathDocumentModel, "&conjugate0;", wmiMathContext), 1);
            }
            wmiOverModel2.setParent(wmiCompositeModel);
            wmiOverModel2.addAttribute("Typesetting:-msemantics", "conjugate");
            wmiOverModel = wmiOverModel2;
            return wmiOverModel;
        }
    }

    protected static class MathRootBuilder
    implements WmiMathMLParserModelBuilder {
        protected MathRootBuilder() {
        }

        public WmiModel createModel(WmiMathDocumentModel wmiMathDocumentModel, WmiMathContext wmiMathContext, WmiCompositeModel wmiCompositeModel, WmiInlineMathModel wmiInlineMathModel) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
            WmiRootModel wmiRootModel = null;
            WmiRootModel wmiRootModel2 = (WmiRootModel)wmiInlineMathModel.getChild(0);
            if (wmiInlineMathModel.getChildCount() == 3) {
                wmiRootModel2.replaceChild(wmiInlineMathModel.getChild(2), 0);
            }
            wmiRootModel2.replaceChild(wmiInlineMathModel.getChild(1), 1);
            wmiRootModel2.setParent(wmiCompositeModel);
            wmiRootModel = wmiRootModel2;
            return wmiRootModel;
        }
    }

    protected static class MathDivideBuilder
    implements WmiMathMLParserModelBuilder {
        protected MathDivideBuilder() {
        }

        public WmiModel createModel(WmiMathDocumentModel wmiMathDocumentModel, WmiMathContext wmiMathContext, WmiCompositeModel wmiCompositeModel, WmiInlineMathModel wmiInlineMathModel) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
            WmiFractionModel wmiFractionModel = null;
            WmiFractionModel wmiFractionModel2 = (WmiFractionModel)wmiInlineMathModel.getChild(0);
            WmiModel wmiModel = wmiInlineMathModel.getChild(1);
            WmiModel wmiModel2 = wmiInlineMathModel.getChild(2);
            if (wmiModel != null && wmiModel2 != null) {
                wmiFractionModel2.replaceChild(wmiModel, 0);
                wmiFractionModel2.replaceChild(wmiModel2, 1);
                wmiFractionModel2.setParent(wmiCompositeModel);
                wmiFractionModel = wmiFractionModel2;
            }
            return wmiFractionModel;
        }
    }

    protected static class MathPowerBuilder
    implements WmiMathMLParserModelBuilder {
        protected MathPowerBuilder() {
        }

        public WmiModel createModel(WmiMathDocumentModel wmiMathDocumentModel, WmiMathContext wmiMathContext, WmiCompositeModel wmiCompositeModel, WmiInlineMathModel wmiInlineMathModel) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
            WmiSuperscriptModel wmiSuperscriptModel = null;
            WmiSuperscriptModel wmiSuperscriptModel2 = (WmiSuperscriptModel)wmiInlineMathModel.getChild(0);
            WmiModel wmiModel = wmiInlineMathModel.getChild(1);
            WmiModel wmiModel2 = wmiInlineMathModel.getChild(2);
            if (wmiModel != null && wmiModel2 != null) {
                if (wmiModel instanceof WmiInlineMathModel) {
                    try {
                        WmiModel[] wmiModelArray = new WmiModel[]{wmiModel};
                        WmiMathFencedModel wmiMathFencedModel = new WmiMathFencedModel(wmiMathDocumentModel, wmiModelArray, wmiMathContext);
                        wmiSuperscriptModel2.replaceChild(wmiMathFencedModel, 0);
                    }
                    catch (WmiInvalidModelInitializationException wmiInvalidModelInitializationException) {
                        WmiErrorLog.log(wmiInvalidModelInitializationException);
                    }
                } else {
                    wmiSuperscriptModel2.replaceChild(wmiModel, 0);
                }
                wmiSuperscriptModel2.replaceChild(wmiModel2, 1);
                wmiSuperscriptModel2.setParent(wmiCompositeModel);
                wmiSuperscriptModel = wmiSuperscriptModel2;
            }
            return wmiSuperscriptModel;
        }
    }

    protected static class MathTransposeBuilder
    implements WmiMathMLParserModelBuilder {
        protected MathTransposeBuilder() {
        }

        public WmiModel createModel(WmiMathDocumentModel wmiMathDocumentModel, WmiMathContext wmiMathContext, WmiCompositeModel wmiCompositeModel, WmiInlineMathModel wmiInlineMathModel) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
            WmiSuperscriptModel wmiSuperscriptModel = null;
            WmiSuperscriptModel wmiSuperscriptModel2 = (WmiSuperscriptModel)wmiInlineMathModel.getChild(0);
            WmiModel wmiModel = wmiInlineMathModel.getChild(1);
            if (wmiModel != null) {
                WmiMathTokenModel wmiMathTokenModel = WmiMathFactory.createMathIdentifierToken(wmiMathDocumentModel, "T", wmiMathContext);
                wmiSuperscriptModel2.replaceChild(wmiModel, 0);
                wmiSuperscriptModel2.replaceChild(wmiMathTokenModel, 1);
                wmiSuperscriptModel2.setParent(wmiCompositeModel);
                wmiSuperscriptModel = wmiSuperscriptModel2;
            }
            return wmiSuperscriptModel;
        }
    }

    protected static class MathExpBuilder
    implements WmiMathMLParserModelBuilder {
        protected MathExpBuilder() {
        }

        public WmiModel createModel(WmiMathDocumentModel wmiMathDocumentModel, WmiMathContext wmiMathContext, WmiCompositeModel wmiCompositeModel, WmiInlineMathModel wmiInlineMathModel) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
            WmiSuperscriptModel wmiSuperscriptModel = null;
            WmiSuperscriptModel wmiSuperscriptModel2 = (WmiSuperscriptModel)wmiInlineMathModel.getChild(0);
            WmiModel wmiModel = wmiInlineMathModel.getChild(1);
            if (wmiModel != null) {
                WmiMathTokenModel wmiMathTokenModel = WmiMathFactory.createMathIdentifierToken(wmiMathDocumentModel, "&exponentiale;", wmiMathContext);
                wmiSuperscriptModel2.replaceChild(wmiMathTokenModel, 0);
                wmiSuperscriptModel2.replaceChild(wmiModel, 1);
                wmiSuperscriptModel2.setParent(wmiCompositeModel);
                wmiSuperscriptModel = wmiSuperscriptModel2;
            }
            return wmiSuperscriptModel;
        }
    }

    protected static class MathInverseBuilder
    implements WmiMathMLParserModelBuilder {
        protected MathInverseBuilder() {
        }

        public WmiModel createModel(WmiMathDocumentModel wmiMathDocumentModel, WmiMathContext wmiMathContext, WmiCompositeModel wmiCompositeModel, WmiInlineMathModel wmiInlineMathModel) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
            WmiSuperscriptModel wmiSuperscriptModel = null;
            WmiSuperscriptModel wmiSuperscriptModel2 = (WmiSuperscriptModel)wmiInlineMathModel.getChild(0);
            WmiModel wmiModel = wmiInlineMathModel.getChild(1);
            if (wmiModel != null) {
                try {
                    wmiSuperscriptModel2.replaceChild(wmiModel, 0);
                    WmiMathTokenModel wmiMathTokenModel = WmiMathFactory.createMathNumericToken(wmiMathDocumentModel, "-1", wmiMathContext);
                    WmiModel[] wmiModelArray = new WmiModel[]{wmiMathTokenModel};
                    WmiMathFencedModel wmiMathFencedModel = new WmiMathFencedModel(wmiMathDocumentModel, wmiModelArray, wmiMathContext);
                    wmiSuperscriptModel2.replaceChild(wmiMathFencedModel, 1);
                    wmiSuperscriptModel2.setParent(wmiCompositeModel);
                    wmiSuperscriptModel = wmiSuperscriptModel2;
                }
                catch (WmiInvalidModelInitializationException wmiInvalidModelInitializationException) {
                    WmiErrorLog.log(wmiInvalidModelInitializationException);
                }
            }
            return wmiSuperscriptModel;
        }
    }

    protected static class MathFencedBuilder
    implements WmiMathMLParserModelBuilder {
        protected MathFencedBuilder() {
        }

        public WmiModel createModel(WmiMathDocumentModel wmiMathDocumentModel, WmiMathContext wmiMathContext, WmiCompositeModel wmiCompositeModel, WmiInlineMathModel wmiInlineMathModel) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
            WmiMathFencedModel wmiMathFencedModel = (WmiMathFencedModel)wmiInlineMathModel.getChild(0);
            WmiModel wmiModel = wmiInlineMathModel.getChild(1);
            if (wmiModel != null) {
                wmiMathFencedModel.appendChild(wmiModel);
                wmiInlineMathModel.removeChild(wmiModel);
            }
            return wmiInlineMathModel;
        }
    }

    public static class WmiMathMLDeclaration {
        private String type;
        private int nargs;
        private String occurence;
        private WmiInlineMathModel definition;

        public void setType(String string) {
            this.type = string;
        }

        public void setNargs(int n) {
            this.nargs = n;
        }

        public void setOccurence(String string) {
            this.occurence = string;
        }

        public void setDefinition(WmiInlineMathModel wmiInlineMathModel) {
            this.definition = wmiInlineMathModel;
        }
    }
}

