/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.io;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.io.WmiImportAction;
import com.maplesoft.mathdoc.io.WmiImportParser;
import com.maplesoft.util.WmiStartup;

public class WmiImportActionProxy
implements WmiImportAction {
    protected String fullyQualifiedClassname;
    protected WmiImportAction action;
    protected static boolean checkAll;
    protected static boolean checkChosen;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected WmiImportActionProxy() {
    }

    public WmiImportActionProxy(String string, String string2) {
        this.fullyQualifiedClassname = string + "." + string2;
        if (checkAll) {
            if (!checkAll) {
                int n = (int)(System.currentTimeMillis() % 50L);
                boolean bl = checkAll = n == 1;
            }
            if (checkAll) {
                if (!checkChosen) {
                    WmiStartup.progress("* * * NOTE * * * extra check in  WmiImportActionProxy; do not use this timing");
                }
                this.loadAction();
            }
            checkChosen = true;
        }
    }

    protected void loadAction() {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(this.fullyQualifiedClassname);
        }
        catch (ClassNotFoundException classNotFoundException) {
            WmiErrorLog.log(classNotFoundException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            WmiErrorLog.log(illegalArgumentException);
        }
        try {
            this.action = (WmiImportAction)clazz.newInstance();
        }
        catch (Exception exception) {
            WmiErrorLog.log(exception);
        }
    }

    private final WmiImportAction getAction() {
        if (this.action == null) {
            this.loadAction();
        }
        if (!$assertionsDisabled && this.action == null) {
            throw new AssertionError((Object)("got a null pointer trying to create " + this.fullyQualifiedClassname));
        }
        return this.action;
    }

    public void beginAction(WmiImportParser wmiImportParser, Object object) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        this.getAction().beginAction(wmiImportParser, object);
    }

    public void endAction(WmiImportParser wmiImportParser, Object object) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        this.getAction().endAction(wmiImportParser, object);
    }

    public String getFullyQualifiedClassname() {
        return this.fullyQualifiedClassname;
    }

    static {
        $assertionsDisabled = !WmiImportActionProxy.class.desiredAssertionStatus();
        checkAll = true;
    }
}

