/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.font;

import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.font.FontIndexer;
import com.maplesoft.mathdoc.font.WmiFontMetrics;
import com.maplesoft.mathdoc.font.WmiFontResolver;
import com.maplesoft.mathdoc.font.WmiLocalizedFontResolver;
import com.maplesoft.mathdoc.font.WmiSharedGlyphVector;
import com.maplesoft.mathdoc.model.math.WmiAbstractMathTokenModel;
import com.maplesoft.mathdoc.model.math.WmiMathGlyphModel;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.math.WmiMathGlyphView;
import com.maplesoft.util.RuntimePlatform;
import com.maplesoft.util.StringTools;
import com.maplesoft.util.WmiMathEntityNameMapper;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphMetrics;
import java.awt.font.GlyphVector;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;

public class WmiTextLayout {
    private Font font;
    private GlyphVector glyphs;
    private WmiTextLayout next = null;
    private String contents;
    private FontRenderContext frc = null;
    private int contentsLengthFromThisToEnd;
    private int widthFromThisToEnd;
    private short baseline;
    private short height;
    private short preKernAdjust;
    private short postKernAdjust;
    private boolean layoutChainContainsTabs = false;
    private int horizontalOffset = -1;
    private int mglyphColor = 0;
    private static final float ANTIALIAS_THRESHOLD = 16.0f;

    private WmiTextLayout() {
    }

    public static WmiTextLayout createTextLayout(char c, Font font, WmiMathDocumentView wmiMathDocumentView) {
        return WmiTextLayout.createTextLayout(Character.toString(c), font, wmiMathDocumentView, true, 0);
    }

    public static WmiTextLayout createTextLayout(char c, Font font, WmiMathDocumentView wmiMathDocumentView, boolean bl) {
        return WmiTextLayout.createTextLayout(Character.toString(c), font, wmiMathDocumentView, bl, 0);
    }

    public static WmiTextLayout createTextLayout(String string, Font font, WmiMathDocumentView wmiMathDocumentView) {
        return WmiTextLayout.createTextLayout(string, font, wmiMathDocumentView, true, 0);
    }

    public static WmiTextLayout createTextLayout(String string, Font font, WmiMathDocumentView wmiMathDocumentView, boolean bl) {
        return WmiTextLayout.createTextLayout(string, font, wmiMathDocumentView, bl, 0);
    }

    public static WmiTextLayout createTextLayout(String string, Font font, WmiMathDocumentView wmiMathDocumentView, boolean bl, int n) {
        WmiTextLayout wmiTextLayout;
        WmiTextLayout wmiTextLayout2 = wmiTextLayout = new WmiTextLayout();
        int n2 = WmiTextLayout.updateNewLayout(wmiTextLayout2, string, font, wmiMathDocumentView, bl, n);
        boolean bl2 = string != null && string.length() > 0 && WmiMathEntityNameMapper.isMathEntity(string.charAt(0));
        LinkedList<WmiTextLayout> linkedList = null;
        while (string.length() > 0) {
            if ((n2 = wmiTextLayout2.checkForTabs(wmiTextLayout2.contents, n2)) == 0 || bl2) {
                WmiTextLayout.resolveFontAtFirstChar(wmiTextLayout2, bl2);
                if (string.length() == 1) break;
                string = string.substring(1);
            } else {
                if (n2 < 0) {
                    if (!WmiTextLayout.startsWithTab(string)) {
                        wmiTextLayout2.glyphs = new WmiSharedGlyphVector(wmiTextLayout2.font, string, wmiTextLayout2.frc);
                        break;
                    }
                    wmiTextLayout2.contents = string;
                    break;
                }
                wmiTextLayout2.glyphs = new WmiSharedGlyphVector(wmiTextLayout2.font, string.substring(0, n2), wmiTextLayout2.frc);
                wmiTextLayout2.contents = string.substring(0, n2);
                string = string.substring(n2);
            }
            if (linkedList == null) {
                linkedList = new LinkedList<WmiTextLayout>();
                linkedList.addFirst(wmiTextLayout2);
            }
            wmiTextLayout2 = wmiTextLayout2.next = new WmiTextLayout();
            linkedList.addFirst(wmiTextLayout2);
            n2 = WmiTextLayout.updateNewLayout(wmiTextLayout2, string, font, wmiMathDocumentView, bl, 0);
            bl2 = string != null && string.length() > 0 && WmiMathEntityNameMapper.isMathEntity(string.charAt(0));
        }
        if (wmiTextLayout2.glyphs == null) {
            wmiTextLayout2.glyphs = new WmiSharedGlyphVector(font, string, wmiTextLayout.frc);
        }
        if (linkedList == null) {
            WmiTextLayout.calculateMetrics(wmiTextLayout);
        } else {
            Iterator iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                wmiTextLayout2 = (WmiTextLayout)iterator.next();
                WmiTextLayout.calculateMetrics(wmiTextLayout2);
            }
        }
        return wmiTextLayout;
    }

    public static WmiTextLayout createTextLayout(WmiAbstractMathTokenModel wmiAbstractMathTokenModel, Font font, WmiMathDocumentView wmiMathDocumentView, boolean bl) throws WmiNoReadAccessException {
        WmiTextLayout wmiTextLayout;
        WmiTextLayout wmiTextLayout2 = wmiTextLayout = new WmiTextLayout();
        ArrayList arrayList = wmiAbstractMathTokenModel.getGlyphIndices();
        String string = wmiAbstractMathTokenModel.getText();
        int n = 0;
        LinkedList<WmiTextLayout> linkedList = null;
        for (int i = 0; i < arrayList.size() + 1; ++i) {
            boolean bl2;
            int n2 = string.length();
            if (i < arrayList.size()) {
                n2 = (Integer)arrayList.get(i);
            }
            String string2 = string.substring(n, n2);
            int n3 = WmiTextLayout.updateNewLayout(wmiTextLayout2, string2, font, wmiMathDocumentView, bl, 0);
            if (linkedList == null) {
                linkedList = new LinkedList<WmiTextLayout>();
            }
            linkedList.addFirst(wmiTextLayout2);
            boolean bl3 = bl2 = string2 != null && string2.length() > 0 && WmiMathEntityNameMapper.isMathEntity(string2.charAt(0));
            while (string2.length() > 0) {
                if ((n3 = wmiTextLayout2.checkForTabs(wmiTextLayout2.contents, n3)) == 0 || bl2) {
                    WmiTextLayout.resolveFontAtFirstChar(wmiTextLayout2, bl2);
                    if (string2.length() == 1) break;
                    string2 = string2.substring(1);
                    continue;
                }
                if (n3 < 0) {
                    if (!WmiTextLayout.startsWithTab(string2)) {
                        wmiTextLayout2.glyphs = new WmiSharedGlyphVector(wmiTextLayout2.font, string2, wmiTextLayout2.frc);
                        break;
                    }
                    wmiTextLayout2.contents = string2;
                    break;
                }
                wmiTextLayout2.glyphs = new WmiSharedGlyphVector(wmiTextLayout2.font, string2.substring(0, n3), wmiTextLayout2.frc);
                wmiTextLayout2.contents = string2.substring(0, n3);
                string2 = string2.substring(n3);
            }
            if (wmiTextLayout2.glyphs == null) {
                wmiTextLayout2.glyphs = new WmiSharedGlyphVector(font, string2, wmiTextLayout.frc);
            }
            if (i < arrayList.size()) {
                wmiTextLayout2 = wmiTextLayout2.next = new WmiTextLayout();
                WmiMathGlyphModel wmiMathGlyphModel = wmiAbstractMathTokenModel.getGlyph(i);
                WmiMathGlyphModel.WmiMathGlyphAttributeSet wmiMathGlyphAttributeSet = (WmiMathGlyphModel.WmiMathGlyphAttributeSet)wmiMathGlyphModel.getAttributesForRead();
                String string3 = wmiMathGlyphAttributeSet.getFontFamily();
                Font font2 = new Font(string3, 0, wmiMathDocumentView.getZoomFactor() * WmiMathGlyphView.DEFAULT_FONT_SIZE / 100);
                WmiTextLayout.updateNewLayout(wmiTextLayout2, " ", font2, wmiMathDocumentView, bl, 0);
                int[] nArray = new int[]{wmiMathGlyphAttributeSet.getIndex()};
                wmiTextLayout2.glyphs = font2.createGlyphVector(wmiTextLayout2.frc, nArray);
                GlyphMetrics glyphMetrics = wmiTextLayout2.glyphs.getGlyphMetrics(0);
                if (font2.getName().equals("") || glyphMetrics.getBounds2D().getWidth() <= 0.0) {
                    WmiTextLayout.updateNewLayout(wmiTextLayout2, wmiMathGlyphAttributeSet.getAlt(), font2, wmiMathDocumentView, bl, 0);
                    wmiTextLayout2.glyphs = new WmiSharedGlyphVector(font, wmiMathGlyphAttributeSet.getAlt(), wmiTextLayout.frc);
                }
                wmiTextLayout2.mglyphColor = wmiMathGlyphAttributeSet.getForeground();
                wmiTextLayout2 = wmiTextLayout2.next = new WmiTextLayout();
            }
            n = n2;
        }
        if (linkedList == null) {
            WmiTextLayout.calculateMetrics(wmiTextLayout);
        } else {
            Iterator iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                wmiTextLayout2 = (WmiTextLayout)iterator.next();
                WmiTextLayout.calculateMetrics(wmiTextLayout2);
            }
        }
        return wmiTextLayout;
    }

    public WmiTextLayout splitLayout(int n, int n2) {
        WmiTextLayout wmiTextLayout = null;
        int n3 = this.contents.length();
        WmiTextLayout wmiTextLayout2 = this;
        while (wmiTextLayout2 != null && n >= n3) {
            if ((wmiTextLayout2 = wmiTextLayout2.getNext()) == null) continue;
            n -= n3;
            if (wmiTextLayout2.contents == null) continue;
            n3 = wmiTextLayout2.contents.length();
        }
        if (wmiTextLayout2 != null) {
            wmiTextLayout = new WmiTextLayout();
            if (n + n2 > n3) {
                n2 = n3 - n;
            }
            wmiTextLayout.contents = wmiTextLayout2.contents.substring(n + n2);
            wmiTextLayout2.contents = wmiTextLayout2.contents.substring(0, n);
            wmiTextLayout.font = wmiTextLayout2.font;
            wmiTextLayout.frc = wmiTextLayout2.frc;
            GlyphVector glyphVector = wmiTextLayout2.getGlyphs();
            wmiTextLayout.glyphs = glyphVector instanceof WmiSharedGlyphVector ? ((WmiSharedGlyphVector)glyphVector).splitVector(n, n2) : new WmiSharedGlyphVector(wmiTextLayout.font, wmiTextLayout.contents, wmiTextLayout.frc);
            wmiTextLayout.next = wmiTextLayout2.next;
            wmiTextLayout2.next = null;
            int n4 = 0;
            for (WmiTextLayout wmiTextLayout3 = wmiTextLayout; wmiTextLayout3 != null; wmiTextLayout3 = wmiTextLayout3.getNext()) {
                if (wmiTextLayout3.containsTabs()) {
                    wmiTextLayout3.setHorizontalOffset(n4);
                }
                n4 += wmiTextLayout3.getSegmentWidth();
            }
            WmiTextLayout.calculateMetrics(wmiTextLayout);
            WmiTextLayout.calculateMetrics(this);
            WmiTextLayout.updateContentLength(wmiTextLayout2);
            WmiTextLayout.updateContentLength(wmiTextLayout);
            WmiTextLayout.updateContentLength(this);
        }
        return wmiTextLayout;
    }

    private static void updateContentLength(WmiTextLayout wmiTextLayout) {
        WmiTextLayout wmiTextLayout2;
        int n = 0;
        for (wmiTextLayout2 = wmiTextLayout; wmiTextLayout2 != null; wmiTextLayout2 = wmiTextLayout2.getNext()) {
            n += wmiTextLayout2.contents.length();
        }
        for (wmiTextLayout2 = wmiTextLayout; wmiTextLayout2 != null; wmiTextLayout2 = wmiTextLayout2.getNext()) {
            wmiTextLayout2.contentsLengthFromThisToEnd = n;
            n -= wmiTextLayout2.contents.length();
        }
    }

    private static int updateNewLayout(WmiTextLayout wmiTextLayout, String string, Font font, WmiMathDocumentView wmiMathDocumentView, boolean bl, int n) {
        WmiLocalizedFontResolver wmiLocalizedFontResolver;
        wmiTextLayout.contentsLengthFromThisToEnd = string.length();
        wmiTextLayout.font = font;
        wmiTextLayout.widthFromThisToEnd = n;
        int n2 = bl ? FontIndexer.getForceMappingIndex(string) : -1;
        int n3 = n2 == -1 ? WmiFontResolver.canDisplayUpTo(font, string) : WmiFontResolver.canDisplayUpTo(font, string.substring(0, n2));
        if (n2 >= 0 && (n2 < n3 || n3 < 0)) {
            n3 = n2;
        }
        if ((wmiLocalizedFontResolver = WmiLocalizedFontResolver.getInstance()) != null) {
            int n4 = wmiLocalizedFontResolver.getContinuousRunIndex(string);
            wmiTextLayout.font = wmiLocalizedFontResolver.mapFont(wmiTextLayout.font, string);
            if (n4 != -1 && (n3 == -1 || n4 < n3)) {
                n3 = n4;
            }
        }
        if (wmiMathDocumentView != null && wmiMathDocumentView.isPrintView()) {
            wmiTextLayout.frc = WmiFontMetrics.getPrintContext();
        } else {
            wmiTextLayout.frc = WmiFontMetrics.getScreenContext();
            if (!RuntimePlatform.isMac() && string != null && wmiTextLayout.frc.isAntiAliased() && wmiTextLayout.getFont().getSize2D() <= 16.0f && string.indexOf(8722) >= 0) {
                wmiTextLayout.frc = new FontRenderContext(wmiTextLayout.frc.getTransform(), false, true);
            }
        }
        wmiTextLayout.contents = string;
        return n3;
    }

    private static void calculateMetrics(WmiTextLayout wmiTextLayout) {
        wmiTextLayout.widthFromThisToEnd = wmiTextLayout.getSegmentWidth();
        WmiFontMetrics wmiFontMetrics = WmiFontResolver.getFontMetrics(wmiTextLayout.getMappedFont(0));
        wmiTextLayout.baseline = (short)(wmiFontMetrics.getFontProperty(3, wmiTextLayout.frc) + wmiFontMetrics.getFontProperty(0, wmiTextLayout.frc));
        wmiTextLayout.height = (short)(wmiTextLayout.baseline + wmiFontMetrics.getFontProperty(4, wmiTextLayout.frc));
        if (wmiTextLayout.next != null) {
            WmiTextLayout.calculateMetrics(wmiTextLayout.next);
            wmiTextLayout.widthFromThisToEnd += wmiTextLayout.next.getWidth();
        }
    }

    private static void resolveFontAtFirstChar(WmiTextLayout wmiTextLayout, boolean bl) {
        Font font = wmiTextLayout.font;
        String string = null;
        char c = wmiTextLayout.contents.charAt(0);
        if (!bl && StringTools.isCJKCharacter(c)) {
            string = RuntimePlatform.isMac() && wmiTextLayout.font.getFamily().equals("Hiragino Mincho Pro") ? "Hiragino Mincho Pro" : WmiFontResolver.getCJKFontForText(wmiTextLayout.contents);
        }
        font = string != null ? new Font(string, wmiTextLayout.font.getStyle(), wmiTextLayout.font.getSize()) : WmiFontResolver.getFontForCharacter(wmiTextLayout.contents, wmiTextLayout.font);
        c = WmiFontResolver.mapCharacterForFont(c, font);
        String string2 = Character.toString(c);
        wmiTextLayout.glyphs = new WmiSharedGlyphVector(font, string2, wmiTextLayout.frc);
        wmiTextLayout.contents = string2;
        wmiTextLayout.font = font;
    }

    private static boolean startsWithTab(String string) {
        return string != null && string.length() > 0 && string.charAt(0) == '\t';
    }

    private int checkForTabs(String string, int n) {
        if (WmiTextLayout.startsWithTab(string)) {
            n = -1;
            for (int i = 1; i < string.length(); ++i) {
                if (string.charAt(i) == '\t') continue;
                n = i;
                break;
            }
            this.layoutChainContainsTabs = true;
        } else {
            int n2 = string.indexOf(9);
            if (n2 >= 0) {
                n = n2;
                this.layoutChainContainsTabs = true;
            }
        }
        return n;
    }

    private boolean isTabLayout() {
        return WmiTextLayout.startsWithTab(this.contents);
    }

    public boolean containsTabs() {
        return this.layoutChainContainsTabs;
    }

    public void setHorizontalOffset(int n) {
        this.horizontalOffset = n;
        if (this.next != null) {
            this.next.setHorizontalOffset(n + this.getSegmentWidth());
        }
    }

    public int getTabWidth() {
        return 72;
    }

    private int getWidthOfTabCount(int n) {
        if (n == 0) {
            return 0;
        }
        int n2 = this.getTabWidth();
        int n3 = n2 - this.horizontalOffset % n2;
        return (n - 1) * n2 + n3;
    }

    public void applyKerningAdjustment(boolean bl, boolean bl2) {
        if (this.contents.length() > 0) {
            this.preKernAdjust = bl ? this.computePreKernAdjustment() : (short)0;
            this.postKernAdjust = bl2 ? this.computePostKernAdjustment() : (short)0;
        }
    }

    public short computePreKernAdjustment() {
        short s = 0;
        if (this.contents.length() > 0) {
            Font font = this.getMappedFont(0);
            char c = this.getMappedCharacter(0);
            WmiFontMetrics wmiFontMetrics = WmiFontResolver.getFontMetrics(font);
            s = (short)Math.round(wmiFontMetrics.getCharacterProperty(1, c, this.frc));
        }
        return s;
    }

    public short computePostKernAdjustment() {
        short s = 0;
        if (this.contents.length() > 0) {
            int n = this.contents.length() - 1;
            Font font = this.getMappedFont(n);
            char c = this.getMappedCharacter(n);
            WmiFontMetrics wmiFontMetrics = WmiFontResolver.getFontMetrics(font);
            s = (short)Math.round(wmiFontMetrics.getCharacterProperty(3, c, this.frc));
        }
        return s;
    }

    public int computeSpaceAbove() {
        int n = 0;
        int n2 = 0;
        Font font = null;
        WmiFontMetrics wmiFontMetrics = null;
        for (WmiTextLayout wmiTextLayout = this; wmiTextLayout != null; wmiTextLayout = wmiTextLayout.getNext()) {
            int n3;
            int n4;
            String string = wmiTextLayout.contents;
            int n5 = n4 = string != null ? string.length() : 0;
            if (n4 > 0) {
                font = wmiTextLayout.getMappedFont(0);
                wmiFontMetrics = WmiFontResolver.getFontMetrics(font);
            }
            for (n3 = 0; n3 < n4; ++n3) {
                int n6 = Math.round(wmiFontMetrics.getCharacterProperty(4, string.charAt(n3), this.frc));
                if (n6 <= n) continue;
                n = n6;
            }
            n3 = wmiFontMetrics.getFontProperty(3, this.frc);
            if (n3 <= n2) continue;
            n2 = n3;
        }
        return n2 - n;
    }

    public int computeSpaceBelow() {
        int n = 0;
        int n2 = 0;
        Font font = null;
        WmiFontMetrics wmiFontMetrics = null;
        for (WmiTextLayout wmiTextLayout = this; wmiTextLayout != null; wmiTextLayout = wmiTextLayout.getNext()) {
            int n3;
            int n4;
            String string = wmiTextLayout.contents;
            int n5 = n4 = string != null ? string.length() : 0;
            if (n4 > 0) {
                font = wmiTextLayout.getMappedFont(0);
                wmiFontMetrics = WmiFontResolver.getFontMetrics(font);
            }
            for (n3 = 0; n3 < n4; ++n3) {
                int n6 = wmiFontMetrics.getCharacterProperty(5, string.charAt(n3), this.frc);
                if (n6 <= n) continue;
                n = n6;
            }
            n3 = wmiFontMetrics.getFontProperty(4);
            if (n3 <= n2) continue;
            n2 = n3;
        }
        return n2 - n;
    }

    public void draw(Graphics graphics, int n, int n2) {
        this.draw(graphics, n, n2, this.preKernAdjust);
    }

    public void draw(Graphics graphics, int n, int n2, int n3) {
        this.drawThis(graphics, n, n2, n3);
        n = n + n3 + this.getSegmentWidth();
        for (WmiTextLayout wmiTextLayout = this.next; wmiTextLayout != null; wmiTextLayout = wmiTextLayout.getNext()) {
            wmiTextLayout.drawThis(graphics, n, n2, 0);
            n += wmiTextLayout.getSegmentWidth();
        }
    }

    private void drawThis(Graphics graphics, int n, int n2, int n3) {
        if (this.glyphs instanceof WmiSharedGlyphVector) {
            this.glyphs = this.font.createGlyphVector(this.frc, this.contents);
        }
        Color color = graphics.getColor();
        if (this.mglyphColor != 0) {
            graphics.setColor(new Color(this.mglyphColor));
        }
        ((Graphics2D)graphics).drawGlyphVector(this.glyphs, n + n3, n2);
        if (this.mglyphColor != 0) {
            graphics.setColor(color);
        }
    }

    public Font getMappedFont(int n) {
        WmiTextLayout wmiTextLayout;
        Font font = null;
        int n2 = this.contents.length();
        for (wmiTextLayout = this; wmiTextLayout != null && n > n2; wmiTextLayout = wmiTextLayout.getNext(), n -= n2) {
            n2 = this.contents.length();
        }
        if (wmiTextLayout != null) {
            font = wmiTextLayout.getGlyphs().getFont();
        }
        return font;
    }

    public char getMappedCharacter(int n) {
        WmiTextLayout wmiTextLayout;
        char c = '\uffff';
        int n2 = this.contents.length();
        for (wmiTextLayout = this; wmiTextLayout != null && n > n2; wmiTextLayout = wmiTextLayout.getNext(), n -= n2) {
            n2 = wmiTextLayout.contents.length();
        }
        if (wmiTextLayout != null) {
            c = wmiTextLayout.getContents().charAt(n);
        }
        return c;
    }

    public void drawAsString(Graphics graphics, int n, int n2) {
        this.drawAsString(graphics, n, n2, this.preKernAdjust);
    }

    public void drawAsString(Graphics graphics, int n, int n2, int n3) {
        this.drawThisAsString(graphics, n, n2, n3);
        n += this.getSegmentWidth() + n3;
        for (WmiTextLayout wmiTextLayout = this.next; wmiTextLayout != null; wmiTextLayout = wmiTextLayout.getNext()) {
            wmiTextLayout.drawThisAsString(graphics, n, n2, 0);
            n += wmiTextLayout.getSegmentWidth();
        }
    }

    private void drawThisAsString(Graphics graphics, int n, int n2, int n3) {
        Font font = graphics.getFont();
        graphics.setFont(this.getMappedFont(0));
        graphics.drawString(this.contents, n + n3, n2);
        graphics.setFont(font);
    }

    public int getBaseline() {
        return this.baseline;
    }

    public int getCaretPosition(int n, boolean bl) {
        return WmiTextLayout.getCaretPositionFromHead(this, n, bl);
    }

    private static int getCaretPositionFromHead(WmiTextLayout wmiTextLayout, int n, boolean bl) {
        boolean bl2;
        if (!bl) {
            ++n;
        }
        int n2 = 0;
        WmiTextLayout wmiTextLayout2 = wmiTextLayout;
        boolean bl3 = bl2 = wmiTextLayout2 == null;
        while (!bl2) {
            n2 += wmiTextLayout2.getPreKernAdjust();
            int n3 = wmiTextLayout2.contents.length();
            if (n < 0) {
                bl2 = true;
                continue;
            }
            if (n <= n3) {
                bl2 = true;
                if (wmiTextLayout2.isTabLayout()) {
                    n2 += wmiTextLayout2.getWidthOfTabCount(n);
                    continue;
                }
                n2 += WmiTextLayout.getHorizontalOffset(n, wmiTextLayout2.getGlyphs());
                continue;
            }
            if (wmiTextLayout2.getNext() != null) {
                n2 += wmiTextLayout2.getSegmentWidth();
                n -= n3;
                wmiTextLayout2 = wmiTextLayout2.getNext();
                continue;
            }
            bl2 = true;
            n2 += wmiTextLayout2.getWidth();
        }
        return n2;
    }

    public static int getHorizontalOffset(int n, GlyphVector glyphVector) {
        int n2 = 0;
        n2 = glyphVector instanceof WmiSharedGlyphVector ? (int)((WmiSharedGlyphVector)glyphVector).getHorizontalOffset(n) : (int)glyphVector.getGlyphPosition(n).getX();
        return n2;
    }

    public int getHeight() {
        return this.height;
    }

    public int getIndex(Point point) {
        return WmiTextLayout.getIndexFromHead(this, point);
    }

    private static int getIndexFromHead(WmiTextLayout wmiTextLayout, Point point) {
        int n = 0;
        boolean bl = false;
        WmiTextLayout wmiTextLayout2 = wmiTextLayout;
        Point point2 = (Point)point.clone();
        while (!bl) {
            int n2 = wmiTextLayout2.contents.length();
            int n3 = wmiTextLayout2.getSegmentWidth();
            int n4 = (int)point.getX() - wmiTextLayout2.getPreKernAdjust();
            if (n4 < n3) {
                bl = true;
                int n5 = n2;
                int n6 = wmiTextLayout2.isTabLayout() ? 0 : WmiTextLayout.getHorizontalOffset(0, wmiTextLayout2.getGlyphs());
                for (int i = 0; i < n2; ++i) {
                    int n7;
                    int n8 = n7 = wmiTextLayout2.isTabLayout() ? wmiTextLayout2.getWidthOfTabCount(i + 1) : WmiTextLayout.getHorizontalOffset(i + 1, wmiTextLayout2.getGlyphs());
                    if (n6 > n4) {
                        n5 = i;
                        break;
                    }
                    if (n7 > n4 && (n6 + n7) / 2 > n4) {
                        n5 = i;
                        break;
                    }
                    n6 = n7;
                }
                n += n5;
                continue;
            }
            if (wmiTextLayout2.getNext() != null) {
                point.translate(-n3, 0);
                n += n2;
                wmiTextLayout2 = wmiTextLayout2.getNext();
                continue;
            }
            bl = true;
            n += n2;
        }
        point.x = point2.x;
        point.y = point2.y;
        return n;
    }

    public int getWidth() {
        int n = this.widthFromThisToEnd + this.preKernAdjust + this.postKernAdjust;
        return n;
    }

    public int getSegmentWidth() {
        int n = this.isTabLayout() ? this.getWidthOfTabCount(this.contents.length()) : WmiTextLayout.getHorizontalOffset(this.contents.length(), this.glyphs);
        return n;
    }

    public Font getFont() {
        return this.font;
    }

    public int getTextLength() {
        return this.contentsLengthFromThisToEnd;
    }

    private GlyphVector getGlyphs() {
        return this.glyphs;
    }

    private WmiTextLayout getNext() {
        return this.next;
    }

    private String getContents() {
        return this.contents;
    }

    private int getPreKernAdjust() {
        return this.preKernAdjust;
    }

    public FontRenderContext getFontRenderContext() {
        return this.frc;
    }
}

