/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.font;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.font.FontIndexer;
import com.maplesoft.mathdoc.font.MaplePiIndexer;
import com.maplesoft.mathdoc.font.WmiFontCache;
import com.maplesoft.mathdoc.font.WmiFontMetrics;
import com.maplesoft.mathdoc.model.WmiFontAttributeSet;
import com.maplesoft.util.ResourceLoader;
import com.maplesoft.util.RuntimeLocale;
import com.maplesoft.util.RuntimePlatform;
import com.maplesoft.util.StringToolsJapanese;
import com.maplesoft.util.StringToolsSimplifiedChinese;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;

public class WmiFontResolver {
    public static float DPI_SCALE_FACTOR = 1.0f;
    public static final String SYMBOL_FONT = "ESSTIXOne";
    public static final String ESSTIX_SYMBOL_FONT = "ESSTIXOne";
    public static final String FONT_RESOURCES_PACKAGE = "/com/maplesoft/mathdoc/font/resources/";
    private static final String MAPLE_PI_FONT_FILE_NAME = "MaplePi.ttf";
    public static final String FONT_KEY_POSTFIX = ".font";
    private static final String REQUIRED_SYMBOL_CHARACTERS = "\u23a7\u23ab\u23aa\u239b\u239e\u23a4";
    public static final String MAPLE_PI_FONT_NAME = "MaplePi";
    public static final String ESSTIX_ONE_FONT_FILE_NAME = "ESSTIX1_.TTF";
    private static FontIndexer maplePiIndexer = null;
    private static Font maplePiFont;
    private static Font esstixSourceFont;
    private static final int MAX_ZOOM_FACTOR = 1000;
    private static final int MAX_FONT_SIZE = 50;
    private static final Map fontName2IndexerClassName;
    private static final Map fontIndexerMap;
    protected static HashSet monospacedFamilySet;
    private static String[] indexedFonts;
    private static HashMap[][] fontCache;
    private static HashMap[][] printFontCache;
    private static HashMap fontFamilyCache;
    private static HashMap metricsCache;
    private static String[] availableFontFamilies;
    private static String defaultSerifFontFamily;
    private static Font[] asianFonts;
    private static String defaultAsianFontName;
    private static final String FONT_DEFAULT_MONOSPACED = "Lucida Sans Typewriter";
    private static final String FONT_DEFAULT_SANSSERIF = "Lucida Sans";
    private static final String FONT_DEFAULT_SERIF = "Lucida Bright";
    private static final String FONT_TIMES_NEW_ROMAN = "Times New Roman";
    private static final String FONT_DEFAULT_MONOSPACED_JAPANESE;
    private static final String FONT_DEFAULT_SANSSERIF_JAPANESE;
    private static final String FONT_DEFAULT_SERIF_JAPANESE;
    public static final String FONT_DEFAULT_JAPANESE;
    public static final String FONT_DEFAULT_KOREAN = "\ubc14\ud0d5\uccb4";
    public static final String FONT_DEFAULT_CHINESE_SIMPLIFIED = "SimSun";
    public static final String FONT_DEFAULT_CHINESE_TRADITIONAL = "MingLiU";
    private static final String[] FONT_FAMILIES_MONOSPACED;
    private static final String[] FONT_FAMILIES_SERIF;
    private static final String[] FONT_FAMILIES_SANSSERIF;
    private static Map fontFamilyMap;
    public static final int MAP_ALL_CHARS = -1;
    public static final int MAP_ONE_CHAR = 1;
    private static WmiFontCache esstixCache;
    private static WmiFontCache maplePiCache;

    private static FontIndexer getFontIndexer(String string) {
        if (!fontIndexerMap.containsKey(string)) {
            String string2 = (String)fontName2IndexerClassName.get(string);
            if (string2 == null) {
                return null;
            }
            try {
                Class<?> clazz = Class.forName(string2);
                fontIndexerMap.put(string, clazz.newInstance());
            }
            catch (Exception exception) {
                WmiErrorLog.log(exception);
            }
        }
        return (FontIndexer)fontIndexerMap.get(string);
    }

    private static String getDefaultJapaneseSansSerifFont() {
        String string = null;
        string = RuntimePlatform.isMac() ? (RuntimePlatform.getMacOSVersion() <= 3 ? "Osaka" : "Hiragino Kaku Gothic Pro") : "MS Gothic";
        return string;
    }

    private static Map buildFontFamilyMap() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        WmiFontResolver.addFontFamilyMappings(hashMap, FONT_FAMILIES_MONOSPACED, WmiFontResolver.getDefaultMonospacedFontFamily());
        WmiFontResolver.addFontFamilyMappings(hashMap, FONT_FAMILIES_SANSSERIF, WmiFontResolver.getDefaultSansSerifFontFamily());
        WmiFontResolver.addFontFamilyMappings(hashMap, FONT_FAMILIES_SERIF, WmiFontResolver.getDefaultSerifFontFamily());
        WmiFontResolver.getAvailableFontFamilyNames();
        for (int i = 0; i < availableFontFamilies.length; ++i) {
            hashMap.put(availableFontFamilies[i], availableFontFamilies[i]);
        }
        hashMap.put("ESSTIXOne", MAPLE_PI_FONT_NAME);
        if (RuntimeLocale.isJapanese()) {
            WmiFontResolver.addFontFamilyMappingIfNecessary(StringToolsJapanese.JAPANESE_FONT_NAMES, StringToolsJapanese.JAPANESE_FONT_ALTERNATE_NAMES, hashMap);
        } else {
            Locale locale = Locale.getDefault();
            if (RuntimeLocale.areLocalesEqual(locale, Locale.SIMPLIFIED_CHINESE)) {
                WmiFontResolver.addFontFamilyMappingIfNecessary(StringToolsSimplifiedChinese.SIMPLIFIED_CHINESE_FONT_NAMES, StringToolsSimplifiedChinese.SIMPLIFIED_CHINESE_FONT_ALTERNATE_NAMES, hashMap);
            }
        }
        return hashMap;
    }

    private static void addFontFamilyMappingIfNecessary(String[] stringArray, String[] stringArray2, Map map) {
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            String string2 = stringArray2[i];
            int n = WmiFontResolver.binarySearch(availableFontFamilies, 0, availableFontFamilies.length, string);
            if (n >= 0) continue;
            map.put(string, string2);
        }
    }

    private static void addFontFamilyMappings(Map map, String[] stringArray, String string) {
        for (int i = 0; i < stringArray.length; ++i) {
            map.put(stringArray[i], string);
        }
    }

    private static String getFontFamily(Font font) {
        String string = (String)fontFamilyCache.get(font);
        if (string == null) {
            string = font.getFamily();
            fontFamilyCache.put(font, string);
        }
        return string;
    }

    private WmiFontResolver() {
    }

    private static String[] getAllFontNames(GraphicsEnvironment graphicsEnvironment) {
        Font[] fontArray = graphicsEnvironment.getAllFonts();
        String[] stringArray = new String[fontArray.length];
        for (int i = 0; i < fontArray.length; ++i) {
            stringArray[i] = fontArray[i].getName();
        }
        return stringArray;
    }

    private static String[] getFontFamilyNames(GraphicsEnvironment graphicsEnvironment) {
        String[] stringArray = graphicsEnvironment.getAvailableFontFamilyNames();
        return stringArray;
    }

    public static String[] getAvailableFontFamilyNames() {
        if (availableFontFamilies == null) {
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            try {
                availableFontFamilies = WmiFontResolver.getFontFamilyNames(graphicsEnvironment);
            }
            catch (NullPointerException nullPointerException) {
                try {
                    availableFontFamilies = WmiFontResolver.getAllFontNames(graphicsEnvironment);
                }
                catch (NullPointerException nullPointerException2) {
                    // empty catch block
                }
            }
            if (availableFontFamilies != null) {
                int n;
                int n2 = -1;
                if (RuntimeLocale.isJapanese() || RuntimeLocale.isKorean()) {
                    n2 = WmiFontResolver.binarySearch(availableFontFamilies, 0, availableFontFamilies.length, "Monospaced");
                }
                if ((n = Arrays.binarySearch(availableFontFamilies, "ESSTIXOne")) > -1) {
                    ArrayList<String> arrayList = new ArrayList<String>(availableFontFamilies.length);
                    for (int i = 0; i < availableFontFamilies.length; ++i) {
                        if (i == n || n2 != -1 && i == n2) continue;
                        arrayList.add(availableFontFamilies[i]);
                    }
                    availableFontFamilies = arrayList.toArray(new String[arrayList.size()]);
                }
            }
        }
        return availableFontFamilies;
    }

    private static int binarySearch(String[] stringArray, int n, int n2, String string) {
        int n3 = -1;
        if (n < n2) {
            n3 = (n2 - n) / 2 + n;
            int n4 = stringArray[n3].compareToIgnoreCase(string);
            if (n4 > 0) {
                n3 = WmiFontResolver.binarySearch(stringArray, n, n3, string);
            } else if (n4 < 0) {
                n3 = WmiFontResolver.binarySearch(stringArray, n3 + 1, n2, string);
            }
        }
        return n3;
    }

    public static int canDisplayUpTo(Font font, String string) {
        int n;
        int n2 = -1;
        FontIndexer fontIndexer = WmiFontResolver.getFontIndexer(WmiFontResolver.getFontFamily(font));
        if (fontIndexer != null) {
            n2 = n = string.length();
            for (int i = 0; i < n; ++i) {
                char c = fontIndexer.get(string.charAt(i));
                if (c != '\u0000') continue;
                n2 = i;
                break;
            }
        }
        if (n2 == -1) {
            for (n = 0; n < string.length(); ++n) {
                if (string.charAt(n) == '\n' || font.canDisplay(string.charAt(n))) continue;
                n2 = n;
                break;
            }
        }
        return n2;
    }

    public static boolean isMonospacedFont(Font font) {
        String string = WmiFontResolver.getFontFamily(font);
        return monospacedFamilySet.contains(string.toLowerCase());
    }

    public static String findExistingFontFamily(String string) {
        if ((string = (String)fontFamilyMap.get(string)) == null) {
            string = WmiFontResolver.getDefaultSerifFontFamily();
        }
        return string;
    }

    public static String getDefaultMonospacedFontFamily() {
        String string = FONT_DEFAULT_MONOSPACED;
        if (RuntimeLocale.isJapanese()) {
            string = FONT_DEFAULT_MONOSPACED_JAPANESE;
        } else if (RuntimeLocale.isKorean()) {
            string = FONT_DEFAULT_KOREAN;
        }
        return string;
    }

    public static String getDefaultSerifFontFamily() {
        if (fontFamilyMap == null) {
            return FONT_DEFAULT_SERIF;
        }
        if (defaultSerifFontFamily == null) {
            defaultSerifFontFamily = fontFamilyMap == null || fontFamilyMap.get(FONT_TIMES_NEW_ROMAN) == null ? FONT_DEFAULT_SERIF : (String)fontFamilyMap.get(FONT_TIMES_NEW_ROMAN);
            if (RuntimeLocale.isJapanese()) {
                defaultSerifFontFamily = FONT_DEFAULT_SERIF_JAPANESE;
            } else if (RuntimeLocale.isKorean()) {
                defaultSerifFontFamily = FONT_DEFAULT_KOREAN;
            }
        }
        return defaultSerifFontFamily;
    }

    public static String getDefaultSansSerifFontFamily() {
        String string = FONT_DEFAULT_SANSSERIF;
        if (RuntimeLocale.isJapanese()) {
            string = FONT_DEFAULT_SANSSERIF_JAPANESE;
        } else if (RuntimeLocale.isKorean()) {
            string = FONT_DEFAULT_KOREAN;
        }
        return string;
    }

    public static String getDefaultStyleFontFamily() {
        String string = FONT_TIMES_NEW_ROMAN;
        Locale locale = RuntimeLocale.getEncodingLocale();
        if (RuntimeLocale.areLocalesEqual(locale, Locale.JAPANESE)) {
            string = FONT_DEFAULT_JAPANESE;
        }
        return string;
    }

    public static Font getFontForCharacter(String string, Font font) {
        boolean bl = false;
        Font font2 = font;
        if (string != null && string.length() > 0) {
            char c = string.charAt(0);
            if (WmiFontResolver.shouldUseMaplePi(c)) {
                font2 = maplePiCache.getFont(font.getStyle(), font.getSize());
            } else {
                int n;
                FontIndexer fontIndexer = WmiFontResolver.getFontIndexer(WmiFontResolver.getFontFamily(font));
                if (fontIndexer != null && (n = fontIndexer.get(c)) != 0) {
                    bl = true;
                }
                if (!bl) {
                    n = font.getStyle();
                    for (int i = 0; i < indexedFonts.length; ++i) {
                        fontIndexer = WmiFontResolver.getFontIndexer(indexedFonts[i]);
                        char c2 = fontIndexer.get(c, n);
                        if (c2 == '\u0000') continue;
                        font2 = fontIndexer.getFont(n, font.getSize());
                        break;
                    }
                }
            }
        }
        return font2;
    }

    public static char mapCharacterForFont(char c, Font font) {
        char c2;
        char c3 = c;
        FontIndexer fontIndexer = WmiFontResolver.getIndexer(font, c);
        if (fontIndexer != null && (c2 = fontIndexer.get(c)) != '\u0000') {
            c3 = c2;
        }
        return c3;
    }

    public static String mapCharactersForFont(String string, Font font, int n) {
        FontIndexer fontIndexer = WmiFontResolver.getIndexer(font, string.charAt(0));
        if (fontIndexer != null) {
            int n2 = string.length();
            if (n2 > n) {
                n2 = n;
            }
            char[] cArray = new char[n2];
            for (int i = 0; i < n2; ++i) {
                char c = string.charAt(i);
                cArray[i] = fontIndexer.get(c);
                if (cArray[i] != '\u0000') continue;
                cArray[i] = c;
            }
            string = new String(cArray);
        }
        return string;
    }

    private static FontIndexer getIndexer(Font font, char c) {
        FontIndexer fontIndexer = null;
        if (WmiFontResolver.shouldUseMaplePi(c)) {
            if (maplePiIndexer == null) {
                maplePiIndexer = new MaplePiIndexer();
            }
            fontIndexer = maplePiIndexer;
        } else {
            fontIndexer = WmiFontResolver.getFontIndexer(WmiFontResolver.getFontFamily(font));
        }
        return fontIndexer;
    }

    private static boolean shouldUseMaplePi(char c) {
        return '\u0391' <= c && c <= '\u03c9' && c != '\u03c2' && !RuntimeLocale.isGreek();
    }

    public static Font getFont(WmiFontAttributeSet wmiFontAttributeSet, int n, boolean bl) {
        HashMap[] hashMapArray = null;
        HashMap hashMap = null;
        int n2 = wmiFontAttributeSet.getSize();
        if (n < fontCache.length) {
            if (bl) {
                hashMapArray = printFontCache[n];
                if (hashMapArray == null) {
                    WmiFontResolver.printFontCache[n] = new HashMap[50];
                    hashMapArray = WmiFontResolver.printFontCache[n];
                }
            } else {
                hashMapArray = fontCache[n];
                if (hashMapArray == null) {
                    WmiFontResolver.fontCache[n] = new HashMap[50];
                    hashMapArray = WmiFontResolver.fontCache[n];
                }
            }
            if (n2 > 0 && n2 < 50 && (hashMap = hashMapArray[n2]) == null) {
                hashMapArray[n2] = new HashMap();
            }
        }
        Font font = null;
        String string = wmiFontAttributeSet.getFamily();
        if (hashMap != null) {
            font = (Font)hashMap.get(wmiFontAttributeSet);
        }
        if (font == null) {
            int n3 = 0;
            if (wmiFontAttributeSet.hasStyle(1)) {
                n3 |= 1;
            }
            if (wmiFontAttributeSet.hasStyle(2)) {
                n3 |= 2;
            }
            int n4 = n * n2 / 100;
            if (string.equals(MAPLE_PI_FONT_NAME)) {
                font = maplePiFont.deriveFont((float)n4);
            }
            if (font == null) {
                font = new Font(WmiFontResolver.findExistingFontFamily(string), n3, n4);
            }
            if (hashMap != null) {
                hashMap.put(wmiFontAttributeSet, font);
            }
        }
        return font;
    }

    public static Font getOperatorRendererFont(int n) {
        return esstixCache.getFont(0, n);
    }

    public static Font getFont(String string, int n, int n2) {
        Font font = null;
        font = new Font(string, n, n2);
        if (string.equals("ESSTIXOne") && (font == null || font.canDisplayUpTo(REQUIRED_SYMBOL_CHARACTERS) != -1)) {
            font = maplePiFont.deriveFont(n, n2);
        }
        if (string.equals("ESSTIXOne")) {
            font = esstixSourceFont.deriveFont(n, n2);
        }
        return font;
    }

    public static WmiFontMetrics getFontMetrics(Font font) {
        WmiFontMetrics wmiFontMetrics = (WmiFontMetrics)metricsCache.get(font);
        if (wmiFontMetrics == null) {
            wmiFontMetrics = WmiFontMetrics.createFontMetrics(font);
            metricsCache.put(font, wmiFontMetrics);
        }
        return wmiFontMetrics;
    }

    public static String getCJKFontForText(String string) {
        if (asianFonts == null) {
            asianFonts = new Font[]{WmiFontResolver.createFont(FONT_DEFAULT_JAPANESE), WmiFontResolver.createFont(FONT_DEFAULT_KOREAN), WmiFontResolver.createFont(FONT_DEFAULT_CHINESE_SIMPLIFIED), WmiFontResolver.createFont(FONT_DEFAULT_CHINESE_TRADITIONAL)};
        }
        String string2 = null;
        for (int i = 0; i < asianFonts.length; ++i) {
            if (asianFonts[i].canDisplayUpTo(string) >= 0) continue;
            string2 = asianFonts[i].getFamily();
            break;
        }
        if (string2 == null) {
            if (defaultAsianFontName == null) {
                Locale locale = Locale.getDefault();
                defaultAsianFontName = RuntimeLocale.areLocalesEqual(locale, Locale.KOREAN) ? FONT_DEFAULT_KOREAN : (RuntimeLocale.areLocalesEqual(locale, Locale.SIMPLIFIED_CHINESE) ? FONT_DEFAULT_CHINESE_SIMPLIFIED : (RuntimeLocale.areLocalesEqual(locale, Locale.TRADITIONAL_CHINESE) ? FONT_DEFAULT_CHINESE_TRADITIONAL : FONT_DEFAULT_JAPANESE));
            }
            string2 = defaultAsianFontName;
        }
        return string2;
    }

    private static Font createFont(String string) {
        String string2 = (String)fontFamilyMap.get(string);
        if (string2 == null) {
            string2 = string;
        }
        return new Font(string2, 0, 12);
    }

    static {
        fontName2IndexerClassName = new HashMap();
        fontIndexerMap = new HashMap();
        monospacedFamilySet = new HashSet();
        indexedFonts = new String[]{"ESSTIXOne", "ESSTIXTwo", "ESSTIXThree", "ESSTIXFour", "ESSTIXFive", "ESSTIXSix", "ESSTIXSeven", "ESSTIXEight", "ESSTIXNine", "ESSTIXTen", "ESSTIXEleven", "ESSTIXTwelve", "ESSTIXThirteen", "ESSTIXFourteen", "ESSTIXFifteen"};
        if (!GraphicsEnvironment.isHeadless()) {
            String string = "com.maplesoft.mathdoc.font.";
            String string2 = "Indexer";
            for (int i = 0; i < indexedFonts.length; ++i) {
                String string3 = indexedFonts[i];
                if (string3.startsWith("ESSTIX")) {
                    string3 = "Esstix" + string3.substring(6);
                }
                String string4 = string + string3 + string2;
                String string5 = indexedFonts[i];
                fontName2IndexerClassName.put(string5, string4);
            }
            try {
                esstixSourceFont = ResourceLoader.getResourceAsFont("/com/maplesoft/mathdoc/font/resources/ESSTIX1_.TTF");
                maplePiFont = ResourceLoader.getResourceAsFont("/com/maplesoft/mathdoc/font/resources/MaplePi.ttf");
            }
            catch (FontFormatException fontFormatException) {
                WmiErrorLog.log(fontFormatException);
            }
            catch (IOException iOException) {
                WmiErrorLog.log(iOException);
            }
            DPI_SCALE_FACTOR = (float)((double)Toolkit.getDefaultToolkit().getScreenResolution() / 72.0);
        }
        fontCache = new HashMap[1000][];
        printFontCache = new HashMap[1000][];
        fontFamilyCache = new HashMap();
        metricsCache = new HashMap();
        availableFontFamilies = null;
        defaultSerifFontFamily = null;
        asianFonts = null;
        defaultAsianFontName = null;
        FONT_DEFAULT_MONOSPACED_JAPANESE = RuntimePlatform.isMac() ? "MS Gothic" : "MS Gothic";
        FONT_DEFAULT_SANSSERIF_JAPANESE = WmiFontResolver.getDefaultJapaneseSansSerifFont();
        FONT_DEFAULT_SERIF_JAPANESE = RuntimePlatform.isMac() ? "Hiragino Mincho Pro" : "MS Mincho";
        FONT_DEFAULT_JAPANESE = FONT_DEFAULT_SANSSERIF_JAPANESE;
        FONT_FAMILIES_MONOSPACED = new String[]{"American Typewriter", "Andale Mono", "Courier", "Courier New", FONT_DEFAULT_MONOSPACED, "MS Gothic", "Monaco", "Monospaced", FONT_DEFAULT_CHINESE_SIMPLIFIED};
        FONT_FAMILIES_SERIF = new String[]{"Apple Chancery", "AppleMyungjo", "Baskeville", "Baskeville Old Face", "Batang", "Bell MT", "Bernard MT Condensed", "BiauKai", "Book Antiqua", "Bookman Old Style", "Calisto MT", "Century", "Century Schoolbook", "Cochin", "Colonna MT", "Copper Black", "Curiz MT", "Didot", "Edwardian Script ITC", "Engravers MT", "Footlight MT Light", "Garamond", "Georgia", "Goudy Old Style", "Harrington", "Hoefler Text", "Imprint MT Shadow", "LiSong Pro", "Lucida Blackletter", FONT_DEFAULT_SERIF, "Lucida Fax", "MS Mincho", "MS PMincho", "Matura MT Script Capitals", "Mistral", "Modern No. 20", "Monotype Corsiva", "Onyx", "PMingLiU", "Papyrus", "Playbil", "Rockwell", "Rockwell Extra Bold", "STFangsong", "STKaiti", "STSong", "Serif", "Stencil", "Times", FONT_TIMES_NEW_ROMAN, "Wide Latin", "Zapfino"};
        FONT_FAMILIES_SANSSERIF = new String[]{"#GungSeo", "#HeadLineA", "#PCMyungjo", "#PilGi", "Abadi MT Condensed Extra Bold", "Abadi MT Condensed Light", "Apple Gothic", "Apple LiGothic", "Apple LiSung", "Arial", "Arial Black", "Arial Narrow", "Arial Rounded MT Bold", "Bauhaus 93", "Big Caslon", "Braggadocio", "Britannic Bold", "Brush Script MT", "Century Gothic", "Chalkboard", "Comic Sans MS", "Copperplate", "Copperplate Gothic Bold", "Copperplate Gothic Light", "Default", "Desdemona", "Dialog", "Dialog Input", "Eurostile", "Fang Song", "Futura", "Geneva", "Gill Sans", "Gill Sans Ultra Bold", "Gloucester MT Extra Condensed", "Gulim", "Haettenschweiler", "Hei", "Helvetica", "Helvetica Neue", "Herculanum", "Hiragino Kaku Gothic Pro", "Hiragino Kaku Gothic Std", "Hiragino Maru Gothic Pro", "Hiragino Mincho Pro", "Impact", "Kai", "Kino MT", "LiHei Pro", "Lucida Calligraphy", "Lucida Grande", "Lucida Handwriting", FONT_DEFAULT_SANSSERIF, "MS PGothic", "MT Extra", "Marker Felt", "News Gothic MT", "Optima", "Osaka", "Perpetua Titling MT", "STHeiti", "SansSerif", "Skia", "Song", "Tahoma", "Trebuchet MS", "Verdana"};
        fontFamilyMap = WmiFontResolver.buildFontFamilyMap();
        esstixCache = new WmiFontCache(esstixSourceFont);
        maplePiCache = new WmiFontCache(maplePiFont);
    }
}

