/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.controller.navigation;

import com.maplesoft.mathdoc.controller.WmiViewFactory;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModelLock;
import com.maplesoft.mathdoc.view.WmiCompositeView;
import com.maplesoft.mathdoc.view.WmiHighlightPainter;
import com.maplesoft.mathdoc.view.WmiInlineView;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiPositionMarker;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiResizableContainerView;
import com.maplesoft.mathdoc.view.WmiRowView;
import com.maplesoft.mathdoc.view.WmiSelection;
import com.maplesoft.mathdoc.view.WmiSelectionBuilder;
import com.maplesoft.mathdoc.view.WmiTextView;
import com.maplesoft.mathdoc.view.WmiTraversableView;
import com.maplesoft.mathdoc.view.WmiView;
import com.maplesoft.mathdoc.view.WmiViewPath;
import com.maplesoft.mathdoc.view.WmiViewPosition;
import com.maplesoft.mathdoc.view.WmiViewUtil;
import java.awt.Point;
import java.awt.Rectangle;

public class WmiViewNavigator {
    private WmiView reference;
    private int offset;
    private WmiRowView parentRowView = null;
    private WmiInlineView parentInlineView = null;
    private int rowIndex = -1;
    private int lineOffset = -1;
    private String text = null;
    private boolean selectionCommand;

    public WmiViewNavigator(WmiView wmiView, int n, boolean bl) {
        this.reference = wmiView;
        this.offset = n;
        this.selectionCommand = bl;
        this.extractParentRowView();
    }

    public void extractParentRowView() {
        WmiCompositeView wmiCompositeView;
        WmiView wmiView = this.reference;
        for (wmiCompositeView = this.reference.getParentView(); wmiCompositeView != null && !(wmiCompositeView instanceof WmiRowView); wmiCompositeView = wmiCompositeView.getParentView()) {
            wmiView = wmiCompositeView;
        }
        if (wmiCompositeView != null) {
            this.parentRowView = (WmiRowView)wmiCompositeView;
            this.rowIndex = wmiCompositeView.indexOf(wmiView);
            if (this.rowIndex >= 0) {
                WmiView wmiView2 = wmiCompositeView.getChild(this.rowIndex);
                this.parentInlineView = wmiView2 instanceof WmiInlineView ? (WmiInlineView)wmiView2 : null;
            }
        } else {
            this.parentRowView = null;
            this.parentInlineView = null;
            this.rowIndex = -1;
        }
        this.text = null;
    }

    public void updatePosition(WmiView wmiView, int n) {
        this.reference = wmiView;
        this.offset = n;
    }

    public WmiView getReferenceView() {
        return this.reference;
    }

    public int getViewOffset() {
        return this.offset;
    }

    public WmiInlineView getLine() {
        return this.parentInlineView;
    }

    private void getText(WmiCompositeView wmiCompositeView, StringBuffer stringBuffer) throws WmiNoReadAccessException {
        for (int i = 0; i < wmiCompositeView.getChildCount(); ++i) {
            WmiView wmiView = wmiCompositeView.getChild(i);
            if (wmiView instanceof WmiTextView) {
                WmiTextView wmiTextView = (WmiTextView)wmiView;
                stringBuffer.append(wmiTextView.getText());
                continue;
            }
            if (!(wmiView instanceof WmiCompositeView)) continue;
            this.getText((WmiCompositeView)wmiView, stringBuffer);
        }
    }

    public String getText() throws WmiNoReadAccessException {
        if (this.parentInlineView == null) {
            this.text = null;
        } else if (this.text == null) {
            StringBuffer stringBuffer = new StringBuffer();
            int n = this.parentInlineView.getChildCount();
            for (int i = 0; i < n; ++i) {
                WmiView wmiView = this.parentInlineView.getChild(i);
                if (wmiView instanceof WmiTextView) {
                    WmiTextView wmiTextView = (WmiTextView)wmiView;
                    stringBuffer.append(wmiTextView.getText());
                    continue;
                }
                if (wmiView instanceof WmiCompositeView) {
                    this.getText((WmiCompositeView)wmiView, stringBuffer);
                    continue;
                }
                stringBuffer.append("x");
            }
            this.text = stringBuffer.toString();
        }
        if (this.text == null) {
            this.text = new String();
        }
        return this.text;
    }

    public int getOffset() throws WmiNoReadAccessException {
        if (this.parentInlineView == null) {
            this.lineOffset = -1;
        } else if (this.lineOffset < 0) {
            int n;
            this.lineOffset = 0;
            WmiCompositeView wmiCompositeView = this.reference.getParentView();
            WmiView wmiView = this.reference;
            while (wmiCompositeView != this.parentInlineView) {
                n = this.getOffset(wmiCompositeView, wmiView);
                if (n >= 0) {
                    this.lineOffset += n;
                    wmiView = wmiCompositeView;
                    wmiCompositeView = wmiView.getParentView();
                    continue;
                }
                this.lineOffset = -1;
                break;
            }
            if (this.lineOffset >= 0) {
                n = this.getOffset(this.parentInlineView, wmiView);
                if (n >= 0) {
                    this.lineOffset += n;
                    this.lineOffset += this.offset;
                } else {
                    this.lineOffset = -1;
                }
            }
        }
        return this.lineOffset;
    }

    public int getOffset(WmiCompositeView wmiCompositeView, WmiView wmiView) throws WmiNoReadAccessException {
        int n = -1;
        int n2 = wmiCompositeView.indexOf(wmiView);
        if (n2 >= 0) {
            n = 0;
            for (int i = 0; i < n2; ++i) {
                wmiView = wmiCompositeView.getChild(i);
                n += WmiViewNavigator.getWidth(wmiView);
            }
        }
        return n;
    }

    public int getHorizontalOffset() {
        int n = -1;
        WmiMathDocumentView wmiMathDocumentView = this.reference.getDocumentView();
        WmiPositionMarker wmiPositionMarker = wmiMathDocumentView.getPositionMarker();
        if (wmiPositionMarker != null) {
            Rectangle rectangle = wmiPositionMarker.getBounds();
            n = rectangle.x;
        }
        return n;
    }

    public void setNearest(int n) throws WmiNoReadAccessException {
        this.setNearest((WmiPositionedView)this.parentInlineView, n);
    }

    public void setNearest(WmiPositionedView wmiPositionedView, int n) throws WmiNoReadAccessException {
        Point point = WmiViewUtil.getAbsoluteOffset(wmiPositionedView);
        if (point.x > n) {
            this.updatePosition(wmiPositionedView, 0);
        } else if (n > point.x + wmiPositionedView.getWidth()) {
            this.reference = wmiPositionedView;
            this.offset = WmiViewNavigator.getWidth(wmiPositionedView);
        } else if (WmiViewUtil.isTraversableView(wmiPositionedView)) {
            point.x = n - point.x;
            point.y = wmiPositionedView.getHeight() / 2;
            int n2 = ((WmiTraversableView)wmiPositionedView).getOffset(point);
            if (n2 >= 0) {
                this.reference = wmiPositionedView;
                this.offset = n2;
            }
        } else {
            this.reference = wmiPositionedView;
            this.offset = 0;
        }
    }

    public boolean setNearest(WmiPositionedView wmiPositionedView, Point point) {
        boolean bl = false;
        WmiViewPosition wmiViewPosition = WmiViewUtil.findNearestView(wmiPositionedView, point);
        if (wmiViewPosition != null) {
            this.reference = wmiViewPosition.getView();
            this.offset = wmiViewPosition.getOffset();
            bl = true;
        }
        return bl;
    }

    public static int getWidth(WmiView wmiView) throws WmiNoReadAccessException {
        int n = 1;
        if (wmiView instanceof WmiTextView) {
            n = ((WmiTextView)wmiView).getEndOffset() - ((WmiTextView)wmiView).getStartOffset();
        } else if (WmiViewUtil.isTraversableView(wmiView)) {
            n = ((WmiTraversableView)wmiView).getTraversableCount();
        }
        return n;
    }

    public void updateOffset(int n) throws WmiNoReadAccessException {
        if (this.parentInlineView != null) {
            WmiView wmiView = null;
            int n2 = this.parentInlineView.getChildCount();
            int n3 = 0;
            int n4 = 0;
            WmiView wmiView2 = null;
            for (int i = 0; i < n2; ++i) {
                wmiView2 = this.parentInlineView.getChild(i);
                if ((n3 += WmiViewNavigator.getWidth(wmiView2)) >= n) {
                    wmiView = wmiView2;
                    break;
                }
                n4 = n3;
            }
            if (wmiView == null) {
                this.reference = wmiView2;
                this.offset = WmiViewNavigator.getWidth(this.reference);
            } else {
                this.reference = wmiView;
                this.offset = n - n4;
            }
            this.lineOffset = n;
        }
    }

    public boolean updateRow(int n) throws WmiNoReadAccessException {
        int n2;
        Cloneable cloneable;
        Cloneable cloneable2;
        int n3;
        WmiPositionedView wmiPositionedView;
        boolean bl = false;
        WmiView wmiView = this.getReferenceView();
        Cloneable cloneable3 = null;
        while (wmiView instanceof WmiPositionedView && (cloneable3 = (wmiPositionedView = (WmiPositionedView)wmiView).getNextView(n > 0 ? 1 : 0)) == null) {
            if (!((wmiView = wmiView.getParentView()) instanceof WmiTraversableView) || ((n3 = (cloneable2 = (WmiTraversableView)wmiView).getTraversalType()) & 0x10) == 0) continue;
            return false;
        }
        wmiPositionedView = (WmiPositionedView)this.getReferenceView();
        cloneable2 = WmiViewUtil.getAbsoluteOffset(wmiPositionedView);
        n3 = ((Point)cloneable2).x = wmiPositionedView.getDocumentView().getLastHorizontalPosition();
        if (cloneable3 != null) {
            cloneable = WmiViewUtil.getAbsoluteOffset(cloneable3);
            n2 = n > 0 ? -((Point)cloneable2).y : cloneable3.getHeight() - ((Point)cloneable2).y;
            ((Point)cloneable2).translate(-((Point)cloneable).x, n2);
        }
        while (cloneable3 != null) {
            if (WmiViewUtil.isTraversableView(cloneable3) && (n2 = (cloneable = (WmiTraversableView)cloneable3).getTraversalType()) == 8) {
                this.setNearest((WmiPositionedView)cloneable3, n3);
                this.extractParentRowView();
                bl = true;
                break;
            }
            cloneable = cloneable3.getViewForNavigation(n > 0 ? -2 : -1, (Point)cloneable2);
            if (cloneable != null) {
                cloneable3 = cloneable;
                ((Point)cloneable2).translate(-cloneable.getHorizontalOffset(), -cloneable.getVerticalOffset());
                continue;
            }
            this.setNearest((WmiPositionedView)cloneable3, n3);
            this.extractParentRowView();
            bl = true;
            break;
        }
        return bl;
    }

    public boolean updateLeftRightSelectionEndpoint(int n) throws WmiNoReadAccessException {
        WmiView wmiView = this.getReferenceView();
        WmiMathDocumentView wmiMathDocumentView = wmiView.getDocumentView();
        WmiSelection wmiSelection = wmiMathDocumentView.getSelection();
        int[] nArray = new int[1];
        boolean bl = false;
        if (wmiSelection != null) {
            WmiViewPath wmiViewPath;
            WmiViewPath wmiViewPath2 = wmiViewPath = n == -1 ? wmiSelection.getSelectionStartPath() : wmiSelection.getSelectionEndPath();
            if (wmiViewPath != null && WmiViewUtil.isTraversableView(wmiView = wmiViewPath.extractView(wmiMathDocumentView, nArray))) {
                nArray[0] = nArray[0] + n;
                int n2 = ((WmiTraversableView)wmiView).getTraversableCount();
                if (nArray[0] >= 0 && nArray[0] < n2) {
                    this.updatePosition(wmiView, nArray[0]);
                    bl = true;
                }
            }
        }
        return bl;
    }

    public boolean updateLeftRight(int n) throws WmiNoReadAccessException {
        int n2;
        WmiPositionedView wmiPositionedView;
        Cloneable cloneable;
        boolean bl = false;
        WmiView wmiView = this.getReferenceView();
        WmiPositionedView wmiPositionedView2 = null;
        while (wmiView instanceof WmiPositionedView && (wmiPositionedView2 = (cloneable = (WmiPositionedView)wmiView).getNextView(n > 0 ? 3 : 2)) == null) {
            if (!WmiViewUtil.isTraversableView(wmiView = wmiView.getParentView())) continue;
            wmiPositionedView = (WmiTraversableView)wmiView;
            n2 = wmiPositionedView.getTraversalType();
            if ((n2 & 0x10) != 0) {
                return false;
            }
            if (n == 1 && (n2 & 4) != 0) {
                this.updatePosition(wmiView, -1);
                bl = true;
                break;
            }
            if (n != -1 || (n2 & 2) == 0) continue;
            this.updatePosition(wmiView, 0);
            bl = true;
            break;
        }
        if (wmiPositionedView2 instanceof WmiResizableContainerView) {
            this.updatePosition(wmiPositionedView2, 0);
            bl = true;
        }
        if (!bl) {
            cloneable = new Point(0, 0);
            while (wmiPositionedView2 instanceof WmiPositionedView) {
                if (WmiViewUtil.isTraversableView(wmiPositionedView2) && (n2 = (wmiPositionedView = (WmiTraversableView)wmiPositionedView2).getTraversalType()) == 8) {
                    this.updatePosition(wmiPositionedView2, n < 0 ? -1 : 0);
                    bl = true;
                    break;
                }
                if (n < 0) {
                    cloneable = new Point(wmiPositionedView2.getWidth(), wmiPositionedView2.getHeight());
                }
                if (WmiViewUtil.isTraversableView(wmiPositionedView = wmiPositionedView2.getViewForNavigation(n > 0 ? -4 : -3, (Point)cloneable))) {
                    WmiPositionedView wmiPositionedView3 = wmiPositionedView;
                    int n3 = wmiPositionedView3.getTraversalType();
                    if (n == 1 && (n3 & 2) != 0) {
                        this.updatePosition(wmiPositionedView, 0);
                        bl = true;
                    } else if (n == -1 && (n3 & 4) != 0) {
                        this.updatePosition(wmiPositionedView, -1);
                        bl = true;
                    } else if (n3 == 8) {
                        this.updatePosition(wmiPositionedView, 0);
                        bl = true;
                    }
                    if (bl) break;
                }
                if (wmiPositionedView != null) {
                    wmiPositionedView2 = wmiPositionedView;
                    continue;
                }
                Point point = WmiViewUtil.getAbsoluteOffset(wmiPositionedView2);
                this.setNearest(wmiPositionedView2, ((Point)cloneable).x + point.x);
                bl = true;
                break;
            }
        }
        return bl;
    }

    public void moveToParagraphStart() {
        this.parentInlineView = (WmiInlineView)this.parentRowView.getChild(0);
        this.reference = this.parentInlineView.getChild(0);
        this.rowIndex = 0;
        this.offset = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void select(int n, int n2) throws WmiNoReadAccessException {
        WmiViewFactory wmiViewFactory;
        this.updateOffset(n);
        WmiViewPath wmiViewPath = new WmiViewPath(this.reference);
        wmiViewPath.push(this.offset);
        this.updateOffset(n2);
        WmiViewPath wmiViewPath2 = new WmiViewPath(this.reference);
        wmiViewPath2.push(this.offset);
        WmiMathDocumentView wmiMathDocumentView = this.reference.getDocumentView();
        WmiViewFactory wmiViewFactory2 = wmiViewFactory = wmiMathDocumentView != null ? wmiMathDocumentView.getViewFactory() : null;
        if (wmiViewFactory != null) {
            wmiViewFactory.createSelection(wmiViewPath, wmiViewPath2);
        }
        WmiMathDocumentModel wmiMathDocumentModel = (WmiMathDocumentModel)wmiMathDocumentView.getModel();
        try {
            Rectangle rectangle;
            WmiModelLock.readLock(wmiMathDocumentModel, true);
            WmiSelection wmiSelection = wmiMathDocumentView.getSelection();
            WmiHighlightPainter wmiHighlightPainter = wmiSelection.getSelectionHighlighter();
            if (wmiHighlightPainter != null && ((rectangle = wmiHighlightPainter.getBounds()) == null || rectangle.width <= 1)) {
                wmiMathDocumentView.setSelection(null);
                ((WmiPositionedView)this.reference).setPositionMarker(this.offset);
            }
        }
        finally {
            WmiModelLock.readUnlock(wmiMathDocumentModel);
        }
    }

    public void select(WmiView wmiView) throws WmiNoReadAccessException {
        this.reference = wmiView;
        this.offset = -1;
        WmiMathDocumentView wmiMathDocumentView = wmiView.getDocumentView();
        WmiViewFactory wmiViewFactory = wmiMathDocumentView.getViewFactory();
        WmiSelectionBuilder wmiSelectionBuilder = wmiViewFactory.getSelectionBuilder();
        wmiSelectionBuilder.selectModel(wmiView.getModel());
    }

    public void moveToParagraphEnd() throws WmiNoReadAccessException {
        this.rowIndex = this.parentRowView.getChildCount() - 1;
        WmiView wmiView = this.parentRowView.getChild(this.rowIndex);
        this.parentInlineView = wmiView instanceof WmiInlineView ? (WmiInlineView)wmiView : null;
        String string = this.getText();
        this.updateOffset(string.length());
    }

    public void updateMarker() {
        WmiMathDocumentView wmiMathDocumentView = this.reference.getDocumentView();
        if (this.selectionCommand) {
            this.updateSelection();
        } else if (wmiMathDocumentView != null && wmiMathDocumentView.getSelection() != null) {
            wmiMathDocumentView.setSelection(null);
            wmiMathDocumentView.repaint();
        }
        WmiPositionMarker wmiPositionMarker = null;
        boolean bl = false;
        while (!bl) {
            WmiCompositeView wmiCompositeView;
            int n;
            if (WmiViewUtil.isTraversableView(this.reference)) {
                ((WmiPositionedView)this.reference).setPositionMarker(this.offset);
                bl = true;
                continue;
            }
            if (this.reference instanceof WmiResizableContainerView) {
                ((WmiResizableContainerView)this.reference).setPositionMarker(this.offset);
                bl = true;
                continue;
            }
            if (!(this.reference instanceof WmiCompositeView) || (n = (wmiCompositeView = (WmiCompositeView)this.reference).getChildCount()) <= 0) break;
            if (this.offset == 0) {
                this.reference = wmiCompositeView.getChild(0);
                continue;
            }
            this.reference = wmiCompositeView.getChild(n - 1);
        }
        if (!bl && this.reference instanceof WmiPositionedView) {
            ((WmiPositionedView)this.reference).setPositionMarker(this.offset);
            if (wmiMathDocumentView != null) {
                wmiPositionMarker = wmiMathDocumentView.getPositionMarker();
            }
        }
        if (wmiMathDocumentView != null) {
            wmiPositionMarker = wmiMathDocumentView.getPositionMarker();
        }
        if (wmiPositionMarker != null && bl) {
            wmiPositionMarker.show();
            wmiPositionMarker.scrollVisible();
        }
    }

    private void updateSelection() {
        WmiMathDocumentView wmiMathDocumentView = this.reference.getDocumentView();
        if (wmiMathDocumentView != null) {
            WmiViewFactory wmiViewFactory = wmiMathDocumentView.getViewFactory();
            wmiViewFactory.updateSelection(this.reference, this.offset);
        }
    }

    public boolean viewRepeatable() {
        boolean bl = false;
        if (this.reference != null && WmiViewUtil.isTraversableView(this.reference) && ((WmiTraversableView)this.reference).isRepeatable()) {
            bl = true;
        }
        return bl;
    }
}

