/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.controller.metadata;

import com.maplesoft.mathdoc.components.WmiSmoothFadeContainer;
import com.maplesoft.mathdoc.model.WmiMetatag;
import java.awt.Color;
import java.awt.Container;
import java.util.Iterator;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class WmiMetatagInfoPopup
extends WmiSmoothFadeContainer {
    public WmiMetatagInfoPopup(Container container, WmiMetatag wmiMetatag) {
        super(container, true, 0.0f, 0.9f);
        this.setBackground(Color.BLACK);
        JComponent jComponent = this.createContents(wmiMetatag);
        jComponent.doLayout();
        this.add(jComponent);
        this.setSize(jComponent.getPreferredSize());
    }

    protected JComponent createContents(WmiMetatag wmiMetatag) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel.setForeground(Color.WHITE);
        jPanel.setBackground(Color.BLACK);
        JLabel jLabel = this.generatePopupContent(wmiMetatag);
        jLabel.setForeground(Color.WHITE);
        jPanel.add(jLabel);
        jPanel.setSize(jPanel.getPreferredSize());
        return jPanel;
    }

    protected JLabel generatePopupContent(WmiMetatag wmiMetatag) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<html><table><small>");
        stringBuffer.append("<tr><td><b>Category:</b></td>");
        stringBuffer.append("<td>");
        stringBuffer.append(this.stringToHTMLString(wmiMetatag.getCategory()));
        stringBuffer.append("</td></tr>");
        stringBuffer.append("<tr><td><b>Name:</b></td>");
        stringBuffer.append("<td>");
        stringBuffer.append(this.stringToHTMLString(wmiMetatag.getName()));
        stringBuffer.append("</td></tr>");
        Set set = wmiMetatag.getAttributeKeySet();
        if (!set.isEmpty()) {
            stringBuffer.append("<tr><td colspan=2 height=3 align=center valign=center><hr></td></tr>");
            stringBuffer.append("<tr><td colspan=2 align=center><b>Attributes</b></td></tr>");
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String string2 = wmiMetatag.getAttribute(string);
                stringBuffer.append("<tr>");
                stringBuffer.append("<td>" + this.stringToHTMLString(string) + ":</td>");
                stringBuffer.append("<td>" + this.stringToHTMLString(string2) + "</td>");
                stringBuffer.append("</tr>");
            }
        }
        stringBuffer.append("</small></table></html>");
        return new JLabel(stringBuffer.toString());
    }

    protected String stringToHTMLString(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        boolean bl = false;
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == ' ') {
                if (bl) {
                    bl = false;
                    stringBuffer.append("&nbsp;");
                    continue;
                }
                bl = true;
                stringBuffer.append(' ');
                continue;
            }
            bl = false;
            if (c == '\"') {
                stringBuffer.append("&quot;");
                continue;
            }
            if (c == '&') {
                stringBuffer.append("&amp;");
                continue;
            }
            if (c == '<') {
                stringBuffer.append("&lt;");
                continue;
            }
            if (c == '>') {
                stringBuffer.append("&gt;");
                continue;
            }
            if (c == '\n') {
                stringBuffer.append("&lt;br/&gt;");
                continue;
            }
            int n2 = 0xFFFF & c;
            if (n2 < 160) {
                stringBuffer.append(c);
                continue;
            }
            stringBuffer.append("&#");
            stringBuffer.append(new Integer(n2).toString());
            stringBuffer.append(';');
        }
        return stringBuffer.toString();
    }
}

