/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.controller.metadata;

import com.maplesoft.mathdoc.controller.metadata.WmiCategoryChangeDialog;
import com.maplesoft.mathdoc.controller.metadata.WmiMetadataManager;
import com.maplesoft.mathdoc.controller.metadata.WmiMetatagAttributeTable;
import com.maplesoft.mathdoc.controller.metadata.WmiMetatagCategoriesDialog;
import com.maplesoft.mathdoc.dialog.WmiDialog;
import com.maplesoft.mathdoc.dialog.WmiDialogButton;
import com.maplesoft.mathdoc.dialog.WmiDialogLabel;
import com.maplesoft.mathdoc.dialog.WmiDialogTextField;
import com.maplesoft.mathdoc.model.WmiMetatag;
import com.maplesoft.mathdoc.model.WmiMetatagCategory;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Iterator;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class WmiMetatagEditorDialog
extends WmiDialog
implements ItemListener {
    protected static final String RESOURCE_PATH = "com.maplesoft.mathdoc.controller.metadata.resources.Metadata";
    private static final int LABEL_FIELD_WIDTH = 35;
    private static final int LBL_CAT_PANEL_ROWS = 2;
    private static final int LBL_CAT_PANEL_COLS = 2;
    private static final int LBL_CAT_PANEL_TOP_MARGIN = 0;
    private static final int LBL_CAT_PANEL_LEFT_MARGIN = 0;
    private static final int LBL_CAT_PANEL_X_PADDING = 0;
    private static final int LBL_CAT_PANEL_Y_PADDING = 20;
    private WmiDialogLabel mtLabelLbl = null;
    private WmiDialogLabel mtCategoryLbl = null;
    private WmiDialogLabel mtAttributesLbl = null;
    private WmiDialogTextField mtLabelFld = null;
    private JComboBox mtCategoryCombo = null;
    private WmiMetatagAttributeTable mtAttrTable = null;
    private JScrollPane mtTablePane = null;
    private WmiDialogButton mtNewCategoryBtn = null;
    private WmiDialogButton mtAddAttributeBtn = null;
    private WmiDialogButton mtRemoveAttributeBtn = null;
    private WmiDialogButton mtCancelBtn = null;
    private WmiDialogButton mtOKBtn = null;
    private JFrame parentFrame = null;
    private WmiMetadataManager dataMgr;
    private WmiMetatag srcTag = null;
    private WmiMetatag dstTag = null;
    private boolean tagEdited = false;
    private boolean categoryComboIsUpdating = false;

    public WmiMetatagEditorDialog(JFrame jFrame, WmiMetadataManager wmiMetadataManager, WmiMetatag wmiMetatag) {
        super((Frame)jFrame);
        this.parentFrame = jFrame;
        this.dataMgr = wmiMetadataManager;
        this.srcTag = wmiMetatag;
        this.dstTag = wmiMetatag.copyTag();
        this.setTitle("MTED_Title");
        this.createDialogComponents();
        this.layoutDialog();
    }

    public boolean editTag() {
        this.show();
        return this.tagEdited;
    }

    protected void addComponents() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.getContentPane().setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 8, 8);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        this.getContentPane().add((Component)this.mtLabelLbl, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 5;
        this.getContentPane().add((Component)this.mtLabelFld, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.1;
        this.getContentPane().add((Component)this.mtCategoryLbl, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 4;
        this.getContentPane().add((Component)this.mtCategoryCombo, gridBagConstraints);
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 22;
        this.getContentPane().add((Component)this.mtNewCategoryBtn, gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 6;
        this.getContentPane().add((Component)this.mtTablePane, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(11, 0, 0, 8);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.anchor = 21;
        this.getContentPane().add((Component)this.createEditButtonPanel(), gridBagConstraints);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 22;
        this.getContentPane().add((Component)this.createDefaultButtonsPanel(), gridBagConstraints);
    }

    protected String getResourcePath() {
        return RESOURCE_PATH;
    }

    protected void createDialogComponents() {
        this.mtLabelLbl = this.createLabel("MTED_Label");
        this.mtCategoryLbl = this.createLabel("MTED_Category");
        this.mtAttributesLbl = this.createLabel("MTED_Attributes");
        this.mtLabelFld = new WmiDialogTextField(35);
        String string = this.dstTag.getName();
        if (string.length() == 0) {
            this.mtLabelFld.setText("<default>");
        } else {
            this.mtLabelFld.setText(this.dstTag.getName());
        }
        this.mtCategoryCombo = new JComboBox();
        this.resyncCategoriesCombo(true);
        this.mtCategoryCombo.addItemListener(this);
        this.mtAttrTable = new WmiMetatagAttributeTable(this.dstTag);
        this.mtTablePane = new JScrollPane(this.mtAttrTable, 22, 31);
        this.mtNewCategoryBtn = this.createButton("MTED_EditCategories");
        this.mtNewCategoryBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WmiMetatagEditorDialog.this.newCategoryAction();
            }
        });
        this.mtAddAttributeBtn = this.createButton("MTED_AddAttribute");
        this.mtAttrTable.setAddButton((JButton)this.mtAddAttributeBtn);
        this.mtRemoveAttributeBtn = this.createButton("MTED_RemoveAttribute");
        this.mtAttrTable.setDeleteButton((JButton)this.mtRemoveAttributeBtn);
        this.mtCancelBtn = this.createCancelButton();
        this.mtOKBtn = this.createOKButton();
    }

    private JPanel createEditButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add((Component)this.mtAddAttributeBtn);
        jPanel.add((Component)this.mtRemoveAttributeBtn);
        return jPanel;
    }

    private void resyncCategoriesCombo(boolean bl) {
        this.categoryComboIsUpdating = true;
        String string = this.dstTag.getCategory();
        if (bl) {
            this.mtCategoryCombo.removeAllItems();
            Iterator iterator = this.dataMgr.getCategoryList().iterator();
            while (iterator.hasNext()) {
                String string2 = iterator.next().toString();
                this.mtCategoryCombo.addItem(string2);
            }
        }
        boolean bl2 = false;
        int n = this.mtCategoryCombo.getItemCount();
        for (int i = 0; i < n; ++i) {
            String string3;
            Object e = this.mtCategoryCombo.getItemAt(i);
            if (e == null || !(string3 = e.toString()).equals(this.dstTag.getCategory())) continue;
            bl2 = true;
            break;
        }
        if (bl2) {
            this.mtCategoryCombo.setSelectedItem(this.dstTag.getCategory());
        }
        this.categoryComboIsUpdating = false;
    }

    private void resyncCategoriesCombo() {
        this.resyncCategoriesCombo(false);
    }

    protected void changeCategory(String string) {
        boolean bl = false;
        String string2 = this.dstTag.getCategory();
        if (string2 == null) {
            bl = true;
        } else if (string != null && !string2.equals(string)) {
            bl = true;
        }
        if (bl) {
            int n = 1;
            WmiMetatagCategory wmiMetatagCategory = this.dataMgr.findCategory(string);
            if (wmiMetatagCategory != null) {
                if (wmiMetatagCategory.getAttributeCount() > 0) {
                    WmiCategoryChangeDialog wmiCategoryChangeDialog = new WmiCategoryChangeDialog((JDialog)((Object)this));
                    n = wmiCategoryChangeDialog.runDialog();
                }
            } else {
                n = 0;
            }
            if (n != 0) {
                this.dstTag.setCategory(wmiMetatagCategory, n);
            }
            this.resyncCategoriesCombo();
            this.mtAttrTable.reloadTable();
        }
    }

    protected void newCategoryAction() {
        WmiMetatagCategoriesDialog wmiMetatagCategoriesDialog = new WmiMetatagCategoriesDialog(this.parentFrame, this.dataMgr);
        if (wmiMetatagCategoriesDialog.editCategories()) {
            this.resyncCategoriesCombo(true);
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object;
        if (itemEvent.getSource() == this.mtCategoryCombo && !this.categoryComboIsUpdating && itemEvent.getID() == 701 && itemEvent.getStateChange() == 1 && (object = this.mtCategoryCombo.getSelectedItem()) != null) {
            this.changeCategory(object.toString());
        }
    }

    protected void cancelAction() {
        this.tagEdited = false;
        super.cancelAction();
    }

    protected void okAction() {
        this.dstTag.setName(this.mtLabelFld.getText());
        this.dstTag.setCategory(this.mtCategoryCombo.getSelectedItem().toString());
        this.mtAttrTable.unloadTable();
        this.srcTag.reloadFromTag(this.dstTag);
        this.tagEdited = true;
        super.okAction();
    }
}

