/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.controller.insert;

import com.maplesoft.mathdoc.controller.insert.MathInsertUtil;
import com.maplesoft.mathdoc.controller.insert.WmiInsertGenericMathCommand;
import com.maplesoft.mathdoc.controller.navigation.WmiSearchAndSelect;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiModelIndexOutOfBoundsException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoUpdateAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiFontAttributeSet;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelLock;
import com.maplesoft.mathdoc.model.WmiModelPosition;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiTextModel;
import com.maplesoft.mathdoc.model.math.MathTokenizer;
import com.maplesoft.mathdoc.model.math.WmiIdentifierModel;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiSubSupModel;
import com.maplesoft.mathdoc.model.math.WmiSubscriptModel;
import com.maplesoft.mathdoc.model.math.WmiUnderOverModel;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiPositionUpdateHandler;
import java.awt.Color;

public class InsertMathStructureCommand
extends WmiInsertGenericMathCommand {
    private final Color PLACEHOLDER_COLOR = new Color(200, 0, 200);

    public InsertMathStructureCommand(String string) {
        super(string);
    }

    public InsertMathStructureCommand(String string, boolean bl) {
        super(string, bl);
    }

    protected int getReplacePlaceholderIndex() {
        return 0;
    }

    protected int getCaretPlaceHolderIndex() {
        return 1;
    }

    protected WmiModelPosition getExistingPlaceholder(WmiModel wmiModel) throws WmiNoReadAccessException {
        return null;
    }

    protected int getInsertBias() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean addBrackets(WmiModel wmiModel) {
        WmiCompositeModel wmiCompositeModel;
        WmiMathDocumentModel wmiMathDocumentModel;
        boolean bl;
        WmiModelTag wmiModelTag = wmiModel != null ? wmiModel.getTag() : null;
        boolean bl2 = true;
        if (wmiModelTag == WmiModelTag.MATH_OVER || wmiModelTag == WmiModelTag.MATH_UNDER || wmiModelTag == WmiModelTag.MATH_UNDER_OVER || wmiModelTag == WmiModelTag.MATH_SQUARE_ROOT || wmiModelTag == WmiModelTag.MATH_NROOT || wmiModelTag == WmiModelTag.MATH_FENCED) {
            bl2 = false;
        } else if (wmiModelTag == WmiModelTag.MATH_ACTION && ((bl = WmiModelLock.ownsWriteLock(wmiMathDocumentModel = (wmiCompositeModel = (WmiCompositeModel)wmiModel).getDocument())) || WmiModelLock.readLock(wmiMathDocumentModel, true))) {
            try {
                if (wmiCompositeModel.getChildCount() == 1) {
                    bl2 = this.addBrackets(wmiCompositeModel.getChild(0));
                }
            }
            catch (WmiNoReadAccessException wmiNoReadAccessException) {
                WmiErrorLog.log(wmiNoReadAccessException);
            }
            finally {
                if (!bl) {
                    WmiModelLock.readUnlock(wmiMathDocumentModel);
                }
            }
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WmiMathModel createPlaceHolder(WmiMathDocumentModel wmiMathDocumentModel, WmiMathContext wmiMathContext) {
        WmiIdentifierModel wmiIdentifierModel = null;
        WmiFontAttributeSet wmiFontAttributeSet = null;
        boolean bl = WmiModelLock.ownsWriteLock(wmiMathDocumentModel);
        if (bl || WmiModelLock.readLock(wmiMathDocumentModel, false)) {
            try {
                wmiFontAttributeSet = wmiMathDocumentModel.getActiveEditAttributes();
                wmiFontAttributeSet = (WmiFontAttributeSet)wmiFontAttributeSet.copyAttributes();
                wmiFontAttributeSet.setStyle(1, false);
                wmiFontAttributeSet.setStyle(2, true);
            }
            catch (WmiNoReadAccessException wmiNoReadAccessException) {
                WmiErrorLog.log(wmiNoReadAccessException);
            }
            finally {
                if (!bl) {
                    WmiModelLock.readUnlock(wmiMathDocumentModel);
                }
            }
        }
        wmiIdentifierModel = wmiFontAttributeSet != null ? new WmiIdentifierModel(wmiMathDocumentModel, "", "", wmiFontAttributeSet, false) : new WmiIdentifierModel(wmiMathDocumentModel, "", "", wmiMathContext, false);
        return wmiIdentifierModel;
    }

    protected boolean performInsert(WmiMathDocumentView wmiMathDocumentView, WmiMathContext wmiMathContext) throws WmiModelIndexOutOfBoundsException, WmiNoReadAccessException, WmiNoUpdateAccessException, WmiNoWriteAccessException {
        boolean bl = false;
        WmiModelPosition wmiModelPosition = MathInsertUtil.wrapSelection(wmiMathDocumentView, this.getInsertBias());
        WmiMathDocumentModel wmiMathDocumentModel = (WmiMathDocumentModel)wmiMathDocumentView.getModel();
        if (wmiModelPosition != null) {
            WmiModel wmiModel = wmiModelPosition.getModel();
            WmiModelPosition wmiModelPosition2 = this.getExistingPlaceholder(wmiModel);
            if (wmiModelPosition2 == null) {
                WmiModelTag wmiModelTag;
                WmiCompositeModel wmiCompositeModel = this.createCompositeInsertModel(wmiMathDocumentModel, wmiMathContext);
                boolean bl2 = this.addBrackets(wmiModel);
                if (bl2 && (wmiModelTag = this.combineTag()) == wmiModel.getTag()) {
                    bl2 = false;
                }
                wmiModelPosition = MathInsertUtil.performModelWrap(wmiModel, wmiCompositeModel, wmiMathContext, this.getReplacePlaceholderIndex(), this.getCaretPlaceHolderIndex(), bl2);
                if (this.combineTag() != null) {
                    this.combineModels(wmiCompositeModel, wmiMathContext);
                }
            } else {
                wmiModelPosition = wmiModelPosition2;
            }
            if (wmiModelPosition != null) {
                wmiMathDocumentView.setPendingPosition(wmiModelPosition);
                wmiMathDocumentModel.update(this.getResource(5));
                bl = true;
            }
        }
        if (!bl) {
            wmiMathDocumentModel.revertPendingUpdates();
        }
        return bl;
    }

    public static boolean performInsert(WmiMathDocumentView wmiMathDocumentView, WmiMathModel wmiMathModel, String string) throws WmiModelIndexOutOfBoundsException, WmiNoReadAccessException, WmiNoUpdateAccessException, WmiNoWriteAccessException {
        WmiModelPosition wmiModelPosition;
        boolean bl = false;
        WmiMathDocumentModel wmiMathDocumentModel = (WmiMathDocumentModel)wmiMathDocumentView.getModel();
        if (string != null) {
            wmiMathDocumentModel.startUndoableEdit(string);
        }
        if ((wmiModelPosition = MathInsertUtil.wrapSelection(wmiMathDocumentView, 0)) != null) {
            WmiModel wmiModel = wmiModelPosition.getModel();
            WmiCompositeModel wmiCompositeModel = wmiModel.getParent();
            int n = wmiCompositeModel.indexOf(wmiModel);
            if (n >= 0) {
                WmiCompositeModel wmiCompositeModel2;
                int n2;
                bl = true;
                wmiCompositeModel.addChild(wmiMathModel, ++n);
                WmiModel wmiModel2 = wmiMathModel;
                while (wmiModel2 instanceof WmiCompositeModel && (n2 = (wmiCompositeModel2 = (WmiCompositeModel)wmiModel2).getChildCount()) > 0) {
                    wmiModel2 = wmiCompositeModel2.getChild(n2 - 1);
                }
                wmiModelPosition = new WmiModelPosition(wmiModel2, -1);
                wmiMathDocumentView.setPendingPosition(wmiModelPosition);
                wmiModelPosition = MathTokenizer.retokenize(wmiModelPosition);
                if (wmiModelPosition != null) {
                    wmiMathDocumentView.setPendingPosition(wmiModelPosition);
                }
            }
            wmiMathDocumentModel.update(string);
        }
        if (!bl) {
            wmiMathDocumentModel.revertPendingUpdates();
        }
        if (string != null) {
            wmiMathDocumentModel.endUndoableEdit();
        }
        return bl;
    }

    protected WmiCompositeModel createCompositeInsertModel(WmiMathDocumentModel wmiMathDocumentModel, WmiMathContext wmiMathContext) throws WmiNoWriteAccessException, WmiNoReadAccessException {
        return null;
    }

    public WmiCompositeModel createCombinedInsertModel(WmiMathDocumentModel wmiMathDocumentModel, WmiMathContext wmiMathContext) throws WmiNoWriteAccessException {
        return null;
    }

    protected void combineModels(WmiCompositeModel wmiCompositeModel, WmiMathContext wmiMathContext) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        Object object;
        WmiModelTag wmiModelTag;
        WmiModel wmiModel = wmiCompositeModel.getChild(0);
        WmiCompositeModel wmiCompositeModel2 = wmiCompositeModel.getParent();
        if (wmiCompositeModel2 != null && wmiCompositeModel2.getChild(0) != wmiCompositeModel) {
            wmiCompositeModel2 = null;
        }
        WmiModelTag wmiModelTag2 = wmiModel != null ? wmiModel.getTag() : null;
        WmiModelTag wmiModelTag3 = wmiModelTag = wmiCompositeModel2 != null ? wmiCompositeModel2.getTag() : null;
        if (wmiModelTag == WmiModelTag.MATH_ROW && wmiCompositeModel2.getChildCount() == 1) {
            object = wmiCompositeModel2;
            if ((wmiCompositeModel2 = wmiCompositeModel2.getParent()) != null && wmiCompositeModel2.indexOf((WmiModel)object) != 0) {
                wmiCompositeModel2 = null;
            }
            WmiModelTag wmiModelTag4 = wmiModelTag = wmiCompositeModel2 != null ? wmiCompositeModel2.getTag() : null;
        }
        if (wmiModelTag2 == (object = this.combineTag())) {
            this.doInnerCombine(wmiCompositeModel, (WmiCompositeModel)wmiModel, wmiMathContext);
        } else if (wmiModelTag == object) {
            this.doOuterCombine(wmiCompositeModel, wmiCompositeModel2, wmiMathContext);
        }
    }

    protected void doInnerCombine(WmiCompositeModel wmiCompositeModel, WmiCompositeModel wmiCompositeModel2, WmiMathContext wmiMathContext) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
    }

    protected void doOuterCombine(WmiCompositeModel wmiCompositeModel, WmiCompositeModel wmiCompositeModel2, WmiMathContext wmiMathContext) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
    }

    protected WmiModelTag combineTag() {
        return null;
    }

    public WmiCompositeModel createSubSupModel(WmiMathDocumentModel wmiMathDocumentModel, WmiMathContext wmiMathContext) throws WmiNoWriteAccessException {
        WmiMathModel wmiMathModel = this.createPlaceHolder(wmiMathDocumentModel, wmiMathContext);
        WmiMathModel wmiMathModel2 = this.createPlaceHolder(wmiMathDocumentModel, wmiMathContext);
        WmiMathModel wmiMathModel3 = this.createPlaceHolder(wmiMathDocumentModel, wmiMathContext);
        WmiSubSupModel wmiSubSupModel = new WmiSubSupModel(wmiMathDocumentModel, wmiMathModel, wmiMathModel2, wmiMathModel3, wmiMathContext);
        return wmiSubSupModel;
    }

    private String getSemanticsString(WmiModel wmiModel) {
        String string = "";
        if (wmiModel instanceof WmiMathModel) {
            try {
                String string2 = (String)((WmiMathModel)wmiModel).getAttributesForRead().getAttribute("Typesetting:-msemantics");
                if (string2 != null) {
                    string = string2;
                }
            }
            catch (WmiNoReadAccessException wmiNoReadAccessException) {
                WmiErrorLog.log(wmiNoReadAccessException);
            }
        }
        return string.trim().length() != 0 ? string : "none";
    }

    protected void createSubSupModel(WmiModel wmiModel, WmiModel wmiModel2, WmiModel wmiModel3, WmiModel wmiModel4, WmiMathContext wmiMathContext) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        WmiCompositeModel wmiCompositeModel = this.createCombinedInsertModel(wmiModel.getDocument(), wmiMathContext);
        WmiModel[] wmiModelArray = new WmiModel[]{wmiModel2, wmiModel3, wmiModel4};
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        if (wmiModel instanceof WmiSubscriptModel) {
            stringBuffer.append(this.getSemanticsString(wmiModel));
            stringBuffer.append(",");
            stringBuffer.append(this.getSemanticsString(wmiModel2.getParent()));
        } else {
            stringBuffer.append(this.getSemanticsString(wmiModel2.getParent()));
            stringBuffer.append(",");
            stringBuffer.append(this.getSemanticsString(wmiModel));
        }
        stringBuffer.append("]");
        wmiCompositeModel.addAttribute("Typesetting:-msemantics", stringBuffer.toString());
        WmiCompositeModel wmiCompositeModel2 = wmiModel.getParent();
        int n = wmiCompositeModel2.indexOf(wmiModel);
        wmiCompositeModel2.replaceChild(wmiCompositeModel, n);
        wmiCompositeModel.replaceChildren(wmiModelArray, 0, 3);
    }

    public WmiCompositeModel createUnderOverModel(WmiMathDocumentModel wmiMathDocumentModel, WmiMathContext wmiMathContext) throws WmiNoWriteAccessException {
        WmiMathModel wmiMathModel = this.createPlaceHolder(wmiMathDocumentModel, wmiMathContext);
        WmiMathModel wmiMathModel2 = this.createPlaceHolder(wmiMathDocumentModel, wmiMathContext);
        WmiMathModel wmiMathModel3 = this.createPlaceHolder(wmiMathDocumentModel, wmiMathContext);
        WmiUnderOverModel wmiUnderOverModel = new WmiUnderOverModel(wmiMathDocumentModel, wmiMathModel, wmiMathModel2, wmiMathModel3, wmiMathContext);
        return wmiUnderOverModel;
    }

    protected void createUnderModel(WmiModel wmiModel, WmiModel wmiModel2, WmiModel wmiModel3, WmiModel wmiModel4, WmiMathContext wmiMathContext) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        WmiCompositeModel wmiCompositeModel = this.createCombinedInsertModel(wmiModel.getDocument(), wmiMathContext);
        WmiModel[] wmiModelArray = new WmiModel[]{wmiModel2, wmiModel3, wmiModel4};
        WmiCompositeModel wmiCompositeModel2 = wmiModel.getParent();
        int n = wmiCompositeModel2.indexOf(wmiModel);
        wmiCompositeModel2.replaceChild(wmiCompositeModel, n);
        wmiCompositeModel.replaceChildren(wmiModelArray, 0, 3);
    }

    protected static void selectModel(WmiMathDocumentView wmiMathDocumentView, WmiModel wmiModel) {
        wmiMathDocumentView.setPendingPositionUpdateHandler(new ModelSelector(wmiMathDocumentView, wmiModel));
    }

    protected WmiMathModel createTablePlaceholder(WmiMathDocumentModel wmiMathDocumentModel, WmiMathContext wmiMathContext) throws WmiNoWriteAccessException {
        WmiIdentifierModel wmiIdentifierModel = new WmiIdentifierModel(wmiMathDocumentModel, "?", "?", wmiMathContext, false);
        wmiIdentifierModel.addAttribute("foreground", this.PLACEHOLDER_COLOR);
        wmiIdentifierModel.addAttribute(WmiFontAttributeSet.PLACEHOLDER_KEY, "true");
        return wmiIdentifierModel;
    }

    protected static class ModelSelector
    implements WmiPositionUpdateHandler {
        private WmiMathDocumentView docView;
        private WmiModel model;

        protected ModelSelector(WmiMathDocumentView wmiMathDocumentView, WmiModel wmiModel) {
            this.docView = wmiMathDocumentView;
            this.model = wmiModel;
        }

        public void updatePosition() throws WmiNoReadAccessException {
            if (this.model instanceof WmiTextModel) {
                WmiSearchAndSelect.selectTextModel(this.docView, (WmiTextModel)this.model);
            } else if (this.model instanceof WmiCompositeModel) {
                WmiSearchAndSelect.selectCompositeModel(this.docView, (WmiCompositeModel)this.model);
            }
        }
    }
}

