/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.controller.format;

import com.maplesoft.mathdoc.controller.format.WmiFormatMathCommand;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoUpdateAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelLock;
import com.maplesoft.mathdoc.model.WmiModelUtil;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathWrapperModel;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiPositionMarker;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiView;
import java.awt.event.ActionEvent;

public abstract class WmiFormatMathModelAttributeCommand
extends WmiFormatMathCommand {
    private Class targetModelClass;

    protected WmiFormatMathModelAttributeCommand(String string, Class clazz) {
        super(string);
        this.targetModelClass = clazz;
    }

    public void doCommand(ActionEvent actionEvent) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiMathDocumentView wmiMathDocumentView = WmiFormatMathModelAttributeCommand.getDocumentView(actionEvent);
        if (wmiMathDocumentView != null && this.isEnabled(wmiMathDocumentView)) {
            WmiPositionMarker wmiPositionMarker = wmiMathDocumentView.getPositionMarker();
            WmiMathModel wmiMathModel = null;
            wmiMathModel = this.findTargetModel(wmiPositionMarker);
            if (wmiMathModel != null) {
                WmiAttributeSet wmiAttributeSet = wmiMathModel.getAttributes();
                wmiAttributeSet = this.modifyAttribute(wmiAttributeSet);
                wmiMathModel.setAttributes(wmiAttributeSet);
                wmiMathModel.setSemantics(null);
                WmiModel wmiModel = wmiMathModel;
                while (!(wmiModel instanceof WmiMathWrapperModel)) {
                    if (!((wmiModel = wmiModel.getParent()) instanceof WmiMathModel)) continue;
                    wmiModel.setSemantics(null);
                }
                try {
                    wmiMathModel.getDocument().update(this.getResource(5));
                }
                catch (WmiNoUpdateAccessException wmiNoUpdateAccessException) {
                    WmiErrorLog.log(wmiNoUpdateAccessException);
                }
            }
        }
    }

    public abstract WmiAttributeSet modifyAttribute(WmiAttributeSet var1);

    protected WmiMathModel findTargetModel(WmiPositionMarker wmiPositionMarker) throws WmiNoReadAccessException {
        WmiPositionedView wmiPositionedView;
        WmiMathModel wmiMathModel = null;
        if (wmiPositionMarker != null && (wmiPositionedView = wmiPositionMarker.getView()) != null) {
            WmiModel wmiModel = wmiPositionedView.getModel();
            wmiMathModel = this.getTargetModel(wmiModel);
        }
        return wmiMathModel;
    }

    protected WmiMathModel getTargetModel(WmiModel wmiModel) throws WmiNoReadAccessException {
        WmiMathModel wmiMathModel = null;
        wmiMathModel = wmiModel.getClass().equals(this.targetModelClass) ? (WmiMathModel)wmiModel : (WmiMathModel)((Object)WmiModelUtil.findAncestorOfClass(wmiModel, this.targetModelClass));
        return wmiMathModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEnabled(WmiView wmiView) {
        WmiMathDocumentView wmiMathDocumentView;
        boolean bl = false;
        WmiMathDocumentView wmiMathDocumentView2 = wmiMathDocumentView = wmiView != null ? wmiView.getDocumentView() : null;
        if (wmiMathDocumentView != null) {
            WmiPositionMarker wmiPositionMarker = wmiMathDocumentView.getPositionMarker();
            if (WmiModelLock.readLock(wmiView.getModel(), false)) {
                try {
                    WmiMathModel wmiMathModel = this.findTargetModel(wmiPositionMarker);
                    bl = wmiMathModel != null && !wmiPositionMarker.isReadOnly();
                }
                catch (WmiNoReadAccessException wmiNoReadAccessException) {
                    WmiErrorLog.log(wmiNoReadAccessException);
                }
                finally {
                    WmiModelLock.readUnlock(wmiView.getModel());
                }
            }
        }
        return bl;
    }
}

