/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.controller.edit;

import com.maplesoft.mathdoc.controller.insert.MathInsertUtil;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiAbstractModel;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiFontAttributeSet;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelPath;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiTextModel;
import com.maplesoft.mathdoc.model.WmiTransferModel;
import com.maplesoft.mathdoc.model.math.WmiAbstractMathTokenModel;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathStringModel;
import com.maplesoft.mathdoc.model.math.WmiMathTextModel;
import com.maplesoft.mathdoc.model.math.WmiMathWrapperModel;
import com.maplesoft.mathdoc.view.WmiBoundsMarker;
import com.maplesoft.mathdoc.view.WmiSelection;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.FlavorMap;
import java.awt.datatransfer.SystemFlavorMap;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;

public class WmiTransfer
implements Transferable,
ClipboardOwner {
    private ArrayList flavors = null;
    private ArrayList data = null;
    private static HashSet invalidTransferModelTags = new HashSet();
    private static HashSet selfreturningTransferModelTags;

    protected WmiTransfer() {
    }

    protected void addDataFlavor(DataFlavor dataFlavor, Object object) {
        if (this.flavors == null) {
            this.flavors = new ArrayList();
            this.data = new ArrayList();
        }
        this.flavors.add(dataFlavor);
        this.data.add(object);
    }

    public static WmiTransfer createTransferable(WmiSelection wmiSelection) {
        return null;
    }

    public static WmiTransfer createTransferable(WmiBoundsMarker wmiBoundsMarker) {
        return null;
    }

    public DataFlavor[] getTransferDataFlavors() {
        DataFlavor[] dataFlavorArray = null;
        if (this.flavors != null) {
            dataFlavorArray = new DataFlavor[this.flavors.size()];
            for (int i = 0; i < this.flavors.size(); ++i) {
                dataFlavorArray[i] = (DataFlavor)this.flavors.get(i);
            }
        }
        return dataFlavorArray;
    }

    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        boolean bl = false;
        if (this.flavors != null) {
            for (int i = 0; i < this.flavors.size(); ++i) {
                DataFlavor dataFlavor2 = (DataFlavor)this.flavors.get(i);
                if (dataFlavor2 == null || !dataFlavor2.equals(dataFlavor)) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public Object getTransferData(DataFlavor dataFlavor) {
        Object var2_2 = null;
        if (this.flavors != null && this.data != null) {
            for (int i = 0; i < this.flavors.size(); ++i) {
                DataFlavor dataFlavor2 = (DataFlavor)this.flavors.get(i);
                if (dataFlavor2 == null || !dataFlavor2.equals(dataFlavor)) continue;
                var2_2 = this.data.get(i);
                break;
            }
        }
        return var2_2;
    }

    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }

    protected static void trimStartPath(WmiTransferModel wmiTransferModel, WmiModelPath wmiModelPath, int n, int n2) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        int n3 = wmiModelPath.depth();
        WmiModel wmiModel = wmiTransferModel.getFirstChild();
        if (!(wmiModel instanceof WmiMathWrapperModel)) {
            WmiTransferModel wmiTransferModel2;
            int n4;
            int n5;
            while (++n < n3) {
                n5 = wmiModelPath.peek(n);
                if (!(wmiModel instanceof WmiCompositeModel)) break;
                n4 = ((WmiCompositeModel)wmiModel).getChildCount() - 1;
                wmiTransferModel2 = new WmiTransferModel((WmiCompositeModel)wmiModel, n5, n4);
                if (wmiModel instanceof WmiMathModel) {
                    wmiTransferModel2.setSemantics(((WmiMathModel)wmiModel).getSemantics());
                }
                wmiTransferModel.replaceFirstChild(wmiTransferModel2);
                wmiTransferModel = wmiTransferModel2;
                wmiModel = wmiTransferModel.getFirstChild();
                if (!(wmiModel instanceof WmiMathWrapperModel)) continue;
                break;
            }
            if (!(wmiModel instanceof WmiMathModel)) {
                if (wmiModel instanceof WmiTextModel && n2 > 0) {
                    String string = ((WmiTextModel)wmiModel).getText();
                    WmiTextModel wmiTextModel = new WmiTextModel(wmiModel.getDocument(), string.substring(n2), (WmiFontAttributeSet)wmiModel.getAttributesForRead());
                    wmiTransferModel.replaceFirstChild(wmiTextModel);
                } else if (wmiModel instanceof WmiCompositeModel) {
                    n5 = n2 == -1 ? 0 : n2;
                    n4 = ((WmiCompositeModel)wmiModel).getChildCount() - 1;
                    wmiTransferModel2 = new WmiTransferModel((WmiCompositeModel)wmiModel, n5, n4);
                    if (wmiModel instanceof WmiMathModel) {
                        wmiTransferModel2.setSemantics(((WmiMathModel)wmiModel).getSemantics());
                    }
                    wmiTransferModel.replaceFirstChild(wmiTransferModel2);
                }
            } else if (wmiModel instanceof WmiAbstractMathTokenModel) {
                if (n2 > 0) {
                    WmiAbstractMathTokenModel wmiAbstractMathTokenModel = (WmiAbstractMathTokenModel)wmiModel;
                    WmiTextModel wmiTextModel = WmiTransfer.normalizeMathTextModel(wmiAbstractMathTokenModel, n2, true);
                    wmiTextModel.setParent(wmiAbstractMathTokenModel.getParent());
                    wmiTransferModel.replaceFirstChild(wmiTextModel);
                }
            } else if (wmiModel instanceof WmiMathModel && n2 == -1) {
                wmiTransferModel.trim(0);
            }
        }
    }

    protected static void trimEndPath(WmiTransferModel wmiTransferModel, WmiModelPath wmiModelPath, int n, int n2, int n3) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        int n4 = wmiModelPath.depth();
        WmiModel wmiModel = wmiTransferModel.getLastChild();
        if (!(wmiModel instanceof WmiMathWrapperModel)) {
            WmiAbstractModel wmiAbstractModel;
            int n5;
            while (++n < n4) {
                n5 = wmiModelPath.peek(n);
                if (!(wmiModel instanceof WmiCompositeModel)) break;
                wmiAbstractModel = new WmiTransferModel((WmiCompositeModel)wmiModel, 0, n5);
                if (wmiModel instanceof WmiMathModel) {
                    wmiAbstractModel.setSemantics(((WmiMathModel)wmiModel).getSemantics());
                }
                wmiTransferModel.replaceLastChild(wmiAbstractModel);
                wmiTransferModel = wmiAbstractModel;
                wmiModel = wmiTransferModel.getLastChild();
                if (!(wmiModel instanceof WmiMathWrapperModel)) continue;
                break;
            }
            if (!(wmiModel instanceof WmiMathModel)) {
                if (wmiModel instanceof WmiTextModel) {
                    String string = ((WmiTextModel)wmiModel).getText();
                    if (n2 < string.length()) {
                        wmiAbstractModel = new WmiTextModel(wmiModel.getDocument(), string.substring(0, n2), (WmiFontAttributeSet)wmiModel.getAttributesForRead());
                        wmiTransferModel.replaceLastChild(wmiAbstractModel);
                    }
                } else if (wmiModel instanceof WmiCompositeModel) {
                    n5 = ((WmiCompositeModel)wmiModel).getChildCount() - 1;
                    int n6 = n2 == -1 ? n5 : n2;
                    WmiTransferModel wmiTransferModel2 = new WmiTransferModel((WmiCompositeModel)wmiModel, 0, n6);
                    if (wmiModel instanceof WmiMathModel) {
                        wmiTransferModel2.setSemantics(((WmiMathModel)wmiModel).getSemantics());
                    }
                    wmiTransferModel.replaceLastChild(wmiTransferModel2);
                }
            } else if (wmiModel instanceof WmiAbstractMathTokenModel) {
                if (wmiTransferModel.getChildCount() == 1) {
                    n2 -= n3;
                }
                WmiAbstractMathTokenModel wmiAbstractMathTokenModel = (WmiAbstractMathTokenModel)wmiModel;
                if (n2 != -1 && n2 < wmiAbstractMathTokenModel.getLength()) {
                    wmiAbstractModel = WmiTransfer.normalizeMathTextModel(wmiAbstractMathTokenModel, n2, false);
                    wmiAbstractModel.setParent(wmiAbstractMathTokenModel.getParent());
                    wmiTransferModel.replaceLastChild(wmiAbstractModel);
                }
            }
        }
    }

    private static WmiTextModel normalizeMathTextModel(WmiAbstractMathTokenModel wmiAbstractMathTokenModel, int n, boolean bl) throws WmiNoReadAccessException {
        String string = wmiAbstractMathTokenModel.getAllText();
        WmiAttributeSet wmiAttributeSet = wmiAbstractMathTokenModel.getAttributesForRead();
        if (wmiAttributeSet instanceof WmiMathStringModel.WmiMathStringAttributeSet) {
            Object object = wmiAttributeSet.getAttribute("lquote");
            Object object2 = wmiAttributeSet.getAttribute("rquote");
            if (object == null) {
                object = "\"";
            }
            if (object2 == null) {
                object2 = "\"";
            }
            string = object + string + object2;
            wmiAttributeSet = wmiAttributeSet.copyAttributes();
            wmiAttributeSet.addAttribute("lquote", "");
            wmiAttributeSet.addAttribute("rquote", "");
            wmiAbstractMathTokenModel = new WmiMathTextModel(wmiAbstractMathTokenModel.getDocument(), string, wmiAttributeSet);
        }
        int n2 = n;
        int n3 = wmiAbstractMathTokenModel.getLength();
        if (!bl) {
            n2 = 0;
            n3 = n;
        }
        return MathInsertUtil.createModel(wmiAbstractMathTokenModel, string, n2, n3);
    }

    public static DataFlavor getFlavor(String string) {
        FlavorMap flavorMap = SystemFlavorMap.getDefaultFlavorMap();
        Map<String, DataFlavor> map = flavorMap.getFlavorsForNatives(null);
        return map.get(string);
    }

    protected static boolean isValidTransferModelRoot(WmiModel wmiModel) {
        WmiModelTag wmiModelTag = wmiModel.getTag();
        return !invalidTransferModelTags.contains(wmiModelTag);
    }

    protected static boolean isOwnTransferModel(WmiModel wmiModel) {
        WmiModelTag wmiModelTag = wmiModel.getTag();
        return selfreturningTransferModelTags.contains(wmiModelTag);
    }

    static {
        invalidTransferModelTags.add(WmiModelTag.MATH_TABLE_ROW);
        invalidTransferModelTags.add(WmiModelTag.MATH_TABLE_ROW);
        selfreturningTransferModelTags = new HashSet();
    }
}

