/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.controller.edit;

import com.maplesoft.mathdoc.controller.edit.WmiTransfer;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiFormatException;
import com.maplesoft.mathdoc.exception.WmiModelIndexOutOfBoundsException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoUpdateAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.exception.WmiParseException;
import com.maplesoft.mathdoc.io.WmiExportFormatter;
import com.maplesoft.mathdoc.io.mathml.WmiMathMLImportParser;
import com.maplesoft.mathdoc.io.mathml.export.WmiMathMLPresentationFormatter;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelLock;
import com.maplesoft.mathdoc.model.WmiModelPath;
import com.maplesoft.mathdoc.model.WmiTransferModel;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.view.WmiMathMLDocumentView;
import com.maplesoft.mathdoc.view.WmiRenderPath;
import com.maplesoft.mathdoc.view.WmiSelection;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.image.BufferedImage;
import java.io.StringReader;
import java.io.StringWriter;

public class WmiMathMLTransfer
extends WmiTransfer
implements Transferable,
ClipboardOwner {
    public static final DataFlavor MATHML_STRING_FLAVOR = new DataFlavor("application/x-java-maple-mathml;class=java.lang.String", "MathML");
    public static final DataFlavor MATHML_IMAGE_FLAVOR = new DataFlavor("application/x-java-maple-mathml-image", "MathML Image");

    private WmiMathMLTransfer() {
    }

    public static WmiTransfer createTransferable(WmiSelection wmiSelection) {
        WmiMathMLTransfer wmiMathMLTransfer = null;
        WmiModel[] wmiModelArray = new WmiModel[2];
        int[] nArray = new int[2];
        if (wmiSelection.getModelInterval(wmiModelArray, nArray)) {
            WmiMathMLDocumentView wmiMathMLDocumentView = (WmiMathMLDocumentView)wmiSelection.getSourceDocument();
            wmiMathMLTransfer = WmiMathMLTransfer.createCompositeModelTransferable(wmiModelArray[0], nArray[0], wmiModelArray[1], nArray[1], wmiMathMLDocumentView);
        }
        return wmiMathMLTransfer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static WmiMathMLTransfer createCompositeModelTransferable(WmiModel wmiModel, int n, WmiModel wmiModel2, int n2, WmiMathMLDocumentView wmiMathMLDocumentView) {
        WmiMathMLTransfer wmiMathMLTransfer = null;
        WmiCompositeModel wmiCompositeModel = wmiModel.getDocument();
        WmiTransferModel wmiTransferModel = null;
        WmiMathDocumentModel wmiMathDocumentModel = null;
        try {
            Object object;
            int n3;
            int n4;
            int n5;
            WmiModelPath wmiModelPath = new WmiModelPath(wmiModel);
            WmiModelPath wmiModelPath2 = new WmiModelPath(wmiModel2);
            if (wmiModelPath.depth() == 0 || wmiModelPath2.depth() == 0) {
                WmiMathMLTransfer wmiMathMLTransfer2 = null;
                return wmiMathMLTransfer2;
            }
            int n6 = wmiModelPath.depth();
            int n7 = n6 < (n5 = wmiModelPath2.depth()) ? n6 : n5;
            for (n4 = 0; n4 < n7 && (n3 = wmiModelPath.peek(n4)) == wmiModelPath2.peek(n4) && (object = wmiCompositeModel.getChild(n3)) instanceof WmiCompositeModel && object != wmiModel; ++n4) {
                wmiCompositeModel = (WmiCompositeModel)object;
            }
            if (WmiMathMLTransfer.isValidTransferModelRoot(wmiCompositeModel)) {
                Object object2;
                wmiTransferModel = new WmiTransferModel(wmiCompositeModel, wmiModelPath.peek(n4), wmiModelPath2.peek(n4));
                if (wmiCompositeModel instanceof WmiMathModel) {
                    wmiTransferModel.setSemantics(((WmiMathModel)((Object)wmiCompositeModel)).getSemantics());
                }
                WmiMathMLTransfer.trimStartPath(wmiTransferModel, wmiModelPath, n4, n);
                WmiMathMLTransfer.trimEndPath(wmiTransferModel, wmiModelPath2, n4, n2, n);
                wmiMathMLTransfer = new WmiMathMLTransfer();
                StringWriter stringWriter = new StringWriter();
                object = new WmiMathMLPresentationFormatter(wmiMathMLDocumentView);
                if (wmiModelPath.equals(wmiModelPath2)) {
                    object2 = wmiCompositeModel.getChild(wmiModelPath.peek(n4));
                    ((WmiExportFormatter)object).format(stringWriter, (WmiModel)object2);
                } else {
                    ((WmiExportFormatter)object).format(stringWriter, wmiTransferModel);
                }
                object2 = stringWriter.toString();
                if (!((String)object2).startsWith("<math")) {
                    object2 = "<math xmlns='http://www.w3.org/1998/Math/MathML'>" + (String)object2 + "</math>";
                }
                wmiMathMLTransfer.addDataFlavor(DataFlavor.stringFlavor, object2);
                WmiTransferMathMLView wmiTransferMathMLView = new WmiTransferMathMLView();
                wmiMathDocumentModel = (WmiMathDocumentModel)wmiTransferMathMLView.getModel();
                WmiMathMLImportParser wmiMathMLImportParser = new WmiMathMLImportParser();
                StringReader stringReader = new StringReader((String)object2);
                WmiModelLock.writeLock(wmiMathDocumentModel, true);
                wmiMathMLImportParser.parse(stringReader, (WmiCompositeModel)wmiMathDocumentModel, 0);
                wmiMathDocumentModel.update(null);
                int n8 = wmiTransferMathMLView.getHeight();
                int n9 = wmiTransferMathMLView.getWidth();
                BufferedImage bufferedImage = new BufferedImage(n9, n8, 2);
                Graphics2D graphics2D = bufferedImage.createGraphics();
                wmiTransferMathMLView.draw(graphics2D, new WmiRenderPath(wmiTransferMathMLView), new Rectangle(0, 0, n9, n8));
                wmiMathMLTransfer.addDataFlavor(DataFlavor.imageFlavor, bufferedImage);
                graphics2D.dispose();
            }
        }
        catch (WmiNoReadAccessException wmiNoReadAccessException) {
            WmiErrorLog.log(wmiNoReadAccessException);
        }
        catch (WmiNoWriteAccessException wmiNoWriteAccessException) {
            WmiErrorLog.log(wmiNoWriteAccessException);
        }
        catch (WmiModelIndexOutOfBoundsException wmiModelIndexOutOfBoundsException) {
            WmiErrorLog.log(wmiModelIndexOutOfBoundsException);
        }
        catch (WmiParseException wmiParseException) {
            WmiErrorLog.log(wmiParseException);
        }
        catch (WmiNoUpdateAccessException wmiNoUpdateAccessException) {
            WmiErrorLog.log(wmiNoUpdateAccessException);
        }
        catch (WmiFormatException wmiFormatException) {
            WmiErrorLog.log(wmiFormatException);
        }
        finally {
            if (wmiMathDocumentModel != null) {
                WmiModelLock.writeUnlock(wmiMathDocumentModel);
            }
        }
        return wmiMathMLTransfer;
    }

    protected static class WmiTransferMathMLView
    extends WmiMathMLDocumentView {
        private static final int EQUATION_WIDTH = 400;

        protected WmiTransferMathMLView() {
        }

        public int getBreakWidth() {
            return 400;
        }
    }
}

