/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.controller;

import com.maplesoft.mathdoc.controller.WmiController;
import com.maplesoft.mathdoc.controller.WmiTextKeyListener;
import com.maplesoft.mathdoc.controller.WmiTextMouseListener;
import com.maplesoft.mathdoc.controller.WmiViewFactory;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelLock;
import com.maplesoft.mathdoc.view.WmiHighlightPainter;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiSelection;
import com.maplesoft.mathdoc.view.WmiTraversableView;
import com.maplesoft.mathdoc.view.WmiView;
import java.awt.Rectangle;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelListener;

public class WmiTextController
implements WmiController {
    private WmiTextMouseListener mouseListener = null;
    private KeyListener keyListener = this.createKeyListener();

    public WmiTextController() {
        this.mouseListener = this.createMouseListener();
    }

    protected KeyListener createKeyListener() {
        return new WmiTextKeyListener();
    }

    protected WmiTextMouseListener createMouseListener() {
        return new WmiTextMouseListener();
    }

    public KeyListener getKeyListener() {
        return this.keyListener;
    }

    public MouseListener getMouseListener() {
        return this.mouseListener;
    }

    public MouseMotionListener getMouseMotionListener() {
        return this.mouseListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateSelection(WmiTraversableView wmiTraversableView, int n) throws WmiNoReadAccessException {
        WmiMathDocumentView wmiMathDocumentView = wmiTraversableView.getDocumentView();
        if (wmiMathDocumentView != null) {
            WmiViewFactory wmiViewFactory = wmiMathDocumentView.getViewFactory();
            if (wmiViewFactory != null) {
                wmiViewFactory.updateSelection(wmiTraversableView, n);
            }
            WmiMathDocumentModel wmiMathDocumentModel = (WmiMathDocumentModel)wmiMathDocumentView.getModel();
            try {
                WmiHighlightPainter wmiHighlightPainter;
                WmiModelLock.readLock(wmiMathDocumentModel, true);
                WmiSelection wmiSelection = wmiMathDocumentView.getSelection();
                WmiHighlightPainter wmiHighlightPainter2 = wmiHighlightPainter = wmiSelection != null ? wmiSelection.getSelectionHighlighter() : null;
                if (wmiHighlightPainter != null) {
                    Rectangle rectangle = wmiHighlightPainter.getBounds();
                    if (rectangle.width <= 1) {
                        wmiMathDocumentView.setSelection(null);
                        wmiTraversableView.setPositionMarker(n);
                    }
                }
            }
            finally {
                WmiModelLock.readUnlock(wmiMathDocumentModel);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetSelection(WmiView wmiView) {
        WmiModel wmiModel = null;
        try {
            wmiModel = wmiView.getModel();
            WmiModelLock.readLock(wmiModel, true);
            WmiMathDocumentView wmiMathDocumentView = wmiView.getDocumentView();
            wmiMathDocumentView.setSelection(null);
            wmiMathDocumentView.repaint();
        }
        finally {
            WmiModelLock.readUnlock(wmiModel);
        }
    }

    public MouseWheelListener getMouseWheelListener() {
        return null;
    }
}

