/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.controller;

import com.maplesoft.mathdoc.controller.WmiMathDocumentMouseListener;
import com.maplesoft.mathdoc.controller.WmiMouseInputAdapter;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelLock;
import com.maplesoft.mathdoc.model.math.WmiMathActionAttributeSet;
import com.maplesoft.mathdoc.model.math.WmiMathActionModel;
import com.maplesoft.mathdoc.view.WmiView;
import java.awt.event.MouseEvent;

public class WmiMathMouseListener
extends WmiMouseInputAdapter {
    public void mouseClicked(MouseEvent mouseEvent) {
        this.findAndPerformAction(mouseEvent, 2);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.findAndPerformAction(mouseEvent, 0);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.findAndPerformAction(mouseEvent, 5);
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.findAndPerformAction(mouseEvent, 6);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        WmiView wmiView = (WmiView)mouseEvent.getSource();
        if (!this.findAndPerformAction(mouseEvent, 3) && !mouseEvent.isConsumed() && !WmiMathMouseListener.isPopupTrigger(mouseEvent) && WmiMathMouseListener.isConditionalCaretPlacingEvent(mouseEvent)) {
            if (!mouseEvent.isShiftDown()) {
                WmiMathDocumentMouseListener.snapToNearestView(mouseEvent);
            } else {
                WmiMathDocumentMouseListener.updateSelection(mouseEvent);
            }
        }
        wmiView.getDocumentView().saveLastHorizontalPosition();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.findAndPerformAction(mouseEvent, 4);
    }

    private boolean isValidAction(String string, MouseEvent mouseEvent, int n) {
        boolean bl = false;
        if (string != null && WmiMathActionModel.actionTable.isKnownAction(string)) {
            String string2 = this.categorizeTriggerEvent(mouseEvent, n);
            bl = WmiMathActionModel.actionTable.isTrigger(string, string2);
        }
        return bl;
    }

    private String categorizeTriggerEvent(MouseEvent mouseEvent, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        if (mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 2) {
            stringBuffer.append("double-click");
        } else {
            stringBuffer.append(mouseEvent.getButton());
            stringBuffer.append("-");
            String string = null;
            if (n == 2) {
                string = "click";
            } else if (n == 3) {
                string = "press";
            } else if (n == 4) {
                string = "release";
            } else if (n == 1) {
                string = "move";
            } else if (n == 5) {
                string = "enter";
            } else if (n == 6) {
                string = "exit";
            } else if (n == 0) {
                string = "drag";
            }
            stringBuffer.append(string);
            stringBuffer.append("-");
            stringBuffer.append(mouseEvent.getClickCount());
        }
        return stringBuffer.toString();
    }

    private String findAction(WmiMathActionModel wmiMathActionModel) throws WmiNoReadAccessException {
        String string = null;
        if (wmiMathActionModel != null) {
            WmiMathActionAttributeSet wmiMathActionAttributeSet = (WmiMathActionAttributeSet)wmiMathActionModel.getAttributesForRead();
            string = (String)wmiMathActionAttributeSet.getAttribute("actiontype");
        }
        return string;
    }

    private void performAction(String string, MouseEvent mouseEvent, WmiMathActionModel wmiMathActionModel, int n) {
        WmiMathActionModel.WmiMathActionCommand wmiMathActionCommand = WmiMathActionModel.actionTable.getActionCode(string);
        wmiMathActionCommand.execute(mouseEvent, wmiMathActionModel, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean findAndPerformAction(MouseEvent mouseEvent, int n) {
        boolean bl = false;
        WmiView wmiView = (WmiView)mouseEvent.getSource();
        WmiMathActionModel wmiMathActionModel = null;
        String string = null;
        if (WmiModelLock.readLock(wmiView.getModel().getDocument(), true)) {
            try {
                wmiMathActionModel = this.findActionModel(mouseEvent);
                string = this.findAction(wmiMathActionModel);
            }
            catch (WmiNoReadAccessException wmiNoReadAccessException) {
                WmiErrorLog.log(wmiNoReadAccessException);
            }
            finally {
                WmiModelLock.readUnlock(wmiView.getModel().getDocument());
            }
        }
        if (this.isValidAction(string, mouseEvent, n)) {
            this.performAction(string, mouseEvent, wmiMathActionModel, n);
            bl = true;
            mouseEvent.consume();
        }
        return bl;
    }

    private WmiMathActionModel findActionModel(MouseEvent mouseEvent) throws WmiNoReadAccessException {
        WmiMathActionModel wmiMathActionModel = null;
        Object object = mouseEvent.getSource();
        if (object instanceof WmiView) {
            WmiModel wmiModel = ((WmiView)object).getModel();
            while (!(wmiModel instanceof WmiMathActionModel) && wmiModel != null) {
                if (wmiModel == null) continue;
                wmiModel = wmiModel.getParent();
            }
            if (wmiModel != null) {
                wmiMathActionModel = (WmiMathActionModel)wmiModel;
            }
        }
        return wmiMathActionModel;
    }
}

