/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.controller;

import com.maplesoft.mathdoc.controller.WmiClipboardManager;
import com.maplesoft.mathdoc.controller.edit.WmiMathMLTransfer;
import com.maplesoft.mathdoc.controller.edit.WmiTransfer;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiModelIndexOutOfBoundsException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoUpdateAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.exception.WmiParseException;
import com.maplesoft.mathdoc.io.mathml.WmiMathMLImportParser;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiMathDocumentHierarchyValidator;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelUtil;
import com.maplesoft.mathdoc.model.WmiParagraphModel;
import com.maplesoft.mathdoc.model.WmiTransferModel;
import com.maplesoft.mathdoc.model.math.WmiMathWrapperModel;
import com.maplesoft.mathdoc.view.WmiBoundsMarker;
import com.maplesoft.mathdoc.view.WmiMathMLDocumentView;
import com.maplesoft.mathdoc.view.WmiMathMLEditorDocumentView;
import com.maplesoft.mathdoc.view.WmiPositionMarker;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiSelection;
import com.maplesoft.mathdoc.view.WmiTextView;
import com.maplesoft.mathdoc.view.WmiView;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.StringReader;

public class WmiMathMLClipboardManager
extends WmiClipboardManager {
    public static final String RESOURCES = "com.maplesoft.mathdoc.controller.edit.resources.Edit";

    public WmiMathMLClipboardManager(WmiMathMLDocumentView wmiMathMLDocumentView) {
        super(wmiMathMLDocumentView);
    }

    public WmiMathMLClipboardManager(WmiMathMLEditorDocumentView wmiMathMLEditorDocumentView) {
        super(wmiMathMLEditorDocumentView);
    }

    protected Transferable createTransferable(WmiSelection wmiSelection, WmiPositionMarker wmiPositionMarker, boolean bl) {
        WmiTransfer wmiTransfer = null;
        if (wmiSelection != null) {
            wmiTransfer = WmiMathMLTransfer.createTransferable(wmiSelection);
        } else if (wmiPositionMarker instanceof WmiBoundsMarker) {
            wmiTransfer = WmiMathMLTransfer.createTransferable((WmiBoundsMarker)wmiPositionMarker);
        }
        return wmiTransfer;
    }

    public boolean paste(Transferable transferable) {
        boolean bl = false;
        if (this.docView != null) {
            WmiMathMLDocumentView wmiMathMLDocumentView = (WmiMathMLDocumentView)this.docView;
            if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                try {
                    String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                    int n = string.indexOf("<math");
                    int n2 = string.indexOf("</math>");
                    if (n != -1 && n2 != -1 && n2 > n) {
                        bl = this.pasteMathML(wmiMathMLDocumentView, transferable);
                    }
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                    WmiErrorLog.log(unsupportedFlavorException);
                }
                catch (IOException iOException) {
                    WmiErrorLog.log(iOException);
                }
            }
        }
        return bl;
    }

    protected boolean pasteMathML(WmiMathMLDocumentView wmiMathMLDocumentView, Transferable transferable) {
        boolean bl = false;
        try {
            String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
            WmiTransferModel wmiTransferModel = new WmiTransferModel((WmiMathDocumentModel)this.docView.getModel());
            int n = string.indexOf("<math");
            int n2 = string.indexOf("</math>");
            string = string.substring(n, n2 + "</math>".length());
            WmiMathMLImportParser wmiMathMLImportParser = new WmiMathMLImportParser();
            wmiMathMLImportParser.parse(new StringReader(string), (WmiCompositeModel)wmiTransferModel, 0);
            WmiMathDocumentModel wmiMathDocumentModel = (WmiMathDocumentModel)wmiMathMLDocumentView.getModel();
            WmiPositionMarker wmiPositionMarker = wmiMathMLDocumentView.getPositionMarker();
            WmiSelection wmiSelection = wmiMathMLDocumentView.getSelection();
            WmiPositionedView wmiPositionedView = null;
            int n3 = 0;
            boolean bl2 = false;
            if (wmiSelection != null) {
                bl2 = true;
                wmiMathDocumentModel.startUndoableEdit(null);
                wmiSelection.deleteSelection();
                wmiPositionMarker = wmiMathMLDocumentView.getPositionMarker();
            }
            if (wmiPositionMarker != null) {
                wmiPositionedView = wmiPositionMarker.getView();
                n3 = wmiPositionMarker.getOffset();
            }
            if (wmiPositionedView != null) {
                bl = this.insertMathMLModel(wmiTransferModel, wmiMathDocumentModel, wmiPositionedView, n3);
            }
            if (bl2) {
                wmiMathDocumentModel.endUndoableEdit();
            }
            return bl;
        }
        catch (WmiNoReadAccessException wmiNoReadAccessException) {
            WmiErrorLog.log(wmiNoReadAccessException);
        }
        catch (WmiNoWriteAccessException wmiNoWriteAccessException) {
            WmiErrorLog.log(wmiNoWriteAccessException);
        }
        catch (WmiModelIndexOutOfBoundsException wmiModelIndexOutOfBoundsException) {
            WmiErrorLog.log(wmiModelIndexOutOfBoundsException);
        }
        catch (WmiParseException wmiParseException) {
            WmiErrorLog.log(wmiParseException);
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            WmiErrorLog.log(unsupportedFlavorException);
        }
        catch (IOException iOException) {
            WmiErrorLog.log(iOException);
        }
        return bl;
    }

    public boolean insertMathMLModel(WmiCompositeModel wmiCompositeModel, WmiMathDocumentModel wmiMathDocumentModel, WmiView wmiView, int n) {
        boolean bl = false;
        try {
            WmiModel wmiModel;
            WmiParagraphModel wmiParagraphModel = (WmiParagraphModel)wmiCompositeModel.getChild(0);
            WmiMathWrapperModel wmiMathWrapperModel = (WmiMathWrapperModel)wmiParagraphModel.getChild(0);
            WmiModel[] wmiModelArray = new WmiModel[wmiMathWrapperModel.getChildCount()];
            for (int i = 0; i < wmiMathWrapperModel.getChildCount(); ++i) {
                wmiModelArray[i] = wmiMathWrapperModel.getChild(i);
            }
            WmiMathDocumentHierarchyValidator wmiMathDocumentHierarchyValidator = wmiMathDocumentModel.getModelHierarchyValidator();
            for (wmiModel = wmiView.getModel(); wmiModel != null && !wmiMathDocumentHierarchyValidator.isValid(wmiModel, wmiModelArray); wmiModel = wmiModel.getParent()) {
            }
            if (wmiModel instanceof WmiCompositeModel) {
                if (wmiView instanceof WmiTextView) {
                    n += ((WmiTextView)wmiView).getStartOffset();
                }
                if (wmiView != null) {
                    for (WmiModel wmiModel2 = wmiView.getModel(); wmiModel2 != wmiModel && (n = WmiModelUtil.splitModel(wmiModel2, n)) >= 0; wmiModel2 = wmiModel2.getParent()) {
                    }
                }
                if (n >= 0) {
                    ((WmiCompositeModel)wmiModel).addChildren(wmiModelArray, n);
                    wmiCompositeModel.getDocument().update(null);
                    bl = true;
                }
            }
        }
        catch (WmiNoReadAccessException wmiNoReadAccessException) {
            WmiErrorLog.log(wmiNoReadAccessException);
        }
        catch (WmiNoWriteAccessException wmiNoWriteAccessException) {
            WmiErrorLog.log(wmiNoWriteAccessException);
        }
        catch (WmiNoUpdateAccessException wmiNoUpdateAccessException) {
            WmiErrorLog.log(wmiNoUpdateAccessException);
        }
        catch (WmiModelIndexOutOfBoundsException wmiModelIndexOutOfBoundsException) {
            WmiErrorLog.log(wmiModelIndexOutOfBoundsException);
        }
        return bl;
    }
}

