/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.controller;

import com.maplesoft.mathdoc.components.WmiContextManager;
import com.maplesoft.mathdoc.controller.Wmi2DEntryMode;
import com.maplesoft.mathdoc.controller.WmiCommand;
import com.maplesoft.mathdoc.controller.WmiKeyBinder;
import com.maplesoft.mathdoc.controller.WmiTextKeyListener;
import com.maplesoft.mathdoc.controller.insert.WmiInsertEntityCommand;
import com.maplesoft.mathdoc.controller.insert.WmiInsertGenericMathCommand;
import com.maplesoft.mathdoc.controller.insert.WmiInsertTokenCommand;
import com.maplesoft.mathdoc.controller.insert.WmiInsertWrapFenceCommand;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiModelIndexOutOfBoundsException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoUpdateAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelLock;
import com.maplesoft.mathdoc.view.WmiCaret;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiSelection;
import com.maplesoft.mathdoc.view.WmiView;
import com.maplesoft.util.RuntimePlatform;
import java.awt.event.KeyEvent;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.KeyStroke;

public class WmiMathKeyListener
extends WmiTextKeyListener {
    private static final HashMap TAG_TO_BINDING = new HashMap();
    private static final WmiKeyBinder DEFAULT_BINDER = new WmiKeyBinder();
    private static final HashSet IGNORE_PRESSED = new HashSet();

    private static void setupInsertCharacters() {
        WmiInsertDispatch wmiInsertDispatch = new WmiInsertDispatch();
        DEFAULT_BINDER.registerBindingOverRange('\u0000', '\b', wmiInsertDispatch);
        DEFAULT_BINDER.registerBindingOverRange('\n', '\u007f', wmiInsertDispatch);
        DEFAULT_BINDER.registerBindingOverRange('\u00c0', '\u00d6', wmiInsertDispatch);
        DEFAULT_BINDER.registerBindingOverRange('\u00d8', '\u00f6', wmiInsertDispatch);
        DEFAULT_BINDER.registerBindingOverRange('\u00f8', '\u0236', wmiInsertDispatch);
        DEFAULT_BINDER.registerBindingOverRange('\u0370', '\u050f', wmiInsertDispatch);
        DEFAULT_BINDER.registerBinding('\"', (WmiKeyBinder.WmiDispatchOperation)wmiInsertDispatch);
    }

    private static void setupMainKeyboardMap(int n) {
        new WmiInsertWrapFenceCommand("Insert.Fence.Wrap.Paren", false, "(", ")");
        new WmiInsertWrapFenceCommand("Insert.Fence.Wrap.Square", false, "[", "]");
        new WmiInsertWrapFenceCommand("Insert.Fence.Wrap.Curly", false, "{", "}");
        new WmiInsertWrapFenceCommand("Insert.Fence.Wrap.Abs", false, "|", "|");
        DEFAULT_BINDER.registerBinding('_', (WmiKeyBinder.WmiDispatchOperation)new WmiCommandDispatch("Insert.Msub"));
        DEFAULT_BINDER.registerBinding('^', (WmiKeyBinder.WmiDispatchOperation)new WmiCommandDispatch("Insert.Msup"));
        DEFAULT_BINDER.registerBinding('/', (WmiKeyBinder.WmiDispatchOperation)new WmiCommandDispatch("Insert.Mfrac"));
        if (RuntimePlatform.isMac()) {
            KeyStroke keyStroke = KeyStroke.getKeyStroke(222, n | 1);
            DEFAULT_BINDER.registerBinding(keyStroke, (WmiKeyBinder.WmiDispatchOperation)new WmiCommandDispatch("Insert.Mover"));
            DEFAULT_BINDER.registerBinding('\'', n, (WmiKeyBinder.WmiDispatchOperation)new WmiCommandDispatch("Insert.Munder"));
        } else {
            DEFAULT_BINDER.registerBinding('\"', n | 1, (WmiKeyBinder.WmiDispatchOperation)new WmiCommandDispatch("Insert.Mover"));
            DEFAULT_BINDER.registerBinding('\'', n, (WmiKeyBinder.WmiDispatchOperation)new WmiCommandDispatch("Insert.Munder"));
        }
        DEFAULT_BINDER.registerBinding('/', n, (WmiKeyBinder.WmiDispatchOperation)new WmiCommandDispatch("move.math.baseline"));
        int n2 = n;
        if (!RuntimePlatform.isWindows()) {
            n2 |= 1;
        }
        DEFAULT_BINDER.registerBinding(' ', n2, (WmiKeyBinder.WmiDispatchOperation)new WmiCommandDispatch("Insert.Entitylist"));
        DEFAULT_BINDER.registerBinding(82, n | 1, (WmiKeyBinder.WmiDispatchOperation)new WmiCommandDispatch("Insert.Tablerow"));
        DEFAULT_BINDER.registerBinding(67, n | 1, (WmiKeyBinder.WmiDispatchOperation)new WmiCommandDispatch("Insert.Tablecolumn"));
        DEFAULT_BINDER.registerBinding(92, n | 1, (WmiKeyBinder.WmiDispatchOperation)new WmiCommandDispatch("Insert.Tablecolumn"));
        DEFAULT_BINDER.registerBinding('^', n, (WmiKeyBinder.WmiDispatchOperation)new WmiCommandDispatch("Insert.Presup"));
        DEFAULT_BINDER.registerBinding(54, n | 1, (WmiKeyBinder.WmiDispatchOperation)new WmiCommandDispatch("Insert.Presup"));
        DEFAULT_BINDER.registerBinding('_', n, (WmiKeyBinder.WmiDispatchOperation)new WmiCommandDispatch("Insert.Presub"));
        DEFAULT_BINDER.registerBinding(45, n | 1, (WmiKeyBinder.WmiDispatchOperation)new WmiCommandDispatch("Insert.Presub"));
        DEFAULT_BINDER.registerBinding('\b', (WmiKeyBinder.WmiDispatchOperation)new WmiCommandDispatch("edit.backspace"));
        DEFAULT_BINDER.registerBinding('\u007f', (WmiKeyBinder.WmiDispatchOperation)new WmiCommandDispatch("edit.delete"));
        DEFAULT_BINDER.registerBinding('\t', (WmiKeyBinder.WmiDispatchOperation)new WmiCommandDispatch("focus.cycle.forward"));
        DEFAULT_BINDER.registerBinding(KeyStroke.getKeyStroke(new Character('\t'), 0), (WmiKeyBinder.WmiDispatchOperation)new WmiCommandDispatch("focus.cycle.forward"));
        DEFAULT_BINDER.registerBinding(KeyStroke.getKeyStroke(new Character('\t'), 1), (WmiKeyBinder.WmiDispatchOperation)new WmiCommandDispatch("focus.cycle.reverse"));
        DEFAULT_BINDER.registerBinding(9, 1, (WmiKeyBinder.WmiDispatchOperation)new WmiCommandDispatch("focus.cycle.reverse"));
        DEFAULT_BINDER.registerBinding('G', n, (WmiKeyBinder.WmiDispatchOperation)new WmiCommandDispatch("edit.greek.toggle"));
        DEFAULT_BINDER.registerBinding(71, n | 1, (WmiKeyBinder.WmiDispatchOperation)new WmiCommandDispatch("edit.greek.toggle"));
    }

    private static void setupI18nKeyboardMap(int n) {
        int n2 = n | 8;
        DEFAULT_BINDER.registerBinding(KeyStroke.getKeyStroke(79, n2), (WmiKeyBinder.WmiDispatchOperation)new WmiCommandDispatch("Insert.Mover"));
        DEFAULT_BINDER.registerBinding(KeyStroke.getKeyStroke(85, n2), (WmiKeyBinder.WmiDispatchOperation)new WmiCommandDispatch("Insert.Munder"));
        DEFAULT_BINDER.registerBinding(KeyStroke.getKeyStroke(80, n2), (WmiKeyBinder.WmiDispatchOperation)new WmiCommandDispatch("Insert.Presup"));
        DEFAULT_BINDER.registerBinding(KeyStroke.getKeyStroke(66, n2), (WmiKeyBinder.WmiDispatchOperation)new WmiCommandDispatch("Insert.Presub"));
        DEFAULT_BINDER.registerBinding(KeyStroke.getKeyStroke(76, n2), (WmiKeyBinder.WmiDispatchOperation)new WmiCommandDispatch("move.math.baseline"));
        DEFAULT_BINDER.registerBinding(KeyStroke.getKeyStroke(75, n2), (WmiKeyBinder.WmiDispatchOperation)new WmiCommandDispatch("scope.out"));
        DEFAULT_BINDER.registerBinding(KeyStroke.getKeyStroke(74, n2), (WmiKeyBinder.WmiDispatchOperation)new WmiCommandDispatch("scope.in"));
    }

    public WmiKeyBinder getDefaultBindings() {
        return DEFAULT_BINDER;
    }

    public void keyPressed(KeyEvent keyEvent) {
        Object object;
        Wmi2DEntryMode wmi2DEntryMode = this.getMode(keyEvent);
        boolean bl = false;
        WmiView wmiView = null;
        if (!keyEvent.isConsumed()) {
            if (this.acceptKeyPressed(keyEvent) && (object = keyEvent.getSource()) instanceof WmiView && (bl = DEFAULT_BINDER.dispatch(keyEvent, wmiView = (WmiView)object))) {
                keyEvent.consume();
            }
            if (!bl) {
                super.keyPressed(keyEvent);
            }
        }
        if (keyEvent.isConsumed()) {
            this.resetMode(keyEvent, wmi2DEntryMode);
            if (wmiView != null && (object = wmiView.getDocumentView()) != null) {
                ((WmiMathDocumentView)object).saveLastHorizontalPosition();
            }
        } else if (RuntimePlatform.isMac_10_2() && keyEvent.getKeyCode() != 127 && keyEvent.getKeyCode() != 8 && keyEvent.getKeyCode() != 9) {
            this.keyTyped(keyEvent);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        Wmi2DEntryMode wmi2DEntryMode = this.getMode(keyEvent);
        boolean bl = false;
        if (RuntimePlatform.isUnix() && !keyEvent.isConsumed()) {
            if (keyEvent.getKeyCode() == 32) {
                if (keyEvent.isControlDown() || keyEvent.isMetaDown() || keyEvent.isShiftDown()) {
                    Object object = keyEvent.getSource();
                    if (object instanceof WmiView && (bl = DEFAULT_BINDER.dispatch(keyEvent, (WmiView)object))) {
                        keyEvent.consume();
                    }
                    if (!bl) {
                        super.keyPressed(keyEvent);
                    }
                }
            } else if (this.isDeadKey(keyEvent.getKeyCode())) {
                super.keyReleased(keyEvent);
            }
        }
        if (keyEvent.isConsumed()) {
            this.resetMode(keyEvent, wmi2DEntryMode);
        }
        this.notifyKeyReleased(keyEvent);
    }

    protected boolean checkModifiers(KeyEvent keyEvent) {
        return !keyEvent.isControlDown() && !keyEvent.isMetaDown() && (!keyEvent.isAltDown() || RuntimePlatform.isMac());
    }

    public void keyTyped(KeyEvent keyEvent) {
        Wmi2DEntryMode wmi2DEntryMode = this.getMode(keyEvent);
        boolean bl = false;
        if (!keyEvent.isConsumed() && this.checkModifiers(keyEvent) && keyEvent.getKeyChar() != '\u001b') {
            Object object = keyEvent.getSource();
            if (object instanceof WmiView && (bl = DEFAULT_BINDER.dispatch(keyEvent, (WmiView)object))) {
                keyEvent.consume();
            }
            if (!bl) {
                super.keyPressed(keyEvent);
            }
        }
        if (keyEvent.isConsumed()) {
            this.resetMode(keyEvent, wmi2DEntryMode);
        }
        this.notifyKeyTyped(keyEvent);
    }

    private boolean acceptKeyPressed(KeyEvent keyEvent) {
        KeyStroke keyStroke;
        boolean bl;
        boolean bl2 = bl = keyEvent.isControlDown() || keyEvent.isMetaDown() || keyEvent.isShiftDown();
        if (bl && IGNORE_PRESSED.contains(keyStroke = KeyStroke.getKeyStroke(new Character(keyEvent.getKeyChar()), keyEvent.getModifiers()))) {
            bl = false;
        }
        return bl;
    }

    protected boolean finalKeyDispatch(KeyEvent keyEvent, WmiView wmiView, WmiCaret wmiCaret, WmiSelection wmiSelection, boolean bl) {
        WmiKeyBinder wmiKeyBinder;
        WmiModel wmiModel;
        boolean bl2 = false;
        if (wmiView != null && (wmiModel = wmiView.getModel()) != null && (wmiKeyBinder = (WmiKeyBinder)TAG_TO_BINDING.get(wmiModel.getTag())) != null) {
            bl2 = wmiKeyBinder.dispatch(keyEvent, wmiView);
        }
        if (!bl2) {
            bl2 = DEFAULT_BINDER.dispatch(keyEvent, wmiView);
        }
        if (!bl2) {
            bl2 = super.finalKeyDispatch(keyEvent, wmiView, wmiCaret, wmiSelection, bl);
        }
        return bl2;
    }

    private Wmi2DEntryMode getMode(KeyEvent keyEvent) {
        WmiMathDocumentView wmiMathDocumentView;
        WmiContextManager wmiContextManager;
        Wmi2DEntryMode wmi2DEntryMode = WmiContextManager.EM_STANDARD;
        Object object = keyEvent.getSource();
        if (object instanceof WmiView && (wmiContextManager = (wmiMathDocumentView = ((WmiView)object).getDocumentView()).getContextManager()) != null) {
            wmi2DEntryMode = wmiContextManager.getEntryMode();
        }
        return wmi2DEntryMode;
    }

    private void resetMode(KeyEvent keyEvent, Wmi2DEntryMode wmi2DEntryMode) {
        Object object;
        if (!wmi2DEntryMode.equals(WmiContextManager.EM_STANDARD) && (object = keyEvent.getSource()) instanceof WmiView) {
            WmiMathDocumentView wmiMathDocumentView = ((WmiView)object).getDocumentView();
            WmiContextManager wmiContextManager = wmiMathDocumentView.getContextManager();
            wmiContextManager.updateEntryMode(WmiContextManager.EM_STANDARD);
        }
    }

    protected boolean treatTabsAsChars() {
        return false;
    }

    static {
        int n = RuntimePlatform.isMac() ? 4 : 2;
        WmiMathKeyListener.setupInsertCharacters();
        WmiMathKeyListener.setupMainKeyboardMap(n);
        WmiMathKeyListener.setupI18nKeyboardMap(n);
        IGNORE_PRESSED.add(KeyStroke.getKeyStroke(new Character('\t'), 1));
    }

    private static class WmiGreekKeyboardMapper {
        private static final HashMap GREEK_CHARS = new HashMap();

        private WmiGreekKeyboardMapper() {
        }

        public static String getGreekEntity(char c) {
            Character c2 = new Character(c);
            String string = (String)GREEK_CHARS.get(c2);
            return string;
        }

        private static void addCharGreekMapping(char c, String string) {
            Character c2 = new Character(c);
            GREEK_CHARS.put(c2, string);
        }

        static {
            WmiGreekKeyboardMapper.addCharGreekMapping('a', "&alpha;");
            WmiGreekKeyboardMapper.addCharGreekMapping('b', "&beta;");
            WmiGreekKeyboardMapper.addCharGreekMapping('c', "&psi;");
            WmiGreekKeyboardMapper.addCharGreekMapping('d', "&delta;");
            WmiGreekKeyboardMapper.addCharGreekMapping('e', "&varepsilon;");
            WmiGreekKeyboardMapper.addCharGreekMapping('f', "&phi;");
            WmiGreekKeyboardMapper.addCharGreekMapping('g', "&gamma;");
            WmiGreekKeyboardMapper.addCharGreekMapping('h', "&eta;");
            WmiGreekKeyboardMapper.addCharGreekMapping('i', "&iota;");
            WmiGreekKeyboardMapper.addCharGreekMapping('j', "&varphi;");
            WmiGreekKeyboardMapper.addCharGreekMapping('k', "&kappa;");
            WmiGreekKeyboardMapper.addCharGreekMapping('l', "&lambda;");
            WmiGreekKeyboardMapper.addCharGreekMapping('m', "&mu;");
            WmiGreekKeyboardMapper.addCharGreekMapping('n', "&nu;");
            WmiGreekKeyboardMapper.addCharGreekMapping('o', "&omicron;");
            WmiGreekKeyboardMapper.addCharGreekMapping('p', "&pi;");
            WmiGreekKeyboardMapper.addCharGreekMapping('q', "&chi;");
            WmiGreekKeyboardMapper.addCharGreekMapping('r', "&rho;");
            WmiGreekKeyboardMapper.addCharGreekMapping('s', "&sigma;");
            WmiGreekKeyboardMapper.addCharGreekMapping('t', "&tau;");
            WmiGreekKeyboardMapper.addCharGreekMapping('u', "&upsilon;");
            WmiGreekKeyboardMapper.addCharGreekMapping('v', "&varpi;");
            WmiGreekKeyboardMapper.addCharGreekMapping('w', "&omega;");
            WmiGreekKeyboardMapper.addCharGreekMapping('x', "&xi;");
            WmiGreekKeyboardMapper.addCharGreekMapping('y', "&theta;");
            WmiGreekKeyboardMapper.addCharGreekMapping('z', "&zeta;");
            WmiGreekKeyboardMapper.addCharGreekMapping('A', "&Alpha;");
            WmiGreekKeyboardMapper.addCharGreekMapping('B', "&Beta;");
            WmiGreekKeyboardMapper.addCharGreekMapping('C', "&Psi;");
            WmiGreekKeyboardMapper.addCharGreekMapping('D', "&Delta;");
            WmiGreekKeyboardMapper.addCharGreekMapping('E', "&epsilon;");
            WmiGreekKeyboardMapper.addCharGreekMapping('F', "&Phi;");
            WmiGreekKeyboardMapper.addCharGreekMapping('G', "&Gamma;");
            WmiGreekKeyboardMapper.addCharGreekMapping('H', "&Eta;");
            WmiGreekKeyboardMapper.addCharGreekMapping('I', "&digamma;");
            WmiGreekKeyboardMapper.addCharGreekMapping('J', "J");
            WmiGreekKeyboardMapper.addCharGreekMapping('K', "&varkappa;");
            WmiGreekKeyboardMapper.addCharGreekMapping('L', "&Lambda;");
            WmiGreekKeyboardMapper.addCharGreekMapping('M', "&Mu;");
            WmiGreekKeyboardMapper.addCharGreekMapping('N', "&Nu;");
            WmiGreekKeyboardMapper.addCharGreekMapping('O', "&Omicron;");
            WmiGreekKeyboardMapper.addCharGreekMapping('P', "&Pi;");
            WmiGreekKeyboardMapper.addCharGreekMapping('Q', "Q");
            WmiGreekKeyboardMapper.addCharGreekMapping('R', "&Rho;");
            WmiGreekKeyboardMapper.addCharGreekMapping('S', "&Sigma;");
            WmiGreekKeyboardMapper.addCharGreekMapping('T', "&varsigma;");
            WmiGreekKeyboardMapper.addCharGreekMapping('U', "&Upsilon;");
            WmiGreekKeyboardMapper.addCharGreekMapping('V', "V");
            WmiGreekKeyboardMapper.addCharGreekMapping('W', "&Omega;");
            WmiGreekKeyboardMapper.addCharGreekMapping('X', "&Xi;");
            WmiGreekKeyboardMapper.addCharGreekMapping('Y', "&Theta;");
            WmiGreekKeyboardMapper.addCharGreekMapping('Z', "&vartheta;");
        }
    }

    public static class WmiInsertDispatch
    implements WmiKeyBinder.WmiDispatchOperation {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean dispatch(KeyEvent keyEvent, WmiView wmiView) {
            WmiCompositeModel wmiCompositeModel = null;
            if (wmiView != null && wmiView.getModel() != null) {
                boolean bl = false;
                WmiMathDocumentView wmiMathDocumentView = wmiView.getDocumentView();
                WmiContextManager wmiContextManager = wmiMathDocumentView.getContextManager();
                WmiMathDocumentModel wmiMathDocumentModel = (WmiMathDocumentModel)wmiMathDocumentView.getModel();
                if (WmiModelLock.writeLock(wmiMathDocumentModel, true)) {
                    try {
                        WmiModel wmiModel = wmiView.getModel();
                        WmiCompositeModel wmiCompositeModel2 = wmiCompositeModel = wmiModel != null ? wmiModel.getParent() : null;
                        if (wmiCompositeModel != null) {
                            String string;
                            if (wmiContextManager != null && wmiContextManager.getEntryMode().equals(WmiContextManager.EM_GREEK) && (string = WmiGreekKeyboardMapper.getGreekEntity(keyEvent.getKeyChar())) != null) {
                                WmiInsertEntityCommand.DEFAULT_ENTITY_INSERTER.insert(wmiMathDocumentView, string);
                                bl = true;
                            }
                            if (!bl) {
                                int n = keyEvent.getKeyChar();
                                if (n == 42 && !WmiInsertGenericMathCommand.isEscapedInsert(wmiMathDocumentView, "*")) {
                                    n = 8901;
                                }
                                WmiInsertTokenCommand.insertAndUpdate((char)n, wmiView, null);
                            }
                        }
                    }
                    catch (WmiModelIndexOutOfBoundsException wmiModelIndexOutOfBoundsException) {
                        WmiErrorLog.log(wmiModelIndexOutOfBoundsException);
                    }
                    catch (WmiNoReadAccessException wmiNoReadAccessException) {
                        WmiErrorLog.log(wmiNoReadAccessException);
                    }
                    catch (WmiNoUpdateAccessException wmiNoUpdateAccessException) {
                        WmiErrorLog.log(wmiNoUpdateAccessException);
                    }
                    catch (WmiNoWriteAccessException wmiNoWriteAccessException) {
                        WmiErrorLog.log(wmiNoWriteAccessException);
                    }
                    finally {
                        WmiModelLock.writeUnlock(wmiMathDocumentModel);
                    }
                }
            }
            return true;
        }
    }

    public static class WmiCommandDispatch
    implements WmiKeyBinder.WmiDispatchOperation {
        String command = null;

        public WmiCommandDispatch(String string) {
            this.command = string;
        }

        public boolean dispatch(KeyEvent keyEvent, WmiView wmiView) {
            WmiCommand.invokeCommand(this.command);
            return true;
        }
    }
}

