/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.controller;

import com.maplesoft.mathdoc.controller.WmiCommand;
import com.maplesoft.mathdoc.controller.WmiCommandProxy;
import com.maplesoft.mathdoc.controller.WmiController;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiView;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.HashSet;
import java.util.Set;

public class WmiMathDocumentKeyListener
implements KeyListener {
    private static Set allowedWithInputLock;
    private WmiMathDocumentView rootView = null;
    private WmiView focusView = null;

    public static void addInputLockOverride(WmiCommand.WmiShortcutCombination wmiShortcutCombination) {
        if (allowedWithInputLock == null) {
            allowedWithInputLock = new HashSet();
        }
        allowedWithInputLock.add(wmiShortcutCombination);
    }

    public WmiMathDocumentKeyListener(WmiMathDocumentView wmiMathDocumentView) {
        this.rootView = wmiMathDocumentView;
    }

    public void setFocus(WmiView wmiView) {
        this.focusView = wmiView;
    }

    public WmiView getFocus() {
        return this.focusView;
    }

    private boolean overridesInputLock(KeyEvent keyEvent) {
        if (allowedWithInputLock != null) {
            return allowedWithInputLock.contains(new WmiCommand.WmiShortcutCombination(keyEvent.getKeyChar(), keyEvent.getKeyCode(), keyEvent.getModifiersEx()));
        }
        return false;
    }

    public void keyTyped(KeyEvent keyEvent) {
        try {
            if (this.rootView.getInputLock().isLocked() && this.overridesInputLock(keyEvent)) {
                WmiCommandProxy wmiCommandProxy = WmiCommand.getCommandProxy(keyEvent);
                if (wmiCommandProxy != null) {
                    wmiCommandProxy.actionPerformed(new ActionEvent(wmiCommandProxy, 0, wmiCommandProxy.getName()));
                }
            } else {
                KeyListener keyListener = this.getKeyListener();
                if (keyListener != null && !keyEvent.isConsumed()) {
                    Object object = keyEvent.getSource();
                    keyEvent.setSource(this.focusView);
                    keyListener.keyTyped(keyEvent);
                    keyEvent.setSource(object);
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            WmiErrorLog.log(nullPointerException);
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        try {
            KeyListener keyListener = this.getKeyListener();
            if (keyListener != null && !keyEvent.isConsumed()) {
                Object object = keyEvent.getSource();
                keyEvent.setSource(this.focusView);
                keyListener.keyPressed(keyEvent);
                keyEvent.setSource(object);
            }
        }
        catch (NullPointerException nullPointerException) {
            WmiErrorLog.log(nullPointerException);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        try {
            KeyListener keyListener = this.getKeyListener();
            if (keyListener != null) {
                Object object = keyEvent.getSource();
                keyEvent.setSource(this.focusView);
                keyListener.keyReleased(keyEvent);
                keyEvent.setSource(object);
            }
        }
        catch (NullPointerException nullPointerException) {
            WmiErrorLog.log(nullPointerException);
        }
    }

    protected KeyListener getKeyListener() {
        KeyListener keyListener = null;
        if (this.focusView != null) {
            if (this.focusView.getModel() != null && !this.rootView.getInputLock().isLocked()) {
                WmiController wmiController = this.rootView.getViewFactory().getController(this.focusView);
                keyListener = wmiController != null ? wmiController.getKeyListener() : null;
            } else {
                this.focusView = null;
            }
        }
        return keyListener;
    }
}

