/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.controller;

import com.maplesoft.mathdoc.components.WmiComponentUtil;
import com.maplesoft.mathdoc.controller.WmiCommand;
import com.maplesoft.mathdoc.util.WmiResourcePackage;
import com.maplesoft.util.RuntimeLocale;
import com.maplesoft.util.RuntimePlatform;
import com.maplesoft.util.StringTools;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class WmiCommandLoader
extends Task {
    private static final String COMMAND_NAMES_KEY = "names";
    private static final String COMMAND_LOADING_CUSTOM = "customloading";
    private static final String MENU_LOADING_CUSTOM = ".menu.custom";
    private static final String separator;
    private static final int LOW_ASCII = 127;
    private static int menuCounter;
    private static int itemCounter;
    private String source;
    private String basedir;
    private String proxy;
    private String target;
    private String className;
    private File targetFile;
    private FileWriter writer;
    private String indent = "";
    static final /* synthetic */ boolean $assertionsDisabled;

    public void execute() throws BuildException {
        System.setProperty("java.awt.headless", "true");
        try {
            String[] stringArray = null;
            stringArray = RuntimePlatform.isWindows() ? new String[]{"Win", "Mac", "Unix"} : (RuntimePlatform.isMac() ? new String[]{"Mac", "Win", "Unix"} : new String[]{"Unix", "Win", "Mac"});
            for (int i = 0; i < stringArray.length; ++i) {
                RuntimePlatform.setOS(stringArray[i]);
                WmiResourcePackage.setPlatformSuffix();
                this.exportAllLocalizations(stringArray[i]);
            }
        }
        catch (IOException iOException) {
            throw new BuildException((Throwable)iOException);
        }
    }

    private void exportAllLocalizations(String string) throws IOException {
        Iterator iterator = RuntimeLocale.getSupportedLocaleIterator();
        while (iterator.hasNext()) {
            Locale locale = (Locale)iterator.next();
            RuntimeLocale.setDisplayLocale(locale);
            this.export(string + "_" + locale.toString());
        }
    }

    private void export(String string) throws IOException {
        int n = this.target.lastIndexOf("/");
        if (n < 0) {
            throw new IOException("Invalid target");
        }
        this.className = this.target.substring(n + 1) + string;
        this.targetFile = new File(this.target + string + ".java");
        boolean bl = false;
        if (!this.targetFile.exists()) {
            bl = true;
        } else {
            bl = this.checkFiles(this.source);
            if (this.proxy != null) {
                bl |= this.checkFiles(this.proxy);
            }
        }
        if (bl) {
            File file = new File(this.source);
            String string2 = file.getName();
            int n2 = string2.indexOf(46);
            if (n2 >= 0) {
                string2 = string2.substring(0, n2);
            }
            this.registerCommands();
        }
    }

    public boolean checkFiles(String string) {
        boolean bl = false;
        File file = new File(this.basedir + "/" + string + ".properties");
        File file2 = new File(this.basedir + "/" + string + "_localized_en.properties");
        File file3 = new File(this.basedir + "/" + string + "_localized_ja.properties");
        if (file.lastModified() > this.targetFile.lastModified()) {
            bl = true;
        } else if (file2.lastModified() > this.targetFile.lastModified()) {
            bl = true;
        } else if (file3 != null && file3.lastModified() > this.targetFile.lastModified()) {
            bl = true;
        }
        return bl;
    }

    public void setSource(String string) {
        this.source = string;
    }

    public void setBaseDir(String string) {
        this.basedir = string;
    }

    public void setProxy(String string) {
        this.proxy = string;
    }

    public void setTarget(String string) {
        this.target = string;
    }

    public void setClassname(String string) {
        this.className = string;
    }

    public void registerCommands() {
        try {
            String string;
            Object object;
            String[] stringArray;
            Object object2;
            WmiResourcePackage wmiResourcePackage = WmiResourcePackage.getResourcePackage(this.source);
            WmiResourcePackage wmiResourcePackage2 = this.proxy != null ? WmiResourcePackage.getResourcePackage(this.proxy) : null;
            int n = this.source.lastIndexOf(47);
            String string2 = n >= 0 ? this.source.substring(n + 1) : null;
            String string3 = wmiResourcePackage.getStringForKey("package");
            String string4 = wmiResourcePackage.getStringForKey("classes");
            String string5 = wmiResourcePackage.getStringForKey(COMMAND_NAMES_KEY);
            String string6 = string2 != null ? wmiResourcePackage.getStringForKey(string2 + ".menu") : null;
            this.writePreamble();
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            if (string4 != null) {
                object2 = string4.split("  *");
                for (int i = 0; i < ((String[])object2).length; ++i) {
                    stringArray = object2[i].split(":");
                    if (!$assertionsDisabled && stringArray.length != 2 && stringArray.length != 1) {
                        throw new AssertionError();
                    }
                    String string7 = stringArray[0];
                    object = this.writeCommandLoader(string3, string7);
                    if (object == null) continue;
                    string = ((WmiCommand)object).getName();
                    String string8 = this.getResource(wmiResourcePackage, string, ".proxy");
                    this.setIndent("        ");
                    if (string8 == null) {
                        this.writeSetResources(wmiResourcePackage, wmiResourcePackage2, string);
                    } else {
                        this.writeSetResources(wmiResourcePackage2, wmiResourcePackage2, string8);
                    }
                    this.writeln("WmiCommand.registerCommand( command );");
                    hashMap.put(string, object);
                    this.setIndent("");
                }
            }
            object2 = null;
            if (string2 != null) {
                object2 = new MenuBuilder(string2, wmiResourcePackage, wmiResourcePackage2);
            }
            if (string5 != null) {
                String string9 = wmiResourcePackage.getStringForKey(COMMAND_LOADING_CUSTOM);
                if (string9 != null && !string9.equals(COMMAND_LOADING_CUSTOM)) {
                    this.writeln("// java code imported from the properties file:");
                    this.writeln(string9);
                }
                stringArray = string5.split("  *");
                for (int i = 0; i < stringArray.length; ++i) {
                    object = stringArray[i];
                    if (hashMap.containsKey(object)) continue;
                    string = this.getResource(wmiResourcePackage, (String)object, ".proxy");
                    if (string == null) {
                        this.writeResourceLoader(wmiResourcePackage, wmiResourcePackage2, (String)object);
                        continue;
                    }
                    this.writeResourceLoader(wmiResourcePackage2, wmiResourcePackage2, string);
                }
                this.flushCommandLoader(true);
            } else {
                this.flushCommandLoader(false);
            }
            if (string2 != null) {
                this.writeMenuPreamble(((MenuBuilder)object2).menuID);
                ((MenuBuilder)object2).write();
                this.flushMenu();
            }
            this.flush();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void setIndent(String string) {
        this.indent = string;
    }

    private void writeln(String string) throws IOException {
        this.writer.write(this.indent);
        this.writer.write(string);
        this.writer.write(separator);
    }

    private void writeLines(String[] stringArray) throws IOException {
        for (int i = 0; i < stringArray.length; ++i) {
            this.writeln(stringArray[i]);
        }
    }

    private void writePreamble() throws IOException {
        this.writer = new FileWriter(this.targetFile);
        this.writeLines(new String[]{"// This is an autogenerated file -- Please do not edit directly.", "", "", "package com.maplesoft.wksload;", "", "", "import java.util.HashMap;", "import java.util.Iterator;", "import javax.swing.KeyStroke;", "import javax.swing.JMenu;", "import javax.swing.JMenuItem;", "import javax.swing.event.MenuListener;", "import javax.swing.event.MenuEvent;", "import com.maplesoft.client.BuildConstants;", "import com.maplesoft.mathdoc.controller.WmiCommand;", "import com.maplesoft.mathdoc.controller.WmiCommandProxy;", "import com.maplesoft.mathdoc.controller.WmiMenuBuilder;", "import com.maplesoft.worksheet.application.WmiWorksheet;", "", "", "public class " + this.className + " implements WmiMenuBuilder {", "", "", "    public boolean loadCommands() {", "        WmiWorksheet.progress(\"loadCommands in " + this.targetFile.getName() + "\");", "        WmiCommand command = null;", "        HashMap commandMap = new HashMap();", "         boolean register;", "        WmiCommand.setAutoRegister( false );"});
    }

    private WmiCommand writeCommandLoader(String string, String string2) throws IOException {
        String string3 = string + "." + string2;
        try {
            if (string2.indexOf("Mru") != -1) {
                throw new Exception("Force normal loading of Mru items");
            }
            Class<?> clazz = Class.forName(string3);
            WmiCommand wmiCommand = (WmiCommand)clazz.newInstance();
            this.writeLines(new String[]{"        command = new WmiCommandProxy(", "            \"" + string3 + "\",", "            \"" + wmiCommand.getName() + "\",", "            \"" + wmiCommand.getDocumentTypeTag() + "\", // doctype", "            " + wmiCommand.getType() + ", // type", "            " + wmiCommand.isBackgroundTask() + ", // isBackground", "            " + wmiCommand.isUpdateCommand() + ", // isUpdate", "            " + wmiCommand.lockTypeRequired() + ", // lockType", "            " + wmiCommand.getIgnorableModifier() + ", // ignore", "            \"" + wmiCommand.getResourcePath() + "\",", "            " + wmiCommand.shouldConsumeEvent(), "        );"});
            return wmiCommand;
        }
        catch (Exception exception) {
            this.writeln("        // " + exception.toString());
            string2 = string2.trim().replaceAll("\\$", ".");
            String string4 = string + "." + string2;
            this.writeLines(new String[]{"        command = new " + string4 + "();", "        commandMap.put( command.getName(), command); "});
            return null;
        }
    }

    private void flushCommandLoader(boolean bl) throws IOException {
        this.writeLines(new String[]{"        if( BuildConstants.DEBUG && commandMap.size() > 0 ) { ", "            Iterator it = commandMap.keySet().iterator();", "            while( it.hasNext() ) {", "                System.out.println(\"Did not initialize resources for \" + it.next() );", "            }", "        }", "        WmiCommand.setAutoRegister( true );", "        return " + bl + ";", "    }", ""});
    }

    private void writeMenuPreamble(int n) throws IOException {
        this.writeLines(new String[]{"    public void buildMenu( JMenu menu ) {", "        buildMenu" + n + "( menu );", "    }", ""});
    }

    private void flushMenu() throws IOException {
        this.writer.write(separator);
    }

    private void writeResourceLoader(WmiResourcePackage wmiResourcePackage, WmiResourcePackage wmiResourcePackage2, String string) throws IOException {
        if ((string = string.trim()).length() > 0) {
            this.writeLines(new String[]{"        command = (WmiCommand) commandMap.get(\"" + string + "\");", "         register = true;", "        if( command == null ) { ", "            command = WmiCommand.getCommandProxy(\"" + string + "\");", "             register = false;", "         }"});
            this.writeln("        if( command != null ) {");
            this.setIndent("            ");
            this.writeSetResources(wmiResourcePackage, wmiResourcePackage2, string);
            this.setIndent("");
            this.writeLines(new String[]{"            if( register ) {", "                WmiCommand.registerCommand( command );", "                if( BuildConstants.DEBUG ) {", "                    commandMap.remove(\"" + string + "\");", "                }", "            }", "        } else {", "            if( BuildConstants.DEBUG ) {", "                 System.out.println( \"Failed to load " + string + "\");", "            }", "        }"});
        }
    }

    private void writeSetResources(WmiResourcePackage wmiResourcePackage, WmiResourcePackage wmiResourcePackage2, String string) throws IOException {
        String string2 = wmiResourcePackage.getStringForKey(string + ".proxy");
        if (string2 != null) {
            string = string2;
            wmiResourcePackage = wmiResourcePackage2;
        }
        String[] stringArray = new String[13];
        stringArray[0] = this.getResource(wmiResourcePackage, string, ".menuitem");
        stringArray[1] = this.getResource(wmiResourcePackage, string, ".tooltip");
        stringArray[2] = this.getResource(wmiResourcePackage, string, ".icon");
        stringArray[3] = this.getResource(wmiResourcePackage, string, ".accel");
        stringArray[4] = this.getResource(wmiResourcePackage, string, ".button");
        stringArray[5] = this.getResource(wmiResourcePackage, string, ".undo");
        stringArray[6] = this.getResource(wmiResourcePackage, string, ".edit");
        stringArray[7] = this.getResource(wmiResourcePackage, string, ".lock");
        stringArray[8] = this.getResource(wmiResourcePackage, string, ".background");
        stringArray[11] = this.getResource(wmiResourcePackage, string, ".toolbar");
        stringArray[12] = this.getResource(wmiResourcePackage, string, ".inputlock");
        String string3 = this.getResource(wmiResourcePackage, string, "documentType");
        string3 = string3 == null ? "default" : string3.trim();
        stringArray[9] = string3;
        this.writeLines(new String[]{"command.setResources( new String[] {"});
        for (int i = 0; i < 13; ++i) {
            this.writer.write(this.indent);
            if (stringArray[i] != null) {
                this.writer.write("    \"");
                this.writer.write(this.encode(stringArray[i].trim()));
                this.writer.write("\"");
            } else {
                this.writer.write("     null");
            }
            if (i < 12) {
                this.writer.write(",");
            } else {
                this.writer.write("}");
            }
            this.writer.write(separator);
        }
        this.writeLines(new String[]{");"});
    }

    private void flush() throws IOException {
        this.writer.write("}");
        this.writer.write(separator);
        this.writer.close();
    }

    private String getResource(WmiResourcePackage wmiResourcePackage, String string, String string2) {
        return wmiResourcePackage.getStringForKey(string + string2);
    }

    private static void debugIndent(int n) {
        for (int i = 0; i < 4 * n; ++i) {
            System.out.print(' ');
        }
    }

    private String encode(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string != null) {
            int n = string.length();
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                if (c > '\u007f') {
                    stringBuffer.append(this.toUnicode(c));
                    continue;
                }
                stringBuffer.append(c);
            }
        }
        return stringBuffer.toString();
    }

    private String toUnicode(char c) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\\u");
        if (c <= '\u0fff') {
            stringBuffer.append("0");
        }
        if (c <= '\u00ff') {
            stringBuffer.append("0");
        }
        stringBuffer.append(Integer.toHexString(c));
        return stringBuffer.toString();
    }

    static /* synthetic */ int access$108() {
        return menuCounter++;
    }

    static /* synthetic */ int access$708() {
        return itemCounter++;
    }

    static {
        $assertionsDisabled = !WmiCommandLoader.class.desiredAssertionStatus();
        separator = System.getProperty("line.separator");
        menuCounter = 0;
        itemCounter = 0;
    }

    public class ItemBuilder
    implements Builder {
        private String name;
        private String altName;
        private String mapleCommand;
        private String helpTopic;
        private char mnemonic;
        private String key;
        private String tooltip;
        private String accelerator;
        private int itemID = WmiCommandLoader.access$708();

        public ItemBuilder(String string, WmiResourcePackage wmiResourcePackage, WmiResourcePackage wmiResourcePackage2) {
            this.key = string;
            String string2 = wmiResourcePackage.getStringForKey(string + ".proxy");
            if (string2 != null) {
                this.key = string = string2;
                wmiResourcePackage = wmiResourcePackage2;
            }
            this.name = wmiResourcePackage.getStringForKey(string + ".menuitem");
            if (this.name == null) {
                this.name = string;
                int n = string.lastIndexOf(46);
                if (n >= 0) {
                    this.name = string.substring(n + 1);
                }
            }
            String string3 = WmiComponentUtil.getMnemonic(this.name);
            this.name = StringTools.removeTilde(this.name);
            if (string3 != null && string3.length() == 1) {
                this.mnemonic = string3.charAt(0);
            }
            this.altName = wmiResourcePackage.getStringForKey(string + ".altText");
            this.mapleCommand = wmiResourcePackage.getStringForKey(string + ".command");
            this.helpTopic = wmiResourcePackage.getStringForKey(string + ".topic");
            String string4 = wmiResourcePackage.getStringForKey(string + ".proxy");
            if (string4 != null) {
                this.key = string4;
            }
            this.tooltip = WmiCommandLoader.this.getResource(wmiResourcePackage, string, ".tooltip");
            this.accelerator = WmiCommandLoader.this.getResource(wmiResourcePackage, string, ".accel");
        }

        public void debugPrint(int n) {
            WmiCommandLoader.debugIndent(n);
            System.out.print(this.name + " ");
            if (this.mnemonic != '\u0000') {
                System.out.print("(" + this.mnemonic + ")");
            }
            System.out.println("  [" + this.key + "]");
        }

        public void write() throws IOException {
            if (this.mapleCommand != null) {
                WmiCommandLoader.this.writeLines(new String[]{"    private JMenuItem buildItem" + this.itemID + "( JMenu menu ) {", "        JMenuItem item = null;", "        WmiCommand command = new com.maplesoft.worksheet.controller.tools.WmiWorksheetToolsCommandWrapper(\"" + this.key + "\", \"" + this.mapleCommand + "\");", "         if( command != null ) {"});
            } else if (this.helpTopic != null) {
                WmiCommandLoader.this.writeLines(new String[]{"    private JMenuItem buildItem" + this.itemID + "( JMenu menu ) {", "        JMenuItem item = null;", "        WmiCommand command = new com.maplesoft.worksheet.controller.help.WmiWorksheetHelpQueryCommand( \"" + this.key + "\" ) {", "\t\t\tprotected String getTopicName() {", "\t\t\t\treturn \"" + this.helpTopic + "\";", "\t\t\t}", "\t\t\tprotected String getResourcePath() {", "\t\t\t\treturn com.maplesoft.worksheet.controller.tools.WmiWorksheetToolsCommand.RESOURCES;", "\t\t\t}", "\t\t };", "        if ( command != null ) {"});
            } else {
                WmiCommandLoader.this.writeLines(new String[]{"    private JMenuItem buildItem" + this.itemID + "( JMenu menu ) {", "        JMenuItem item = null;", "        WmiCommand command = WmiCommand.getCommandProxy(\"" + this.key + "\");", "         if( command != null ) {"});
            }
            if (this.altName != null) {
                WmiCommandLoader.this.writeln("             item = command.createMenuItem(\"" + WmiCommandLoader.this.encode(this.name) + "\", \"" + WmiCommandLoader.this.encode(this.altName) + "\");");
            } else {
                WmiCommandLoader.this.writeln("             item = command.createMenuItem(\"" + WmiCommandLoader.this.encode(this.name) + "\");");
            }
            WmiCommandLoader.this.writeln("             item.addActionListener( command );");
            if (this.tooltip != null) {
                WmiCommandLoader.this.writeln("             item.setToolTipText(\"" + WmiCommandLoader.this.encode(this.tooltip) + "\");");
            }
            if (this.mnemonic != '\u0000') {
                WmiCommandLoader.this.writeln("             item.setMnemonic('" + this.mnemonic + "');");
            }
            if (this.accelerator != null) {
                WmiCommandLoader.this.writeln("             item.setAccelerator( KeyStroke.getKeyStroke(\"" + this.accelerator + "\") );");
            }
            WmiCommandLoader.this.writeLines(new String[]{"             command.addMenuListeners( menu, item );", "         }", "        return item;", "    }", ""});
        }
    }

    public class MenuSeparatorBuilder
    implements Builder {
        public void debugPrint(int n) {
            WmiCommandLoader.debugIndent(n);
            System.out.println("[separator]");
        }

        public void write() throws IOException {
        }
    }

    public class CustomMenuBuilder
    implements Builder {
        private String command = null;
        private String name = null;

        public CustomMenuBuilder(String string, WmiResourcePackage wmiResourcePackage, WmiResourcePackage wmiResourcePackage2) {
            String string2 = wmiResourcePackage.getStringForKey(string + ".proxy");
            if (string2 != null) {
                string = string2;
                wmiResourcePackage = wmiResourcePackage2;
            }
            this.name = wmiResourcePackage.getStringForKey(string + ".menuitem");
            if (this.name == null) {
                this.name = string;
                int n = string.lastIndexOf(46);
                if (n >= 0) {
                    this.name = string.substring(n + 1);
                }
            }
            this.command = wmiResourcePackage.getStringForKey(string + WmiCommandLoader.MENU_LOADING_CUSTOM);
        }

        public void debugPrint(int n) {
            WmiCommandLoader.debugIndent(n);
            System.out.println(this.command);
        }

        public String getCommand() {
            return this.command;
        }

        public String getName() {
            return this.name;
        }

        public void write() throws IOException {
        }
    }

    public class MenuBuilder
    implements Builder {
        private String name;
        private char mnemonic;
        private int menuID = WmiCommandLoader.access$108();
        ArrayList contents = new ArrayList();

        public MenuBuilder(String string, WmiResourcePackage wmiResourcePackage, WmiResourcePackage wmiResourcePackage2) {
            String string2 = string;
            String string3 = wmiResourcePackage.getStringForKey(string + ".proxy");
            if (string3 != null) {
                string2 = string = string3;
                wmiResourcePackage = wmiResourcePackage2;
            }
            this.name = wmiResourcePackage.getStringForKey(string + ".menuitem");
            if (this.name == null) {
                this.name = string;
                int n = string.lastIndexOf(46);
                if (n >= 0) {
                    this.name = string.substring(n + 1);
                }
            }
            String string4 = wmiResourcePackage.getStringForKey(string + ".menu");
            String string5 = WmiComponentUtil.getMnemonic(this.name);
            this.name = StringTools.removeTilde(this.name);
            if (string5 != null && string5.length() == 1) {
                this.mnemonic = string5.charAt(0);
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string4);
            while (stringTokenizer.hasMoreTokens()) {
                String string6 = stringTokenizer.nextToken();
                if (string6.equals("-")) {
                    this.contents.add(new MenuSeparatorBuilder());
                    continue;
                }
                String string7 = string2 + "." + string6;
                String string8 = wmiResourcePackage.getStringForKey(string7 + WmiCommandLoader.MENU_LOADING_CUSTOM);
                String string9 = wmiResourcePackage.getStringForKey(string7 + ".menu");
                if (string8 != null) {
                    this.contents.add(new CustomMenuBuilder(string7, wmiResourcePackage, wmiResourcePackage2));
                    continue;
                }
                if (string9 != null) {
                    this.contents.add(new MenuBuilder(string7, wmiResourcePackage, wmiResourcePackage2));
                    continue;
                }
                this.contents.add(new ItemBuilder(string7, wmiResourcePackage, wmiResourcePackage2));
            }
        }

        public void debugPrint(int n) {
            WmiCommandLoader.debugIndent(n);
            System.out.print(this.name + " ");
            if (this.mnemonic != '\u0000') {
                System.out.print("(" + this.mnemonic + ")");
            }
            System.out.println();
            int n2 = this.contents.size();
            for (int i = 0; i < n2; ++i) {
                Object e = this.contents.get(i);
                if (!(e instanceof Builder)) continue;
                ((Builder)e).debugPrint(n + 1);
            }
        }

        public void write() throws IOException {
            Object e;
            int n;
            WmiCommandLoader.this.writeLines(new String[]{"    private void buildMenu" + this.menuID + "(final JMenu menu) {", "        menu.setText(\"" + WmiCommandLoader.this.encode(this.name) + "\");"});
            if (this.mnemonic != '\u0000') {
                WmiCommandLoader.this.writeln("        menu.setMnemonic('" + this.mnemonic + "');");
            }
            WmiCommandLoader.this.writeLines(new String[]{"        final MenuListener cml = new MenuListener() {", "            public void menuCanceled(MenuEvent e) {}", "            public void menuDeselected(MenuEvent e) {}", "            public void menuSelected(MenuEvent e) {", "                JMenuItem childItem = null;", "                JMenu childMenu = null;"});
            int n2 = this.contents.size();
            for (n = 0; n < n2; ++n) {
                e = this.contents.get(n);
                if (e instanceof CustomMenuBuilder) {
                    String string = WmiCommandLoader.this.encode(((CustomMenuBuilder)e).getName());
                    WmiCommandLoader.this.writeLines(new String[]{"                   childMenu = new JMenu();", "                   childMenu.setText(\"" + string + "\");", "                   " + ((CustomMenuBuilder)e).getCommand() + "( childMenu );", "                   menu.add( childMenu );"});
                    continue;
                }
                if (e instanceof MenuBuilder) {
                    WmiCommandLoader.this.writeLines(new String[]{"                   childMenu = new JMenu();", "                   buildMenu" + ((MenuBuilder)e).menuID + "( childMenu );", "                   menu.add( childMenu );"});
                    continue;
                }
                if (e instanceof MenuSeparatorBuilder) {
                    WmiCommandLoader.this.writeln("        menu.addSeparator();");
                    continue;
                }
                if (!(e instanceof ItemBuilder)) continue;
                WmiCommandLoader.this.writeLines(new String[]{"                   childItem = buildItem" + ((ItemBuilder)e).itemID + "( menu );", "                   if( childItem != null ) {", "                       menu.add( childItem );", "                   }"});
            }
            WmiCommandLoader.this.writeLines(new String[]{"                menu.removeMenuListener(this);", "            }", "        };", "        menu.addMenuListener(cml);", "    }", ""});
            for (n = 0; n < n2; ++n) {
                e = this.contents.get(n);
                if (e instanceof MenuBuilder) {
                    ((MenuBuilder)e).write();
                    continue;
                }
                if (!(e instanceof ItemBuilder)) continue;
                ((ItemBuilder)e).write();
            }
        }
    }

    public static interface Builder {
        public void debugPrint(int var1);

        public void write() throws IOException;
    }
}

