/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.controller;

import com.maplesoft.mathdoc.components.WmiComboBox;
import com.maplesoft.mathdoc.components.WmiComponentUtil;
import com.maplesoft.mathdoc.components.WmiToolBar;
import com.maplesoft.mathdoc.components.WmiToolBarButton;
import com.maplesoft.mathdoc.controller.WmiCommandProxy;
import com.maplesoft.mathdoc.controller.WmiDocumentType;
import com.maplesoft.mathdoc.controller.WmiMenuItem;
import com.maplesoft.mathdoc.controller.WmiNormalMenuItem;
import com.maplesoft.mathdoc.controller.WmiSwitchingMenuItem;
import com.maplesoft.mathdoc.controller.WmiTaskMonitor;
import com.maplesoft.mathdoc.controller.WmiToggleMenuItem;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiInputLock;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.platform.WmiComboBoxUIFactory;
import com.maplesoft.mathdoc.util.WmiResourcePackage;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiView;
import com.maplesoft.util.ResourceLoader;
import com.maplesoft.util.RuntimeLocale;
import com.maplesoft.util.RuntimePlatform;
import com.maplesoft.util.StringTools;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public abstract class WmiCommand
extends AbstractAction {
    public static final int NORMAL = 0;
    public static final int TOGGLE = 1;
    public static final int MULTI_OPTION = 2;
    public static final int SWITCHING = 3;
    public static final int ICON_SIZE_NONE = 0;
    public static final int ICON_SIZE_SMALL = 1;
    public static final int ICON_SIZE_LARGE = 2;
    public static final int MENU_ITEM_KEY = 0;
    public static final int TOOLTIP_KEY = 1;
    public static final int ICON_KEY = 2;
    public static final int ACCELERATOR_KEY = 3;
    public static final int BUTTON_TEXT_KEY = 4;
    public static final int UNDO_KEY = 5;
    public static final int EDIT_KEY = 6;
    public static final int LOCK_KEY = 7;
    public static final int BACKGROUND_KEY = 8;
    public static final int DOCUMENT_KEY = 9;
    public static final int ALT_TEXT_KEY = 10;
    public static final int TOOLBAR_ITEM_KEY = 11;
    public static final int INPUT_LOCK_KEY = 12;
    public static final int RESOURCE_KEY_COUNT = 13;
    public static final String MENU_KEY_STRING = ".menu";
    public static final String MENU_MODEL_KEY_STRING = ".model";
    public static final String MENU_ITEM_KEY_STRING = ".menuitem";
    public static final String TOOLTIP_KEY_STRING = ".tooltip";
    public static final String ICON_KEY_STRING = ".icon";
    public static final String ACCELERATOR_KEY_STRING = ".accel";
    public static final String PRIORITY_KEY_STRING = ".priority";
    public static final String BUTTON_TEXT_KEY_STRING = ".button";
    public static final String UNDO_KEY_STRING = ".undo";
    public static final String EDIT_KEY_STRING = ".edit";
    public static final String LOCK_KEY_STRING = ".lock";
    public static final String INPUT_LOCK_KEY_STRING = ".inputlock";
    public static final String BACKGROUND_KEY_STRING = ".background";
    public static final String PROXY_KEY_STRING = ".proxy";
    public static final String FULLY_QUALIFIED_PROXY_KEY_STRING = ".fullyQualifiedProxy";
    public static final String DOCUMENT_TYPE_TAG = "documentType";
    public static final String ALT_TEXT_STRING = ".altText";
    public static final String TOOLBAR_ITEM_KEY_STRING = ".toolbar";
    public static final String RESOURCE_PACKAGE_KEY = "package";
    public static final String RESOURCE_CLASSES_KEY = "classes";
    private static final String LOCK_VALUE_WRITE = "WRITE";
    private static final String LOCK_VALUE_READ = "READ";
    private static final String LOCK_VALUE_NONE = "NONE";
    private static final String PROP_VALUE_TRUE = "TRUE";
    private static final String PROP_VALUE_FALSE = "FALSE";
    private static final String DEFAULT_COMBO_CONTENTS = "<No Items>";
    private static WmiDocumentType defaultDocType = null;
    private static HashMap commandMap = new HashMap();
    private static HashMap keyMap = new HashMap();
    private static boolean menuTipsEnabled = false;
    private static boolean autoRegister = true;
    private String name = null;
    private WmiResourcePackage bundle = null;
    private Integer modelLockType = null;
    private Boolean inputLockType = null;
    private Boolean backgroundCommand = null;
    private ArrayList queueableCommandList;
    private ArrayList buttonList;
    private String[] resourceValue = null;
    private boolean[] resourceLoadNeeded = null;
    private Icon[] icons = null;
    private int iconSize = 0;

    protected WmiCommand(String string, boolean bl, boolean bl2, WmiResourcePackage wmiResourcePackage) {
        boolean bl3;
        this.bundle = wmiResourcePackage;
        boolean bl4 = bl3 = string != null && bl2;
        if (bl3 && commandMap.containsKey(string) && !bl) {
            bl3 = false;
        }
        this.name = string;
        if (autoRegister && bl3) {
            WmiCommand.registerCommand(this);
        }
        this.queueableCommandList = new ArrayList();
        this.buttonList = new ArrayList();
    }

    protected WmiCommand(String string, boolean bl, boolean bl2) {
        this(string, bl, bl2, null);
    }

    protected WmiCommand(String string, boolean bl) {
        this(string, bl, true);
    }

    protected WmiCommand(String string) {
        this(string, false);
    }

    public static WmiCommandProxy getCommandProxy(String string) {
        return WmiCommand.getCommandProxy(string, WmiMathDocumentView.getActiveDocumentView());
    }

    public static WmiCommandProxy getCommandProxy(String string, WmiMathDocumentView wmiMathDocumentView) {
        WmiDocumentType wmiDocumentType = wmiMathDocumentView == null ? WmiCommand.getDefaultDocumentType() : wmiMathDocumentView.getDocumentType();
        String string2 = wmiDocumentType.getDocumentType();
        while (string2 != null) {
            List list;
            Object v = commandMap.get(string2);
            if (v != null && (list = (List)((HashMap)v).get(string)) != null) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    WmiCommandProxy wmiCommandProxy = (WmiCommandProxy)iterator.next();
                    if (wmiCommandProxy == null || !wmiCommandProxy.shouldConsumeEvent() && !wmiCommandProxy.isEnabled(wmiMathDocumentView)) continue;
                    return wmiCommandProxy;
                }
            }
            string2 = wmiDocumentType.getDocumentTagAfter(string2);
        }
        return null;
    }

    public static WmiCommandProxy getCommand(String string) {
        return WmiCommand.getCommandProxy(string);
    }

    public static WmiCommand getCommandInstance(String string) {
        WmiCommandProxy wmiCommandProxy = WmiCommand.getCommandProxy(string);
        if (wmiCommandProxy != null) {
            return wmiCommandProxy.getInstance();
        }
        return null;
    }

    protected static boolean isAutoRegisterEnabled() {
        return autoRegister;
    }

    public static WmiCommandProxy getCommandProxy(KeyEvent keyEvent) {
        WmiMathDocumentView wmiMathDocumentView = WmiMathDocumentView.getActiveDocumentView();
        WmiShortcutCombination wmiShortcutCombination = new WmiShortcutCombination(keyEvent.getKeyChar(), keyEvent.getKeyCode(), keyEvent.getModifiersEx());
        String string = wmiMathDocumentView.getDocumentType().getDocumentType();
        while (string != null) {
            Object v = keyMap.get(string);
            if (v instanceof HashMap) {
                Object object;
                List list = (List)((HashMap)v).get(wmiShortcutCombination);
                if (list == null) {
                    object = new WmiShortcutCombination('\uffff', keyEvent.getKeyCode(), keyEvent.getModifiersEx());
                    list = (List)((HashMap)v).get(object);
                }
                if (list != null) {
                    object = list.iterator();
                    while (object.hasNext()) {
                        WmiCommandProxy wmiCommandProxy = (WmiCommandProxy)object.next();
                        if (wmiCommandProxy == null || !wmiCommandProxy.shouldConsumeEvent() && !wmiCommandProxy.isEnabled(wmiMathDocumentView)) continue;
                        wmiCommandProxy.getPriority();
                        return wmiCommandProxy;
                    }
                }
            }
            string = wmiMathDocumentView.getDocumentType().getDocumentTagAfter(string);
        }
        return null;
    }

    public static WmiCommandProxy getCommand(KeyEvent keyEvent) {
        return WmiCommand.getCommandProxy(keyEvent);
    }

    public static WmiMathDocumentView getDocumentView(ActionEvent actionEvent) {
        WmiMathDocumentView wmiMathDocumentView = null;
        WmiView wmiView = WmiCommand.getView(actionEvent);
        if (wmiView != null) {
            wmiMathDocumentView = wmiView.getDocumentView();
        }
        return wmiMathDocumentView;
    }

    public static void setDefaultDocumentType(WmiDocumentType wmiDocumentType) {
        defaultDocType = wmiDocumentType;
    }

    public static WmiDocumentType getDefaultDocumentType() {
        if (defaultDocType == null) {
            defaultDocType = new WmiDocumentType();
        }
        return defaultDocType;
    }

    public static WmiView getView(ActionEvent actionEvent) {
        Object object;
        WmiView wmiView = null;
        if (actionEvent != null && (object = actionEvent.getSource()) instanceof WmiView) {
            wmiView = (WmiView)object;
        }
        return wmiView;
    }

    public static void getViews(ActionEvent actionEvent, Collection collection) {
        if (actionEvent != null && collection != null) {
            Object object = actionEvent.getSource();
            if (object instanceof WmiView) {
                collection.add(object);
            } else if (object instanceof Collection) {
                Iterator iterator = ((Collection)object).iterator();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    if (!(e instanceof WmiView)) continue;
                    collection.add(e);
                }
            }
        }
    }

    public static void invokeCommand(String string) {
        WmiCommandProxy wmiCommandProxy = WmiCommand.getCommandProxy(string);
        if (wmiCommandProxy != null) {
            ActionEvent actionEvent = new ActionEvent(wmiCommandProxy, 0, string);
            wmiCommandProxy.actionPerformed(actionEvent);
        }
    }

    public static void registerCommand(WmiCommand wmiCommand) {
        WmiCommandProxy wmiCommandProxy = WmiCommandProxy.getProxyForCommand(wmiCommand);
        WmiCommand.registerCommand(wmiCommandProxy);
    }

    public static void registerCommand(WmiCommandProxy wmiCommandProxy) {
        Object object;
        String string = wmiCommandProxy.getDocumentTypeTag();
        Object object2 = commandMap.get(string);
        if (object2 == null) {
            object2 = new HashMap();
            commandMap.put(wmiCommandProxy.getDocumentTypeTag(), object2);
        }
        if (object2 instanceof HashMap) {
            int n;
            object = ((HashMap)object2).get(wmiCommandProxy.getName());
            if (object == null) {
                object = new LinkedList();
                ((HashMap)object2).put(wmiCommandProxy.getName(), object);
            }
            List list = (List)object;
            for (n = 0; n < list.size() && ((WmiCommandProxy)list.get(n)).getPriority() > wmiCommandProxy.getPriority(); ++n) {
            }
            list.add(n, wmiCommandProxy);
        }
        if ((object = wmiCommandProxy.getKeyBindings()) != null) {
            for (int i = 0; i < ((KeyStroke[])object).length; ++i) {
                KeyStroke keyStroke = object[i];
                if (keyStroke == null) continue;
                int n = keyStroke.getModifiers();
                wmiCommandProxy.registerKeyBinding(string, new WmiShortcutCombination(keyStroke.getKeyChar(), keyStroke.getKeyCode(), n));
                int n2 = n | wmiCommandProxy.getIgnorableModifier();
                if (n2 == n) continue;
                wmiCommandProxy.registerKeyBinding(string, new WmiShortcutCombination(keyStroke.getKeyChar(), keyStroke.getKeyCode(), n2));
            }
        }
    }

    public static void loadCommandPackage(String string) {
        Class[] classArray = ResourceLoader.getClasses(string, WmiCommand.class);
        for (int i = 0; i < classArray.length; ++i) {
            if (Modifier.isAbstract(classArray[i].getModifiers())) continue;
            try {
                classArray[i].newInstance();
                continue;
            }
            catch (InstantiationException instantiationException) {
                instantiationException.printStackTrace();
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
        }
    }

    public static void setMenuTipsEnabled(boolean bl) {
        menuTipsEnabled = bl;
    }

    public static boolean getMenuTipsEnabled() {
        return menuTipsEnabled;
    }

    public static void setAutoRegister(boolean bl) {
        autoRegister = bl;
    }

    public final String getName() {
        return this.name;
    }

    public String getDocumentTypeTag() {
        return this.getResource(9);
    }

    public int getType() {
        return 0;
    }

    public final void setEnabled(boolean bl) {
        for (int i = 0; i < this.buttonList.size(); ++i) {
            AbstractButton abstractButton = (AbstractButton)this.buttonList.get(i);
            abstractButton.setEnabled(bl);
        }
        super.setEnabled(bl);
    }

    public boolean isBackgroundTask() {
        if (this.backgroundCommand == null) {
            boolean bl = false;
            String string = this.getResource(8);
            if (string != null && string.toUpperCase().indexOf(PROP_VALUE_TRUE) >= 0) {
                bl = true;
            }
            this.backgroundCommand = new Boolean(bl);
        }
        return this.backgroundCommand;
    }

    public boolean isUpdateCommand() {
        return false;
    }

    public boolean isSelected() {
        return false;
    }

    public boolean isSelected(WmiMathDocumentView wmiMathDocumentView) {
        return this.isSelected();
    }

    public boolean waitsForInputLock() {
        if (this.inputLockType == null) {
            boolean bl = true;
            String string = this.getResource(12);
            if (string != null && string.equalsIgnoreCase(Boolean.FALSE.toString())) {
                bl = false;
            }
            this.inputLockType = bl;
        }
        return this.inputLockType;
    }

    public int lockTypeRequired() {
        if (this.modelLockType == null) {
            int n = 0;
            String string = this.getResource(7);
            if (string != null) {
                if (string.toUpperCase().indexOf(LOCK_VALUE_WRITE) >= 0) {
                    n = 1;
                } else if (string.toUpperCase().indexOf(LOCK_VALUE_NONE) >= 0) {
                    n = -1;
                }
            }
            this.modelLockType = new Integer(n);
        }
        return this.modelLockType;
    }

    public final boolean isEnabled() {
        boolean bl = true;
        WmiMathDocumentView wmiMathDocumentView = WmiMathDocumentView.getActiveDocumentView();
        if (wmiMathDocumentView != null) {
            bl = this.isEnabled(wmiMathDocumentView);
        }
        return bl;
    }

    public boolean isInputEnabled() {
        WmiInputLock wmiInputLock;
        boolean bl = true;
        WmiMathDocumentView wmiMathDocumentView = WmiMathDocumentView.getActiveDocumentView();
        if (wmiMathDocumentView != null && (wmiInputLock = wmiMathDocumentView.getInputLock()) != null) {
            bl = !wmiInputLock.isLocked();
        }
        return bl;
    }

    public abstract boolean isEnabled(WmiView var1);

    public boolean shouldConsumeEvent() {
        return true;
    }

    public JMenuItem createMenuItem() {
        JMenuItem jMenuItem = null;
        String string = null;
        String string2 = this.getResource(0);
        String string3 = this.getResource(1);
        String string4 = null;
        if (this.getType() == 3) {
            string4 = this.getResource(10);
        }
        if (string2 != null) {
            string = WmiComponentUtil.getMnemonic(string2);
            string2 = StringTools.removeTilde(string2);
        }
        jMenuItem = this.createMenuItem(string2, string4);
        if (string3 != null) {
            jMenuItem.setToolTipText(string3);
        }
        jMenuItem.addActionListener(this);
        KeyStroke[] keyStrokeArray = this.getKeyBindings();
        if (keyStrokeArray != null) {
            jMenuItem.setAccelerator(keyStrokeArray[0]);
        }
        if (string != null && string.length() == 1) {
            jMenuItem.setMnemonic(string.charAt(0));
        }
        return jMenuItem;
    }

    public JMenuItem createMenuItem(String string) {
        return this.createMenuItem(string, null);
    }

    public JMenuItem createMenuItem(String string, String string2) {
        JMenuItem jMenuItem = null;
        switch (this.getType()) {
            case 0: {
                jMenuItem = new WmiNormalMenuItem(string, this);
                break;
            }
            case 1: {
                jMenuItem = new WmiToggleMenuItem(string);
                break;
            }
            case 3: {
                if (string2 != null) {
                    jMenuItem = new WmiSwitchingMenuItem(string, string2);
                    break;
                }
                jMenuItem = new WmiSwitchingMenuItem(string, string);
                break;
            }
        }
        if (jMenuItem != null && RuntimePlatform.isWindows() && RuntimeLocale.isSimplifiedChinese()) {
            Font font = jMenuItem.getFont();
            jMenuItem.setFont(font.deriveFont(12.0f));
        }
        return jMenuItem;
    }

    public JMenuItem createMenuItem(JMenu jMenu) {
        return this.createMenuItem(jMenu, -1);
    }

    public void addMenuListeners(JMenu jMenu, JMenuItem jMenuItem) {
        jMenuItem.setEnabled(this.isEnabled());
        switch (this.getType()) {
            case 0: {
                jMenu.addMenuListener(new WmiMenuActivateListener(jMenuItem));
                break;
            }
            case 1: {
                jMenu.addMenuListener(new WmiToggleMenuActivateListener(jMenuItem));
                jMenuItem.setSelected(this.isSelected());
                break;
            }
            case 3: {
                if (!(jMenuItem instanceof WmiSwitchingMenuItem)) break;
                WmiSwitchingItemActivateListener wmiSwitchingItemActivateListener = new WmiSwitchingItemActivateListener((WmiSwitchingMenuItem)jMenuItem);
                jMenu.addMenuListener(wmiSwitchingItemActivateListener);
                jMenuItem.setText(wmiSwitchingItemActivateListener.getItemText());
                break;
            }
        }
        if (jMenuItem instanceof WmiMenuItem) {
            ((WmiMenuItem)((Object)jMenuItem)).setContainingMenu(jMenu);
        }
    }

    public final JMenuItem createMenuItem(JMenu jMenu, int n) {
        JMenuItem jMenuItem = this.createMenuItem();
        if (n < 0) {
            jMenu.add(jMenuItem);
        } else {
            jMenu.insert(jMenuItem, n);
        }
        this.addMenuListeners(jMenu, jMenuItem);
        return jMenuItem;
    }

    public AbstractButton createButton(int n) {
        return this.createButton(n, 24);
    }

    public AbstractButton createButton(int n, int n2) {
        WmiToolBarButton wmiToolBarButton = null;
        if (this.iconSize == n && this.icons != null) {
            wmiToolBarButton = new WmiToolBarButton(this.icons);
        } else {
            String string = this.getResource(2);
            if (string != null) {
                wmiToolBarButton = new WmiToolBarButton(n, n2, string, this.getResourceDirectory());
                this.icons = new Icon[2];
                this.icons[0] = wmiToolBarButton.getIcon();
                this.icons[1] = wmiToolBarButton.getDisabledIcon();
                this.iconSize = n;
            } else {
                String string2 = this.getResource(4);
                if (string2 != null) {
                    int n3 = string2.indexOf(126);
                    string2 = string2.replaceFirst("~", "");
                    wmiToolBarButton = new WmiToolBarButton();
                    wmiToolBarButton.setText(string2);
                    if (n3 >= 0 && n3 < string2.length()) {
                        wmiToolBarButton.setMnemonic(string2.charAt(n3));
                    }
                }
            }
        }
        if (wmiToolBarButton != null) {
            wmiToolBarButton.setEnabled(this.isEnabled());
            wmiToolBarButton.setToolTipText(this.getResource(1));
            wmiToolBarButton.addActionListener(this);
            this.buttonList.add(wmiToolBarButton);
        }
        return wmiToolBarButton;
    }

    public final AbstractButton createSpeedbarButton(int n, int n2) {
        WmiToolBarButton wmiToolBarButton = null;
        if (this.iconSize == n && this.icons != null) {
            wmiToolBarButton = new WmiToolBarButton(this.icons);
        } else {
            String string = this.getResource(2);
            if (string != null) {
                wmiToolBarButton = new WmiToolBarButton(n, n2, string, this.getResourceDirectory());
                this.icons = new Icon[2];
                this.icons[0] = wmiToolBarButton.getIcon();
                this.icons[1] = wmiToolBarButton.getDisabledIcon();
                this.iconSize = n;
            } else {
                return this.createButton(n, n2);
            }
        }
        if (wmiToolBarButton != null) {
            wmiToolBarButton.setEnabled(true);
            wmiToolBarButton.setToolTipText(this.getResource(1));
            wmiToolBarButton.addActionListener(this);
            this.buttonList.add(wmiToolBarButton);
        }
        return wmiToolBarButton;
    }

    public final AbstractButton createButton(int n, JToolBar jToolBar) {
        int n2 = jToolBar instanceof WmiToolBar ? ((WmiToolBar)jToolBar).getPreferredButtonIconSize() : 24;
        AbstractButton abstractButton = this.createSpeedbarButton(n, n2);
        if (abstractButton != null && jToolBar != null) {
            jToolBar.add(abstractButton);
        }
        return abstractButton;
    }

    public final void detachButton(AbstractButton abstractButton) {
        this.buttonList.remove(abstractButton);
    }

    protected final KeyStroke[] getKeyBindings() {
        KeyStroke[] keyStrokeArray = null;
        String string = this.getResource(3);
        if (string != null) {
            String[] stringArray = string.split("\\s*,\\s*");
            keyStrokeArray = new KeyStroke[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                keyStrokeArray[i] = KeyStroke.getKeyStroke(stringArray[i]);
            }
        }
        return keyStrokeArray;
    }

    protected int getIgnorableModifier() {
        return 0;
    }

    public final void registerKeyBinding(String string, WmiShortcutCombination wmiShortcutCombination) {
        Object object = keyMap.get(string);
        if (object == null) {
            object = new HashMap();
            keyMap.put(this.getDocumentTypeTag(), object);
        }
        if (object instanceof HashMap) {
            int n;
            Object object2 = ((HashMap)object).get(wmiShortcutCombination);
            if (object2 == null) {
                object2 = new LinkedList();
                ((HashMap)object).put(wmiShortcutCombination, object2);
            }
            List list = (List)object2;
            for (n = 0; n < list.size() && ((WmiCommand)list.get(n)).getPriority() > this.getPriority(); ++n) {
            }
            WmiCommandProxy wmiCommandProxy = WmiCommandProxy.getProxyForCommand(this);
            list.add(n, wmiCommandProxy);
        }
    }

    public final int getPriority() {
        int n = 0;
        String string = this.getResource(this.name + PRIORITY_KEY_STRING);
        if (string != null) {
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n;
    }

    public final WmiComboBox createComboBox(WmiModel wmiModel) {
        WmiComboBox wmiComboBox = null;
        if (this.getType() == 2) {
            wmiComboBox = new WmiComboBox(this);
            wmiComboBox.setUI(WmiComboBoxUIFactory.createUI(1));
            Font font = wmiComboBox.getFont();
            wmiComboBox.setFont(font.deriveFont(10.0f));
            this.reloadComboBox(wmiComboBox, wmiModel);
            wmiComboBox.setToolTipText(this.getResource(1));
        }
        return wmiComboBox;
    }

    public final WmiComboBox createComboBox(WmiView wmiView) {
        return this.createComboBox(wmiView.getModel());
    }

    public final WmiComboBox createComboBox() {
        return this.createComboBox((WmiModel)null);
    }

    public final void reloadComboBox(WmiComboBox wmiComboBox, WmiModel wmiModel) {
        if (wmiComboBox != null) {
            boolean bl = wmiComboBox.isIgnoreSelectionChange();
            wmiComboBox.setIgnoreSelectionChange(true);
            wmiComboBox.removeAllItems();
            this.comboBoxItemLoader(wmiComboBox, wmiModel);
            wmiComboBox.setIgnoreSelectionChange(bl);
        }
    }

    public void comboBoxItemLoader(WmiComboBox wmiComboBox, WmiModel wmiModel) {
        if (wmiComboBox != null) {
            wmiComboBox.removeAllItems();
            wmiComboBox.addItem(DEFAULT_COMBO_CONTENTS);
        }
    }

    public void updateComboBoxSelection(WmiComboBox wmiComboBox, WmiModel wmiModel) {
    }

    public void updateComboBoxSelection(WmiComboBox wmiComboBox, WmiView wmiView) {
        if (wmiView != null) {
            this.updateComboBoxSelection(wmiComboBox, wmiView.getModel());
        }
    }

    protected abstract String getResourcePath();

    public final String getResourceDirectory() {
        String string = '/' + this.getResourcePath().replace('.', '/');
        int n = string.lastIndexOf(47);
        if (n > 0) {
            string = string.substring(0, n);
        }
        return string;
    }

    private WmiResourcePackage getResourceBundle() {
        if (this.bundle == null) {
            String string = this.getResourcePath();
            this.bundle = WmiResourcePackage.getResourcePackage(string);
        }
        return this.bundle;
    }

    public final String getResource(String string) {
        WmiResourcePackage wmiResourcePackage = this.getResourceBundle();
        return wmiResourcePackage.getStringForKey(string);
    }

    public final String getResource(int n) {
        String string = null;
        if (this.resourceValue == null) {
            this.resourceValue = new String[13];
            this.resourceLoadNeeded = new boolean[13];
            for (int i = 0; i < 13; ++i) {
                this.resourceLoadNeeded[i] = true;
            }
        } else {
            string = this.resourceValue[n];
        }
        if (this.resourceLoadNeeded[n]) {
            String string2 = null;
            switch (n) {
                case 0: {
                    string2 = MENU_ITEM_KEY_STRING;
                    break;
                }
                case 11: {
                    string2 = TOOLBAR_ITEM_KEY_STRING;
                    break;
                }
                case 1: {
                    string2 = TOOLTIP_KEY_STRING;
                    break;
                }
                case 2: {
                    string2 = ICON_KEY_STRING;
                    break;
                }
                case 3: {
                    string2 = ACCELERATOR_KEY_STRING + WmiResourcePackage.getPlatformSuffix();
                    break;
                }
                case 4: {
                    string2 = BUTTON_TEXT_KEY_STRING;
                    break;
                }
                case 5: {
                    string2 = UNDO_KEY_STRING;
                    break;
                }
                case 6: {
                    string2 = EDIT_KEY_STRING;
                    break;
                }
                case 7: {
                    string2 = LOCK_KEY_STRING;
                    break;
                }
                case 12: {
                    string2 = INPUT_LOCK_KEY_STRING;
                    break;
                }
                case 8: {
                    string2 = BACKGROUND_KEY_STRING;
                    break;
                }
                case 9: {
                    string = this.getResource(DOCUMENT_TYPE_TAG);
                    if (string == null) {
                        string = "default";
                        break;
                    }
                    string = string.trim();
                    break;
                }
                case 10: {
                    string2 = ALT_TEXT_STRING;
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            if (n != 9) {
                string = this.getResource(this.name + string2);
            }
            this.resourceValue[n] = string;
            this.resourceLoadNeeded[n] = false;
        }
        return string;
    }

    public final void setResources(String[] stringArray) {
        this.resourceValue = stringArray;
        this.resourceLoadNeeded = new boolean[13];
    }

    public final void setResource(int n, String string) {
        if (this.resourceValue == null) {
            this.getResource(n);
        }
        this.resourceValue[n] = string;
        this.resourceLoadNeeded[n] = false;
    }

    protected final boolean checkEnabledForEvent(Object object) {
        boolean bl = false;
        if (object instanceof Collection) {
            Collection collection = (Collection)object;
            try {
                WmiView[] wmiViewArray = new WmiView[collection.size()];
                wmiViewArray = collection.toArray(wmiViewArray);
                for (int i = 0; !bl && i < wmiViewArray.length; ++i) {
                    bl = this.isEnabled(wmiViewArray[i]);
                }
            }
            catch (ArrayStoreException arrayStoreException) {}
        } else {
            bl = object instanceof WmiView ? this.isEnabled((WmiView)object) : this.isEnabled(WmiMathDocumentView.getActiveDocumentView());
        }
        if (bl && this.waitsForInputLock()) {
            bl = this.isInputEnabled();
        }
        return bl;
    }

    public final void actionPerformed(ActionEvent actionEvent) {
        if (this.checkEnabledForEvent(actionEvent.getSource())) {
            WmiTaskMonitor.getInstance().executeCommand(this, actionEvent);
        }
    }

    public abstract void doCommand(ActionEvent var1) throws WmiNoReadAccessException, WmiNoWriteAccessException;

    public final WmiModel getModel(ActionEvent actionEvent) {
        WmiView wmiView = (WmiView)actionEvent.getSource();
        WmiModel wmiModel = wmiView.getModel();
        return wmiModel;
    }

    public static void registerCommands(WmiResourcePackage wmiResourcePackage) {
        try {
            wmiResourcePackage.instantiateClasses();
        }
        catch (Exception exception) {
            WmiErrorLog.log(exception);
        }
    }

    protected final void addQueueableCommand(String string) {
        if (!this.queueableCommandList.contains(string)) {
            this.queueableCommandList.add(string);
        }
    }

    protected final void removeQueueableCommand(String string) {
        this.queueableCommandList.remove(string);
    }

    public boolean canQueue(String string) {
        return this.queueableCommandList.contains(string);
    }

    public static class WmiShortcutCombination {
        private static final int RELEVANT_MODIFIERS = 960;
        private char shortcutChar;
        private int shortcutCode;
        private int shortcutModifiers;

        public WmiShortcutCombination(char c, int n, int n2) {
            this.shortcutChar = c;
            this.shortcutCode = n;
            this.shortcutModifiers = 0x3C0 & n2;
            if (RuntimePlatform.isMac() && c == '\u007f') {
                this.shortcutChar = (char)65535;
            } else if (c != '\uffff') {
                this.shortcutCode = 0;
            }
        }

        public boolean equals(Object object) {
            boolean bl = false;
            if (object instanceof WmiShortcutCombination) {
                WmiShortcutCombination wmiShortcutCombination = (WmiShortcutCombination)object;
                bl = this.shortcutChar != '\uffff' && wmiShortcutCombination.shortcutChar != '\uffff' ? this.shortcutChar == wmiShortcutCombination.shortcutChar : this.shortcutCode == wmiShortcutCombination.shortcutCode;
                bl &= this.shortcutModifiers == wmiShortcutCombination.shortcutModifiers;
            }
            return bl;
        }

        public int hashCode() {
            int n = this.shortcutChar;
            n ^= this.shortcutCode;
            return n ^= this.shortcutModifiers;
        }
    }

    protected class WmiSwitchingItemActivateListener
    implements MenuListener {
        private WmiSwitchingMenuItem theItem = null;

        public WmiSwitchingItemActivateListener(WmiSwitchingMenuItem wmiSwitchingMenuItem) {
            this.theItem = wmiSwitchingMenuItem;
        }

        public String getItemText() {
            return WmiCommand.this.isSelected() ? this.theItem.getSelectedItemText() : this.theItem.getUnselectedItemText();
        }

        public void menuCanceled(MenuEvent menuEvent) {
            if (this.theItem.isVisible()) {
                this.theItem.setEnabled(WmiCommand.this.checkEnabledForEvent(menuEvent.getSource()) && WmiCommand.this.isInputEnabled());
                this.theItem.setText(this.getItemText());
            }
        }

        public void menuDeselected(MenuEvent menuEvent) {
            if (this.theItem.isVisible()) {
                this.theItem.setEnabled(WmiCommand.this.checkEnabledForEvent(menuEvent.getSource()) && WmiCommand.this.isInputEnabled());
                this.theItem.setText(this.getItemText());
            }
        }

        public void menuSelected(MenuEvent menuEvent) {
            if (this.theItem.isVisible()) {
                this.theItem.setEnabled(WmiCommand.this.checkEnabledForEvent(menuEvent.getSource()) && WmiCommand.this.isInputEnabled());
                this.theItem.setText(this.getItemText());
            }
        }
    }

    protected class WmiToggleMenuActivateListener
    extends WmiMenuActivateListener
    implements MenuListener {
        protected WmiToggleMenuActivateListener(JMenuItem jMenuItem) {
            super(jMenuItem);
        }

        public void menuCanceled(MenuEvent menuEvent) {
            super.menuCanceled(menuEvent);
            if (this.item.isVisible()) {
                this.item.setSelected(WmiCommand.this.isSelected());
            }
        }

        public void menuDeselected(MenuEvent menuEvent) {
            super.menuDeselected(menuEvent);
            if (this.item.isVisible()) {
                this.item.setSelected(WmiCommand.this.isSelected());
            }
        }

        public void menuSelected(MenuEvent menuEvent) {
            super.menuSelected(menuEvent);
            if (this.item.isVisible()) {
                this.item.setSelected(WmiCommand.this.isSelected());
            }
        }
    }

    protected class WmiMenuActivateListener
    implements MenuListener {
        protected JMenuItem item;

        protected WmiMenuActivateListener(JMenuItem jMenuItem) {
            this.item = jMenuItem;
        }

        public void menuCanceled(MenuEvent menuEvent) {
            if (this.item.isVisible()) {
                this.item.setEnabled(WmiCommand.this.checkEnabledForEvent(menuEvent.getSource()) && WmiCommand.this.isInputEnabled());
            }
        }

        public void menuDeselected(MenuEvent menuEvent) {
            if (this.item.isVisible()) {
                this.item.setEnabled(WmiCommand.this.checkEnabledForEvent(menuEvent.getSource()) && WmiCommand.this.isInputEnabled());
            }
        }

        public void menuSelected(MenuEvent menuEvent) {
            if (this.item.isVisible()) {
                this.item.setEnabled(WmiCommand.this.checkEnabledForEvent(menuEvent.getSource()) && WmiCommand.this.isInputEnabled());
            }
        }
    }
}

