/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.controller;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelLock;
import com.maplesoft.mathdoc.util.WmiResourcePackage;
import com.maplesoft.mathdoc.view.WmiCaret;
import com.maplesoft.mathdoc.view.WmiHighlightPainter;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiPositionMarker;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiSelection;
import com.maplesoft.mathdoc.view.WmiViewPosition;
import com.maplesoft.mathdoc.view.WmiViewUtil;
import com.maplesoft.mathdoc.view.math.WmiMathCaret;
import com.maplesoft.util.ResourceLoader;
import com.maplesoft.util.RuntimePlatform;
import com.sun.media.jai.codec.MemoryCacheSeekableStream;
import java.awt.AlphaComposite;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.FlavorMap;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetContext;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.media.jai.JAI;
import javax.media.jai.RenderedOp;

public class WmiClipboardManager {
    private static final Point DRAG_IMAGE_OFFSET = new Point(5, 5);
    private static final FlavorMap DEFAULT_FLAVOR_MAP = new MathDocumentFlavorMap();
    private static final String MAC_NO_DROP_CURSOR_RESOURCE = "com/maplesoft/mathdoc/controller/edit/resources/mac_no_drop.tiff";
    private static Cursor MAC_NO_DROP = null;
    private static final String RESOURCE_PATH = "com/maplesoft/mathdoc/controller/edit/resources/Edit";
    private WmiResourcePackage bundle = WmiResourcePackage.getResourcePackage("com/maplesoft/mathdoc/controller/edit/resources/Edit");
    private static WmiMathDocumentView dragDoc = null;
    private static WmiPositionMarker dropLocation = null;
    private static boolean forceCopy = false;
    private static boolean isDragAndDropOperation = false;
    private DragSource dragSource = null;
    private DropTarget dropTarget = null;
    private DragGestureListener dragListener = null;
    DropTargetListener dropListener = null;
    DragGestureRecognizer dragGestureRecognizer = null;
    private boolean dragArmed = false;
    protected WmiMathDocumentView docView;

    private static Cursor createMacNoDropCursor() {
        Cursor cursor = null;
        if (RuntimePlatform.isMac()) {
            try {
                InputStream inputStream = ResourceLoader.getResourceAsStream(MAC_NO_DROP_CURSOR_RESOURCE);
                MemoryCacheSeekableStream memoryCacheSeekableStream = new MemoryCacheSeekableStream(inputStream);
                RenderedOp renderedOp = JAI.create((String)"stream", (Object)memoryCacheSeekableStream);
                BufferedImage bufferedImage = new BufferedImage(renderedOp.getWidth(), renderedOp.getHeight(), 2);
                Graphics2D graphics2D = bufferedImage.createGraphics();
                graphics2D.drawRenderedImage((RenderedImage)renderedOp, new AffineTransform());
                graphics2D.dispose();
                cursor = Toolkit.getDefaultToolkit().createCustomCursor(bufferedImage, new Point(4, 4), "no drop");
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                cursor = Cursor.getDefaultCursor();
            }
            catch (Throwable throwable) {
                cursor = Cursor.getDefaultCursor();
            }
        }
        return cursor;
    }

    public WmiClipboardManager(WmiMathDocumentView wmiMathDocumentView) {
        this.docView = wmiMathDocumentView;
        if (!GraphicsEnvironment.isHeadless()) {
            this.dragSource = this.createDragSource();
            this.dropTarget = this.createDropTarget();
        }
    }

    public void release() {
        if (this.dragSource != null) {
            DragSourceListener[] dragSourceListenerArray = this.dragSource.getDragSourceListeners();
            if (dragSourceListenerArray != null) {
                for (int i = 0; i < dragSourceListenerArray.length; ++i) {
                    this.dragSource.removeDragSourceListener(dragSourceListenerArray[i]);
                }
            }
            this.dragSource = null;
        }
        this.dragListener = null;
        if (this.dragGestureRecognizer != null) {
            this.dragGestureRecognizer.setComponent(null);
            this.dragGestureRecognizer = null;
        }
        if (this.dropTarget != null) {
            this.dropTarget.removeDropTargetListener(this.dropListener);
            this.dropTarget.setComponent(null);
            this.dropTarget = null;
            this.dropListener = null;
        }
        this.docView = null;
    }

    public Transferable createTransferable(boolean bl) {
        Transferable transferable = null;
        if (this.docView != null) {
            WmiSelection wmiSelection = this.docView.getSelection();
            WmiPositionMarker wmiPositionMarker = this.docView.getPositionMarker();
            transferable = this.createTransferable(wmiSelection, wmiPositionMarker, bl);
        }
        return transferable;
    }

    protected Transferable createTransferable(WmiSelection wmiSelection, WmiPositionMarker wmiPositionMarker, boolean bl) {
        Transferable transferable = null;
        return transferable;
    }

    public boolean paste() {
        boolean bl = false;
        if (this.docView != null) {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            Transferable transferable = clipboard.getContents(null);
            bl = this.paste(transferable);
        }
        return bl;
    }

    public boolean paste(Transferable transferable) {
        boolean bl = false;
        return bl;
    }

    protected boolean processDragOver(DropTargetDragEvent dropTargetDragEvent) {
        return false;
    }

    public void armDragAndDrop(boolean bl) {
        this.dragArmed = bl;
    }

    public boolean isEnabled() {
        return this.dragArmed;
    }

    public DragSource createDragSource() {
        this.dragListener = new MathDocumentDragListener();
        DragSource dragSource = DragSource.getDefaultDragSource();
        this.dragGestureRecognizer = dragSource.createDefaultDragGestureRecognizer(this.docView, 3, this.dragListener);
        return dragSource;
    }

    public DropTarget createDropTarget() {
        this.dropListener = new MathDocumentDropListener();
        DropTarget dropTarget = new DropTarget(this.docView, 3, this.dropListener, true, null);
        return dropTarget;
    }

    public FlavorMap getFlavorMap() {
        return DEFAULT_FLAVOR_MAP;
    }

    protected int determineOrdering(WmiPositionMarker wmiPositionMarker, WmiSelection wmiSelection) {
        WmiHighlightPainter wmiHighlightPainter;
        int n = 0;
        WmiHighlightPainter wmiHighlightPainter2 = wmiHighlightPainter = wmiSelection != null ? wmiSelection.getSelectionHighlighter() : null;
        if (wmiHighlightPainter != null) {
            Rectangle rectangle = wmiHighlightPainter.getBounds();
            Rectangle rectangle2 = wmiPositionMarker.getBounds();
            int n2 = rectangle2.x + rectangle2.width / 2;
            if (wmiPositionMarker instanceof WmiMathCaret) {
                WmiMathCaret wmiMathCaret = (WmiMathCaret)wmiPositionMarker;
                n2 = wmiMathCaret.getUprightBottom();
            }
            int n3 = rectangle2.y + rectangle2.height / 2;
            int n4 = wmiHighlightPainter.getLeftBoundary(n3);
            int n5 = wmiHighlightPainter.getRightBoundary(n3);
            n = n4 > n2 ? -1 : (n5 < n2 && n5 >= 0 ? 1 : (n4 < 0 || n5 < 0 ? (n3 < rectangle.y ? -1 : 1) : 0));
        }
        return n;
    }

    protected void handleFileListDrop(DropTargetDropEvent dropTargetDropEvent) {
    }

    public boolean isActiveDragAndDrop() {
        return isDragAndDropOperation;
    }

    public static Cursor getMoveCursor() {
        return DragSource.DefaultMoveDrop;
    }

    public static Cursor getCopyCursor() {
        return DragSource.DefaultCopyDrop;
    }

    public static Cursor getNoDropCursor() {
        Cursor cursor = DragSource.DefaultMoveNoDrop;
        if (RuntimePlatform.isMac()) {
            if (MAC_NO_DROP == null) {
                MAC_NO_DROP = WmiClipboardManager.createMacNoDropCursor();
            }
            cursor = MAC_NO_DROP;
        }
        return cursor;
    }

    public class MathDocumentDropListener
    implements DropTargetListener {
        protected WmiPositionMarker marker = null;

        protected boolean acceptOrRejectDrag(DropTargetDragEvent dropTargetDragEvent) {
            boolean bl = false;
            if (this.canGrabFocus()) {
                if (dropTargetDragEvent.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    bl = true;
                } else {
                    Point point = dropTargetDragEvent.getLocation();
                    bl = this.acceptOrRejectDrag(point);
                }
            }
            return bl;
        }

        protected boolean canGrabFocus() {
            Container container = WmiClipboardManager.this.docView;
            while (!(container instanceof Window)) {
                container = container.getParent();
            }
            return container.isDisplayable() && container.isFocusable() && container.isEnabled();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean acceptOrRejectDrag(Point point) {
            boolean bl = false;
            boolean bl2 = false;
            if (this.canGrabFocus()) {
                WmiMathDocumentModel wmiMathDocumentModel = (WmiMathDocumentModel)WmiClipboardManager.this.docView.getModel();
                try {
                    if (!WmiModelLock.ownsWriteLock(wmiMathDocumentModel)) {
                        bl2 = WmiModelLock.readLock(wmiMathDocumentModel, true);
                    }
                    if (!wmiMathDocumentModel.isReadOnly()) {
                        this.updateMarkerPosition(point);
                        if (this.marker != null) {
                            WmiModel wmiModel;
                            WmiPositionedView wmiPositionedView = this.marker.getView();
                            WmiSelection wmiSelection = WmiClipboardManager.this.docView.getSelection();
                            WmiModel wmiModel2 = wmiModel = wmiPositionedView != null ? wmiPositionedView.getModel() : null;
                            if (wmiMathDocumentModel.isMutableModel(wmiModel)) {
                                bl = true;
                            }
                        }
                    }
                }
                catch (WmiNoReadAccessException wmiNoReadAccessException) {
                    WmiErrorLog.log(wmiNoReadAccessException);
                }
                finally {
                    if (bl2) {
                        WmiModelLock.readUnlock(wmiMathDocumentModel);
                    }
                }
            }
            return bl;
        }

        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
            int n;
            DropTargetContext dropTargetContext = dropTargetDragEvent.getDropTargetContext();
            int n2 = n = forceCopy ? 1 : 3;
            if (this.acceptOrRejectDrag(dropTargetDragEvent)) {
                dropTargetDragEvent.acceptDrag(n);
                WmiClipboardManager.this.docView.setCursor(WmiClipboardManager.getMoveCursor());
            } else {
                dropTargetDragEvent.rejectDrag();
                WmiClipboardManager.this.docView.setCursor(WmiClipboardManager.getNoDropCursor());
            }
        }

        public void dragExit(DropTargetEvent dropTargetEvent) {
            DropTargetContext dropTargetContext = dropTargetEvent.getDropTargetContext();
            WmiClipboardManager.this.docView.setCursor(Cursor.getDefaultCursor());
        }

        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
            if (this.acceptOrRejectDrag(dropTargetDragEvent)) {
                int n = dropTargetDragEvent.getDropAction();
                if (dragDoc != WmiClipboardManager.this.docView || forceCopy) {
                    n = 1;
                }
                if (!WmiClipboardManager.this.processDragOver(dropTargetDragEvent)) {
                    DropTargetContext dropTargetContext = dropTargetDragEvent.getDropTargetContext();
                    Cursor cursor = null;
                    switch (n) {
                        case 2: 
                        case 3: {
                            cursor = WmiClipboardManager.getMoveCursor();
                            break;
                        }
                        case 1: {
                            cursor = WmiClipboardManager.getCopyCursor();
                            break;
                        }
                        default: {
                            cursor = Cursor.getDefaultCursor();
                        }
                    }
                    WmiClipboardManager.this.docView.setCursor(cursor);
                    dropTargetDragEvent.acceptDrag(n);
                }
            } else {
                DropTargetContext dropTargetContext = dropTargetDragEvent.getDropTargetContext();
                Cursor cursor = WmiClipboardManager.getNoDropCursor();
                WmiClipboardManager.this.docView.setCursor(cursor);
                dropTargetDragEvent.rejectDrag();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            dropLocation = null;
            Transferable transferable = dropTargetDropEvent.getTransferable();
            if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                dropTargetDropEvent.acceptDrop(3);
                WmiClipboardManager.this.handleFileListDrop(dropTargetDropEvent);
            } else if (this.acceptOrRejectDrag(dropTargetDropEvent.getLocation())) {
                int n = dropTargetDropEvent.getDropAction();
                if (forceCopy) {
                    n = 1;
                }
                dropTargetDropEvent.acceptDrop(n);
                if (n != 1 && dragDoc == WmiClipboardManager.this.docView) {
                    this.updateMarkerPosition(dropTargetDropEvent.getLocation());
                    dropLocation = this.marker;
                    boolean bl = this.dropMove(transferable, dropLocation);
                    dropTargetDropEvent.dropComplete(bl);
                } else {
                    boolean bl = false;
                    if (transferable != null && this.marker != null) {
                        WmiModel wmiModel = WmiClipboardManager.this.docView.getModel();
                        try {
                            WmiModelLock.writeLock(wmiModel, true);
                            WmiClipboardManager.this.docView.setSelection(null);
                            this.updateMarkerPosition(dropTargetDropEvent.getLocation());
                            bl = WmiClipboardManager.this.paste(transferable);
                        }
                        catch (Exception exception) {
                            WmiErrorLog.log(exception);
                        }
                        finally {
                            WmiModelLock.writeUnlock(wmiModel);
                        }
                        dropTargetDropEvent.dropComplete(bl);
                    }
                }
                WmiClipboardManager.this.docView.setCursor(Cursor.getDefaultCursor());
            }
            dragDoc = null;
            forceCopy = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean dropMove(Transferable transferable, WmiPositionMarker wmiPositionMarker) {
            boolean bl = false;
            WmiMathDocumentModel wmiMathDocumentModel = (WmiMathDocumentModel)WmiClipboardManager.this.docView.getModel();
            WmiSelection wmiSelection = WmiClipboardManager.this.docView.getSelection();
            int n = WmiClipboardManager.this.determineOrdering(wmiPositionMarker, wmiSelection);
            try {
                WmiModelLock.writeLock(wmiMathDocumentModel, true);
                String string = WmiClipboardManager.this.bundle.getStringForKey("edit.dragndrop.undo");
                wmiMathDocumentModel.startUndoableEdit(string);
                boolean bl2 = WmiClipboardManager.this.docView.getPositionMarker() instanceof WmiCaret;
                if (!bl2 || n > 0) {
                    WmiClipboardManager.this.docView.setSelection(null);
                    WmiClipboardManager.this.docView.setPositionMarker(wmiPositionMarker);
                    bl = WmiClipboardManager.this.paste(transferable);
                    if (wmiSelection != null && bl) {
                        wmiSelection.deleteSelection();
                    }
                } else if (n < 0) {
                    WmiPositionedView wmiPositionedView = wmiPositionMarker.getView();
                    int n2 = wmiPositionMarker.getOffset();
                    if (wmiSelection != null) {
                        wmiSelection.deleteSelection();
                    }
                    WmiClipboardManager.this.docView.setSelection(null);
                    wmiPositionedView.setPositionMarker(n2);
                    bl = WmiClipboardManager.this.paste(transferable);
                }
                wmiMathDocumentModel.update(null);
                wmiMathDocumentModel.endUndoableEdit();
            }
            catch (Exception exception) {
                WmiErrorLog.log(exception);
                bl = false;
            }
            finally {
                WmiModelLock.writeUnlock(wmiMathDocumentModel);
            }
            return bl;
        }

        public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void updateMarkerPosition(Point point) {
            WmiViewPosition wmiViewPosition = WmiViewUtil.findNearestView(WmiClipboardManager.this.docView, point);
            if (wmiViewPosition != null) {
                WmiPositionedView wmiPositionedView = wmiViewPosition.getView();
                int n = wmiViewPosition.getOffset();
                WmiModel wmiModel = wmiPositionedView.getModel();
                try {
                    this.marker = WmiClipboardManager.this.docView.getPositionMarker();
                    if (this.marker != null) {
                        WmiClipboardManager.this.docView.repaint(this.marker.getBounds());
                    }
                    WmiModelLock.readLock(wmiModel, true);
                    wmiPositionedView.setPositionMarker(n);
                    this.marker = WmiClipboardManager.this.docView.getPositionMarker();
                    if (this.marker != null) {
                        Rectangle rectangle = this.marker.getBounds();
                        WmiClipboardManager.this.docView.repaint(rectangle);
                    }
                }
                finally {
                    WmiModelLock.readUnlock(wmiModel);
                }
            }
        }
    }

    protected class MathDocumentDragListener
    implements DragGestureListener,
    DragSourceListener {
        protected MathDocumentDragListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
            if (WmiClipboardManager.this.isEnabled()) {
                Object object;
                Transferable transferable = null;
                dropLocation = null;
                forceCopy = false;
                WmiModel wmiModel = WmiClipboardManager.this.docView.getModel();
                Cursor cursor = WmiClipboardManager.getMoveCursor();
                try {
                    WmiModelLock.readLock(wmiModel, true);
                    dragDoc = WmiClipboardManager.this.docView;
                    transferable = WmiClipboardManager.this.createTransferable(false);
                    object = WmiClipboardManager.this.docView.getSelection();
                    if (object != null && object.isReadOnly()) {
                        cursor = WmiClipboardManager.getCopyCursor();
                        forceCopy = true;
                    }
                }
                catch (WmiNoReadAccessException wmiNoReadAccessException) {
                    WmiErrorLog.log(wmiNoReadAccessException);
                }
                finally {
                    WmiModelLock.readUnlock(wmiModel);
                }
                if (transferable != null) {
                    isDragAndDropOperation = true;
                    if (DragSource.isDragImageSupported()) {
                        object = this.createDragImage();
                        dragGestureEvent.startDrag(RuntimePlatform.isWindows() ? null : cursor, (Image)object, DRAG_IMAGE_OFFSET, transferable, this);
                    } else {
                        dragGestureEvent.startDrag(RuntimePlatform.isWindows() ? null : cursor, transferable, this);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Image createDragImage() {
            BufferedImage bufferedImage = null;
            if (WmiClipboardManager.this.docView != null) {
                WmiSelection wmiSelection = WmiClipboardManager.this.docView.getSelection();
                WmiHighlightPainter wmiHighlightPainter = wmiSelection != null ? wmiSelection.getSelectionHighlighter() : null;
                Rectangle rectangle = wmiHighlightPainter != null ? wmiHighlightPainter.getBounds() : null;
                Rectangle rectangle2 = WmiClipboardManager.this.docView.getVisibleRegion();
                if (rectangle != null) {
                    int n = rectangle.width < rectangle2.width ? rectangle.width : rectangle2.width;
                    int n2 = rectangle.height < rectangle2.height ? rectangle.height : rectangle2.height;
                    bufferedImage = new BufferedImage(n, n2, 2);
                    Graphics2D graphics2D = (Graphics2D)((Image)bufferedImage).getGraphics();
                    graphics2D.setComposite(AlphaComposite.getInstance(3, 0.7f));
                    graphics2D.translate(-rectangle.x, -rectangle.y);
                    WmiClipboardManager.this.docView.setSelection(null);
                    WmiPositionMarker wmiPositionMarker = WmiClipboardManager.this.docView.getPositionMarker();
                    WmiModel wmiModel = WmiClipboardManager.this.docView.getModel();
                    try {
                        WmiModelLock.readLock(wmiModel, true);
                        WmiClipboardManager.this.docView.setPositionMarker(null);
                        WmiClipboardManager.this.docView.paint(graphics2D);
                        WmiClipboardManager.this.docView.setSelection(wmiSelection);
                        WmiClipboardManager.this.docView.setPositionMarker(wmiPositionMarker);
                    }
                    finally {
                        WmiModelLock.readUnlock(wmiModel);
                    }
                    graphics2D.dispose();
                }
            }
            return bufferedImage;
        }

        public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
        }

        public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
        }

        public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
        }

        public void dragExit(DragSourceEvent dragSourceEvent) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
            if (dragSourceDropEvent.getDropSuccess() && dragSourceDropEvent.getDropAction() != 1 && dragSourceDropEvent.getDropAction() != 0) {
                WmiSelection wmiSelection;
                if (dropLocation == null && (wmiSelection = WmiClipboardManager.this.docView.getSelection()) != null) {
                    wmiSelection.deleteSelection();
                }
            } else {
                WmiModel wmiModel = WmiClipboardManager.this.docView.getModel();
                try {
                    WmiModelLock.readLock(wmiModel, true);
                    WmiClipboardManager.this.docView.setSelection(null);
                }
                catch (Exception exception) {
                    WmiErrorLog.log(exception);
                }
                finally {
                    WmiModelLock.readUnlock(wmiModel);
                }
            }
            isDragAndDropOperation = false;
        }
    }

    protected static class MathDocumentFlavorMap
    implements FlavorMap {
        protected MathDocumentFlavorMap() {
        }

        public Map getFlavorsForNatives(String[] stringArray) {
            HashMap<String, DataFlavor> hashMap = new HashMap<String, DataFlavor>(2);
            DataFlavor dataFlavor = DataFlavor.stringFlavor;
            hashMap.put(dataFlavor.getMimeType(), dataFlavor);
            dataFlavor = DataFlavor.javaFileListFlavor;
            hashMap.put(dataFlavor.getMimeType(), dataFlavor);
            return hashMap;
        }

        public Map getNativesForFlavors(DataFlavor[] dataFlavorArray) {
            HashMap<DataFlavor, String> hashMap = new HashMap<DataFlavor, String>(2);
            DataFlavor dataFlavor = DataFlavor.stringFlavor;
            hashMap.put(DataFlavor.stringFlavor, dataFlavor.getMimeType());
            dataFlavor = DataFlavor.javaFileListFlavor;
            hashMap.put(DataFlavor.stringFlavor, dataFlavor.getMimeType());
            return hashMap;
        }
    }
}

