/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.components.palettes;

import com.maplesoft.mathdoc.components.WmiComponentUtil;
import com.maplesoft.mathdoc.components.dockingtools.WmiPaletteButtonFactory;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiModelLock;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

public class WmiMathMLPaletteButtonFactory
extends WmiPaletteButtonFactory {
    public WmiMathMLPaletteButtonFactory() {
        super(null);
    }

    public AbstractButton createButton(char c, boolean bl) {
        WmiPaletteButtonFactory.PaletteButton paletteButton = bl ? new TopLevelPaletteButton() : new WmiPaletteButtonFactory.PaletteButton();
        WmiMathMLPaletteButtonFactory.installFont(paletteButton, c);
        return paletteButton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractButton createButton(String string, boolean bl, int n, int n2) {
        WmiPaletteButtonFactory.PaletteButton paletteButton = bl ? new TopLevelPaletteButton() : new WmiPaletteButtonFactory.PaletteButton();
        if (string.startsWith("<mrow")) {
            try {
                WmiModelLock.writeLock(this.renderView.getModel(), true);
                int[] nArray = new int[1];
                Image image = this.renderMathML(string, this.renderView, nArray, false);
                paletteButton.setIcon(new ImageIcon(image));
                paletteButton.setBaseline(nArray[0]);
                paletteButton.setPreferredSize(new Dimension(n, n2));
            }
            catch (WmiNoReadAccessException wmiNoReadAccessException) {
                WmiErrorLog.log(wmiNoReadAccessException);
            }
            catch (WmiNoWriteAccessException wmiNoWriteAccessException) {
                WmiErrorLog.log(wmiNoWriteAccessException);
            }
            finally {
                WmiModelLock.writeUnlock(this.renderView.getModel());
            }
        }
        return paletteButton;
    }

    public AbstractButton createButton(String string, String string2, boolean bl, int n, int n2) {
        WmiPaletteButtonFactory.PaletteButton paletteButton = bl ? new TopLevelPaletteButton() : new WmiPaletteButtonFactory.PaletteButton();
        ImageIcon imageIcon = WmiComponentUtil.getImageIcon(string + string2);
        paletteButton.setIcon(imageIcon);
        if (n != 0 && n2 != 0) {
            paletteButton.setPreferredSize(new Dimension(n, n2));
        }
        return paletteButton;
    }

    public AbstractButton createButton(JComponent jComponent, boolean bl, int n, int n2) {
        WmiPaletteButtonFactory.PaletteButton paletteButton = bl ? new TopLevelPaletteButton() : new WmiPaletteButtonFactory.PaletteButton();
        Image image = this.renderComponent(jComponent);
        paletteButton.setIcon(new ImageIcon(image));
        paletteButton.setPreferredSize(new Dimension(n, n2));
        return paletteButton;
    }

    public static class TopLevelPaletteButton
    extends WmiPaletteButtonFactory.PaletteButton {
        public void paint(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Object object = graphics2D.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
            Object object2 = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            super.paint(graphics);
            Rectangle rectangle = this.getBounds();
            Polygon polygon = new Polygon();
            polygon.addPoint(rectangle.width - 11, rectangle.height - 10);
            polygon.addPoint(rectangle.width - 5, rectangle.height - 10);
            polygon.addPoint(rectangle.width - 8, rectangle.height - 5);
            graphics2D.setColor(Color.black);
            graphics2D.fill(polygon);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, object);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object2);
        }
    }
}

