/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.components.dockingtools;

import com.maplesoft.mathdoc.components.WmiComponentUtil;
import com.maplesoft.mathdoc.components.dockingtools.WmiDockException;
import com.maplesoft.mathdoc.components.dockingtools.WmiDockingHost;
import com.maplesoft.mathdoc.components.dockingtools.WmiItemConfigurationError;
import com.maplesoft.mathdoc.components.dockingtools.WmiPalette;
import com.maplesoft.mathdoc.components.dockingtools.WmiPaletteContentPanel;
import com.maplesoft.mathdoc.controller.view.palettes.WmiPaletteManager;
import com.maplesoft.mathdoc.util.WmiResourcePackage;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.MissingResourceException;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;

public class WmiConfigurablePalette
extends WmiPalette {
    public static final String ITEM_COUNT_PROPERTY = "items.count";
    public static final String PALETTE_TITLE_PROPERTY = "palette.title";
    public static final String PALETTE_ICON_PATH_PROPERTY = "palette.iconpath";
    public static final String PALETTE_INITIAL_EXPANDED_PROPERTY = "palette.initialexpanded";
    public static final String PALETTE_BORDER_COLOR_PROPERTY = "palette.border.color";
    public static final String PALETTE_TITLE_COLOR_PROPERTY = "palette.title.color";
    public static final String PALETTE_ICON_SIZE_PROPERTY = "palette.default.icon.size";
    public static final String PALETTE_HORIZ_TEXT_PROPERTY = "palette.item.text.position.horiz";
    public static final String PALETTE_VERT_TEXT_PROPERTY = "palette.item.text.position.vert";
    public static final String PALETTE_HIGHLIGHT_PROPERTY = "palette.item.highlight.enabled";
    public static final String PALETTE_ITEM_DEFAULT_PREFFERED_WIDTH_PROPERTY = "palette.item.preferred.width";
    public static final String PALETTE_ITEM_DEFAULT_PREFFERED_HEIGHT_PROPERTY = "palette.item.preferred.height";
    public static final String PALETTE_ITEM_DEFAULT_MAX_WIDTH_PROPERTY = "palette.item.max.width";
    public static final String PALETTE_ITEM_DEFAULT_MAX_HEIGHT_PROPERTY = "palette.item.max.height";
    public static final String PALETTE_ITEM_DEFAULT_MIN_WIDTH_PROPERTY = "palette.item.min.width";
    public static final String PALETTE_ITEM_DEFAULT_MIN_HEIGHT_PROPERTY = "palette.item.min.height";
    public static final String PALETTE_BUTTON_HIGHLIGHT_STYLE = "palette.item.highlight.style";
    public static final String PALETTE_BUTTON_UNHIGHLIGHT_STYLE = "palette.item.unhighlight.style";
    public static final String ITEM_BORDER_RAISED_VALUE = "raised";
    public static final String ITEM_BORDER_LOWERED_VALUE = "lowered";
    public static final String ITEM_BORDER_NONE_VALUE = "none";
    public static final String PALETTE_PREFERRED_ROWS_PROPERTY = "palette.rows";
    public static final String PALETTE_PREFERRED_COLS_PROPERTY = "palette.columns";
    public static final String PALETTE_ROW_PADDING = "palette.row.padding";
    public static final String PALETTE_COLUMN_PADDING = "palette.column.padding";
    public static final String PALETTE_ICON_SIZE_SMALL_VALUE = "small";
    public static final String PALETTE_ICON_SIZE_LARGE_VALUE = "large";
    public static final int MIN_ROWS = 3;
    public static final int MIN_COLS = 3;
    public static final int DEFAULT_ROW_PADDING = 2;
    public static final int DEFAULT_COLUMN_PADDING = 0;
    public static final String PALETTE_TEXT_RIGHT_VALUE = "right";
    public static final String PALETTE_TEXT_LEFT_VALUE = "left";
    public static final String PALETTE_TEXT_CENTER_VALUE = "center";
    public static final String PALETTE_TEXT_LEADING_VALUE = "leading";
    public static final String PALETTE_TEXT_TRAILING_VALUE = "trailing";
    public static final String PALETTE_TEXT_TOP_VALUE = "top";
    public static final String PALETTE_TEXT_BOTTOM_VALUE = "bottom";
    public static final String PALETTE_TEXT_NONE_VALUE = "none";
    public static final String PALETTE_FALSE_VALUE = "false";
    public static final int DEFAULT_LAYOUT_COLUMNS = 3;
    public static final int DEFAULT_LAYOUT_ROWS = 0;
    public static final int SIZE_SETTING_DISABLED = -1;
    public static final String PROPERTY_SEPARATOR = ".";
    public static final String JAR_FILE_PATH_SEPARATOR = "/";
    public static final String ITEM_TITLE_PROPERTY = "title";
    public static final String ITEM_SMALL_ICON_PROPERTY = "icon.small";
    public static final String ITEM_LARGE_ICON_PROPERTY = "icon.large";
    public static final String ITEM_TOOLTIP_PROPERTY = "tooltip";
    public static final String DEFAULT_ITEM_PREFIX = "button";
    public WmiPaletteManager paletteManager = null;
    protected String iconSize = null;
    protected String itemPrefix = "button";
    protected String iconPath = null;
    protected String textHorizPosition = "none";
    protected String textVertPosition = "none";
    protected int layoutColumns = 3;
    protected int layoutRows = 0;
    protected int rowPadding = 2;
    protected int columnPadding = 0;
    protected int paletteItemPreferredWidth = -1;
    protected int paletteItemPreferredHeight = -1;
    protected int paletteItemMaxWidth = -1;
    protected int paletteItemMaxHeight = -1;
    protected int paletteItemMinWidth = -1;
    protected int paletteItemMinHeight = -1;
    protected ActionControllerCaller actionCaller = new ActionControllerCaller();
    protected DragControllerCaller dragCaller = new DragControllerCaller();
    protected WmiDragController dragController = null;
    protected WmiActionController actionController = null;
    protected HashMap buttonToIndex = new HashMap();
    private boolean uniformContentItemSize = true;
    protected WmiResourcePackage configuration;
    protected boolean extendedPalette = false;
    private boolean isInitialized = true;

    public WmiConfigurablePalette(String string, WmiPaletteManager wmiPaletteManager) {
        this(string, string, wmiPaletteManager);
    }

    public WmiConfigurablePalette(String string, String string2, WmiPaletteManager wmiPaletteManager) {
        super(string, string2);
        this.paletteManager = wmiPaletteManager;
        this.buildLayout();
    }

    public WmiConfigurablePalette(String string, String string2, WmiPaletteManager wmiPaletteManager, boolean bl) {
        super(string, string2);
        this.paletteManager = wmiPaletteManager;
        this.extendedPalette = bl;
        this.buildLayout();
    }

    public void setExpanded(boolean bl, boolean bl2) {
        this.lazyInitializeIfNeeded(bl);
        super.setExpanded(bl, bl2);
    }

    public String getShortName() {
        String string = this.getResourceName();
        return string.substring(string.lastIndexOf(JAR_FILE_PATH_SEPARATOR) + 1);
    }

    protected void buildLayout() {
        this.configure();
    }

    protected boolean performLazyInitialize() {
        return false;
    }

    private void lazyInitializeIfNeeded(boolean bl) {
        if (bl && !this.isInitialized) {
            this.lazyInitialize();
        }
    }

    protected void lazyInitialize() {
        this.populateButtonPanel();
        this.getContent().doLayout();
        this.isInitialized = true;
    }

    public WmiResourcePackage getConfiguration() {
        if (this.configuration == null) {
            String string = this.getResourceName();
            string = this.paletteManager.getPalettePath() + string;
            this.configuration = WmiResourcePackage.getResourcePackage(string);
        }
        return this.configuration;
    }

    public void configure() throws WmiItemConfigurationError {
        this.getConfiguration();
        this.setTitle(this.configuration.getStringForKey(PALETTE_TITLE_PROPERTY));
        this.setIconPath(this.configuration.getStringForKey(PALETTE_ICON_PATH_PROPERTY));
        this.textHorizPosition = this.getOptionalProperty(this.configuration, PALETTE_HORIZ_TEXT_PROPERTY);
        this.textVertPosition = this.getOptionalProperty(this.configuration, PALETTE_VERT_TEXT_PROPERTY);
        this.textHorizPosition = this.textHorizPosition == null ? "none" : this.textHorizPosition;
        this.textVertPosition = this.textVertPosition == null ? "none" : this.textVertPosition;
        this.iconSize = this.getIconSize();
        this.paletteItemPreferredWidth = this.getOptionalIntegerProperty(this.configuration, PALETTE_ITEM_DEFAULT_PREFFERED_WIDTH_PROPERTY, -1);
        this.paletteItemPreferredHeight = this.getOptionalIntegerProperty(this.configuration, PALETTE_ITEM_DEFAULT_PREFFERED_HEIGHT_PROPERTY, -1);
        this.paletteItemMaxWidth = this.getOptionalIntegerProperty(this.configuration, PALETTE_ITEM_DEFAULT_MAX_WIDTH_PROPERTY, -1);
        this.paletteItemMaxHeight = this.getOptionalIntegerProperty(this.configuration, PALETTE_ITEM_DEFAULT_MAX_HEIGHT_PROPERTY, -1);
        this.paletteItemMinWidth = this.getOptionalIntegerProperty(this.configuration, PALETTE_ITEM_DEFAULT_MIN_WIDTH_PROPERTY, -1);
        this.paletteItemMinHeight = this.getOptionalIntegerProperty(this.configuration, PALETTE_ITEM_DEFAULT_MIN_HEIGHT_PROPERTY, -1);
        this.layoutRows = this.getOptionalIntegerProperty(this.configuration, PALETTE_PREFERRED_ROWS_PROPERTY, 0);
        this.layoutColumns = this.getOptionalIntegerProperty(this.configuration, PALETTE_PREFERRED_COLS_PROPERTY, 3);
        this.rowPadding = this.getOptionalIntegerProperty(this.configuration, PALETTE_ROW_PADDING, 2);
        this.columnPadding = this.getOptionalIntegerProperty(this.configuration, PALETTE_COLUMN_PADDING, 0);
        this.readColorConfiguration();
        JPanel jPanel = this.createContentPanel();
        this.setContent(jPanel);
        if (this.performLazyInitialize()) {
            this.isInitialized = false;
        } else {
            this.populateButtonPanel();
        }
        jPanel.doLayout();
        String string = this.getOptionalProperty(this.configuration, PALETTE_INITIAL_EXPANDED_PROPERTY);
        if (string != null && string.equals(PALETTE_FALSE_VALUE)) {
            this.setExpanded(false);
        }
    }

    protected JPanel createContentPanel() {
        return new WmiPaletteContentPanel(this, this.rowPadding, this.columnPadding, this.uniformContentItemSize);
    }

    protected void readColorConfiguration() {
        Color color;
        Color color2 = this.getColorProperty(PALETTE_BORDER_COLOR_PROPERTY);
        if (color2 != null) {
            this.setForeground(color2);
        }
        if ((color = this.getColorProperty(PALETTE_TITLE_COLOR_PROPERTY)) != null) {
            this.setTitleColor(color);
        }
    }

    protected Color getColorProperty(String string) {
        String[] stringArray;
        Color color = null;
        String string2 = this.getOptionalProperty(this.configuration, string);
        if (string2 != null && (stringArray = string2.split(" ")) != null && stringArray.length == 3) {
            int n = Integer.parseInt(stringArray[0]);
            int n2 = Integer.parseInt(stringArray[1]);
            int n3 = Integer.parseInt(stringArray[2]);
            color = new Color(n, n2, n3);
        }
        return color;
    }

    protected void populateButtonPanel() {
        int n = 0;
        try {
            n = Integer.parseInt(this.configuration.getStringForKey(ITEM_COUNT_PROPERTY));
        }
        catch (NumberFormatException numberFormatException) {
            String string = this.getResourceName();
            throw new WmiItemConfigurationError("No items for palette " + string, numberFormatException);
        }
        for (int i = 0; i < n; ++i) {
            this.addItem(this.getItemPrefix(), i, this.configuration);
        }
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public void setIconPath(String string) {
        this.iconPath = string;
        if (string != null && !string.endsWith(JAR_FILE_PATH_SEPARATOR)) {
            this.iconPath = this.iconPath + JAR_FILE_PATH_SEPARATOR;
        }
    }

    public String getIconSize() {
        if (this.iconSize == null) {
            this.iconSize = this.configuration.getStringForKey(PALETTE_ICON_SIZE_PROPERTY);
        }
        return this.iconSize;
    }

    public String getIconPath() {
        return this.iconPath;
    }

    public AbstractButton addItem(String string, int n, WmiResourcePackage wmiResourcePackage) throws WmiItemConfigurationError {
        return this.addItem(string, n, wmiResourcePackage, null);
    }

    public AbstractButton addItem(String string, WmiResourcePackage wmiResourcePackage) throws WmiItemConfigurationError {
        return this.addItem(string, wmiResourcePackage, null);
    }

    public AbstractButton addItem(String string, int n, WmiResourcePackage wmiResourcePackage, AbstractButton abstractButton) throws WmiItemConfigurationError {
        String string2 = string + n + PROPERTY_SEPARATOR;
        AbstractButton abstractButton2 = this.addItem(string2, wmiResourcePackage, abstractButton);
        this.buttonToIndex.put(abstractButton2, new Integer(n));
        return abstractButton2;
    }

    public AbstractButton addItem(String string, WmiResourcePackage wmiResourcePackage, AbstractButton abstractButton) throws WmiItemConfigurationError {
        try {
            String string2;
            String string3;
            AbstractButton abstractButton2;
            AbstractButton abstractButton3 = abstractButton2 = abstractButton != null ? abstractButton : new JButton();
            if (!this.textVertPosition.equals("none") && !this.textHorizPosition.equals("none")) {
                abstractButton2.setText(wmiResourcePackage.getStringForKey(string + ITEM_TITLE_PROPERTY));
                int n = this.getTextPosition(this.textHorizPosition);
                int n2 = this.getTextPosition(this.textVertPosition);
                abstractButton2.setHorizontalTextPosition(n);
                abstractButton2.setVerticalTextPosition(n2);
            }
            if (this.paletteItemPreferredWidth != -1 && this.paletteItemPreferredHeight != -1) {
                abstractButton2.setPreferredSize(new Dimension(this.paletteItemPreferredWidth, this.paletteItemPreferredHeight));
            }
            if (this.paletteItemMinWidth != -1 && this.paletteItemMinHeight != -1) {
                abstractButton2.setMinimumSize(new Dimension(this.paletteItemMinWidth, this.paletteItemMinHeight));
            }
            if (this.paletteItemMaxWidth != -1 && this.paletteItemMaxHeight != -1) {
                abstractButton2.setMaximumSize(new Dimension(this.paletteItemMaxWidth, this.paletteItemMaxHeight));
            }
            if (abstractButton2.getIcon() == null && (string3 = this.getOptionalProperty(wmiResourcePackage, string, ITEM_SMALL_ICON_PROPERTY)) != null) {
                ImageIcon imageIcon = WmiComponentUtil.getImageIcon(this.getIconPath() + string3);
                string3 = wmiResourcePackage.getStringForKey(string + ITEM_LARGE_ICON_PROPERTY);
                ImageIcon imageIcon2 = WmiComponentUtil.getImageIcon(this.getIconPath() + string3);
                if (this.iconSize.equals(PALETTE_ICON_SIZE_SMALL_VALUE)) {
                    abstractButton2.setIcon(imageIcon);
                } else {
                    abstractButton2.setIcon(imageIcon2);
                }
            }
            if ((string2 = this.getOptionalProperty(wmiResourcePackage, string, ITEM_TOOLTIP_PROPERTY)) != null) {
                abstractButton2.setToolTipText(string2);
            }
            abstractButton2.addActionListener(this.actionCaller);
            DragSource dragSource = DragSource.getDefaultDragSource();
            dragSource.createDefaultDragGestureRecognizer(abstractButton2, 1, this.dragCaller);
            this.getContent().add(abstractButton2);
            abstractButton2.setRequestFocusEnabled(false);
            abstractButton2.setFocusable(false);
            return abstractButton2;
        }
        catch (Exception exception) {
            String string4 = this.getResourceName();
            throw new WmiItemConfigurationError("Palette " + string4 + " Configuration Error at item " + string, exception);
        }
    }

    protected String getOptionalProperty(WmiResourcePackage wmiResourcePackage, String string, String string2) {
        return this.getOptionalProperty(wmiResourcePackage, string + string2);
    }

    protected String getOptionalProperty(WmiResourcePackage wmiResourcePackage, String string) {
        String string2 = null;
        try {
            string2 = wmiResourcePackage.getStringForKey(string);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return string2;
    }

    private int getOptionalIntegerProperty(WmiResourcePackage wmiResourcePackage, String string, int n) {
        int n2 = n;
        try {
            n2 = Integer.parseInt(wmiResourcePackage.getStringForKey(string));
        }
        catch (Exception exception) {
            n2 = n;
        }
        return n2;
    }

    private int getTextPosition(String string) {
        int n = 0;
        if (string.equals(PALETTE_TEXT_RIGHT_VALUE)) {
            n = 4;
        } else if (string.equals(PALETTE_TEXT_LEFT_VALUE)) {
            n = 2;
        } else if (string.equals(PALETTE_TEXT_CENTER_VALUE)) {
            n = 0;
        } else if (string.equals(PALETTE_TEXT_LEADING_VALUE)) {
            n = 10;
        } else if (string.equals(PALETTE_TEXT_TRAILING_VALUE)) {
            n = 11;
        } else if (string.equals(PALETTE_TEXT_TOP_VALUE)) {
            n = 1;
        } else if (string.equals(PALETTE_TEXT_BOTTOM_VALUE)) {
            n = 3;
        }
        return n;
    }

    public String getItemPrefix() {
        return this.itemPrefix;
    }

    public void dock(WmiDockingHost wmiDockingHost, int n) throws WmiDockException {
        this.lazyInitializeIfNeeded(this.isExpanded());
        super.dock(wmiDockingHost, n);
    }

    public void setDragController(WmiDragController wmiDragController) {
        this.dragController = wmiDragController;
    }

    public void setActionController(WmiActionController wmiActionController) {
        this.actionController = wmiActionController;
    }

    protected void setUniformContentItemSize(boolean bl) {
        this.uniformContentItemSize = bl;
        if (this.getContent() instanceof WmiPaletteContentPanel) {
            ((WmiPaletteContentPanel)this.getContent()).setUniformContentItemSize(bl);
        }
    }

    protected boolean getUniformContentItemSize() {
        return this.uniformContentItemSize;
    }

    public static interface WmiDragController {
        public void dragGestureRecognized(DragGestureEvent var1, int var2);
    }

    public static interface WmiActionController {
        public void actionPerformed(ActionEvent var1, int var2);
    }

    public class ActionControllerCaller
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            Integer n2 = (Integer)WmiConfigurablePalette.this.buttonToIndex.get(actionEvent.getSource());
            int n3 = n = n2 != null ? n2 : -1;
            if (WmiConfigurablePalette.this.actionController != null) {
                WmiConfigurablePalette.this.actionController.actionPerformed(actionEvent, n);
            }
        }
    }

    public class DragControllerCaller
    implements DragGestureListener {
        public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
            int n = (Integer)WmiConfigurablePalette.this.buttonToIndex.get(dragGestureEvent.getComponent());
            if (WmiConfigurablePalette.this.dragController != null) {
                WmiConfigurablePalette.this.dragController.dragGestureRecognized(dragGestureEvent, n);
            }
        }
    }
}

