/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.components;

import com.maplesoft.mathdoc.controller.WmiCommand;
import com.maplesoft.mathdoc.controller.WmiCommandProxy;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import java.awt.event.ComponentEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;

public class WmiToolBar
extends JToolBar {
    public static final int TOOLBAR_ICONS_DEFAULT = 0;
    public static final int TOOLBAR_ICONS_SMALL = 1;
    public static final int TOOLBAR_ICONS_LARGE = 2;
    protected JPanel toolBarPnl = null;
    protected HashMap commandMap = null;
    private boolean toolBarLocked = false;
    private int toolBarIconSize;
    protected WmiMathDocumentView currentView = null;

    public WmiToolBar(int n, WmiMathDocumentView wmiMathDocumentView) {
        this.currentView = wmiMathDocumentView;
        this.setToolBarIconSize(n);
        this.commandMap = new HashMap();
        this.toolBarPnl = new JPanel();
        this.toolBarPnl.setOpaque(false);
        this.setFocusable(false);
    }

    public WmiToolBar(WmiMathDocumentView wmiMathDocumentView) {
        this(1, wmiMathDocumentView);
    }

    public void resizeToolBar() {
        this.toolBarPnl.invalidate();
        this.validate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseResources() {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.toolBarPnl != null) {
                this.toolBarPnl.removeAll();
            }
            this.toolBarPnl = null;
            if (this.commandMap != null) {
                this.commandMap.clear();
            }
            this.commandMap = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JComboBox addComboBox(JComboBox jComboBox) {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (!this.isToolBarLocked()) {
                this.commandMap.put(jComboBox.getName(), jComboBox);
                this.toolBarPnl.add(jComboBox);
            }
        }
        return jComboBox;
    }

    public void addSeparator() {
        this.addSeparator(10);
    }

    public void addSeparator(int n) {
        this.toolBarPnl.add(Box.createHorizontalStrut(n));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbstractButton addButtonTool(String string) {
        AbstractButton abstractButton = null;
        WmiCommandProxy wmiCommandProxy = null;
        Object object = this.getTreeLock();
        synchronized (object) {
            if (!this.isToolBarLocked()) {
                if (string.equals("-")) {
                    this.addSeparator();
                } else {
                    try {
                        wmiCommandProxy = this.currentView != null ? WmiCommand.getCommandProxy(string, this.currentView) : WmiCommand.getCommandProxy(string);
                        if (wmiCommandProxy != null) {
                            int n = 2;
                            if (this.getToolBarIconSize() == 1) {
                                n = 1;
                            }
                            if ((abstractButton = wmiCommandProxy.createButton(n, this)) != null) {
                                this.toolBarPnl.add(abstractButton);
                                this.commandMap.put(string, abstractButton);
                            }
                        }
                    }
                    catch (NullPointerException nullPointerException) {
                        WmiErrorLog.log(nullPointerException);
                    }
                }
            }
        }
        return abstractButton;
    }

    public int getPreferredButtonIconSize() {
        return 24;
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.resizeToolBar();
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public static void updateTool(AbstractButton abstractButton, String string) {
        WmiCommandProxy wmiCommandProxy = WmiCommand.getCommandProxy(string);
        if (wmiCommandProxy != null) {
            abstractButton.setEnabled(wmiCommandProxy.isEnabled());
            if (((WmiCommand)wmiCommandProxy).getType() == 1) {
                abstractButton.setSelected(((WmiCommand)wmiCommandProxy).isSelected());
            }
        }
    }

    public static void updateTool(AbstractButton abstractButton, String string, WmiMathDocumentView wmiMathDocumentView) {
        WmiCommandProxy wmiCommandProxy = WmiCommand.getCommandProxy(string);
        if (wmiCommandProxy != null) {
            abstractButton.setEnabled(((WmiCommand)wmiCommandProxy).isEnabled(wmiMathDocumentView));
            if (((WmiCommand)wmiCommandProxy).getType() == 1) {
                abstractButton.setSelected(((WmiCommand)wmiCommandProxy).isSelected(wmiMathDocumentView));
            }
        }
    }

    public void updateButtonTools(WmiMathDocumentView wmiMathDocumentView) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.refreshIconImages(wmiMathDocumentView);
        } else {
            SwingUtilities.invokeLater(new WmiToolBarIconUpdater(wmiMathDocumentView));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshIconImages(WmiMathDocumentView wmiMathDocumentView) {
        Object object = this.getTreeLock();
        synchronized (object) {
            Set set = this.commandMap.keySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Object v = this.commandMap.get(string);
                AbstractButton abstractButton = v instanceof AbstractButton ? (AbstractButton)v : null;
                if (abstractButton == null) continue;
                WmiToolBar.updateTool(abstractButton, string, wmiMathDocumentView);
            }
        }
    }

    public boolean isToolBarLocked() {
        return this.toolBarLocked;
    }

    public void setToolBarLocked(boolean bl) {
        this.toolBarLocked = bl;
    }

    public int getToolBarIconSize() {
        return this.toolBarIconSize;
    }

    public void setToolBarIconSize(int n) {
        this.toolBarIconSize = n;
    }

    protected class WmiToolBarIconUpdater
    implements Runnable {
        private WmiMathDocumentView viewToUpdate;

        protected WmiToolBarIconUpdater(WmiMathDocumentView wmiMathDocumentView) {
            this.viewToUpdate = wmiMathDocumentView;
        }

        public void run() {
            WmiToolBar.this.refreshIconImages(this.viewToUpdate);
        }
    }
}

