/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.components;

import com.maplesoft.util.RuntimePlatform;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class WmiTable
extends JTable {
    public WmiTable() {
        this.initializeRenderers();
    }

    public WmiTable(TableModel tableModel) {
        super(tableModel);
        this.initializeRenderers();
    }

    public WmiTable(TableModel tableModel, TableColumnModel tableColumnModel) {
        super(tableModel, tableColumnModel);
        this.initializeRenderers();
    }

    public WmiTable(TableModel tableModel, TableColumnModel tableColumnModel, ListSelectionModel listSelectionModel) {
        super(tableModel, tableColumnModel, listSelectionModel);
        this.initializeRenderers();
    }

    public WmiTable(int n, int n2) {
        super(n, n2);
        this.initializeRenderers();
    }

    public WmiTable(Vector vector, Vector vector2) {
        super(vector, vector2);
        this.initializeRenderers();
    }

    public WmiTable(Object[][] objectArray, Object[] objectArray2) {
        super(objectArray, objectArray2);
        this.initializeRenderers();
    }

    protected void initializeRenderers() {
        if (RuntimePlatform.isMac()) {
            this.setDefaultRenderer(Object.class, new WmiMacTableCellRenderer());
            this.setRowHeight(this.getRowHeight() + 2);
        }
    }

    protected static class WmiMacTableCellRenderer
    extends JLabel
    implements TableCellRenderer {
        private static Font font = new Font("Lucida Grande", 0, 12);
        private static Color selectWithFocusColor = new Color(56, 117, 215);
        private static Color selectWithoutFocusColor = new Color(212, 212, 212);
        boolean isSelected;
        boolean hasFocus;
        JTable myTable;

        protected WmiMacTableCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setFont(font);
            this.isSelected = bl;
            this.hasFocus = bl2;
            this.myTable = jTable;
            if (this.isSelected && (this.hasFocus || jTable.getColumnCount() > 1)) {
                this.setForeground(Color.WHITE);
            } else {
                this.setForeground(Color.BLACK);
            }
            this.setText(object.toString());
            this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            Dimension dimension = this.getPreferredSize();
            dimension.height += 6;
            this.setPreferredSize(dimension);
            return this;
        }

        public void paint(Graphics graphics) {
            Color color = this.isSelected && (this.hasFocus || this.myTable.getColumnCount() > 1) ? selectWithFocusColor : (this.isSelected ? selectWithoutFocusColor : Color.white);
            graphics.setColor(color);
            graphics.fillRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
            super.paint(graphics);
        }
    }
}

