/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.components;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JPanel;

public class WmiSmartFlowLayoutContentPanel
extends JPanel {
    private static Dimension DEFAULT_PROTOTYPE_SIZE = new Dimension(5, 5);
    private boolean uniformContentItemSize;
    private Dimension prototypeSize;

    public WmiSmartFlowLayoutContentPanel(int n, int n2, boolean bl) {
        this(n, n2, bl, 1);
    }

    public WmiSmartFlowLayoutContentPanel(int n, int n2, boolean bl, int n3) {
        this.setLayout(new BaselineFlowLayout(n3, n2, n));
        this.uniformContentItemSize = bl;
        this.setOpaque(false);
    }

    public void setPrototypeButtonSize(Dimension dimension) {
        this.prototypeSize = dimension;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension getPreferredSize() {
        Dimension dimension = null;
        Object object = this.getTreeLock();
        synchronized (object) {
            int n = 0;
            int n2 = 0;
            LayoutManager layoutManager = this.getLayout();
            if (layoutManager instanceof FlowLayout) {
                n = ((FlowLayout)layoutManager).getHgap();
                n2 = ((FlowLayout)layoutManager).getVgap();
            }
            dimension = this.uniformContentItemSize ? this.layoutUniformContentItemSize(n, n2) : this.layoutVariableContentItemSize(n, n2);
        }
        return dimension;
    }

    protected Dimension getDefaultPrototypeSize() {
        return DEFAULT_PROTOTYPE_SIZE;
    }

    protected int getContentWidth() {
        Container container = this.getParent();
        return container != null ? container.getWidth() : 0;
    }

    protected Dimension layoutUniformContentItemSize(int n, int n2) {
        return this.layoutUniformContentItemSize(n, n2, this.getComponentCount());
    }

    protected Dimension layoutUniformContentItemSize(int n, int n2, int n3) {
        Dimension dimension;
        if (this.prototypeSize != null) {
            dimension = this.prototypeSize;
        } else if (this.getComponentCount() > 0) {
            Component component = this.getComponent(0);
            dimension = component.getPreferredSize();
        } else {
            dimension = this.getDefaultPrototypeSize();
        }
        int n4 = dimension.width;
        int n5 = dimension.height;
        if (n4 < 1) {
            n4 = 32;
        }
        n4 += n;
        int n6 = this.getContentWidth();
        if (n6 < 1) {
            n6 = 32;
        }
        int n7 = n6 / n4;
        n7 = Math.max(n7, 1);
        int n8 = n3 / n7;
        if (n3 % n7 != 0) {
            ++n8;
        }
        n8 = Math.max(n8, 1);
        int n9 = n8 * (n5 + n2);
        return new Dimension(n6, n9);
    }

    protected Dimension layoutVariableContentItemSize(int n, int n2) {
        int n3 = this.getContentWidth();
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Component component = this.getComponent(i);
            Dimension dimension = component.getPreferredSize();
            int n7 = dimension.width;
            int n8 = dimension.height + n2;
            if (n5 + n7 <= n3) {
                if (n5 > 0) {
                    n5 += n;
                }
                n5 += n7;
                continue;
            }
            int n9 = this.computeBaselineAlignment(this, n6, i, n4, false) + n2;
            n6 = i;
            n4 += n9;
            if (n7 < n3) {
                n5 = n7;
                continue;
            }
            n5 = 0;
            n4 += n8;
            if (n6 >= this.getComponentCount() - 1) continue;
            ++n6;
        }
        n4 += this.computeBaselineAlignment(this, n6, this.getComponentCount(), n4, false) + n2;
        return new Dimension(n3, n4);
    }

    protected int getBaseline(Component component) {
        return component.getHeight() / 2;
    }

    protected int computeBaselineAlignment(Container container, int n, int n2, int n3, boolean bl) {
        int n4;
        Component component;
        int n5;
        int n6 = 0;
        int n7 = 0;
        for (n5 = n; n5 < n2; ++n5) {
            component = container.getComponent(n5);
            n4 = this.getBaseline(component);
            n6 = Math.max(n4, n6);
        }
        for (n5 = n; n5 < n2; ++n5) {
            component = container.getComponent(n5);
            n4 = this.getBaseline(component);
            int n8 = n6 - n4;
            n7 = Math.max(n8 + component.getHeight(), n7);
            if (!bl) continue;
            component.setLocation(component.getX(), n3 + n8);
        }
        return n7;
    }

    public void setUniformContentItemSize(boolean bl) {
        this.uniformContentItemSize = bl;
    }

    private class BaselineFlowLayout
    extends FlowLayout {
        public BaselineFlowLayout(int n, int n2, int n3) {
            super(n, n2, n3);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void moveComponentsWithBaseline(Container container, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
            Object object = container.getTreeLock();
            synchronized (object) {
                switch (this.getAlignment()) {
                    case 0: {
                        n += bl ? 0 : n3;
                        break;
                    }
                    case 1: {
                        n += n3 / 2;
                        break;
                    }
                    case 2: {
                        n += bl ? n3 : 0;
                        break;
                    }
                    case 3: {
                        break;
                    }
                    case 4: {
                        n += n3;
                    }
                }
                WmiSmartFlowLayoutContentPanel.this.computeBaselineAlignment(container, n5, n6, n2, true);
                for (int i = n5; i < n6; ++i) {
                    Component component = container.getComponent(i);
                    if (!component.isVisible()) continue;
                    int n7 = component.getY();
                    if (bl) {
                        component.setLocation(n, n7);
                    } else {
                        component.setLocation(container.getWidth() - n - component.getWidth(), n7);
                    }
                    n += component.getWidth() + this.getHgap();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void layoutContainer(Container container) {
            Object object = container.getTreeLock();
            synchronized (object) {
                int n = this.getHgap();
                int n2 = this.getVgap();
                Insets insets = container.getInsets();
                int n3 = container.getWidth() - (insets.left + insets.right + n * 2);
                int n4 = container.getComponentCount();
                int n5 = 0;
                int n6 = insets.top + n2;
                int n7 = 0;
                int n8 = 0;
                boolean bl = container.getComponentOrientation().isLeftToRight();
                for (int i = 0; i < n4; ++i) {
                    Component component = container.getComponent(i);
                    if (!component.isVisible()) continue;
                    Dimension dimension = component.getPreferredSize();
                    component.setSize(dimension.width, dimension.height);
                    if (n5 == 0 || n5 + dimension.width <= n3) {
                        if (n5 > 0) {
                            n5 += n;
                        }
                        n5 += dimension.width;
                        n7 = Math.max(n7, dimension.height);
                        continue;
                    }
                    this.moveComponentsWithBaseline(container, insets.left + n, n6, n3 - n5, n7, n8, i, bl);
                    n5 = dimension.width;
                    n6 += n2 + n7;
                    n7 = dimension.height;
                    n8 = i;
                }
                this.moveComponentsWithBaseline(container, insets.left + n, n6, n3 - n5, n7, n8, n4, bl);
            }
        }
    }
}

