/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.components;

import com.maplesoft.mathdoc.components.WmiToolBar;
import com.maplesoft.mathdoc.components.WmiToolBarButton;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;

public abstract class WmiScrollableToolBar
extends WmiToolBar
implements ComponentListener {
    private static final long SCROLL_DELAY_TIME = 1000L;
    private static final int SCROLL_SPEED = 4;
    private static String SCROLL_RIGHT_RESOURCE = "com/maplesoft/mathdoc/components/resources/scroll_right.gif";
    private static String SCROLL_LEFT_RESOURCE = "com/maplesoft/mathdoc/components/resources/scroll_left.gif";
    private static String SCROLL_THREAD_NAME = "ToolBar Scroller";
    private static Insets TOOLBAR_INSETS = new Insets(2, 4, 2, 2);
    private JButton m_right = null;
    private JButton m_left = null;
    private boolean holdScroll = false;
    protected int shift = 0;
    private ToolbarScrollerThread scrollThread = null;
    private MouseListener mlstright = null;
    private MouseListener mlstleft = null;
    protected static String VISIBLE_CLIENT_PROP = "__visible";

    public WmiScrollableToolBar(int n, boolean bl, WmiMathDocumentView wmiMathDocumentView) {
        super(n, wmiMathDocumentView);
        if (bl) {
            this.resetTools();
        }
    }

    public WmiScrollableToolBar(int n, boolean bl) {
        this(n, bl, WmiMathDocumentView.getActiveDocumentView());
    }

    public WmiScrollableToolBar(int n) {
        this(n, true, WmiMathDocumentView.getActiveDocumentView());
    }

    public WmiScrollableToolBar(boolean bl) {
        this(1, bl, WmiMathDocumentView.getActiveDocumentView());
    }

    public WmiScrollableToolBar() {
        this(1, true, WmiMathDocumentView.getActiveDocumentView());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetTools() {
        Object object = this.getTreeLock();
        synchronized (object) {
            this.commandMap.clear();
            this.toolBarPnl.removeAll();
            this.setToolBarLocked(false);
            this.buildTools();
            this.setToolBarLocked(true);
            this.setFloatable(false);
            if (this.toolBarPnl != null) {
                this.m_right = new WmiToolBarButton(8, SCROLL_RIGHT_RESOURCE);
                this.m_left = new WmiToolBarButton(8, SCROLL_LEFT_RESOURCE);
                this.toolBarPnl.add(this.m_right);
                this.toolBarPnl.add(this.m_left);
                this.mlstright = new Scroller(false);
                this.mlstleft = new Scroller(true);
                this.m_right.addMouseListener(this.mlstright);
                this.m_left.addMouseListener(this.mlstleft);
                this.toolBarPnl.setLayout(new ScrollableToolBarLayout());
                this.add(this.toolBarPnl);
                this.validate();
            }
        }
    }

    public void resetScrollBarTools() {
    }

    protected abstract void buildTools();

    protected void scrollOnce(boolean bl) {
        this.shift = bl ? --this.shift : ++this.shift;
        this.toolBarPnl.invalidate();
        this.validate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseResources() {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.m_right != null) {
                this.m_right.removeMouseListener(this.mlstright);
            }
            this.m_right = null;
            if (this.m_left != null) {
                this.m_left.removeMouseListener(this.mlstleft);
            }
            this.m_left = null;
            if (this.scrollThread != null && this.scrollThread.isAlive()) {
                this.scrollThread.cancel();
            }
            this.scrollThread = null;
            super.releaseResources();
        }
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.resizeToolBar();
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    protected int getButtonSpacing() {
        return 1;
    }

    public Insets getInsets() {
        return TOOLBAR_INSETS;
    }

    protected void setVisibleClientProperty(Component component, boolean bl) {
        ((JComponent)component).putClientProperty(VISIBLE_CLIENT_PROP, bl ? Boolean.TRUE : Boolean.FALSE);
    }

    private static class ToolbarScrollerThread
    extends Thread {
        WmiScrollableToolBar myToolBar = null;
        AbstractButton scrollButton = null;
        boolean direction = false;
        boolean running = true;

        public ToolbarScrollerThread(WmiScrollableToolBar wmiScrollableToolBar, AbstractButton abstractButton, boolean bl) {
            super(SCROLL_THREAD_NAME);
            this.myToolBar = wmiScrollableToolBar;
            this.scrollButton = abstractButton;
            this.direction = bl;
        }

        public void run() {
            long l = 0L;
            long l2 = 1000L;
            while (this.running && this.myToolBar.holdScroll && this.scrollButton.isEnabled()) {
                l = System.currentTimeMillis();
                this.myToolBar.scrollOnce(this.direction);
                while (this.running && l + l2 > System.currentTimeMillis() && this.myToolBar.holdScroll) {
                }
                if (1000L - (l2 /= 4L) * 4L <= 8L) continue;
                l2 *= 4L;
            }
        }

        public void cancel() {
            this.running = false;
        }
    }

    protected class ScrollableToolBarLayout
    implements LayoutManager {
        private int hgap;
        private int height;

        protected ScrollableToolBarLayout() {
            this.hgap = WmiScrollableToolBar.this.getButtonSpacing();
            this.height = 0;
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public Dimension preferredLayoutSize(Container container) {
            this.processLayout(container, true);
            return new Dimension(container.getWidth(), this.getToolBarHeight());
        }

        public Dimension minimumLayoutSize(Container container) {
            this.processLayout(container, true);
            return new Dimension(0, this.getToolBarHeight());
        }

        public void layoutContainer(Container container) {
            this.processLayout(container, true);
        }

        public int getToolBarHeight() {
            int n = 44;
            if (WmiScrollableToolBar.this.getToolBarIconSize() == 1) {
                n = 28;
            }
            return n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processLayout(Container container, boolean bl) {
            Object object = container.getTreeLock();
            synchronized (object) {
                Object object2;
                if (WmiScrollableToolBar.this.shift < 0) {
                    WmiScrollableToolBar.this.shift = 0;
                }
                Insets insets = WmiScrollableToolBar.this.getInsets();
                int n = container.getComponentCount() - 2;
                int n2 = container.getWidth() - (insets.left + insets.right - 2 * this.hgap);
                int n3 = n2 - container.getComponent(n + 1).getWidth() - this.hgap;
                if (WmiScrollableToolBar.this.shift != 0) {
                    n2 = n3;
                }
                int n4 = insets.left + this.hgap;
                int n5 = 0;
                int n6 = 0;
                Component component = null;
                this.height = this.getToolBarHeight();
                if (bl) {
                    for (n6 = 0; n6 < WmiScrollableToolBar.this.shift; ++n6) {
                        component = container.getComponent(n6);
                        component.setVisible(false);
                    }
                }
                for (n6 = WmiScrollableToolBar.this.shift; n6 < n; ++n6) {
                    component = container.getComponent(n6);
                    object2 = ((JComponent)component).getClientProperty(VISIBLE_CLIENT_PROP);
                    if (object2 == Boolean.FALSE) {
                        component.setVisible(false);
                        continue;
                    }
                    Dimension dimension = component.getPreferredSize();
                    int n7 = (n6 == n - 1 ? n2 : n3) - this.hgap;
                    if (n4 + dimension.width >= n7) break;
                    if (bl) {
                        component.setVisible(true);
                        component.setSize(dimension.width, dimension.height);
                        component.setLocation(n4, n5 + (this.height - dimension.height) / 2);
                    }
                    n4 += dimension.width + this.hgap;
                }
                if (n6 < n || WmiScrollableToolBar.this.shift != 0) {
                    component = container.getComponent(n);
                    object2 = component.getPreferredSize();
                    n4 = insets.left + this.hgap + n3 - ((Dimension)object2).width;
                    if (bl) {
                        component.setVisible(true);
                        component.setEnabled(n6 < n);
                        component.setSize(((Dimension)object2).width, ((Dimension)object2).height);
                        component.setLocation(n4, this.height / 2 - ((Dimension)object2).height);
                        component = container.getComponent(n + 1);
                        component.setVisible(true);
                        component.setEnabled(WmiScrollableToolBar.this.shift != 0);
                        object2 = component.getPreferredSize();
                        component.setSize(((Dimension)object2).width, ((Dimension)object2).height);
                        component.setLocation(n4, this.height / 2);
                    }
                    n4 += ((Dimension)object2).width;
                } else {
                    container.getComponent(n).setVisible(false);
                    container.getComponent(n + 1).setVisible(false);
                }
                if (bl) {
                    while (n6 < n) {
                        component = container.getComponent(n6++);
                        component.setVisible(false);
                    }
                }
            }
        }
    }

    protected class Scroller
    extends MouseAdapter {
        private boolean scrollBack;

        Scroller(boolean bl) {
            this.scrollBack = bl;
        }

        public void mousePressed(MouseEvent mouseEvent) {
            Object object = mouseEvent.getSource();
            if (object instanceof JButton && ((JButton)object).isEnabled()) {
                JButton jButton = (JButton)object;
                WmiScrollableToolBar.this.holdScroll = true;
                WmiScrollableToolBar.this.scrollThread = new ToolbarScrollerThread(WmiScrollableToolBar.this, jButton, this.scrollBack);
                WmiScrollableToolBar.this.scrollThread.setPriority(1);
                WmiScrollableToolBar.this.scrollThread.start();
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            WmiScrollableToolBar.this.holdScroll = false;
        }
    }
}

