/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.components;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.view.WmiCaret;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiPositionMarker;
import com.maplesoft.mathdoc.view.WmiViewUtil;
import com.maplesoft.util.RuntimePlatform;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class WmiPopupList
extends JPopupMenu {
    public static final int SHOW_LIMIT = 8;
    public static final int PAD_WIDTH = 30;
    public static final int DEFAULT_WIDTH = 350;
    protected JList list;
    private JScrollPane scroller;
    protected WmiMathDocumentView docView;
    protected int position;
    protected int prefixLength;
    protected Object selection;

    public WmiPopupList(WmiMathDocumentView wmiMathDocumentView, Vector vector, int n, int n2) {
        this.docView = wmiMathDocumentView;
        this.position = n;
        this.prefixLength = n2;
        Component component = SwingUtilities.getRoot(wmiMathDocumentView);
        if (component != null && component instanceof JFrame) {
            this.setInvoker((JFrame)component);
        }
        if (RuntimePlatform.isWindows() && component != null && component instanceof JDialog) {
            this.setInvoker((JDialog)component);
        }
        this.createList(vector);
        this.createScroller();
        this.configurePopup();
    }

    protected void createList(Vector vector) {
        this.list = new JList(vector);
        this.list.setBorder(null);
        this.list.setSelectionMode(0);
        this.list.addListSelectionListener(new WmiListSelectionHandler());
        this.list.addMouseMotionListener(new WmiListMouseMotionHandler());
        this.list.addMouseListener(new WmiListMouseHandler());
        this.list.setFocusTraversalKeysEnabled(false);
        this.list.addKeyListener(new WmiListKeyHandler());
    }

    public void setVisible(boolean bl) {
        if (bl != this.isVisible() && !bl) {
            Component component;
            for (component = this.getInvoker(); component != null && !(component instanceof Window); component = component.getParent()) {
            }
            if (component instanceof Window) {
                ((Window)component).toFront();
            }
        }
        super.setVisible(bl);
    }

    protected void createScroller() {
        this.scroller = new JScrollPane(this.list, 20, 31);
        this.scroller.getVerticalScrollBar().setRequestFocusEnabled(false);
        this.scroller.setBorder(null);
    }

    protected void configurePopup() {
        this.setLayout(new BoxLayout(this, 1));
        if (!RuntimePlatform.isMac()) {
            this.setBorderPainted(true);
            this.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        }
        this.setOpaque(false);
        this.add(this.scroller);
        this.setDoubleBuffered(true);
    }

    protected void updateListBoxSelectionForEvent(MouseEvent mouseEvent, boolean bl) {
        Point point = mouseEvent.getPoint();
        if (this.list == null) {
            return;
        }
        int n = this.list.locationToIndex(point);
        if (n == -1) {
            n = point.y < 0 ? 0 : this.list.getModel().getSize() - 1;
        }
        if (this.list.getSelectedIndex() != n) {
            this.list.setSelectedIndex(n);
            if (bl) {
                this.list.ensureIndexIsVisible(n);
            }
        }
    }

    public void display() {
        Dimension dimension = this.computeSize();
        int n = (int)dimension.getHeight();
        int n2 = (int)dimension.getWidth();
        Border border = this.scroller.getBorder();
        Insets insets = null;
        if (border != null) {
            insets = border.getBorderInsets(this.scroller);
            n += insets.top + insets.bottom;
            n2 += insets.left + insets.right;
        }
        this.setSize(this.scroller, n2, n);
        border = this.getBorder();
        if (border != null) {
            insets = border.getBorderInsets(this);
            n += insets.top + insets.bottom;
            n2 += insets.left + insets.right;
        }
        this.setSize(this, n2, n);
        Point point = this.computePosition();
        Point point2 = this.computePlacementLimit();
        int n3 = (int)point.getX();
        int n4 = (int)point.getY();
        if (n2 + n3 > (int)point2.getX()) {
            n3 -= n2;
        }
        if (n + n4 > (int)point2.getY()) {
            n4 -= n + this.getLineHeight();
        }
        this.setLocation(n3, n4);
        this.setVisible(true);
        this.repaint();
        boolean bl = this.list.requestFocusInWindow();
        this.list.setSelectedIndex(0);
        if (!bl && this.list.getRootPane() != this.docView.getRootPane()) {
            Container container;
            Container container2;
            for (container2 = this.list.getParent(); container2 != null && !(container2 instanceof Window); container2 = container2.getParent()) {
            }
            for (container = this.docView.getRootPane().getParent(); container != null && !(container instanceof Window); container = container.getParent()) {
            }
            if (container2 instanceof Window && !(container instanceof JDialog)) {
                ((Window)container2).toFront();
            }
        }
    }

    protected Dimension computeSize() {
        int n = 0;
        int n2 = 0;
        ListModel listModel = this.list.getModel();
        int n3 = listModel.getSize();
        ListCellRenderer listCellRenderer = this.list.getCellRenderer();
        if (n3 > 0) {
            Component component = listCellRenderer.getListCellRendererComponent(this.list, listModel.getElementAt(0), 0, false, false);
            Dimension dimension = component.getPreferredSize();
            n = 350;
            n2 = dimension.height;
        }
        n2 = n3 > 8 ? (n2 *= 8) : (n2 *= n3);
        return new Dimension(n + 30, n2);
    }

    protected Point computePosition() {
        WmiPositionMarker wmiPositionMarker = this.docView != null ? this.docView.getPositionMarker() : null;
        int n = 0;
        int n2 = 0;
        if (wmiPositionMarker != null && wmiPositionMarker instanceof WmiCaret) {
            Rectangle rectangle = wmiPositionMarker.getBounds();
            n = rectangle.x;
            n2 = rectangle.height;
            n2 = (int)((double)n2 + WmiViewUtil.getAbsoluteOffset(wmiPositionMarker.getView()).getY());
            Point point = new Point(n, n2);
            SwingUtilities.convertPointToScreen(point, this.docView);
            n = point.x;
            n2 = point.y;
        }
        return new Point(n, n2);
    }

    protected int getLineHeight() {
        int n = 0;
        try {
            WmiPositionMarker wmiPositionMarker = null;
            if (this.docView != null) {
                wmiPositionMarker = this.docView.getPositionMarker();
            }
            if (wmiPositionMarker != null && wmiPositionMarker.isVisible() && wmiPositionMarker instanceof WmiCaret) {
                Rectangle rectangle = wmiPositionMarker.getBounds();
                n = (int)rectangle.getHeight();
            }
        }
        catch (Exception exception) {
            WmiErrorLog.log(exception);
        }
        return n;
    }

    protected Point computePlacementLimit() {
        Rectangle rectangle = this.docView.getBounds();
        int n = (int)rectangle.getWidth();
        int n2 = (int)rectangle.getHeight();
        for (Container container = this.docView; container != null; container = container.getParent()) {
            rectangle = container.getBounds();
            n += (int)rectangle.getMinX();
            n2 += (int)rectangle.getMinY();
        }
        return new Point(n, n2);
    }

    protected void setSize(JComponent jComponent, int n, int n2) {
        Dimension dimension = new Dimension(n, n2);
        jComponent.setMaximumSize(dimension);
        jComponent.setMinimumSize(dimension);
        jComponent.setPreferredSize(dimension);
        jComponent.invalidate();
    }

    protected void selectionFinalized() {
        this.setVisible(false);
    }

    protected void updateCharacter(char c) {
        this.setVisible(false);
        String string = String.valueOf(c);
    }

    public void dispatchKeyEvent_Mac102Hack(KeyEvent keyEvent) {
        this.list.dispatchEvent(keyEvent);
    }

    private void moveSelection(int n) {
        int n2 = this.list.getSelectedIndex();
        if ((n2 += n) > this.list.getModel().getSize() - 1) {
            n2 = 0;
        } else if (n2 < 0) {
            n2 = this.list.getModel().getSize() - 1;
        }
        Object e = this.list.getModel().getElementAt(n2);
        this.list.setSelectedValue(e, true);
    }

    protected class WmiListKeyHandler
    extends KeyAdapter {
        protected WmiListKeyHandler() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            int n = keyEvent.getModifiers();
            if (n == 0) {
                if (keyEvent.getKeyCode() == 10 || keyEvent.getKeyCode() == 32 || keyEvent.getKeyCode() == 9) {
                    WmiPopupList.this.selectionFinalized();
                    keyEvent.consume();
                } else if (keyEvent.getKeyCode() == 27 || keyEvent.getKeyCode() == 37 || keyEvent.getKeyCode() == 8) {
                    WmiPopupList.this.setVisible(false);
                } else if (RuntimePlatform.isMac() && keyEvent.getKeyCode() == 40) {
                    WmiPopupList.this.moveSelection(1);
                    keyEvent.consume();
                } else if (RuntimePlatform.isMac() && keyEvent.getKeyCode() == 38) {
                    WmiPopupList.this.moveSelection(-1);
                    keyEvent.consume();
                } else {
                    char c = keyEvent.getKeyChar();
                    if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == ':' || c == '-') {
                        WmiPopupList.this.updateCharacter(c);
                    }
                }
            } else {
                keyEvent.consume();
            }
        }
    }

    protected class WmiListMouseMotionHandler
    extends MouseMotionAdapter {
        protected WmiListMouseMotionHandler() {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
            Rectangle rectangle = new Rectangle();
            WmiPopupList.this.list.computeVisibleRect(rectangle);
            if (rectangle.contains(point)) {
                WmiPopupList.this.updateListBoxSelectionForEvent(mouseEvent, false);
            }
        }
    }

    protected class WmiListMouseHandler
    extends MouseAdapter {
        protected WmiListMouseHandler() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            WmiPopupList.this.selectionFinalized();
        }
    }

    protected class WmiListSelectionHandler
    implements ListSelectionListener {
        protected WmiListSelectionHandler() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            WmiPopupList.this.selection = WmiPopupList.this.list.getSelectedValue();
        }
    }
}

