/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.prettyprinter.template;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.prettyprinter.AncestorArrayLayoutBox;
import com.maplesoft.client.prettyprinter.DefaultLayoutBox;
import com.maplesoft.client.prettyprinter.InlineLayoutBox;
import com.maplesoft.client.prettyprinter.LayoutAnchor;
import com.maplesoft.client.prettyprinter.LayoutBox;
import com.maplesoft.client.prettyprinter.LayoutFormatter;
import com.maplesoft.client.prettyprinter.LayoutVector;
import com.maplesoft.client.prettyprinter.NotationLayoutBox;
import com.maplesoft.client.prettyprinter.TTYFormatter;
import com.maplesoft.client.prettyprinter.linebreaker.LineBreaker;
import com.maplesoft.client.prettyprinter.linebreaker.LineBreakerFactory;
import com.maplesoft.client.prettyprinter.selection.SelectionData;
import com.maplesoft.client.prettyprinter.selection.StandardSelectionData;
import com.maplesoft.client.prettyprinter.template.BracketTemplate;
import com.maplesoft.client.prettyprinter.template.SpecialFunctionTemplate;

public class SumProductTemplate
implements SpecialFunctionTemplate {
    private static final double NOTATION_CENTER = 0.5;
    private static final double NOTATION_TOP = 0.2;
    private static SelectionData notationSD = null;
    private int notationType;

    SumProductTemplate(int n) {
        this.notationType = n;
    }

    public SumLayoutBuilder getSumLayoutBuilder(LayoutFormatter layoutFormatter, Dag dag, Dag[] dagArray) {
        SumLayoutBuilder sumLayoutBuilder = null;
        Dag dag2 = null;
        if (dagArray != null && dagArray.length == 2) {
            dag2 = dagArray[1];
        }
        if (dag2 != null) {
            Dag dag3 = null;
            Dag dag4 = null;
            Dag dag5 = null;
            if (dag2.getType() == 20) {
                dag3 = dag2.getChild(0);
                Dag dag6 = dag2.getChild(1);
                if (dag6.getType() == 35) {
                    dag4 = dag6.getChild(0);
                    dag5 = dag6.getChild(1);
                    if (dag4.getType() > 19 || dag5.getType() > 19) {
                        sumLayoutBuilder = null;
                    }
                    sumLayoutBuilder = new RangeLayoutBuilder(layoutFormatter, dag, dagArray);
                } else {
                    sumLayoutBuilder = new ExprLayoutBuilder(layoutFormatter, dag, dagArray);
                }
            } else if (dag2.getType() == 8) {
                if (dag2.getType() > 19) {
                    sumLayoutBuilder = null;
                }
                sumLayoutBuilder = new NameLayoutBuilder(layoutFormatter, dag, dagArray);
            }
        } else if (dagArray != null && dagArray.length == 1) {
            sumLayoutBuilder = new NoArgsLayoutBuilder(layoutFormatter, dag, dagArray);
        }
        return sumLayoutBuilder;
    }

    public LayoutBox apply(LayoutFormatter layoutFormatter, Dag dag, Dag[] dagArray) {
        LayoutBox layoutBox = null;
        SumLayoutBuilder sumLayoutBuilder = this.getSumLayoutBuilder(layoutFormatter, dag, dagArray);
        if (sumLayoutBuilder != null) {
            layoutBox = sumLayoutBuilder.getBox();
        }
        return layoutBox;
    }

    static class SumProdLayoutBox
    extends InlineLayoutBox {
        private static final double BASELINE_ADJUST = 0.65;
        private static LineBreaker lb = LineBreakerFactory.newLineBreaker((int)14);
        private double functionSpace;

        SumProdLayoutBox(LayoutBox layoutBox, LayoutBox layoutBox2, LayoutFormatter layoutFormatter) {
            super(2);
            this.addChild(layoutBox);
            this.addChild(layoutBox2);
            if (!(layoutFormatter instanceof TTYFormatter)) {
                this.functionSpace = 3.0;
            }
        }

        SumProdLayoutBox() {
        }

        public void setLineBreaker(LineBreaker lineBreaker) {
        }

        public LineBreaker getLineBreaker() {
            return lb;
        }

        public void applyLayout() {
            if (!this.isLayoutValid()) {
                this.setOrigin(0.0, 0.0);
                LayoutBox layoutBox = this.getChild(0);
                LayoutBox layoutBox2 = this.getChild(1);
                if (!layoutBox.isLayoutValid()) {
                    layoutBox.applyLayout();
                }
                if (!layoutBox2.isLayoutValid()) {
                    layoutBox2.applyLayout();
                }
                LayoutBox layoutBox3 = layoutBox.getChild(0);
                double d = layoutBox3.getHeight();
                double d2 = layoutBox3.getYorig();
                double d3 = layoutBox2.getBaseline();
                double d4 = 0.65 * d + d2 - d3;
                layoutBox2.setOrigin(layoutBox.getWidth() + this.functionSpace, d4);
                layoutBox.setBaseline(d4 + d3);
                this.computeSize();
            }
        }
    }

    static class SumProdFromLayoutBox
    extends InlineLayoutBox {
        private static LineBreaker lb = LineBreakerFactory.newLineBreaker((int)13);

        SumProdFromLayoutBox(LayoutBox layoutBox, LayoutBox layoutBox2, LayoutBox layoutBox3) {
            super(3);
            this.addChild(layoutBox);
            this.addChild(layoutBox2);
            this.addChild(layoutBox3);
        }

        SumProdFromLayoutBox() {
        }

        public void setLineBreaker(LineBreaker lineBreaker) {
        }

        public LineBreaker getLineBreaker() {
            return lb;
        }
    }

    private abstract class SumLayoutBuilder {
        protected LayoutFormatter formatter = null;
        protected int[] funcPath = new int[]{1, 0};

        protected SumLayoutBuilder(LayoutFormatter layoutFormatter) {
            this.formatter = layoutFormatter;
        }

        public LayoutBox buildFunctionBox(Dag dag, Dag dag2) {
            LayoutBox layoutBox = DagBuilder.createLayout(this.formatter, dag2);
            layoutBox = AncestorArrayLayoutBox.wrapWithAncestorData(layoutBox, dag, this.funcPath);
            layoutBox = BracketTemplate.apply(this.formatter, layoutBox, dag2, 4);
            return layoutBox;
        }

        public LayoutBox buildNotationBox() {
            NotationLayoutBox notationLayoutBox = NotationLayoutBox.createNotationBox(this.formatter, SumProductTemplate.this.notationType);
            if (notationSD == null) {
                notationSD = new StandardSelectionData(4);
                notationSD.setContextHelpAvailable(false);
            }
            notationLayoutBox.setSelectionData(notationSD);
            this.formatter.resizeNotationBox(notationLayoutBox);
            DefaultLayoutBox defaultLayoutBox = new DefaultLayoutBox();
            notationLayoutBox.setRightSideBearing(3.0 * this.formatter.getBearingMultiplier());
            defaultLayoutBox.addChild(notationLayoutBox);
            return defaultLayoutBox;
        }

        public void buildNotationTraversal(LayoutBox layoutBox, boolean bl) {
            int[] nArray = null;
            nArray = bl ? new int[]{2, 0, 1} : new int[]{0, 1};
            SelectionData selectionData = new SelectionData(1);
            selectionData.setTraversalNorthSouth(nArray);
            selectionData.setStandardEastWestArray(layoutBox);
            layoutBox.setSelectionData(selectionData);
        }

        public abstract LayoutBox getBox();
    }

    private class NoArgsLayoutBuilder
    extends SumLayoutBuilder {
        private LayoutBox box;

        private NoArgsLayoutBuilder(LayoutFormatter layoutFormatter, Dag dag, Dag[] dagArray) {
            super(layoutFormatter);
            this.box = null;
            LayoutBox layoutBox = this.buildFunctionBox(dag, dagArray[0]);
            LayoutBox layoutBox2 = this.buildNotationBox();
            this.buildNotationTraversal(layoutBox2, false);
            this.box = new SumProdLayoutBox(layoutBox2, layoutBox, layoutFormatter);
        }

        public LayoutBox getBox() {
            return this.box;
        }
    }

    private class NameLayoutBuilder
    extends SumLayoutBuilder {
        private LayoutBox box;
        protected int[] fromPath;

        private NameLayoutBuilder(LayoutFormatter layoutFormatter, Dag dag, Dag[] dagArray) {
            super(layoutFormatter);
            this.box = null;
            this.fromPath = new int[]{1, 1};
            Dag dag2 = dagArray[1];
            LayoutBox layoutBox = this.buildFunctionBox(dag, dagArray[0]);
            LayoutBox layoutBox2 = this.buildNotationBox();
            layoutFormatter.incSuperscriptCount();
            this.addFromBox(layoutBox2, dag, dag2);
            layoutFormatter.decSuperscriptCount();
            layoutBox2.addLayoutAnchor(LayoutAnchor.OVER_01);
            this.buildNotationTraversal(layoutBox2, false);
            this.box = new SumProdLayoutBox(layoutBox2, layoutBox, layoutFormatter);
        }

        public void addFromBox(LayoutBox layoutBox, Dag dag, Dag dag2) {
            LayoutBox layoutBox2 = DagBuilder.createLayout(this.formatter, dag2);
            layoutBox2 = AncestorArrayLayoutBox.wrapWithAncestorData(layoutBox2, dag, this.fromPath);
            if (dag2 != null) {
                layoutBox.addChild(layoutBox2);
            }
        }

        public LayoutBox getBox() {
            return this.box;
        }
    }

    private class ExprLayoutBuilder
    extends SumLayoutBuilder {
        private LayoutBox box;
        protected int[] fromPath;

        private ExprLayoutBuilder(LayoutFormatter layoutFormatter, Dag dag, Dag[] dagArray) {
            super(layoutFormatter);
            this.box = null;
            this.fromPath = new int[]{1, 1};
            Dag dag2 = dagArray[1];
            LayoutBox layoutBox = this.buildFunctionBox(dag, dagArray[0]);
            LayoutBox layoutBox2 = this.buildNotationBox();
            layoutFormatter.incSuperscriptCount();
            this.addFromBox(layoutBox2, dag, dag2);
            layoutFormatter.decSuperscriptCount();
            layoutBox2.addLayoutAnchor(LayoutAnchor.OVER_01);
            this.buildNotationTraversal(layoutBox2, false);
            this.box = new SumProdLayoutBox(layoutBox2, layoutBox, layoutFormatter);
        }

        public void addFromBox(LayoutBox layoutBox, Dag dag, Dag dag2) {
            LayoutBox layoutBox2 = DagBuilder.createLayout(this.formatter, dag2);
            layoutBox2 = AncestorArrayLayoutBox.wrapWithAncestorData(layoutBox2, dag, this.fromPath);
            if (dag2 != null) {
                layoutBox.addChild(layoutBox2);
            }
        }

        public LayoutBox getBox() {
            return this.box;
        }
    }

    private class RangeLayoutBuilder
    extends SumLayoutBuilder {
        private LayoutBox box;
        protected int[] varPath;
        protected int[] fromPath;
        protected int[] toPath;

        private RangeLayoutBuilder(LayoutFormatter layoutFormatter, Dag dag, Dag[] dagArray) {
            super(layoutFormatter);
            this.box = null;
            this.varPath = new int[]{1, 1, 0};
            this.fromPath = new int[]{1, 1, 1, 0};
            this.toPath = new int[]{1, 1, 1, 1};
            Dag dag2 = dagArray[1];
            Dag dag3 = dag2.getChild(0);
            Dag dag4 = dag2.getChild(1);
            Dag dag5 = dag4.getChild(0);
            Dag dag6 = dag4.getChild(1);
            LayoutBox layoutBox = this.buildFunctionBox(dag, dagArray[0]);
            LayoutBox layoutBox2 = this.buildNotationBox();
            layoutFormatter.incSuperscriptCount();
            this.addFromBox(layoutBox2, dag, dag3, dag5);
            layoutFormatter.decSuperscriptCount();
            layoutBox2.addLayoutAnchor(LayoutAnchor.OVER_01);
            this.addToBox(layoutBox2, dag, dag6);
            this.buildNotationTraversal(layoutBox2, dag6 != null);
            this.box = new SumProdLayoutBox(layoutBox2, layoutBox, layoutFormatter);
        }

        public void addToBox(LayoutBox layoutBox, Dag dag, Dag dag2) {
            if (dag2 != null) {
                this.formatter.incSuperscriptCount();
                LayoutBox layoutBox2 = DagBuilder.createLayout(this.formatter, dag2);
                layoutBox2 = AncestorArrayLayoutBox.wrapWithAncestorData(layoutBox2, dag, this.toPath);
                layoutBox.addChild(layoutBox2);
                if (this.formatter instanceof TTYFormatter) {
                    layoutBox.addLayoutAnchor(LayoutAnchor.UNDER_02);
                } else {
                    layoutBox.addLayoutAnchor(new LayoutAnchor(0, new LayoutVector(0.5, 0.2), 2, LayoutVector.SOUTH));
                }
                this.formatter.decSuperscriptCount();
            }
        }

        public void addFromBox(LayoutBox layoutBox, Dag dag, Dag dag2, Dag dag3) {
            LayoutBox layoutBox2 = DagBuilder.createLayout(this.formatter, dag2);
            layoutBox2 = AncestorArrayLayoutBox.wrapWithAncestorData(layoutBox2, dag, this.varPath);
            LayoutBox layoutBox3 = DagBuilder.createLayout(this.formatter, dag3);
            layoutBox3 = AncestorArrayLayoutBox.wrapWithAncestorData(layoutBox3, dag, this.fromPath);
            if (dag3 != null) {
                NotationLayoutBox notationLayoutBox = NotationLayoutBox.createNotationBox(this.formatter, 5);
                StandardSelectionData standardSelectionData = new StandardSelectionData(16);
                standardSelectionData.setContextHelpAvailable(false);
                notationLayoutBox.setSelectionData(standardSelectionData);
                SumProdFromLayoutBox sumProdFromLayoutBox = new SumProdFromLayoutBox(layoutBox2, notationLayoutBox, layoutBox3);
                sumProdFromLayoutBox.setSelectionData(standardSelectionData);
                layoutBox.addChild(sumProdFromLayoutBox);
            } else {
                layoutBox.addChild(layoutBox2);
            }
        }

        public LayoutBox getBox() {
            return this.box;
        }
    }
}

