/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.prettyprinter;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.prettyprinter.AbstractLayoutBox;
import com.maplesoft.client.prettyprinter.LayoutAnchor;
import com.maplesoft.client.prettyprinter.LayoutBox;
import com.maplesoft.client.prettyprinter.LayoutPoint;
import com.maplesoft.client.prettyprinter.selection.SelectionData;
import com.maplesoft.client.prettyprinter.selection.StandardSelectionData;
import java.util.Iterator;

public abstract class AbstractBranchLayoutBox
extends AbstractLayoutBox {
    protected LayoutBox[] children = null;
    public String name = "";
    protected String data = "";
    int numChildren = 0;
    protected SelectionData selectionData;

    protected AbstractBranchLayoutBox() {
    }

    public void setData(String string) {
        this.data = string;
    }

    public String getData() {
        return this.data;
    }

    public boolean hasChildren() {
        return this.children != null && this.children.length > 0;
    }

    public int numChildren() {
        return this.numChildren;
    }

    public int indexOf(LayoutBox layoutBox) {
        int n = -1;
        for (int i = 0; i < this.numChildren(); ++i) {
            if (this.getChild(i) == null || !this.getChild(i).equals(layoutBox)) continue;
            n = i;
            break;
        }
        return n;
    }

    public LayoutBox getChild(int n) {
        LayoutBox layoutBox = null;
        if (n >= 0 && n < this.numChildren()) {
            layoutBox = this.children[n];
        }
        if (n >= 0 && n == this.numChildren - 1) {
            int n2 = -1;
            int n3 = -1;
            for (int i = n; i < this.children.length - 1; ++i) {
                if (this.children[i] != null) continue;
                n3 = n3 == -1 ? i : n3;
                n2 = i;
            }
            if (n2 > -1 && n3 > -1) {
                LayoutBox[] layoutBoxArray = new LayoutBox[n3];
                System.arraycopy(this.children, 0, layoutBoxArray, 0, n3);
                this.children = layoutBoxArray;
            }
        }
        return layoutBox;
    }

    public void addChild(LayoutBox layoutBox) {
        boolean bl = false;
        if (this.children != null && this.children.length > 0) {
            if (this.numChildren < this.children.length) {
                this.children[this.numChildren] = layoutBox;
                bl = true;
            } else {
                for (int i = 0; i < this.children.length; ++i) {
                    if (this.children[i] != null) continue;
                    bl = true;
                    this.children[i] = layoutBox;
                    break;
                }
            }
        }
        if (!bl) {
            if (this.children == null || this.children.length == 0) {
                this.children = new LayoutBox[1];
                this.children[0] = layoutBox;
            } else {
                LayoutBox[] layoutBoxArray = new LayoutBox[this.numChildren() + 1];
                System.arraycopy(this.children, 0, layoutBoxArray, 0, this.numChildren());
                layoutBoxArray[layoutBoxArray.length - 1] = layoutBox;
                this.children = layoutBoxArray;
            }
            bl = true;
        }
        if (bl) {
            ++this.numChildren;
        }
        this.validLayout = false;
    }

    public void removeChild(int n) {
        LayoutBox[] layoutBoxArray = new LayoutBox[this.numChildren() - 1];
        System.arraycopy(this.children, 0, layoutBoxArray, 0, n);
        System.arraycopy(this.children, n + 1, layoutBoxArray, n, this.numChildren() - n - 1);
        --this.numChildren;
        this.validLayout = false;
    }

    public Iterator getChildren() {
        return new ChildArrayIterator();
    }

    public SelectionData getSelectionData() {
        SelectionData selectionData = null;
        if (this.selectionData != null) {
            selectionData = this.selectionData;
        } else if (this.getDefaultSelectionData() == null) {
            this.setDefaultSelectionData(new StandardSelectionData(this.getSelectionCode()));
        }
        selectionData = selectionData == null ? this.getDefaultSelectionData() : selectionData;
        return selectionData;
    }

    public void setDefaultSelectionData(SelectionData selectionData) {
    }

    public SelectionData getDefaultSelectionData() {
        return null;
    }

    protected int getSelectionCode() {
        return 1;
    }

    public void setSelectionData(SelectionData selectionData) {
        this.selectionData = selectionData;
    }

    public void setTheFirstOrigin() {
        LayoutBox layoutBox = this.getChild(0);
        if (layoutBox.hasChildren()) {
            layoutBox.setTheFirstOrigin();
        } else {
            layoutBox.setOrigin(0.0, 0.0);
        }
    }

    public void computeSize() {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = this.getYorig();
        LayoutBox layoutBox = null;
        double d4 = 0.0;
        double d5 = 0.0;
        for (int i = 0; i < this.numChildren(); ++i) {
            layoutBox = this.getChild(i);
            d4 = layoutBox.getYorig();
            d5 = layoutBox.getHeight();
            if (d4 < d3) {
                d3 = d4;
            }
            if (d4 + d5 > d2) {
                d2 = d4 + d5;
            }
            d += layoutBox.getTotalWidth();
        }
        this.adjustBaselineAndOrigins(d3);
        this.setSize(d, d2 - d3);
        this.setOrigin(0.0, 0.0);
        this.validLayout = true;
    }

    protected void adjustBaselineAndOrigins(double d) {
        this.baseline = 0.0;
        if (this.hasChildren() && this.getChild(0) != null) {
            this.baseline = this.getChild(0).getBaseline();
        }
        if (d != 0.0) {
            LayoutPoint layoutPoint = new LayoutPoint(0.0, -d);
            for (int i = 0; i < this.numChildren(); ++i) {
                this.getChild(i).translateOrigin(layoutPoint);
            }
            this.baseline -= d;
        }
    }

    public void invalidateAll() {
        for (int i = 0; i < this.numChildren(); ++i) {
            if (this.getChild(i) == null) continue;
            this.getChild(i).invalidateAll();
        }
        this.validate(false);
    }

    public abstract Iterator getAnchors();

    public abstract void addLayoutAnchor(LayoutAnchor var1);

    public abstract void applyLayout();

    static void resetLayout(LayoutBox layoutBox) {
        layoutBox.invalidateAll();
        layoutBox.applyLayout();
    }

    public String toString() {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.sizeSet) {
            stringBuffer.append(" Size ");
            stringBuffer.append(this.getSize());
        } else {
            stringBuffer.append(" Size not Set");
        }
        stringBuffer.append(" Origin ");
        stringBuffer.append(this.origin);
        stringBuffer.append("\nLayoutAnchors:\n");
        Iterator iterator = this.getAnchors();
        int n = 0;
        while (iterator.hasNext()) {
            object = (LayoutAnchor)iterator.next();
            stringBuffer.append(object);
            if (++n >= this.numChildren() - 1) continue;
            stringBuffer.append("\n");
        }
        if (n > 0) {
            stringBuffer.append("\n");
        }
        if (this.numChildren() > 0) {
            stringBuffer.append("Children:\n");
        }
        object = this.getChildren();
        while (object.hasNext()) {
            LayoutBox layoutBox = (LayoutBox)object.next();
            stringBuffer.append(layoutBox);
        }
        stringBuffer.append("Data: ");
        stringBuffer.append(this.data);
        stringBuffer.append("\n");
        stringBuffer.append("end ");
        stringBuffer.append(this.name);
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    public void setDag(Dag dag) {
        this.dag = dag;
    }

    public void setAllDags(Dag dag) {
        for (int i = 0; i < this.numChildren(); ++i) {
            this.getChild(i).setAllDags(dag);
        }
        this.setDag(dag);
    }

    public Dag getDag() {
        return this.dag;
    }

    public String getName() {
        return this.name;
    }

    private class ChildArrayIterator
    implements Iterator {
        int position = 0;

        private ChildArrayIterator() {
        }

        public boolean hasNext() {
            return this.position < AbstractBranchLayoutBox.this.numChildren;
        }

        public Object next() {
            return AbstractBranchLayoutBox.this.getChild(this.position++);
        }

        public void remove() {
            AbstractBranchLayoutBox.this.removeChild(this.position);
        }
    }
}

