/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.dag;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.dag.DagUtil;
import com.maplesoft.client.dag.RtableData;
import com.maplesoft.util.WmiByteArrayInputStream;
import java.io.IOException;

public class RtableIntData
extends RtableData {
    int[] theData;
    int[] theDimensions;
    String theName;

    public boolean equals(Object object) {
        if (!(object instanceof RtableIntData)) {
            return false;
        }
        RtableIntData rtableIntData = (RtableIntData)object;
        if (this.theData != rtableIntData.theData && this.theData != null) {
            if (this.theData.length != rtableIntData.theData.length) {
                return false;
            }
            for (int i = 0; i < this.theData.length; ++i) {
                if (this.theData[i] == rtableIntData.theData[i]) continue;
                return false;
            }
        }
        return true;
    }

    public void readDotm(WmiByteArrayInputStream wmiByteArrayInputStream, int[] nArray, int[] nArray2) throws IOException {
        super.readDotm(wmiByteArrayInputStream, nArray, nArray2);
        this.theData = new int[nArray[0]];
        this.theDimensions = nArray2;
        for (int i = 0; i < nArray[0]; ++i) {
            this.theData[i] = DagBuilder.parseShortInteger(wmiByteArrayInputStream);
        }
    }

    public StringBuffer writeDotm() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.theData.length; ++i) {
            DagBuilder.writeShortInteger(stringBuffer, this.theData[i]);
        }
        return stringBuffer;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[ ");
        for (int i = 0; i < this.theData.length; ++i) {
            stringBuffer.append(this.theData[i]);
            stringBuffer.append(" ");
        }
        stringBuffer.append("] ");
        return stringBuffer.toString();
    }

    public int[] getDimensions() {
        return this.theDimensions;
    }

    public int getIntegerAt(int[] nArray) {
        return this.theData[0];
    }

    public double getDoubleAt(int[] nArray) {
        return this.theData[0];
    }

    public double getDoubleAt(int n, int n2) {
        return this.theData[0];
    }

    public float getFloatAt(int[] nArray) {
        return this.theData[0];
    }

    public Dag getDagAt(int[] nArray) {
        return null;
    }

    public Dag getDagAt(int n, int n2) {
        return null;
    }

    public int getIntegerAt(int n) {
        return this.theData[n];
    }

    public double getDoubleAt(int n) {
        return this.theData[n];
    }

    public float getFloatAt(int n) {
        return this.theData[n];
    }

    public Dag getDagAt(int n) {
        return DagUtil.createIntDag(this.theData[n]);
    }

    public String getNamedArray() {
        return this.theName;
    }
}

