/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.dag;

import com.maplesoft.client.MapleNumbers;
import com.maplesoft.client.dag.AbstractDagFactory;
import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.dag.DagConstants;
import com.maplesoft.client.dag.DagUtil;
import com.maplesoft.client.dag.RtableComplexData;
import com.maplesoft.client.dag.RtableDag;
import com.maplesoft.client.dag.RtableDagData;
import com.maplesoft.client.dag.RtableData;
import com.maplesoft.client.dag.RtableDoubleData;
import com.maplesoft.client.dag.RtableIntData;
import com.maplesoft.client.dag.RtableShortData;
import com.maplesoft.client.dag.WmiLPrintOptions;
import com.maplesoft.client.dag.util.RTableElementAccessor;
import com.maplesoft.client.dag.util.RTableFlagConverter;
import com.maplesoft.client.prettyprinter.AbstractLayoutBox;
import com.maplesoft.client.prettyprinter.DefaultLayoutBox;
import com.maplesoft.client.prettyprinter.LayoutBox;
import com.maplesoft.client.prettyprinter.LayoutFormatter;
import com.maplesoft.client.prettyprinter.NotationLayoutBox;
import com.maplesoft.client.prettyprinter.selection.SelectionData;
import com.maplesoft.util.WmiByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RtableDagFactory
extends AbstractDagFactory {
    public static final int RTABLE_DATA = 0;
    public static final int RTABLE_MAPLETYPE = 1;
    public static final int RTABLE_INDFN = 2;
    public static final int RTABLE_ATTRIB = 3;
    public static final int RTABLE_FLAGS = 4;
    public static final int RTABLE_NUMELEMS = 5;
    public static final int RTABLE_BOUNDS = 6;
    public static final int RTABLE_FLAG_COUNT = 7;
    private static final int RTABLE_NUMDIMS_LENGTH = 6;
    private static final int RTABLE_RESERVED_LENGTH = 10;
    private static final int RTABLE_EVAL_LENGTH = 1;
    private static final int RTABLE_LITERAL_LENGTH = 1;
    private static final int RTABLE_FOREIGN_LENGTH = 1;
    private static final int RTABLE_READONLY_LENGTH = 1;
    private static final int RTABLE_ORDER_LENGTH = 1;
    private static final int RTABLE_STORAGE_LENGTH = 4;
    private static final int RTABLE_SUBTYPE_LENGTH = 2;
    private static final int RTABLE_DATATYPE_LENGTH = 5;
    private static final int RTABLE_NUMDIMS_OFFSET = 0;
    private static final int RTABLE_RESERVED_OFFSET = 6;
    private static final int RTABLE_EVAL_OFFSET = 16;
    private static final int RTABLE_LITERAL_OFFSET = 17;
    private static final int RTABLE_FOREIGN_OFFSET = 18;
    private static final int RTABLE_READONLY_OFFSET = 19;
    private static final int RTABLE_ORDER_OFFSET = 20;
    private static final int RTABLE_STORAGE_OFFSET = 21;
    private static final int RTABLE_SUBTYPE_OFFSET = 25;
    private static final int RTABLE_DATATYPE_OFFSET = 27;
    private static final int RTABLE_NUMDIMS_MASK = 63;
    private static final int RTABLE_RESERVED_MASK = 65472;
    private static final int RTABLE_EVAL_MASK = 65536;
    private static final int RTABLE_LITERAL_MASK = 131072;
    private static final int RTABLE_FOREIGN_MASK = 262144;
    private static final int RTABLE_READONLY_MASK = 524288;
    private static final int RTABLE_ORDER_MASK = 0x100000;
    private static final int RTABLE_STORAGE_MASK = 0x1E00000;
    private static final int RTABLE_SUBTYPE_MASK = 0x6000000;
    private static final int RTABLE_DATATYPE_MASK = -134217728;
    private static final int RTABLE_FLAG_MASK = -65473;
    boolean shortOutput = false;

    public int getType() {
        return 38;
    }

    public Dag readDotm(WmiByteArrayInputStream wmiByteArrayInputStream) throws IOException {
        return this.readDotm(wmiByteArrayInputStream, 38, DagBuilder.parseShortInteger(wmiByteArrayInputStream));
    }

    protected Dag readDotm(WmiByteArrayInputStream wmiByteArrayInputStream, int n, int n2) throws IOException {
        int n3 = 0;
        if (n != 57 && n != 56) {
            n3 = DagBuilder.dagCountPlus();
        }
        RtableDag rtableDag = new RtableDag();
        rtableDag.setType(n);
        Object[] objectArray = new Dag[n2];
        Arrays.fill(objectArray, DagConstants.EMPTY);
        rtableDag.setChildren((Dag[])objectArray);
        objectArray[1] = DagBuilder.create(wmiByteArrayInputStream);
        objectArray[2] = DagBuilder.create(wmiByteArrayInputStream);
        objectArray[3] = DagBuilder.create(wmiByteArrayInputStream);
        int[] nArray = new int[7];
        int n4 = DagBuilder.parseShortInteger(wmiByteArrayInputStream);
        if (n4 >> 6 == 7) {
            nArray[0] = DagBuilder.parseShortInteger(wmiByteArrayInputStream);
            nArray[1] = DagBuilder.parseShortInteger(wmiByteArrayInputStream);
            nArray[2] = DagBuilder.parseShortInteger(wmiByteArrayInputStream);
            nArray[3] = DagBuilder.parseShortInteger(wmiByteArrayInputStream);
            nArray[4] = DagBuilder.parseShortInteger(wmiByteArrayInputStream);
            nArray[5] = DagBuilder.parseShortInteger(wmiByteArrayInputStream);
            nArray[6] = DagBuilder.parseShortInteger(wmiByteArrayInputStream);
        } else {
            int n5 = n4;
            nArray[6] = (n5 & 0x3F) >> 0;
            nArray[0] = ((n5 >>= 1) & 0xF8000000) >> 27;
            nArray[1] = (n5 & 0x6000000) >> 25;
            nArray[2] = (n5 & 0x1E00000) >> 21;
            nArray[3] = (n5 & 0x100000) >> 20;
            nArray[4] = (n5 & 0x80000) >> 19;
            nArray[5] = (n5 & 0xFFC0) >> 6;
        }
        rtableDag.setFlags(nArray);
        int[] nArray2 = new int[n2 - 6];
        int n6 = nArray[6];
        for (int i = 6; i < n2; ++i) {
            nArray2[i - 6] = DagBuilder.parseShortInteger(wmiByteArrayInputStream);
        }
        int[] nArray3 = new int[n6];
        int n7 = 2;
        int n8 = 0;
        while (n7 <= nArray3.length * 2) {
            nArray3[n8] = nArray2[n7];
            n7 += 2;
            ++n8;
        }
        rtableDag.setSizes(nArray2);
        RtableData rtableData = null;
        n8 = nArray[0];
        switch (n8) {
            case 1: {
                break;
            }
            case 0: {
                rtableData = new RtableDagData();
                break;
            }
            case 2: {
                rtableData = new RtableShortData();
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                rtableData = new RtableIntData();
                break;
            }
            case 8: {
                break;
            }
            case 6: {
                rtableData = new RtableDoubleData();
                break;
            }
            case 7: {
                rtableData = new RtableComplexData();
                break;
            }
        }
        if (rtableData != null) {
            ((RtableData)rtableData).readDotm(wmiByteArrayInputStream, nArray2, nArray3);
            rtableDag.setTableData(rtableData);
        }
        if (n != 57 && n != 56) {
            DagBuilder.putDag(rtableDag, n3);
        }
        return rtableDag;
    }

    public Dag readDotm(WmiByteArrayInputStream wmiByteArrayInputStream, int n) throws IOException {
        return this.readDotm(wmiByteArrayInputStream, 38, n);
    }

    public void writeDotm(StringBuffer stringBuffer, Dag dag) {
        RtableDag rtableDag = (RtableDag)dag;
        int n = rtableDag.getType();
        char c = (char)(MapleNumbers.dotMOutputTable[n] + 33 - 1);
        stringBuffer.append(c);
        int n2 = rtableDag.getLength();
        DagBuilder.writeShortInteger(stringBuffer, n2);
        DagBuilder.writeDotm(stringBuffer, rtableDag.getChild(1));
        DagBuilder.writeDotm(stringBuffer, rtableDag.getChild(2));
        DagBuilder.writeDotm(stringBuffer, rtableDag.getChild(3));
        DagBuilder.writeShortInteger(stringBuffer, 448);
        DagBuilder.writeShortInteger(stringBuffer, rtableDag.getDataType());
        DagBuilder.writeShortInteger(stringBuffer, rtableDag.getSubType());
        DagBuilder.writeShortInteger(stringBuffer, rtableDag.getStorage());
        DagBuilder.writeShortInteger(stringBuffer, rtableDag.getOrder());
        DagBuilder.writeShortInteger(stringBuffer, rtableDag.getReadOnly());
        DagBuilder.writeShortInteger(stringBuffer, 0);
        DagBuilder.writeShortInteger(stringBuffer, rtableDag.getDimensionCount());
        int[] nArray = rtableDag.getSizes();
        for (int i = 0; i < nArray.length; ++i) {
            DagBuilder.writeShortInteger(stringBuffer, nArray[i]);
        }
        if (rtableDag.getDataType() != 0 || rtableDag.getStorage() != 0) {
            if (rtableDag.getStorage() == 0) {
                // empty if block
            }
            RtableData rtableData = rtableDag.getTableData();
            stringBuffer.append(rtableData.writeDotm());
        }
    }

    private static boolean isSparse(RtableDag rtableDag) {
        return rtableDag.getStorage() == 0;
    }

    private static boolean hasIndexingFunction(RtableDag rtableDag) {
        Dag dag = rtableDag.getChild(2);
        return dag.getLength() > 0;
    }

    private static int getIndexingFunctionCount(RtableDag rtableDag) {
        Dag dag = rtableDag.getChild(2);
        return dag.getLength();
    }

    private static Dag getIndexingFunctions(RtableDag rtableDag) {
        int n;
        Dag dag = rtableDag.getChild(2);
        if (dag.getChild((n = dag.getLength()) - 1).getType() == 38) {
            --n;
        }
        Dag[] dagArray = new Dag[n];
        for (int i = 0; i < n; ++i) {
            dagArray[i] = dag.getChild(i);
        }
        return DagUtil.createListDag(dagArray);
    }

    private static void lPrintTableIndex(StringBuffer stringBuffer, RtableDag rtableDag, Dag dag, WmiLPrintOptions wmiLPrintOptions) {
        stringBuffer.append("(");
        for (int i = 0; i < dag.getLength(); ++i) {
            stringBuffer.append(dag.getChild(i).getData());
            if (i >= dag.getLength() - 1) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append(")");
    }

    private static boolean lPrintTableData(StringBuffer stringBuffer, RtableDag rtableDag, int n, Dag dag, WmiLPrintOptions wmiLPrintOptions) {
        Dag dag2;
        boolean bl = false;
        if (RtableDagFactory.isSparse(rtableDag)) {
            stringBuffer.append("{");
            stringBuffer.append(" sparse_data ");
            stringBuffer.append("}");
            return false;
        }
        int n2 = rtableDag.getDimensionCount();
        int n3 = rtableDag.getRangeUpperBound(n);
        int n4 = rtableDag.getRangeLowerBound(n);
        Dag dag3 = dag2 = dag.getChild(n) != null ? dag.copy() : dag;
        if (n == 0) {
            stringBuffer.append("{");
        }
        if (n == n2 - 1) {
            for (int i = n4; i <= n3; ++i) {
                dag2.replaceChildren(n, n, DagUtil.createIntDag(i));
                Dag dag4 = RTableElementAccessor.getTableElement((RtableDag)rtableDag, (Dag)dag2);
                if (dag4 == null) continue;
                if (i > n4 && bl) {
                    stringBuffer.append(", ");
                }
                RtableDagFactory.lPrintTableIndex(stringBuffer, rtableDag, dag2, wmiLPrintOptions);
                stringBuffer.append(" = ");
                RtableDagFactory.lPrintDescendant(dag4, stringBuffer, wmiLPrintOptions);
                bl = true;
            }
        } else {
            for (int i = n4; i <= n3; ++i) {
                dag2.replaceChildren(n, n, DagUtil.createIntDag(i));
                if (!RtableDagFactory.lPrintTableData(stringBuffer, rtableDag, n + 1, dag2, wmiLPrintOptions)) continue;
                bl = true;
                if (i >= n3) continue;
                stringBuffer.append(", ");
            }
        }
        if (n == 0) {
            stringBuffer.append("}");
        }
        return bl;
    }

    private static void lPrintTableOptions(StringBuffer stringBuffer, RtableDag rtableDag, WmiLPrintOptions wmiLPrintOptions) {
        Dag dag;
        int n = rtableDag.getDataType();
        int n2 = rtableDag.getSubType();
        int n3 = rtableDag.getStorage();
        int n4 = rtableDag.getOrder();
        boolean bl = rtableDag.isReadOnly();
        if (n != 0) {
            stringBuffer.append(", datatype = ");
            stringBuffer.append(RTableFlagConverter.getDataTypeLabel((int)n));
        }
        if (n3 != 4) {
            stringBuffer.append(", storage = ");
            stringBuffer.append(RTableFlagConverter.getStorageLabel((int)n3, (RtableDag)rtableDag));
        }
        if (n4 != 0) {
            stringBuffer.append(", order = ");
            stringBuffer.append(RTableFlagConverter.getOrderLabel((int)n4));
        }
        if (bl) {
            stringBuffer.append(", readonly");
        }
        if (!DagUtil.isNull(dag = rtableDag.getChild(3))) {
            stringBuffer.append(", attributes = [");
            RtableDagFactory.lPrintDescendant(dag, stringBuffer, wmiLPrintOptions);
            stringBuffer.append("]");
        }
        if (n2 != 0 && RtableDagFactory.hasIndexingFunction(rtableDag)) {
            stringBuffer.append(", shape = ");
            Dag dag2 = RtableDagFactory.getIndexingFunctions(rtableDag);
            RtableDagFactory.lPrintDescendant(dag2, stringBuffer, wmiLPrintOptions);
        }
    }

    private static void lPrintDescendant(Dag dag, StringBuffer stringBuffer, WmiLPrintOptions wmiLPrintOptions) {
        String string = DagBuilder.lPrint(dag, wmiLPrintOptions);
        stringBuffer.append(string);
    }

    public void linePrint(StringBuffer stringBuffer, Dag dag, WmiLPrintOptions wmiLPrintOptions) {
        Dag dag2;
        int n;
        RtableDag rtableDag = (RtableDag)dag;
        int n2 = rtableDag.getSubType();
        switch (n2) {
            case 0: {
                stringBuffer.append("Array");
                stringBuffer.append("(");
                int n3 = RtableDagFactory.getIndexingFunctionCount(rtableDag);
                Dag dag3 = rtableDag.getChild(2);
                for (n = 1; n <= n3; ++n) {
                    RtableDagFactory.lPrintDescendant(dag3.getChild(n), stringBuffer, wmiLPrintOptions);
                    stringBuffer.append(",");
                }
                break;
            }
            case 1: {
                stringBuffer.append("Matrix");
                stringBuffer.append("(");
                break;
            }
            case 3: {
                stringBuffer.append("Vector[row]");
                stringBuffer.append("(");
                break;
            }
            case 2: {
                stringBuffer.append("Vector");
                stringBuffer.append("(");
            }
        }
        if (n2 == 0) {
            dag2 = DagUtil.createExpSeqDag(null);
            for (n = 0; n < rtableDag.getDimensionCount(); ++n) {
                stringBuffer.append(Integer.toString(rtableDag.getRangeLowerBound(n)));
                stringBuffer.append("..");
                stringBuffer.append(Integer.toString(rtableDag.getRangeUpperBound(n)));
                stringBuffer.append(", ");
            }
        } else {
            dag2 = DagUtil.createExpSeqDag(null);
            for (n = 0; n < rtableDag.getDimensionCount(); ++n) {
                stringBuffer.append(Integer.toString(rtableDag.getRangeUpperBound(n)));
                stringBuffer.append(", ");
            }
        }
        dag2 = DagUtil.createExpSeqDag(new Dag[rtableDag.getDimensionCount()]);
        if (rtableDag.getDimensionCount() == 0) {
            stringBuffer.append("fill = ");
            RtableDagFactory.lPrintDescendant(dag2, stringBuffer, wmiLPrintOptions);
        } else {
            RtableDagFactory.lPrintTableData(stringBuffer, rtableDag, 0, dag2, wmiLPrintOptions);
        }
        RtableDagFactory.lPrintTableOptions(stringBuffer, rtableDag, wmiLPrintOptions);
        stringBuffer.append(")");
    }

    public Element export(Dag dag, Document document) {
        Element element = null;
        int n = dag.getType();
        RtableDag rtableDag = (RtableDag)dag;
        element = document.createElement(DagBuilder.ELEMENT_NAME[n]);
        RtableData rtableData = rtableDag.getTableData();
        element.setAttribute("data", rtableData.getNamedArray());
        return element;
    }

    public LayoutBox createLayout(LayoutFormatter layoutFormatter, Dag dag) {
        int n = dag.getType();
        AbstractLayoutBox abstractLayoutBox = null;
        abstractLayoutBox = new DefaultLayoutBox(DagBuilder.ELEMENT_NAME[n]);
        this.shortOutput = true;
        StringBuffer stringBuffer = new StringBuffer();
        this.linePrint(stringBuffer, dag, new WmiLPrintOptions());
        abstractLayoutBox = NotationLayoutBox.createCustomBox(layoutFormatter, stringBuffer.toString());
        SelectionData selectionData = new SelectionData(1);
        selectionData.setStandardEastWestArray(abstractLayoutBox);
        selectionData.setStandardNorthSouthArray();
        abstractLayoutBox.setSelectionData(selectionData);
        return abstractLayoutBox;
    }

    public static RtableDag createFromDoubleArray(double[] dArray) {
        RtableDag rtableDag = new RtableDag();
        int n = 3;
        Dag[] dagArray = new Dag[n + 3];
        for (int i = 0; i < n + 3; ++i) {
            dagArray[i] = i == 1 ? Dag.createDag(8, null, "anything", false) : DagConstants.EMPTY;
        }
        rtableDag.setChildren(dagArray);
        int[] nArray = new int[7];
        nArray[0] = 6;
        nArray[1] = 0;
        nArray[2] = 4;
        nArray[3] = 0;
        nArray[6] = 1;
        rtableDag.setFlags(nArray);
        int[] nArray2 = new int[]{dArray.length, 0, dArray.length - 1};
        rtableDag.setSizes(nArray2);
        RtableDoubleData rtableDoubleData = new RtableDoubleData();
        rtableDoubleData.setDoubleData(dArray);
        rtableDag.setTableData(rtableDoubleData);
        return rtableDag;
    }
}

