/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.dag;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.dag.DagUtil;
import com.maplesoft.client.dag.RtableData;
import com.maplesoft.util.WmiByteArrayInputStream;
import java.io.IOException;

public class RtableDagData
extends RtableData {
    private Dag[] theData;
    private String theName;

    public RtableDagData() {
    }

    public RtableDagData(Dag[] dagArray, String string, int[] nArray, int[] nArray2) {
        this.theDimensions = nArray2;
        this.sizes = nArray;
        this.theData = dagArray;
        this.theName = string;
        this.calculatedMultipliers();
    }

    public void readDotm(WmiByteArrayInputStream wmiByteArrayInputStream, int[] nArray, int[] nArray2) throws IOException {
        super.readDotm(wmiByteArrayInputStream, nArray, nArray2);
        this.theData = new Dag[nArray[0]];
        for (int i = 0; i < nArray[0]; ++i) {
            this.theData[i] = DagBuilder.create(wmiByteArrayInputStream);
        }
    }

    public StringBuffer writeDotm() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.theData.length; ++i) {
            DagBuilder.writeDotm(stringBuffer, this.theData[i]);
        }
        return stringBuffer;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[ ");
        for (int i = 0; i < this.theData.length; ++i) {
            DagBuilder.linePrint(stringBuffer, this.theData[i]);
            if (i >= this.theData.length - 1) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("] ");
        return stringBuffer.toString();
    }

    public int getIntegerAt(int[] nArray) {
        int n = this.getPosition(nArray);
        return DagUtil.parseInt(this.theData[n]);
    }

    public double getDoubleAt(int[] nArray) {
        int n = this.getPosition(nArray);
        return DagUtil.parseDouble(this.theData[n]);
    }

    public float getFloatAt(int[] nArray) {
        int n = this.getPosition(nArray);
        return DagUtil.parseFloat(this.theData[n]);
    }

    public Dag getDagAt(int[] nArray) {
        int n = this.getPosition(nArray);
        return this.theData[n];
    }

    public int getIntegerAt(int n) {
        return DagUtil.parseInt(this.theData[n]);
    }

    public double getDoubleAt(int n) {
        return DagUtil.parseDouble(this.theData[n]);
    }

    public float getFloatAt(int n) {
        return DagUtil.parseFloat(this.theData[n]);
    }

    public Dag getDagAt(int n) {
        return n >= 0 && n < this.theData.length ? this.theData[n] : null;
    }

    public String getNamedArray() {
        return this.theName;
    }

    public Dag getDagAt(int n, int n2) {
        int n3 = this.getPosition(n, n2);
        return this.theData[n3];
    }

    public void setDagAt(int[] nArray, Dag dag) {
        int n = this.getPosition(nArray);
        this.theData[n] = dag;
    }

    public void setDagAt(int n, int n2, Dag dag) {
        int n3 = this.getPosition(n, n2);
        this.theData[n3] = dag;
    }

    protected void calculatedMultipliers() {
        this.theMultipliers = new int[this.theDimensions.length];
        for (int i = 0; i < this.theDimensions.length; ++i) {
            if (i == this.theDimensions.length - 1) {
                this.theMultipliers[i] = 0;
                continue;
            }
            this.theMultipliers[i] = 1;
            for (int j = i; j < this.theDimensions.length - 1; ++j) {
                int n = i;
                this.theMultipliers[n] = this.theMultipliers[n] * (this.sizes[2 * j + 2] - this.sizes[2 * j + 1] + 1);
            }
        }
    }
}

