/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.dag;

import com.maplesoft.client.dag.AbstractBinopDagFactory;
import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.dag.DagConstants;
import com.maplesoft.client.dag.DagUtil;
import com.maplesoft.client.dag.WmiLPrintOptions;
import com.maplesoft.client.prettyprinter.InlineLayoutBox;
import com.maplesoft.client.prettyprinter.LayoutBox;
import com.maplesoft.client.prettyprinter.LayoutFormatter;
import com.maplesoft.client.prettyprinter.NotationLayoutBox;
import com.maplesoft.client.prettyprinter.TTYFormatter;
import com.maplesoft.client.prettyprinter.template.DivideTemplate;

public class RationalDagFactory
extends AbstractBinopDagFactory {
    public int getType() {
        return 3;
    }

    public boolean isVariableLength() {
        return false;
    }

    public String getStringOperator(WmiLPrintOptions wmiLPrintOptions) {
        return "/";
    }

    public int getPrecedence() {
        return 4;
    }

    public int getPrecedence(Dag dag) {
        return DagUtil.isNegative(dag) ? 6 : 4;
    }

    public Dag toProduct(Dag dag) {
        Dag dag2 = dag.getChild(0);
        Dag dag3 = dag.getChild(1);
        Dag[] dagArray = new Dag[]{dag2, DagConstants.ONE, dag3, DagConstants.MINUS_ONE};
        return Dag.createDag(14, dagArray, null, false);
    }

    public LayoutBox createLayout(LayoutFormatter layoutFormatter, Dag dag) {
        LayoutBox layoutBox = null;
        if (layoutFormatter.useInLine(dag) || layoutFormatter.isInProc() || layoutFormatter instanceof TTYFormatter && layoutFormatter.isInSuperscript()) {
            layoutBox = super.createLayout(layoutFormatter, dag);
        } else {
            Dag dag2 = dag.getChild(0);
            Dag dag3 = dag.getChild(1);
            double d = layoutFormatter.getSafeBreakWidth();
            InlineLayoutBox inlineLayoutBox = new InlineLayoutBox(1);
            InlineLayoutBox inlineLayoutBox2 = new InlineLayoutBox(1);
            inlineLayoutBox.addChild(DagBuilder.createLayout(layoutFormatter, dag2));
            inlineLayoutBox2.addChild(DagBuilder.createLayout(layoutFormatter, dag3));
            inlineLayoutBox.applyLayout();
            inlineLayoutBox2.applyLayout();
            int n = inlineLayoutBox.getWidth() < d && inlineLayoutBox2.getWidth() < d ? 0 : 1;
            layoutBox = DivideTemplate.apply(layoutFormatter, inlineLayoutBox, inlineLayoutBox2, n);
        }
        return layoutBox;
    }

    public NotationLayoutBox createNotationBox(LayoutFormatter layoutFormatter) {
        return NotationLayoutBox.createNotationBox(layoutFormatter, 19);
    }

    public void linePrint(StringBuffer stringBuffer, Dag dag, WmiLPrintOptions wmiLPrintOptions) {
        Dag dag2 = dag.getChild(0);
        if (DagUtil.isNegative(dag2)) {
            dag = dag.copy();
            dag.setChild(0, DagUtil.negate(dag2));
            stringBuffer.append("-");
        }
        super.linePrint(stringBuffer, dag, wmiLPrintOptions);
    }
}

