/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.dag;

import com.maplesoft.client.dag.AbstractDagFactory;
import com.maplesoft.client.dag.BranchDag;
import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.dag.DagConstants;
import com.maplesoft.client.dag.DagRenderContext;
import com.maplesoft.client.dag.DagUtil;
import com.maplesoft.client.dag.LeafDag;
import com.maplesoft.client.dag.ProcDag;
import com.maplesoft.client.dag.WmiLPrintOptions;
import com.maplesoft.client.prettyprinter.LayoutBox;
import com.maplesoft.client.prettyprinter.LayoutFormatter;
import com.maplesoft.client.prettyprinter.template.ProcTemplate;
import com.maplesoft.util.WmiByteArrayInputStream;
import java.io.IOException;
import java.util.EmptyStackException;
import java.util.Stack;

public class ProcDagFactory
extends AbstractDagFactory {
    private static final boolean DEFAULT_LONGDELIM = false;
    private static final int DEFAULT_VERBOSEPROC = 0;
    private static boolean longForm = false;
    private static int verboseProc = 0;
    public static final int MIN_DAG_LENGTH = 8;
    public static final int NEW_PROC_MIN_LENGTH = 9;
    public static final int OLD_PROC_LENGTH = 7;
    private static final int FIRST = 0;
    public static final int PARAM_INDEX = 0;
    public static final int LOCAL_INDEX = 1;
    public static final int OPTION_INDEX = 2;
    public static final int REMEMBER_INDEX = 3;
    public static final int STATEMENT_INDEX = 4;
    public static final int DESCRIPTION_INDEX = 5;
    public static final int GLOBAL_INDEX = 6;
    public static final int LEXICAL_INDEX = 7;
    public static final int EOP_INDEX = 8;
    private static final int NORMAL_PARAM_COUNT = 8;
    private static Stack parameterStack_read = new Stack();
    private static Stack localStack_read = new Stack();
    private static Stack exportStack_read = new Stack();
    private static Stack lexicalStack_read = new Stack();
    public static final String END_OF_PARAM_MARKER = " $";
    private static int procSubType = 70;

    public void updateContext(DagRenderContext dagRenderContext) {
        longForm = dagRenderContext.getInterfaceProperty("longdelim", false);
        verboseProc = dagRenderContext.getInterfaceProperty("verboseproc", 0);
    }

    public static int getActiveProcSubtype() {
        return procSubType;
    }

    public static void setActiveProcSubtype(int n) {
        procSubType = n;
    }

    public static boolean useLongForm() {
        return longForm;
    }

    public static int getVerbosity() {
        return verboseProc;
    }

    public Dag readDotm(WmiByteArrayInputStream wmiByteArrayInputStream) throws IOException {
        int n = DagBuilder.parseShortInteger(wmiByteArrayInputStream);
        return this.readDotm(wmiByteArrayInputStream, n);
    }

    public Dag readDotm(WmiByteArrayInputStream wmiByteArrayInputStream, int n) throws IOException {
        Object object;
        int n2;
        int n3 = DagBuilder.dagCountPlus();
        int n4 = --n;
        int n5 = ProcDagFactory.getActiveProcSubtype();
        int n6 = n4;
        if (n < 8) {
            n4 = 8;
        }
        Dag[] dagArray = new Dag[n4];
        for (n2 = 0; n2 < n; ++n2) {
            dagArray[n2] = DagBuilder.create(wmiByteArrayInputStream);
        }
        if (n < n4) {
            for (n2 = n; n2 < n4; ++n2) {
                dagArray[n2] = DagConstants.EMPTY;
            }
        }
        Dag dag = dagArray[2];
        boolean bl = false;
        for (int i = 0; i < dag.getLength(); ++i) {
            object = dag.getChild(i).getData();
            if (null == object || !((String)object).equals("builtin")) continue;
            bl = true;
        }
        Dag dag2 = null;
        if (bl) {
            dag2 = DagBuilder.create(wmiByteArrayInputStream);
        }
        object = new ProcDag(n5, n6, dagArray);
        if (dag2 != null) {
            ((Dag)object).setAttributes(dag2);
        }
        DagBuilder.putDag((Dag)object, n3);
        return object;
    }

    public void writeDotm(StringBuffer stringBuffer, Dag dag) {
        int n = dag.getType();
        int n2 = ProcDagFactory.isABackref(dag, n);
        if (n2 > 0) {
            this.writeBackref(stringBuffer, n2);
            return;
        }
        int n3 = dag.getLength();
        char c = '\u0000';
        if (dag instanceof ProcDag) {
            c = (char)((ProcDag)dag).getSubType();
            n3 = ((ProcDag)dag).getLength();
        } else if (n3 == 9 && !dag.getChild(8).equals(DagConstants.EMPTY)) {
            c = (char)116;
        } else {
            c = (char)102;
            if (n3 == 9) {
                --n3;
            }
        }
        stringBuffer.append(c);
        if (n3 > 0) {
            DagBuilder.writeShortInteger(stringBuffer, n3 + 1);
            for (int i = 0; i < n3; ++i) {
                DagBuilder.writeDotm(stringBuffer, dag.getChild(i));
            }
            Dag dag2 = dag.getAttributes();
            if (dag2 != null) {
                DagBuilder.writeDotm(stringBuffer, dag2);
            }
        }
    }

    public static boolean hasReturnType(Dag dag) {
        boolean bl = false;
        int n = dag.getLength();
        if (dag != null && dag.getType() == 34 && n > 8) {
            Dag dag2 = dag.getChild(n - 1);
            bl = false;
            if (dag2 != null && dag2 != DagConstants.EMPTY) {
                bl = ProcDagFactory.containsNameDag(dag2);
            }
        }
        return bl;
    }

    private static boolean containsNameDag(Dag dag) {
        boolean bl = false;
        if (dag instanceof LeafDag) {
            bl = dag.getType() == 8;
        } else {
            int n = dag.getLength();
            for (int i = 0; i < n; ++i) {
                if (!ProcDagFactory.containsNameDag(dag.getChild(i))) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public int getPrecedence() {
        return 1;
    }

    public int getPrecedence(Dag dag) {
        Dag dag2 = dag.getChild(2);
        for (int i = 0; i < dag2.getLength(); ++i) {
            String string = dag2.getChild(i).getData();
            if (string == null || !string.equals("arrow")) continue;
            return 19;
        }
        return this.getPrecedence();
    }

    public static Dag getParameter(int n) {
        Dag dag = null;
        if (!parameterStack_read.empty()) {
            Dag dag2 = (Dag)parameterStack_read.peek();
            dag = n > 0 ? dag2.getChild(n - 1) : null;
        }
        return dag;
    }

    public static Dag getLocal(int n) {
        Dag dag = null;
        Dag dag2 = null;
        int n2 = 0;
        int n3 = 0;
        if (!localStack_read.empty()) {
            dag2 = (Dag)localStack_read.peek();
            n2 = dag2.getLength();
        }
        if (n - 1 >= n2) {
            Dag dag3;
            Dag dag4 = dag3 = exportStack_read.isEmpty() ? null : (Dag)exportStack_read.peek();
            if (dag3 != null && (n3 = n - n2 - 1) >= 0 && n3 < dag3.getLength()) {
                dag = dag3.getChild(n3);
            }
        } else if (dag2 != null && (n3 = n - 1) >= 0 && n3 < dag2.getLength()) {
            dag = dag2.getChild(n3);
        }
        return dag;
    }

    public static Dag getLexical(int n) {
        Dag dag = null;
        if (!lexicalStack_read.empty()) {
            Dag dag2 = (Dag)lexicalStack_read.peek();
            dag = n > 0 ? dag2.getChild(n - 1) : null;
        }
        return dag;
    }

    public static void addToStacks(Dag dag) {
        parameterStack_read.push(dag.getChild(0));
        localStack_read.push(dag.getChild(1));
        if (dag.getLength() > 7) {
            lexicalStack_read.push(dag.getChild(7));
        }
    }

    public static void addToStacks(Dag dag, Dag dag2, Dag dag3, Dag dag4) {
        parameterStack_read.push(dag);
        localStack_read.push(dag2);
        lexicalStack_read.push(dag3);
        exportStack_read.push(dag4);
    }

    public static void removeStacks(Dag dag) {
        try {
            parameterStack_read.pop();
            localStack_read.pop();
            if (dag.getLength() > 7) {
                lexicalStack_read.pop();
            }
        }
        catch (EmptyStackException emptyStackException) {
            // empty catch block
        }
    }

    public static void removeStacks() {
        parameterStack_read.pop();
        localStack_read.pop();
        lexicalStack_read.pop();
        exportStack_read.pop();
    }

    public void linePrint(StringBuffer stringBuffer, Dag dag, WmiLPrintOptions wmiLPrintOptions) {
        int n;
        DagBuilder.inProc = true;
        int n2 = dag.getLength();
        ProcDagFactory.addToStacks(dag);
        stringBuffer.append("proc ");
        stringBuffer.append("(");
        int n3 = ProcDagFactory.countNormalParams(dag);
        Dag dag2 = dag.getChild(0);
        int n4 = n3;
        if (n3 > 0 && DagUtil.isNameNamed(dag2.getChild(n3 - 1), END_OF_PARAM_MARKER)) {
            --n4;
        }
        for (n = 0; n < n4; ++n) {
            DagBuilder.linePrint(stringBuffer, dag2.getChild(n), wmiLPrintOptions);
            if (n >= dag2.getLength() - 1) continue;
            stringBuffer.append(", ");
        }
        if (dag2.getLength() > n3) {
            stringBuffer.append("{ ");
            for (n = n3; n < dag2.getLength(); ++n) {
                DagBuilder.linePrint(stringBuffer, dag2.getChild(n), wmiLPrintOptions);
                if (n >= dag2.getLength() - 1) continue;
                stringBuffer.append(", ");
            }
            stringBuffer.append(" }");
        }
        if (n4 < n3) {
            if (dag2.getLength() > n3) {
                stringBuffer.append(", ");
            }
            DagBuilder.linePrint(stringBuffer, dag2.getChild(n4), wmiLPrintOptions);
        }
        stringBuffer.append(")");
        if (ProcDagFactory.hasReturnType(dag)) {
            Dag dag3 = dag.getChild(n2 - 1);
            stringBuffer.append("::");
            DagBuilder.linePrint(stringBuffer, dag3, wmiLPrintOptions);
            stringBuffer.append(";");
        }
        stringBuffer.append(" ");
        Dag dag4 = dag.getChild(1);
        if (dag4.getLength() > 0) {
            stringBuffer.append("local ");
            DagBuilder.linePrint(stringBuffer, dag4, wmiLPrintOptions);
            stringBuffer.append("; ");
        }
        if ((dag4 = dag.getChild(2)).getLength() > 0) {
            if (dag4.getLength() > 1) {
                stringBuffer.append("options ");
            } else {
                stringBuffer.append("option ");
            }
            DagBuilder.linePrint(stringBuffer, dag4, wmiLPrintOptions);
            stringBuffer.append("; ");
        }
        if ((dag4 = dag.getChild(6)).getLength() > 0) {
            stringBuffer.append("global ");
            DagBuilder.linePrint(stringBuffer, dag4, wmiLPrintOptions);
            stringBuffer.append("; ");
        }
        if (!((dag4 = dag.getChild(5)) instanceof BranchDag) || dag4.getLength() > 0) {
            stringBuffer.append("description ");
            DagBuilder.linePrint(stringBuffer, dag4, wmiLPrintOptions);
            stringBuffer.append("; ");
        }
        if ((dag4 = dag.getChild(3)).getLength() > 0) {
            DagBuilder.linePrint(stringBuffer, dag4, wmiLPrintOptions);
            stringBuffer.append(" ");
        }
        if ((dag4 = dag.getChild(4)) != null) {
            DagBuilder.linePrint(stringBuffer, dag4, wmiLPrintOptions);
            if (dag4.getType() == 29) {
                if (dag4.getLength() > 0) {
                    stringBuffer.append(" ");
                }
            } else {
                stringBuffer.append(" ");
            }
        }
        stringBuffer.append("end proc");
        ProcDagFactory.removeStacks(dag);
        DagBuilder.inProc = false;
    }

    public static int countNormalParams(Dag dag) {
        Dag dag2;
        Dag dag3;
        int n = dag.getChild(0).getLength();
        if (dag.getLength() > 8 && (dag3 = dag.getChild(8)) != null && !DagUtil.isNull(dag3) && DagUtil.isExpSeq(dag3) && (dag2 = dag3.getChild(0)).getType() == 2) {
            n = Integer.parseInt(dag2.getData());
        }
        return n;
    }

    public LayoutBox createLayout(LayoutFormatter layoutFormatter, Dag dag) {
        LayoutBox layoutBox = null;
        ProcDagFactory.addToStacks(dag);
        layoutFormatter.incProcCount();
        layoutBox = ProcTemplate.apply(layoutFormatter, dag);
        layoutFormatter.decProcCount();
        ProcDagFactory.removeStacks(dag);
        return layoutBox;
    }
}

