/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.dag;

import com.maplesoft.client.MapleNumbers;
import com.maplesoft.client.dag.AbstractDagFactory;
import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.dag.DagUtil;
import com.maplesoft.client.dag.WmiLPrintOptions;
import com.maplesoft.client.prettyprinter.LayoutBox;
import com.maplesoft.client.prettyprinter.LayoutFormatter;
import com.maplesoft.client.prettyprinter.NotationLayoutBox;
import com.maplesoft.client.prettyprinter.linebreaker.LineBreakerFactory;
import com.maplesoft.util.WmiByteArrayInputStream;
import java.io.IOException;

public class HfloatDagFactory
extends AbstractDagFactory {
    public Dag readDotm(WmiByteArrayInputStream wmiByteArrayInputStream) throws IOException {
        int n = DagBuilder.dagCountPlus();
        long l = 0L;
        for (int i = 0; i < 16; ++i) {
            int n2 = wmiByteArrayInputStream.read();
            if (n2 <= 57) {
                n2 -= 48;
            } else {
                n2 -= 65;
                n2 += 10;
            }
            l = (l << 4) + (long)n2;
        }
        Dag dag = Dag.createDag(5, null, Long.toString(l), false);
        DagBuilder.putDag(dag, n);
        return dag;
    }

    public void writeDotm(StringBuffer stringBuffer, Dag dag) {
        int n = HfloatDagFactory.isABackref(dag, 5);
        if (n > 0) {
            this.writeBackref(stringBuffer, n);
            return;
        }
        char c = (char)(MapleNumbers.dotMOutputTable[5] + 33 - 1);
        stringBuffer.append(c);
        long l = Long.parseLong(dag.getData());
        String string = Long.toHexString(l);
        int n2 = 16 - string.length();
        for (int i = 0; i < n2; ++i) {
            stringBuffer.append('0');
        }
        stringBuffer.append(string.toUpperCase());
    }

    public static double getDoubleValue(Dag dag) {
        double d = 0.0;
        if (dag != null && dag.getType() == 5) {
            try {
                String string = dag.getData();
                if (string != null) {
                    long l = Long.parseLong(string);
                    d = Double.longBitsToDouble(l);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return d;
    }

    public void linePrint(StringBuffer stringBuffer, Dag dag, WmiLPrintOptions wmiLPrintOptions) {
        stringBuffer.append("HFloat(");
        stringBuffer.append(HfloatDagFactory.toString(dag));
        stringBuffer.append(")");
    }

    public static String toString(Dag dag) {
        double d = HfloatDagFactory.getDoubleValue(dag);
        String string = Double.toString(d);
        string = string.equals("Infinity") ? "HFloat(infinity)" : (string.equals("-Infinity") ? "HFloat(-infinity)" : (string.equals("NaN") ? "HFloat(undefined)" : string.toLowerCase()));
        return string;
    }

    public LayoutBox createLayout(LayoutFormatter layoutFormatter, Dag dag) {
        String string = DagBuilder.lPrint(dag, new WmiLPrintOptions());
        NotationLayoutBox notationLayoutBox = layoutFormatter.createNotationBox(5, string, 4);
        notationLayoutBox.setLineBreaker(LineBreakerFactory.newLineBreaker((int)4));
        return notationLayoutBox;
    }

    public int getPrecedence() {
        return 2;
    }

    public int getPrecedence(Dag dag) {
        return DagUtil.isNegative(dag) ? 6 : 2;
    }
}

