/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.dag;

import com.maplesoft.client.dag.AbstractDagFactory;
import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.dag.DagRenderContext;
import com.maplesoft.client.dag.DagUtil;
import com.maplesoft.client.dag.WmiLPrintOptions;
import com.maplesoft.client.prettyprinter.LayoutBox;
import com.maplesoft.client.prettyprinter.LayoutFormatter;
import com.maplesoft.client.prettyprinter.selection.SelectionData;
import com.maplesoft.client.prettyprinter.selection.StandardSelectionData;
import com.maplesoft.client.prettyprinter.template.FloatTemplate;
import com.maplesoft.util.WmiByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;

public class FloatDagFactory
extends AbstractDagFactory {
    private static final SelectionData noHelpSD;
    public static final int SCIENTIFIC_NOTATION_THRESHOLD = 6;
    public static final String TEN_STRING = "10";
    static final /* synthetic */ boolean $assertionsDisabled;

    public Dag readDotm(WmiByteArrayInputStream wmiByteArrayInputStream) throws IOException {
        return this.readDotm(wmiByteArrayInputStream, 4, 3);
    }

    public void writeDotm(StringBuffer stringBuffer, Dag dag) {
        this.writeDotm(stringBuffer, dag, 4, false);
    }

    public int getPrecedence() {
        return 2;
    }

    public int getPrecedence(Dag dag) {
        return DagUtil.isNegative(dag) ? 6 : 2;
    }

    public void updateContext(DagRenderContext dagRenderContext) {
        FloatTemplate.updateContext(dagRenderContext);
    }

    public void linePrint(StringBuffer stringBuffer, Dag dag, WmiLPrintOptions wmiLPrintOptions) {
        dag.getLength();
        Dag dag2 = dag.getChild(0);
        Dag dag3 = dag.getChild(1);
        if (dag3.getType() == 8) {
            stringBuffer.append("Float(");
            if (DagUtil.isMinusOne(dag2)) {
                stringBuffer.append("-");
            }
            DagBuilder.linePrint(stringBuffer, dag3, wmiLPrintOptions);
            stringBuffer.append(")");
        } else {
            stringBuffer.append(this.processFloat(dag, wmiLPrintOptions));
        }
    }

    public StringBuffer processFloat(Dag dag, WmiLPrintOptions wmiLPrintOptions) {
        dag.getLength();
        StringBuffer stringBuffer = new StringBuffer();
        String string = dag.getChild(0).getData();
        String string2 = DagBuilder.lPrint(dag.getChild(1), wmiLPrintOptions);
        if (string != null && string2 != null) {
            try {
                long l;
                if (dag.getChild(0).getType() == 1) {
                    stringBuffer.append("-");
                }
                if ((l = (long)FloatTemplate.calculateExponent(dag.getChild(1))) > 0L || l < (long)(-1 * string.length())) {
                    stringBuffer.append("0.");
                    stringBuffer.append(string);
                    stringBuffer.append("e");
                    stringBuffer.append(l += (long)string.length());
                } else {
                    if (!($assertionsDisabled || l < Integer.MAX_VALUE && l > Integer.MIN_VALUE)) {
                        throw new AssertionError();
                    }
                    int n = string.length() + (int)l;
                    if (n < 0) {
                        byte[] byArray = new byte[2 - n];
                        Arrays.fill(byArray, (byte)48);
                        byArray[1] = 46;
                        stringBuffer.append(new String(byArray));
                        stringBuffer.append(string);
                    } else if (n > string.length()) {
                        byte[] byArray = new byte[n - string.length()];
                        Arrays.fill(byArray, (byte)48);
                        stringBuffer.append(string);
                        stringBuffer.append(new String(byArray));
                    } else {
                        stringBuffer.append(string.substring(0, n));
                        stringBuffer.append('.');
                        stringBuffer.append(string.substring(n));
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return stringBuffer;
    }

    public LayoutBox createLayout(LayoutFormatter layoutFormatter, Dag dag) {
        return FloatTemplate.apply(layoutFormatter, dag.getChild(0), dag.getChild(1));
    }

    static {
        $assertionsDisabled = !FloatDagFactory.class.desiredAssertionStatus();
        noHelpSD = new StandardSelectionData(2);
        noHelpSD.setContextHelpAvailable(false);
    }
}

