/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.dag;

import com.maplesoft.client.dag.AbstractDagFactory;
import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.dag.DagConstants;
import com.maplesoft.client.dag.DagRenderContext;
import com.maplesoft.client.dag.DagUtil;
import com.maplesoft.client.dag.ProdDagFactory;
import com.maplesoft.client.dag.SumDagFactory;
import com.maplesoft.client.dag.WmiLPrintOptions;
import com.maplesoft.client.prettyprinter.InlineLayoutBox;
import com.maplesoft.client.prettyprinter.LayoutBox;
import com.maplesoft.client.prettyprinter.LayoutFormatter;
import com.maplesoft.client.prettyprinter.linebreaker.LineBreaker;
import com.maplesoft.client.prettyprinter.linebreaker.LineBreakerFactory;
import com.maplesoft.client.prettyprinter.selection.StandardSelectionData;
import com.maplesoft.client.prettyprinter.template.BinaryOperationTemplate;
import com.maplesoft.client.prettyprinter.template.UnaryOperationTemplate;
import com.maplesoft.util.WmiByteArrayInputStream;
import java.io.IOException;

public class ComplexDagFactory
extends AbstractDagFactory {
    static Dag pureImaginary = null;
    static Dag complexUnit = null;
    static Dag unity = null;

    public void updateContext(DagRenderContext dagRenderContext) {
        Object object = dagRenderContext.getInterfaceProperty("imaginaryunit");
        if (object != null) {
            complexUnit = Dag.createDag(8, null, object.toString(), false);
        }
    }

    public int getPrecedence(Dag dag) {
        Dag dag2;
        int n = 6;
        int n2 = dag.getLength();
        if (n2 == 1 && !DagUtil.isNegative(dag2 = dag.getChild(0))) {
            n = DagUtil.isOne(dag2) ? 1 : 4;
        }
        return n;
    }

    public Dag readDotm(WmiByteArrayInputStream wmiByteArrayInputStream) throws IOException {
        return this.readDotm(wmiByteArrayInputStream, 6, DagBuilder.parseShortInteger(wmiByteArrayInputStream));
    }

    public void writeDotm(StringBuffer stringBuffer, Dag dag) {
        this.writeDotm(stringBuffer, dag, 6, true);
    }

    public void linePrint(StringBuffer stringBuffer, Dag dag, WmiLPrintOptions wmiLPrintOptions) {
        Dag dag2 = null;
        Dag dag3 = null;
        int n = dag.getLength();
        if (n == 1) {
            dag2 = dag.getChild(0);
            if (DagUtil.isMinusOne(dag2)) {
                stringBuffer.append("-");
            } else if (!DagUtil.isOne(dag2)) {
                DagBuilder.linePrint(stringBuffer, dag2, wmiLPrintOptions);
                stringBuffer.append("*");
            }
            stringBuffer.append(wmiLPrintOptions.getImaginaryUnit());
        } else {
            dag3 = dag.getChild(0);
            dag2 = dag.getChild(1);
            DagBuilder.linePrint(stringBuffer, dag3, wmiLPrintOptions);
            if (DagUtil.isMinusOne(dag2)) {
                stringBuffer.append("-");
            } else {
                if (!DagUtil.isNegative(dag2)) {
                    stringBuffer.append("+");
                }
                if (!DagUtil.isOne(dag2)) {
                    boolean bl;
                    boolean bl2 = bl = DagBuilder.getPrecedence(dag2, wmiLPrintOptions) > 4;
                    if (bl) {
                        stringBuffer.append("(");
                    }
                    DagBuilder.linePrint(stringBuffer, dag2, wmiLPrintOptions);
                    if (bl) {
                        stringBuffer.append(")");
                    }
                    stringBuffer.append("*");
                }
            }
            stringBuffer.append(wmiLPrintOptions.getImaginaryUnit());
        }
    }

    public Dag normalize(Dag dag) {
        Dag dag2 = null;
        if (dag != null && dag.getType() == 6) {
            dag2 = dag.isNormalized() ? dag : this.doNormalization(dag);
        }
        return dag2;
    }

    public Dag doNormalization(Dag dag) {
        Dag dag2 = null;
        int n = dag.getLength();
        if (n == 1) {
            Dag dag3 = dag.getChild(0);
            if (DagUtil.isNegative(dag3)) {
                Dag dag4 = null;
                dag4 = DagUtil.isMinusOne(dag3) ? pureImaginary : ProdDagFactory.create(DagUtil.negate(dag3), 1, pureImaginary, 1);
                Dag[] dagArray = new Dag[]{dag4, DagConstants.MINUS_ONE};
                dag2 = Dag.createDag(16, dagArray, null, false);
            } else {
                dag2 = DagUtil.isOne(dag3) ? pureImaginary : ProdDagFactory.create(dag3, 1, pureImaginary, 1);
            }
        } else {
            Dag[] dagArray = new Dag[4];
            Dag dag5 = dag.getChild(0);
            if (DagUtil.isNegative(dag5)) {
                dagArray[0] = DagUtil.negate(dag5);
                dagArray[1] = DagConstants.MINUS_ONE;
            } else {
                dagArray[0] = dag5;
                dagArray[1] = DagConstants.ONE;
            }
            dag5 = dag.getChild(1);
            if (DagUtil.isNegative(dag5)) {
                dag5 = DagUtil.negate(dag5);
                dagArray[3] = DagConstants.MINUS_ONE;
            } else {
                dagArray[3] = DagConstants.ONE;
            }
            dagArray[2] = DagUtil.isOne(dag5) ? pureImaginary : ProdDagFactory.create(dag5, 1, pureImaginary, 1);
            dag2 = Dag.createDag(16, dagArray, null, false);
        }
        dag.setNormalized(dag2);
        return dag2;
    }

    public LayoutBox createLayout(LayoutFormatter layoutFormatter, Dag dag) {
        String string = DagBuilder.ELEMENT_NAME[6];
        int n = dag.getLength();
        ComplexLayoutBox complexLayoutBox = new ComplexLayoutBox(string, n + 2);
        if (n == 1) {
            this.createLayoutForPureImaginary(layoutFormatter, dag, complexLayoutBox);
        } else {
            this.createLayoutForRealAndImaginary(layoutFormatter, dag, complexLayoutBox);
        }
        complexLayoutBox.setSelectionData(new StandardSelectionData(2));
        return complexLayoutBox;
    }

    public void createLayoutForRealAndImaginary(LayoutFormatter layoutFormatter, Dag dag, LayoutBox layoutBox) {
        Dag dag2 = null;
        int n = 1;
        Dag dag3 = dag.getChild(0);
        Dag dag4 = dag.getChild(1);
        if (DagUtil.isNegative(dag3)) {
            Dag[] dagArray = new Dag[]{DagUtil.negate(dag3), DagUtil.createIntDag(-1)};
            dag2 = SumDagFactory.create(dagArray);
        } else {
            dag2 = dag3;
        }
        BinaryOperationTemplate.apply(layoutFormatter, layoutBox, n, dag2, this.getPrecedence(dag));
        if (!DagUtil.isNegative(dag4)) {
            dag2 = DagUtil.isOne(dag4) ? complexUnit : ProdDagFactory.create(dag4, complexUnit);
        } else {
            dag2 = DagUtil.isMinusOne(dag4) ? complexUnit : (DagUtil.isNegative(dag4) ? ProdDagFactory.create(DagUtil.negate(dag4), complexUnit) : ProdDagFactory.create(dag4, complexUnit));
            n = 2;
        }
        BinaryOperationTemplate.apply(layoutFormatter, layoutBox, n, dag2, this.getPrecedence(dag));
    }

    public void createLayoutForPureImaginary(LayoutFormatter layoutFormatter, Dag dag, LayoutBox layoutBox) {
        Dag dag2 = null;
        Dag dag3 = dag.getChild(0);
        if (DagUtil.isPositive(dag3)) {
            dag2 = DagUtil.isOne(dag3) ? complexUnit : ProdDagFactory.create(dag3, complexUnit);
            BinaryOperationTemplate.apply(layoutFormatter, layoutBox, 1, dag2, this.getPrecedence(dag));
        } else {
            int n;
            int n2 = n = dag3.getType() == 3 || ProdDagFactory.isQuotient(dag3) ? 111 : 24;
            if (DagUtil.isMinusOne(dag3)) {
                dag2 = complexUnit;
                layoutBox.addChild(UnaryOperationTemplate.apply(layoutFormatter, n, dag2, this.getPrecedence(dag)));
            } else if (DagUtil.isNegative(dag3)) {
                dag2 = ProdDagFactory.create(DagUtil.negate(dag3), complexUnit);
                layoutBox.addChild(UnaryOperationTemplate.apply(layoutFormatter, n, dag2, this.getPrecedence(dag)));
            } else {
                dag2 = ProdDagFactory.create(dag3, complexUnit);
                layoutBox = DagBuilder.createLayout(layoutFormatter, dag2);
            }
        }
    }

    static {
        Dag[] dagArray = new Dag[]{DagConstants.ONE};
        pureImaginary = Dag.createDag(6, dagArray, null, false);
        pureImaginary.setNormalized(pureImaginary);
        complexUnit = Dag.createDag(8, null, "I", false);
        unity = Dag.createDag(2, null, "1", false);
    }

    static class ComplexLayoutBox
    extends InlineLayoutBox {
        private static LineBreaker lb = LineBreakerFactory.newLineBreaker((int)10);

        ComplexLayoutBox(String string, int n) {
            super(string, n);
        }

        ComplexLayoutBox() {
        }

        public void setLineBreaker(LineBreaker lineBreaker) {
        }

        public LineBreaker getLineBreaker() {
            return lb;
        }
    }
}

