/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.dag;

import com.maplesoft.client.dag.Dag;
import java.util.Arrays;

public class BackrefBuilder {
    private static final int HASH_INFLATION = 2;
    private static final int MIN_TABLE_SIZE = 10;
    int tableSize;
    private Dag[] references;
    private int[] indices;
    private int entries;

    public BackrefBuilder(Dag dag) {
        this.tableSize = this.computeDagSize(dag);
        if (this.tableSize < 10) {
            this.tableSize = 10;
        }
        this.references = new Dag[this.tableSize];
        this.tableSize *= 2;
        this.indices = new int[this.tableSize];
        Arrays.fill(this.indices, -1);
        this.entries = 0;
    }

    public int get(Dag dag) {
        int n = -1;
        int n2 = dag.hashCode() % this.tableSize;
        while (this.indices[n2] != -1) {
            Dag dag2 = this.references[this.indices[n2]];
            if (dag2.equals(dag)) {
                n = this.indices[n2];
                break;
            }
            if (++n2 != this.tableSize) continue;
            n2 = 0;
        }
        return n + 1;
    }

    public void put(Dag dag) {
        if (this.entries >= 3 * this.references.length / 4) {
            this.growTables();
            this.put(dag);
        } else if (dag != null) {
            int n = dag.hashCode() % this.tableSize;
            while (this.indices[n] != -1) {
                if (++n != this.tableSize) continue;
                n = 0;
            }
            this.indices[n] = this.entries;
            this.references[this.entries++] = dag;
        }
    }

    private void growTables() {
        Dag[] dagArray = this.references;
        this.entries = 0;
        this.references = new Dag[this.tableSize];
        this.tableSize *= 2;
        this.indices = new int[this.tableSize];
        Arrays.fill(this.indices, -1);
        int n = dagArray.length;
        for (int i = 0; i < n; ++i) {
            this.put(dagArray[i]);
        }
    }

    private int computeDagSize(Dag dag) {
        int n = 1;
        int n2 = dag.getLength();
        for (int i = 0; i < n2; ++i) {
            Dag dag2 = dag.getChild(i);
            if (dag2 == null) continue;
            n += this.computeDagSize(dag2);
        }
        return n;
    }
}

