/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.dag;

import com.maplesoft.client.dag.AbstractElisionDagFactory;
import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.dag.WmiLPrintOptions;
import com.maplesoft.client.prettyprinter.InlineLayoutBox;
import com.maplesoft.client.prettyprinter.LayoutBox;
import com.maplesoft.client.prettyprinter.LayoutFormatter;
import com.maplesoft.client.prettyprinter.NotationLayoutBox;
import com.maplesoft.client.prettyprinter.linebreaker.LineBreakerFactory;
import com.maplesoft.client.prettyprinter.template.BinaryOperationTemplate;
import com.maplesoft.util.WmiByteArrayInputStream;
import java.io.IOException;

public abstract class AbstractBinopDagFactory
extends AbstractElisionDagFactory {
    public abstract int getType();

    public abstract String getStringOperator(WmiLPrintOptions var1);

    public final String getStringOperator() {
        return this.getStringOperator(new WmiLPrintOptions());
    }

    abstract boolean isVariableLength();

    protected String getElisionThresholdProperty() {
        return "elisiontermsthreshold";
    }

    protected String getElisionAfterProperty() {
        return "elisiontermsafter";
    }

    protected String getElisionBeforeProperty() {
        return "elisiontermsbefore";
    }

    protected int getDefaultElideThreshold() {
        return 1000;
    }

    public static Dag create(int n, Dag dag, Dag dag2) {
        Dag[] dagArray = new Dag[]{dag, dag2};
        return Dag.createDag(n, dagArray, null, true);
    }

    public Dag readDotm(WmiByteArrayInputStream wmiByteArrayInputStream) throws IOException {
        int n = this.isVariableLength() ? DagBuilder.parseShortInteger(wmiByteArrayInputStream) : 3;
        return this.readDotm(wmiByteArrayInputStream, this.getType(), n);
    }

    public void writeDotm(StringBuffer stringBuffer, Dag dag) {
        this.writeDotm(stringBuffer, dag, this.getType(), this.isVariableLength());
    }

    abstract NotationLayoutBox createNotationBox(LayoutFormatter var1);

    protected void infixLinePrint(StringBuffer stringBuffer, Dag dag, WmiLPrintOptions wmiLPrintOptions) {
        int n = dag.getLength();
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                Dag dag2 = dag.getChild(i);
                if (this.addBrackets(dag2, wmiLPrintOptions)) {
                    stringBuffer.append("(");
                    DagBuilder.linePrint(stringBuffer, dag2, wmiLPrintOptions);
                    stringBuffer.append(")");
                } else {
                    DagBuilder.linePrint(stringBuffer, dag2, wmiLPrintOptions);
                }
                if (i >= n - 1) continue;
                stringBuffer.append(this.getStringOperator(wmiLPrintOptions));
            }
        }
    }

    protected void prefixLinePrint(StringBuffer stringBuffer, Dag dag, WmiLPrintOptions wmiLPrintOptions) {
        int n = dag.getLength();
        String string = this.getStringOperator(wmiLPrintOptions);
        if (string != null) {
            string = string.trim();
        }
        stringBuffer.append("`" + string + "`(");
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            Dag dag2 = dag.getChild(i);
            DagBuilder.linePrint(stringBuffer, dag2, wmiLPrintOptions);
        }
        stringBuffer.append(")");
    }

    public void linePrint(StringBuffer stringBuffer, Dag dag, WmiLPrintOptions wmiLPrintOptions) {
        if (wmiLPrintOptions.isInLineIfPossible()) {
            this.infixLinePrint(stringBuffer, dag, wmiLPrintOptions);
        } else {
            this.prefixLinePrint(stringBuffer, dag, wmiLPrintOptions);
        }
    }

    public boolean addBrackets(Dag dag, WmiLPrintOptions wmiLPrintOptions) {
        return DagBuilder.getPrecedence(dag, wmiLPrintOptions) > this.getPrecedence();
    }

    public final boolean addBrackets(Dag dag) {
        throw new Error("Go away");
    }

    public LayoutBox createLayout(LayoutFormatter layoutFormatter, Dag dag) {
        return this.createLayout(layoutFormatter, dag, false);
    }

    public LayoutBox createLayout(LayoutFormatter layoutFormatter, Dag dag, boolean bl) {
        int n = bl ? 0 : 1;
        int n2 = dag.getLength();
        InlineLayoutBox inlineLayoutBox = new InlineLayoutBox(2 * n2);
        if (n2 > 0) {
            for (int i = 0; i < n2; ++i) {
                BinaryOperationTemplate.apply(layoutFormatter, (LayoutBox)inlineLayoutBox, this.createNotationBox(layoutFormatter), dag.getChild(i), this.getPrecedence(), n);
            }
        }
        inlineLayoutBox.setLineBreaker(LineBreakerFactory.newLineBreaker((int)13));
        return inlineLayoutBox;
    }
}

