/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client;

import com.maplesoft.client.KernelCommunicationError;
import com.maplesoft.client.KernelConnection;
import com.maplesoft.client.KernelPortReady;
import com.maplesoft.util.RuntimePlatform;
import com.maplesoft.util.commandlineoptions.AbstractOptionHandler;
import com.maplesoft.util.commandlineoptions.CommandOptionException;
import com.maplesoft.util.commandlineoptions.CommandOptionParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import javax.net.ServerSocketFactory;

public class MapleServerSocket
implements Runnable {
    public static final int SOCKET_DEFAULT_CONNECTION = 0;
    public static final int SOCKET_LOCALHOST_CONNECTION = 1;
    public static final int SOCKET_IP_ADDRESS_CONNECTION = 2;
    public static final int NUM_SOCKET_CONNECTION_TYPES = 3;
    public static final String WINDOWS_STARTUP_FILE = "maple.ini";
    public static final String NON_WINDOWS_STARTUP_FILE = ".mapleinit";
    public static final String MAPLE_ROOT = "MAPLE_ROOT";
    public static final String MAPLE_LICENSE_ROOT = "MAPLE_LICENSE_ROOT";
    private static final int STARTUP_ERROR_TIMEOUT = 15000;
    private static final int BASE_PORT = 50577;
    private static final int MAX_PORT = 65535;
    private static int connectionType = 0;
    private int serverPort;
    private ServerSocket serverSocket;
    private volatile Socket clientSocket;
    private int kernelPort;
    private String kernelPortStr;
    private Process mapleServerProc;
    private BufferedReader in;
    private StringBuffer mServerstr = new StringBuffer(256);
    private String errorMsg;
    private boolean shutdown;
    private KernelPortReady kernelPortReady;
    private String language = "C";
    private static CommandOptionParser optionParser;
    private static ArrayList argsToPassToKernel;
    private static boolean libPathSet;
    private static boolean argumentsSetOnce;

    public MapleServerSocket(KernelPortReady kernelPortReady) {
        this.kernelPortReady = kernelPortReady;
        this.shutdown = false;
        this.serverSocket = null;
        this.clientSocket = null;
    }

    public static synchronized void setConnectionType(int n) {
        if (n < 0 || n > 2) {
            throw new IllegalArgumentException("illegal connection type:" + n);
        }
        connectionType = n;
    }

    public static int getNextConnectionType(int n) {
        return (n + 1) % 3;
    }

    public static synchronized int getConnectionType() {
        return connectionType;
    }

    public void setLanguage(String string) {
        this.language = string;
    }

    private ServerSocket createServerSocketByName(String string, int n) throws IOException {
        InetAddress inetAddress = InetAddress.getByName(string);
        ServerSocketFactory serverSocketFactory = ServerSocketFactory.getDefault();
        return serverSocketFactory.createServerSocket(n, 0, inetAddress);
    }

    public ServerSocket createServerSocket(int n) {
        ServerSocket serverSocket = null;
        boolean bl = false;
        while (!bl) {
            try {
                switch (MapleServerSocket.getConnectionType()) {
                    case 0: {
                        serverSocket = new ServerSocket(n);
                        break;
                    }
                    case 1: {
                        serverSocket = this.createServerSocketByName("localhost", n);
                        break;
                    }
                    case 2: {
                        serverSocket = this.createServerSocketByName("127.0.0.1", n);
                    }
                }
                this.serverPort = n;
                bl = true;
            }
            catch (IOException iOException) {
                if (++n <= 65535) continue;
                this.serverPort = -1;
                break;
            }
        }
        return serverSocket;
    }

    public static CommandOptionParser getCommandOptionParser() throws CommandOptionException {
        if (optionParser == null) {
            optionParser = new CommandOptionParser();
            optionParser.addHandler(new KernelPortOption("p"));
            optionParser.addHandler(new KernelPortOption("ktp"));
            optionParser.addHandler(new LibraryOption("b"));
            optionParser.addHandler(new PassToKernelOption("a", 0));
            optionParser.addHandler(new PassToKernelOption("m", 0));
            optionParser.addHandler(new PassToKernelOption("q", 0));
            optionParser.addHandler(new PassToKernelOption("r", 0));
            optionParser.addHandler(new PassToKernelOption("s", 0));
            optionParser.addHandler(new PassToKernelOption("t", 0));
            optionParser.addHandler(new PassToKernelOption("z", 0));
            optionParser.addHandler(new PassToKernelOption("B", 0));
            optionParser.addHandler(new PassToKernelOption("F", 0));
            optionParser.addHandler(new PassToKernelOption("N", 0));
            optionParser.addHandler(new PassToKernelOption("P", 0));
            optionParser.addHandler(new PassToKernelOption("c", 1));
            optionParser.addHandler(new PassToKernelOption("e", 1));
            optionParser.addHandler(new PassToKernelOption("f", 1));
            optionParser.addHandler(new PassToKernelOption("g", 1));
            optionParser.addHandler(new PassToKernelOption("h", 1));
            optionParser.addHandler(new PassToKernelOption("i", 1));
            optionParser.addHandler(new PassToKernelOption("l", 1));
            optionParser.addHandler(new PassToKernelOption("w", 1));
            optionParser.addHandler(new PassToKernelOption("A", 1));
            optionParser.addHandler(new PassToKernelOption("D", 1));
            optionParser.addHandler(new PassToKernelOption("I", 1));
            optionParser.addHandler(new PassToKernelOption("L", 1));
            optionParser.addHandler(new PassToKernelOption("U", 1));
            optionParser.addHandler(new PassToKernelOption("T", 1));
            optionParser.addHandler(new PassToKernelOption("V", 1));
        }
        return optionParser;
    }

    public static synchronized void setStartupArguments(String[] stringArray) throws CommandOptionException {
        if (argumentsSetOnce) {
            throw new CommandOptionException("setStartupArguments may only be called once.");
        }
        argumentsSetOnce = true;
        boolean bl = false;
        argsToPassToKernel = new ArrayList();
        optionParser = MapleServerSocket.getCommandOptionParser();
        optionParser.process(stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.serverSocket = this.createServerSocket(50577);
        if (this.serverSocket == null) {
            KernelPortReady kernelPortReady = this.kernelPortReady;
            synchronized (kernelPortReady) {
                this.kernelPortReady.error = true;
                this.kernelPortReady.notify();
            }
            return;
        }
        WatchForErrors watchForErrors = null;
        Thread thread = null;
        try {
            this.mapleServerProc = this.startMapleServer();
            InputStream inputStream = this.mapleServerProc.getErrorStream();
            watchForErrors = new WatchForErrors(Thread.currentThread(), inputStream);
            thread = new Thread(watchForErrors);
            thread.start();
        }
        catch (Throwable throwable) {
            KernelPortReady kernelPortReady = this.kernelPortReady;
            synchronized (kernelPortReady) {
                this.kernelPortReady.error = true;
                this.kernelPortReady.notify();
            }
            throw new KernelCommunicationError("Unable to start maple server.", throwable);
        }
        try {
            this.clientSocket = this.serverSocket.accept();
            this.in = new BufferedReader(new InputStreamReader(this.clientSocket.getInputStream()));
        }
        catch (IOException iOException) {
            throw new KernelCommunicationError("serverSocket failed in timeout " + this.serverPort, iOException);
        }
        catch (Throwable throwable) {
            throw new KernelCommunicationError(this.errorMsg);
        }
        try {
            char c;
            while ((c = (char)this.in.read()) != '\u0000') {
                this.mServerstr.append(c);
            }
            if (this.mServerstr != null) {
                this.kernelPortStr = this.mServerstr.toString();
            }
            KernelPortReady kernelPortReady = this.kernelPortReady;
            synchronized (kernelPortReady) {
                this.kernelPortReady.ready = true;
                this.kernelPortReady.notify();
            }
        }
        catch (Exception exception) {
            KernelPortReady kernelPortReady = this.kernelPortReady;
            synchronized (kernelPortReady) {
                this.kernelPortReady.ready = true;
                this.kernelPortReady.notify();
            }
        }
        if (watchForErrors != null) {
            watchForErrors.stopRunning();
        }
    }

    private Process startMapleServer() {
        String string = System.getProperty("maple.bin.path");
        if (string == null) {
            throw new IllegalArgumentException("Error starting maple server, system property \"maple.bin.path\" not set.");
        }
        if (this.serverPort < 0) {
            throw new IllegalArgumentException("server port < 0");
        }
        String[] stringArray = new String[argsToPassToKernel.size() + 5];
        String string2 = null;
        string2 = RuntimePlatform.isMac() ? "mserver_ulimit" : "mserver";
        stringArray[0] = string != null ? string + "/" + string2 : string2;
        stringArray[1] = "-kport";
        stringArray[2] = Integer.toString(this.serverPort);
        stringArray[3] = "-O";
        stringArray[4] = this.language;
        for (int i = 0; i < argsToPassToKernel.size(); ++i) {
            stringArray[i + 5] = (String)argsToPassToKernel.get(i);
        }
        Process process = null;
        try {
            Runtime runtime = Runtime.getRuntime();
            File file = new File(string);
            String[] stringArray2 = this.getEnvironmentVariables(string);
            process = runtime.exec(stringArray, stringArray2, file);
            Thread.sleep(4L);
        }
        catch (KernelCommunicationError kernelCommunicationError) {
            throw kernelCommunicationError;
        }
        catch (Throwable throwable) {
            throw new KernelCommunicationError(throwable.getMessage());
        }
        return process;
    }

    private String[] getEnvironmentVariables(String string) {
        ArrayList<String> arrayList = null;
        if (RuntimePlatform.isMac()) {
            String string2;
            String string3;
            String string4;
            String string5;
            arrayList = new ArrayList<String>();
            String string6 = System.getProperty(MAPLE_ROOT);
            if (string6 != null) {
                arrayList.add("MAPLE_ROOT=" + string6);
            }
            if ((string5 = System.getProperty(MAPLE_LICENSE_ROOT)) != null) {
                arrayList.add("MAPLE_LICENSE_ROOT=" + string5);
            }
            if ((string4 = System.getProperty("user.home")) != null) {
                arrayList.add("HOME=" + string4);
            }
            if (string != null) {
                arrayList.add("PATH=" + string);
            }
            if ((string3 = (string3 = System.getProperty("maple.dylib.path")) != null && string3.length() > 0 ? string + ":" + string3 : string) != null) {
                arrayList.add("DYLD_LIBRARY_PATH=" + string3);
            }
            if ((string2 = System.getProperty("matlab.basedir")) != null) {
                arrayList.add("MATLAB_BASEDIR=" + string2);
            }
        }
        return arrayList != null ? arrayList.toArray(new String[arrayList.size()]) : null;
    }

    public synchronized int getKernelPort() {
        this.kernelPort = -1;
        if (this.kernelPortStr != null) {
            this.kernelPort = Integer.valueOf(this.kernelPortStr);
        }
        return this.kernelPort;
    }

    public synchronized void Shutdown(boolean bl) {
        this.shutdown = bl;
        try {
            if (this.in != null) {
                this.in.close();
            }
            this.serverSocket.close();
            this.clientSocket.close();
            this.serverSocket = null;
            this.clientSocket = null;
            this.mapleServerProc.destroy();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized boolean isShutdown() {
        return this.shutdown;
    }

    static {
        argsToPassToKernel = new ArrayList();
        libPathSet = false;
        argumentsSetOnce = false;
    }

    private static class LibraryOption
    extends PassToKernelOption {
        public LibraryOption(String string) {
            super(string, 1);
        }

        public void handle(CommandOptionParser commandOptionParser, String[] stringArray) throws CommandOptionException {
            super.handle(commandOptionParser, stringArray);
            libPathSet = true;
        }
    }

    private static class PassToKernelOption
    extends AbstractOptionHandler {
        int numArgs = 0;

        public PassToKernelOption(String string, int n) {
            this.numArgs = n;
            this.addOptionNames(new String[]{string});
        }

        public int numArgs() {
            return this.numArgs;
        }

        public void handle(CommandOptionParser commandOptionParser, String[] stringArray) throws CommandOptionException {
            for (int i = 0; i < stringArray.length; ++i) {
                String string = i == 0 ? "-" + stringArray[i] : stringArray[i];
                argsToPassToKernel.add(string);
            }
        }
    }

    private static class KernelPortOption
    extends AbstractOptionHandler {
        public KernelPortOption(String string) {
            this.addOptionNames(new String[]{string});
        }

        public int numArgs() {
            return 1;
        }

        public void handle(CommandOptionParser commandOptionParser, String[] stringArray) throws CommandOptionException {
            String string = stringArray[1];
            boolean bl = false;
            if (string != null) {
                try {
                    int n = Integer.parseInt(string);
                    KernelConnection.setServerPort(n);
                    bl = true;
                }
                catch (Exception exception) {
                    bl = false;
                }
            }
            if (!bl) {
                throw new CommandOptionException("Port Option Argument - " + stringArray[1] + " was malformed");
            }
        }
    }

    class WatchForErrors
    implements Runnable {
        InputStream errors;
        Thread parent;
        boolean running = true;

        WatchForErrors(Thread thread, InputStream inputStream) {
            this.errors = inputStream;
            this.parent = thread;
        }

        public void run() {
            try {
                byte[] byArray = new byte[1024];
                StringBuffer stringBuffer = new StringBuffer();
                long l = System.currentTimeMillis();
                while (this.running) {
                    Thread.yield();
                    Thread.sleep(1L);
                    long l2 = System.currentTimeMillis();
                    if (l2 - l <= 15000L) {
                        if (this.errors.available() > 0) {
                            int n = 0;
                            while ((n = this.errors.read(byArray, 0, 1023)) > -1) {
                                for (int i = 0; i < n; ++i) {
                                    stringBuffer.append((char)byArray[i]);
                                }
                            }
                        }
                        if (stringBuffer.length() <= 0) continue;
                        this.running = false;
                        this.signalError(stringBuffer.toString());
                        continue;
                    }
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void stopRunning() {
            this.running = false;
        }

        public void signalError(String string) {
            MapleServerSocket.this.errorMsg = string;
            this.stopRunning();
        }
    }
}

