/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client;

import com.maplesoft.client.ClientReady;
import com.maplesoft.client.CommandQueue;
import com.maplesoft.client.KernelCommunicationError;
import com.maplesoft.client.KernelConnection;
import com.maplesoft.client.KernelEvent;
import com.maplesoft.client.KernelListener;
import com.maplesoft.client.KernelProxy;
import com.maplesoft.client.KernelUtil;
import com.maplesoft.client.MapleSocket;
import com.maplesoft.client.RedirectedKernelListener;
import com.maplesoft.client.kernelresult.KernelResultsDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.Socket;
import java.net.SocketException;

public class MapleClientSocket
implements Runnable {
    private static final int BUSY_WAIT = 20;
    private static boolean kernelDebugDisplay = false;
    private static final String CONNECT_ERROR = "Connection to Kernel lost";
    protected int kernelPort;
    protected volatile Socket clientSocket;
    protected InputStream clientSocketInputStream;
    protected OutputStream clientSocketOutputStream;
    protected ClientReady clientReady;
    protected KernelProxy kernelProxy;
    protected KernelConnection connection;
    protected String commandstr;
    protected boolean kernelBusy;
    protected KernelProxy.KernelTransaction t;
    protected boolean shutdown;
    protected KernelEvent event;
    private boolean interruptedStatus = false;

    public MapleClientSocket(int n, ClientReady clientReady) {
        this.kernelPort = n;
        this.clientReady = clientReady;
        this.shutdown = false;
        this.kernelBusy = false;
    }

    public void setKernelConnection(KernelConnection kernelConnection) {
        this.connection = kernelConnection;
    }

    public void setKernelProxy(KernelProxy kernelProxy) {
        this.kernelProxy = kernelProxy;
    }

    public String getAuthenticationCode() {
        return null;
    }

    public String getCallbackString() {
        return "1000000000";
    }

    public boolean useEvaluateDAG() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int registerCallback() {
        int n = -1;
        String string = this.getCallbackString();
        try {
            String string2 = this.getAuthenticationCode();
            if (string2 != null) {
                KernelUtil.writeInt(this.clientSocketOutputStream, 1);
                KernelUtil.writeInt(this.clientSocketOutputStream, string2.length() + 1);
                KernelUtil.writeText(this.clientSocketOutputStream, string2);
            } else {
                KernelUtil.writeInt(this.clientSocketOutputStream, 0);
            }
            int n2 = KernelUtil.readInt(this.clientSocketInputStream);
            n = KernelUtil.readInt(this.clientSocketInputStream);
            KernelUtil.writeByte(this.clientSocketOutputStream, 36);
            KernelUtil.writeInt(this.clientSocketOutputStream, string.length() + 1);
            KernelUtil.writeText(this.clientSocketOutputStream, string);
            int n3 = KernelUtil.readByte(this.clientSocketInputStream);
        }
        catch (IOException iOException) {
            this.clientReady.failed = true;
            ClientReady clientReady = this.clientReady;
            synchronized (clientReady) {
                this.clientReady.notify();
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.clientSocket = null;
        try {
            this.clientSocket = new Socket("localhost", this.kernelPort);
            this.clientSocket.setTcpNoDelay(true);
        }
        catch (IOException iOException) {
            try {
                this.clientSocket = new Socket("127.0.0.1", this.kernelPort);
            }
            catch (IOException iOException2) {
                this.clientReady.failed = true;
                ClientReady clientReady = this.clientReady;
                synchronized (clientReady) {
                    this.clientReady.notify();
                }
                return;
            }
        }
        try {
            this.clientSocketInputStream = this.clientSocket.getInputStream();
            this.clientSocketOutputStream = this.clientSocket.getOutputStream();
        }
        catch (IOException iOException) {
            this.clientReady.failed = true;
            ClientReady clientReady = this.clientReady;
            synchronized (clientReady) {
                this.clientReady.notify();
            }
        }
        this.registerCallback();
        Object object = this.clientReady;
        synchronized (object) {
            this.clientReady.ready = true;
            this.clientReady.notify();
        }
        this.shutdown = false;
        object = this.connection.getQueue();
        while (!this.isShutdown()) {
            if (!((CommandQueue)object).isEmpty() && !this.kernelBusy) {
                this.t = (KernelProxy.KernelTransaction)((CommandQueue)object).pop();
                KernelEvent kernelEvent = new KernelEvent(9, "", true, this.t.kernelListener);
                kernelEvent.setStreamName("EVALSTART");
                this.interruptedStatus = false;
                boolean bl = false;
                for (KernelListener kernelListener = this.t.kernelListener; kernelListener != null && !(bl = kernelListener.processComputationStateChange(kernelEvent)); kernelListener = kernelListener.getParentListener()) {
                }
                this.kernelBusy = true;
                this.commandstr = this.t.command;
                try {
                    int n = this.t.mrfHow;
                    int n2 = 0;
                    KernelUtil.writeByte(this.clientSocketOutputStream, n);
                    if (n != 42 && n != 45) {
                        if (this.useEvaluateDAG()) {
                            n2 |= 1;
                        }
                        if (this.t.noDitto) {
                            n2 |= 2;
                        }
                    }
                    if (n2 != 0) {
                        KernelUtil.writeByte(this.clientSocketOutputStream, n2);
                    }
                    KernelUtil.writeInt(this.clientSocketOutputStream, this.commandstr.length() + 1);
                    KernelUtil.writeText(this.clientSocketOutputStream, this.commandstr);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.createResults();
                this.t = null;
                continue;
            }
            try {
                boolean bl = false;
                Object object2 = object;
                synchronized (object2) {
                    if (((CommandQueue)object).isEmpty()) {
                        object.wait();
                    } else {
                        bl = true;
                    }
                }
                if (!bl) continue;
                Thread.sleep(20L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    int getPort() {
        return this.kernelPort;
    }

    boolean isKernelBusy() {
        return this.kernelBusy;
    }

    public void createResults() {
        int n = 0;
        try {
            while (this.clientSocket != null && (n = KernelUtil.readByte(this.clientSocketInputStream)) > 0) {
                block17: {
                    Object object;
                    if (this.connection.getRedirectedListener() != null) {
                        object = null;
                        object = this.connection.getRedirectedListener();
                        ((RedirectedKernelListener)object).setParentListener(this.t.kernelListener);
                        this.event = KernelResultsDescriptor.createKernelEvent((KernelConnection)this.connection, (int)n, (KernelListener)object);
                        KernelResultsDescriptor.processEvent((int)n, (KernelListener)object, (KernelEvent)this.event);
                    } else {
                        this.event = KernelResultsDescriptor.createKernelEvent((KernelConnection)this.connection, (int)n, (KernelListener)this.t.kernelListener);
                        KernelResultsDescriptor.processEvent((int)n, (KernelListener)this.t.kernelListener, (KernelEvent)this.event);
                    }
                    object = this.event.getResponseForKernel();
                    if (object != null && this.clientSocket != null) {
                        try {
                            if (this.useEvaluateDAG()) {
                                KernelUtil.writeByte(this.clientSocketOutputStream, 0);
                            } else {
                                KernelUtil.writeByte(this.clientSocketOutputStream, 34);
                            }
                            KernelUtil.writeInt(this.clientSocketOutputStream, ((String)object).length() + 1);
                            KernelUtil.writeText(this.clientSocketOutputStream, (String)object);
                            break block17;
                        }
                        catch (SocketException socketException) {
                            this.connection.clearQueue();
                            this.endComputationResult(this.t, -1);
                            break block17;
                        }
                        catch (Exception exception) {
                            this.connection.clearQueue();
                            this.endComputationResult(this.t, -1);
                            break;
                        }
                    }
                    if (this.clientSocket == null) {
                        if (this.interruptedStatus) {
                            this.endComputationResult(this.t, 0);
                            this.interruptedStatus = false;
                        } else if (this.event.getStreamName().equals("MAPLET_STATUS") && this.event.getText().equals("\"stop\"")) {
                            this.endComputationResult(this.t, 0);
                        } else {
                            this.endComputationResult(this.t, -1);
                        }
                    }
                }
                this.interruptedStatus = false;
            }
            this.endComputationResult(this.t, n);
        }
        catch (SocketException socketException) {
            this.connection.clearQueue();
            this.endComputationResult(this.t, -1);
        }
        catch (Exception exception) {
            this.connection.clearQueue();
            this.endComputationResult(this.t, -1);
        }
        this.kernelBusy = false;
    }

    public void endComputationResult(KernelProxy.KernelTransaction kernelTransaction, int n) {
        if (n == 0 || n == -1) {
            KernelEvent kernelEvent = new KernelEvent(9, "", true, kernelTransaction.kernelListener);
            if (n == 0) {
                kernelEvent.setStreamName("EVALEND");
            } else {
                kernelEvent.setStreamName("KERNELFAIL");
            }
            for (KernelListener kernelListener = kernelTransaction.kernelListener; kernelListener != null && !kernelListener.processComputationStateChange(kernelEvent); kernelListener = kernelListener.getParentListener()) {
            }
            this.kernelBusy = false;
        }
    }

    public synchronized void Shutdown(boolean bl) {
        this.shutdown();
    }

    public synchronized void shutdown() {
        this.shutdown = true;
        try {
            KernelUtil.writeByte(this.clientSocketOutputStream, 9);
            this.clientSocket.close();
            this.clientSocket = null;
            this.clientSocketInputStream = null;
            this.clientSocketOutputStream = null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized boolean isShutdown() {
        return this.shutdown;
    }

    public boolean interrupt() throws KernelCommunicationError {
        return this.interrupt(true);
    }

    public boolean interrupt(boolean bl) throws KernelCommunicationError {
        block9: {
            if (!this.isKernelBusy()) {
                return false;
            }
            if (this.clientSocket instanceof MapleSocket) {
                block8: {
                    try {
                        ((MapleSocket)this.clientSocket).sendInterrupt();
                    }
                    catch (IOException iOException) {
                        if (!bl) break block8;
                        throw new KernelCommunicationError(iOException.toString());
                    }
                }
                return false;
            }
            try {
                Integer n = new Integer(0);
                Class[] classArray = new Class[1];
                Object[] objectArray = new Object[1];
                Class<?> clazz = this.clientSocket.getClass();
                Method method = null;
                classArray[0] = Integer.TYPE;
                method = clazz.getMethod("sendUrgentData", classArray);
                objectArray[0] = n;
                method.invoke((Object)this.clientSocket, objectArray);
                this.interruptedStatus = true;
                return true;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                if (bl) {
                    throw new KernelCommunicationError("Interrupt not supported on all platforms.");
                }
            }
            catch (Exception exception) {
                if (!bl) break block9;
                throw new KernelCommunicationError(exception.toString());
            }
        }
        return true;
    }

    void toDebugMode() throws KernelCommunicationError {
        if (this.clientSocket instanceof MapleSocket) {
            try {
                ((MapleSocket)this.clientSocket).sendDebugMode();
            }
            catch (IOException iOException) {
                System.out.println("error");
                throw new KernelCommunicationError(iOException.toString());
            }
        }
        try {
            Integer n = new Integer(1);
            Class[] classArray = new Class[1];
            Object[] objectArray = new Object[1];
            Class<?> clazz = this.clientSocket.getClass();
            Method method = null;
            classArray[0] = Integer.TYPE;
            method = clazz.getMethod("sendUrgentData", classArray);
            objectArray[0] = n;
            method.invoke((Object)this.clientSocket, objectArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new KernelCommunicationError("Interrupt not supported on all platforms.");
        }
        catch (Exception exception) {
            throw new KernelCommunicationError(exception.toString());
        }
    }

    public InputStream getSocketInputStream() {
        return this.clientSocketInputStream;
    }

    public OutputStream getSocketOutputStream() {
        return this.clientSocketOutputStream;
    }

    public String errorState() {
        return CONNECT_ERROR;
    }
}

