/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client;

import com.maplesoft.client.KernelConnection;
import com.maplesoft.client.KernelEvent;
import com.maplesoft.client.KernelInterfacePropertiesChangeEvent;
import com.maplesoft.client.KernelInterfacePropertiesChangeListener;
import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.dag.DagUtil;
import com.maplesoft.client.preprocessor.PreprocessorSubstitutionTable;
import com.maplesoft.util.RuntimeLocale;
import com.maplesoft.util.RuntimePlatform;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;

public class KernelInterfaceProperties {
    public static final int LPRINT = 0;
    public static final int TTY = 1;
    public static final int J2D_LABEL = 2;
    public static final int J2D_NO_LABEL = 3;
    public static final int DOTM = 4;
    public static final int XML_PRE_NORMALIZE = 5;
    public static final int XML_POST_NORMALIZE = 6;
    public static final int DAG_TOSTRING = 7;
    public static final int DAG_TOSTRING_NORMALIZE = 8;
    public static final String INFINITY_STRING = "infinity";
    public static final String PROPERTY_ANSI = "ansi";
    public static final String PROPERTY_CURRENTDIR = "currentdir";
    public static final String PROPERTY_DIGIT_ELISION_AFTER = "elisiondigitsafter";
    public static final String PROPERTY_DIGIT_ELISION_BEFORE = "elisiondigitsbefore";
    public static final String PROPERTY_DIGIT_ELISION_THRESHOLD = "elisiondigitsthreshold";
    public static final String PROPERTY_DISPLAY_PRECISION = "displayprecision";
    public static final String PROPERTY_ECHO = "echo";
    public static final String PROPERTY_ERROR_BREAK = "errorbreak";
    public static final String PROPERTY_ERROR_CURSOR = "errorcursor";
    public static final String PROPERTY_IMAGINARY_UNIT = "imaginaryunit";
    public static final String PROPERTY_INDENT_AMOUNT = "indentamount";
    public static final String PROPERTY_LABELLING = "labelling";
    public static final String PROPERTY_LABEL_WIDTH = "labelwidth";
    public static final String PROPERTY_LATEX_WIDTH = "latexwidth";
    public static final String PROPERTY_LONG_DELIM = "longdelim";
    public static final String PROPERTY_PLOT_DEVICE = "plotdevice";
    public static final String PROPERTY_PLOT_DRIVER = "plotdriver";
    public static final String PROPERTY_PLOT_OPTIONS = "plotoptions";
    public static final String PROPERTY_PLOT_OUTPUT = "plotoutput";
    public static final String PROPERTY_POSTPLOT = "postplot";
    public static final String PROPERTY_PREPLOT = "preplot";
    public static final String PROPERTY_PRETTYPRINT = "prettyprint";
    public static final String PROPERTY_PROMPT = "prompt";
    public static final String PROPERTY_QUIET = "quiet";
    public static final String PROPERTY_RTABLE_SIZE = "rtablesize";
    public static final String PROPERTY_SCREEN_HEIGHT = "screenheight";
    public static final String PROPERTY_SCREEN_WIDTH = "screenwidth";
    public static final String PROPERTY_SHOW_ASSUMED = "showassumed";
    public static final String PROPERTY_TERM_ELISION_AFTER = "elisiontermsafter";
    public static final String PROPERTY_TERM_ELISION_BEFORE = "elisiontermsbefore";
    public static final String PROPERTY_TERM_ELISION_THRESHOLD = "elisiontermsthreshold";
    public static final String PROPERTY_TYPESETTING = "typesetting";
    public static final String PROPERTY_TYPESETTING_OFF = "standard";
    public static final String PROPERTY_TYPESETTING_ON = "extended";
    public static final String PROPERTY_USE_CLIENT_JVM = "useclientjvm";
    public static final String PROPERTY_VERBOSE_PROC = "verboseproc";
    public static final String PROPERTY_VERSION = "version";
    public static final String PROPERTY_WARN_LEVEL = "warnlevel";
    public static final String FALSE = "false";
    public static final String TRUE = "true";
    private PreprocessorSubstitutionTable subsTable;
    private static final String VERSION_NAME = "Standard Worksheet Interface";
    private static final String VERSION_NUM = "Maple 11.0";
    private static final String VERSION_OS;
    private static final String VERSION_DATE = "November 2 2007";
    private static final String VERSION_BUILD_SEP = " Build ID ";
    private static final int VERSION_BUILDID = 9999999;
    private static final String VERSION_SEP = ", ";
    private static final String VERSION;
    private static Object[] propertyInitTable;
    private static HashMap defaultMap;
    private static String[] retainsValueOnReset;
    private static String[] aliasTable;
    private HashMap propertyMap = new HashMap();
    private LinkedList changeListeners = new LinkedList();
    private static HashMap aliasMap;
    private static HashMap validatorMap;
    private static HashSet retainedPropertySet;
    private KernelConnection user;

    public static String getVersionDate() {
        return VERSION_DATE;
    }

    public static int getVersionBuildID() {
        return 9999999;
    }

    private static String getInitCurrentDir() {
        String string;
        String string2 = System.getProperty("user.dir");
        if (RuntimePlatform.isWindows() && !string2.equals(string = RuntimeLocale.getExportEncoder().fromUnicode(string2))) {
            String string3 = System.getProperty("java.home");
            string2 = string3.charAt(0) + ":\\\\";
        }
        return string2;
    }

    public KernelInterfaceProperties(KernelConnection kernelConnection) {
        for (int i = 0; i < propertyInitTable.length; i += 3) {
            String string = (String)propertyInitTable[i];
            Dag dag = (Dag)propertyInitTable[i + 1];
            Validator validator = (Validator)propertyInitTable[i + 2];
            this.propertyMap.put(string, dag);
            validatorMap.put(string, validator);
        }
        this.user = kernelConnection;
        this.subsTable = new PreprocessorSubstitutionTable();
    }

    public Object getValue(String string) {
        Object object = null;
        String string2 = this.alias(string);
        if (this.propertyMap.containsKey(string2)) {
            Dag dag = (Dag)this.propertyMap.get(string2);
            object = this.convertDag(dag);
        } else {
            Dag dag = DagUtil.createErrorDag(string2 + " not a valid property name");
            this.throwInterfaceErrorToKernel(dag, null);
        }
        return object;
    }

    public int getType(String string) {
        Dag dag = (Dag)defaultMap.get(this.alias(string));
        return dag != null ? dag.getType() : -1;
    }

    public Dag getDagValue(String string) {
        return (Dag)this.propertyMap.get(this.alias(string));
    }

    protected Object convertDag(Dag dag) {
        Object object = null;
        object = DagUtil.isInt(dag) ? new Integer(DagUtil.parseInt(dag)) : (DagUtil.isFloat(dag) ? new Float(DagUtil.parseFloat(dag)) : (DagUtil.isNameNamed(dag, TRUE) ? Boolean.TRUE : (DagUtil.isNameNamed(dag, FALSE) ? Boolean.FALSE : (DagUtil.isText(dag) ? dag.getData() : DagBuilder.lPrint(dag)))));
        return object;
    }

    public boolean isValidProperty(String string) {
        return this.propertyMap.containsKey(this.alias(string));
    }

    public void setValue(String string, Dag dag, KernelEvent kernelEvent) {
        String string2 = this.alias(string);
        if (this.propertyMap.containsKey(string2)) {
            Dag dag2 = (Dag)this.propertyMap.get(string2);
            Validator validator = (Validator)validatorMap.get(string2);
            Dag dag3 = validator.validate(string2, dag);
            if (DagUtil.isError(dag3)) {
                this.throwInterfaceErrorToKernel(dag3, kernelEvent);
            } else if (dag3 != null) {
                this.propertyMap.put(string2, dag3);
                if (dag2 != null && kernelEvent != null) {
                    kernelEvent.setResponseAsDag(dag2);
                    if (!dag2.equals(dag3)) {
                        this.fireChangeEvent(string2, DagBuilder.lPrint(dag2));
                    }
                }
            } else {
                Dag dag4 = DagUtil.createErrorDag("null property detected for property " + string);
                this.throwInterfaceErrorToKernel(dag4, kernelEvent);
            }
        } else {
            Dag dag5 = DagUtil.createErrorDag(string2 + " not a valid property name");
            this.throwInterfaceErrorToKernel(dag5, kernelEvent);
        }
    }

    public Dag setValue(String string, Dag dag) {
        Dag dag2 = null;
        String string2 = this.alias(string);
        if (this.propertyMap.containsKey(string2)) {
            Dag dag3 = (Dag)this.propertyMap.get(string2);
            Validator validator = (Validator)validatorMap.get(string2);
            Dag dag4 = validator.validate(string2, dag);
            if (dag4 == null) {
                dag2 = DagUtil.createErrorDag("null property detected for property " + string);
            } else if (DagUtil.isError(dag4)) {
                dag2 = dag4;
            } else {
                dag2 = dag3;
                this.propertyMap.put(string2, dag4);
                if (dag3 != null && !dag3.equals(dag4)) {
                    this.fireChangeEvent(string2, DagBuilder.lPrint(dag3));
                }
            }
        } else {
            dag2 = DagUtil.createErrorDag(string2 + " not a valid property name");
        }
        return dag2;
    }

    public void setValue(String string, String string2, KernelEvent kernelEvent) {
        String string3 = this.alias(string);
        if (this.propertyMap.containsKey(string3)) {
            Dag dag = (Dag)defaultMap.get(string3);
            Dag dag2 = null;
            if (DagUtil.isString(dag)) {
                dag2 = DagUtil.createStringDag(string2);
            } else if (DagUtil.isName(dag)) {
                dag2 = DagUtil.createNameDag(string2);
            } else if (DagUtil.isInt(dag)) {
                try {
                    int n = Integer.parseInt(string2);
                    dag2 = DagUtil.createIntDag(n);
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (DagUtil.isFloat(dag)) {
                try {
                    float f = Float.parseFloat(string2);
                    dag2 = DagUtil.createFloatDag(f);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (dag2 == null && INFINITY_STRING.equals(string2)) {
                dag2 = DagUtil.createNameDag(INFINITY_STRING);
            }
            if (dag2 != null) {
                this.setValue(string, dag2, kernelEvent);
            } else {
                Dag dag3 = DagUtil.createErrorDag("Could not construct property for " + string + " : " + string2);
                this.throwInterfaceErrorToKernel(dag3, kernelEvent);
            }
        }
    }

    public PreprocessorSubstitutionTable getSubstitutionTable() {
        return this.subsTable;
    }

    protected void throwInterfaceErrorToKernel(Dag dag, KernelEvent kernelEvent) {
        if (kernelEvent != null && this.user != null) {
            kernelEvent.setResponseAsDag(dag);
        }
    }

    private String alias(String string) {
        String string2 = string;
        if (aliasMap.containsKey(string2)) {
            string2 = (String)aliasMap.get(string2);
        }
        return string2;
    }

    public KernelEvent createGetReply(Dag dag, KernelEvent kernelEvent) {
        if (DagUtil.isExpSeq(dag) && dag.getLength() > 0) {
            Dag[] dagArray = new Dag[dag.getLength()];
            Dag dag2 = null;
            for (int i = 0; i < dag.getLength(); ++i) {
                Dag dag3 = dag.getChild(i);
                if (DagUtil.isName(dag3)) {
                    String string = dag3.getData();
                    if (string != null && this.isValidProperty(string)) {
                        dagArray[i] = (Dag)this.propertyMap.get(this.alias(string));
                        continue;
                    }
                    dag2 = DagUtil.createErrorDag("unknown interface variable, " + string);
                    continue;
                }
                dag2 = DagUtil.createErrorDag("Malformed interface property get");
            }
            if (dag2 == null) {
                Dag dag4 = Dag.createDag(29, dagArray, null, false);
                kernelEvent.setResponseAsDag(dag4);
            } else {
                this.throwInterfaceErrorToKernel(dag2, kernelEvent);
            }
        }
        return kernelEvent;
    }

    public KernelEvent createSetReply(String string, Dag dag, KernelEvent kernelEvent) {
        if (this.isValidProperty(string)) {
            Dag dag2 = Dag.createDag(29, new Dag[]{dag}, null, false);
            kernelEvent.setResponseAsDag(dag2);
        } else {
            Dag dag3 = DagUtil.createErrorDag("unknown interface variable, " + string);
            this.throwInterfaceErrorToKernel(dag3, kernelEvent);
        }
        return kernelEvent;
    }

    public void addChangeListener(KernelInterfacePropertiesChangeListener kernelInterfacePropertiesChangeListener) {
        this.changeListeners.add(kernelInterfacePropertiesChangeListener);
        KernelInterfacePropertiesChangeEvent kernelInterfacePropertiesChangeEvent = new KernelInterfacePropertiesChangeEvent(1, this);
        kernelInterfacePropertiesChangeListener.processConnected(kernelInterfacePropertiesChangeEvent);
    }

    public KernelInterfacePropertiesChangeListener removeChangeListener(KernelInterfacePropertiesChangeListener kernelInterfacePropertiesChangeListener) {
        KernelInterfacePropertiesChangeListener kernelInterfacePropertiesChangeListener2 = null;
        int n = -1;
        n = this.changeListeners.indexOf(kernelInterfacePropertiesChangeListener);
        if (n > 0) {
            kernelInterfacePropertiesChangeListener2 = (KernelInterfacePropertiesChangeListener)this.changeListeners.remove(n);
            KernelInterfacePropertiesChangeEvent kernelInterfacePropertiesChangeEvent = new KernelInterfacePropertiesChangeEvent(3, this);
            kernelInterfacePropertiesChangeListener2.processDisconnected(kernelInterfacePropertiesChangeEvent);
        }
        return kernelInterfacePropertiesChangeListener2;
    }

    void fireChangeEvent(String string, String string2) {
        KernelInterfacePropertiesChangeEvent kernelInterfacePropertiesChangeEvent = new KernelInterfacePropertiesChangeEvent(2, this, string, this.getValue(string), string2);
        Iterator iterator = this.changeListeners.iterator();
        while (iterator.hasNext()) {
            ((KernelInterfacePropertiesChangeListener)iterator.next()).processPropertiesUpdated(kernelInterfacePropertiesChangeEvent);
        }
    }

    public int getNumberProperties() {
        return this.propertyMap.size();
    }

    public Iterator getIterator() {
        return this.propertyMap.keySet().iterator();
    }

    public static boolean shouldChangeOnReset(String string) {
        return !retainedPropertySet.contains(string);
    }

    static {
        int n;
        VERSION_OS = System.getProperty("os.name");
        VERSION = "Standard Worksheet Interface, Maple 11.0, " + VERSION_OS + VERSION_SEP + VERSION_DATE + VERSION_BUILD_SEP + 9999999;
        propertyInitTable = new Object[]{PROPERTY_ANSI, DagUtil.createNameDag(FALSE), new BooleanValidator(), PROPERTY_CURRENTDIR, DagUtil.createStringDag(KernelInterfaceProperties.getInitCurrentDir()), new BaseValidator(), PROPERTY_DIGIT_ELISION_AFTER, DagUtil.createIntDag(100), new PositiveIntegerValidator(), PROPERTY_DIGIT_ELISION_BEFORE, DagUtil.createIntDag(100), new PositiveIntegerValidator(), PROPERTY_DIGIT_ELISION_THRESHOLD, DagUtil.createIntDag(10000), new InfinityPositiveIntegerValidator(), PROPERTY_DISPLAY_PRECISION, DagUtil.createIntDag(-1), new IntegerRangeValidator(-1, 100), PROPERTY_ECHO, DagUtil.createIntDag(1), new IntegerRangeValidator(0, 4), PROPERTY_ERROR_BREAK, DagUtil.createIntDag(1), new IntegerRangeValidator(0, 2), PROPERTY_ERROR_CURSOR, DagUtil.createNameDag(FALSE), new BooleanValidator(), PROPERTY_IMAGINARY_UNIT, DagUtil.createNameDag("I"), new BaseValidator(), PROPERTY_INDENT_AMOUNT, DagUtil.createIntDag(4), new PositiveIntegerValidator(), PROPERTY_LABELLING, DagUtil.createNameDag(TRUE), new BooleanValidator(), PROPERTY_LABEL_WIDTH, DagUtil.createIntDag(20), new PositiveIntegerValidator(), PROPERTY_LATEX_WIDTH, DagUtil.createFloatDag(5.0f), new DoubleRangeValidator(0.0, 100.0), PROPERTY_LONG_DELIM, DagUtil.createNameDag(TRUE), new BooleanValidator(), PROPERTY_PLOT_DEVICE, DagUtil.createStringDag("inline"), new BaseValidator(), PROPERTY_PLOT_DRIVER, DagUtil.createStringDag("openviz"), new ReadOnlyValidator(), PROPERTY_PLOT_OPTIONS, DagUtil.createStringDag(""), new BaseValidator(), PROPERTY_PLOT_OUTPUT, DagUtil.createStringDag("terminal"), new BaseValidator(), PROPERTY_POSTPLOT, DagUtil.createStringDag(""), new BaseValidator(), PROPERTY_PREPLOT, DagUtil.createStringDag(""), new BaseValidator(), PROPERTY_PRETTYPRINT, DagUtil.createIntDag(3), new IntegerRangeValidator(0, 3), PROPERTY_PROMPT, DagUtil.createStringDag("> "), new BaseValidator(), PROPERTY_QUIET, DagUtil.createNameDag(FALSE), new BooleanValidator(), PROPERTY_RTABLE_SIZE, DagUtil.createIntDag(10), new InfinityPositiveIntegerValidator(), PROPERTY_SCREEN_HEIGHT, DagUtil.createIntDag(25), new IntegerRangeValidator(1, 9999), PROPERTY_SCREEN_WIDTH, DagUtil.createIntDag(79), new IntegerRangeValidator(10, 9999), PROPERTY_SHOW_ASSUMED, DagUtil.createIntDag(1), new IntegerRangeValidator(0, 2), PROPERTY_TERM_ELISION_AFTER, DagUtil.createIntDag(100), new PositiveIntegerValidator(), PROPERTY_TERM_ELISION_BEFORE, DagUtil.createIntDag(100), new PositiveIntegerValidator(), PROPERTY_TERM_ELISION_THRESHOLD, DagUtil.createIntDag(10000), new InfinityPositiveIntegerValidator(), PROPERTY_TYPESETTING, DagUtil.createNameDag(PROPERTY_TYPESETTING_OFF), new TypesetValidator(), PROPERTY_USE_CLIENT_JVM, DagUtil.createNameDag(TRUE), new BooleanValidator(), PROPERTY_VERBOSE_PROC, DagUtil.createIntDag(1), new IntegerRangeValidator(0, 3), PROPERTY_VERSION, DagUtil.createNameDag(VERSION), new ReadOnlyValidator(), PROPERTY_WARN_LEVEL, DagUtil.createIntDag(3), new IntegerRangeValidator(0, 4)};
        defaultMap = new HashMap();
        for (n = 0; n < propertyInitTable.length; n += 3) {
            String string = (String)propertyInitTable[n];
            Dag dag = (Dag)propertyInitTable[n + 1];
            defaultMap.put(string, dag);
        }
        retainsValueOnReset = new String[]{PROPERTY_DISPLAY_PRECISION, PROPERTY_LATEX_WIDTH, PROPERTY_PLOT_DEVICE, PROPERTY_PLOT_OUTPUT, PROPERTY_PRETTYPRINT, PROPERTY_SHOW_ASSUMED, PROPERTY_VERSION, PROPERTY_DIGIT_ELISION_THRESHOLD, PROPERTY_DIGIT_ELISION_BEFORE, PROPERTY_DIGIT_ELISION_AFTER, PROPERTY_TERM_ELISION_THRESHOLD, PROPERTY_TERM_ELISION_BEFORE, PROPERTY_TERM_ELISION_AFTER, PROPERTY_PLOT_DRIVER};
        aliasTable = new String[]{"Ansi", PROPERTY_ANSI, "ANSI", PROPERTY_ANSI, "CurrentDir", PROPERTY_CURRENTDIR, "currentDir", PROPERTY_CURRENTDIR, "displayPrecision", PROPERTY_DISPLAY_PRECISION, "DisplayPrecision", PROPERTY_DISPLAY_PRECISION, "Echo", PROPERTY_ECHO, "errorBreak", PROPERTY_ERROR_BREAK, "ErrorBreak", PROPERTY_ERROR_BREAK, "errorCursor", PROPERTY_ERROR_CURSOR, "ErrorCursor", PROPERTY_ERROR_CURSOR, "imaginaryUnit", PROPERTY_IMAGINARY_UNIT, "ImaginaryUnit", PROPERTY_IMAGINARY_UNIT, "indentAmount", PROPERTY_INDENT_AMOUNT, "IndentAmount", PROPERTY_INDENT_AMOUNT, "Labelling", PROPERTY_LABELLING, "latexWidth", PROPERTY_LATEX_WIDTH, "LatexWidth", PROPERTY_LATEX_WIDTH, "longDelim", PROPERTY_LONG_DELIM, "LongDelim", PROPERTY_LONG_DELIM, "plotDevice", PROPERTY_PLOT_DEVICE, "PlotDevice", PROPERTY_PLOT_DEVICE, "plotOptions", PROPERTY_PLOT_OPTIONS, "PlotOptions", PROPERTY_PLOT_OPTIONS, "plotOutput", PROPERTY_PLOT_OUTPUT, "PlotOutput", PROPERTY_PLOT_OUTPUT, "prePlot", PROPERTY_PREPLOT, "PrePlot", PROPERTY_PREPLOT, "postPlot", PROPERTY_POSTPLOT, "PostPlot", PROPERTY_POSTPLOT, "prettyPrint", PROPERTY_PRETTYPRINT, "PrettyPrint", PROPERTY_PRETTYPRINT, "Prompt", PROPERTY_PROMPT, "Quiet", PROPERTY_QUIET, "rTableSize", PROPERTY_RTABLE_SIZE, "RTableSize", PROPERTY_RTABLE_SIZE, "RtableSize", PROPERTY_RTABLE_SIZE, "screenHeight", PROPERTY_SCREEN_HEIGHT, "ScreenHeight", PROPERTY_SCREEN_HEIGHT, "screenWidth", PROPERTY_SCREEN_WIDTH, "ScreenWidth", PROPERTY_SCREEN_WIDTH, "showAssumed", PROPERTY_SHOW_ASSUMED, "ShowAssumed", PROPERTY_SHOW_ASSUMED, "verboseProc", PROPERTY_VERBOSE_PROC, "VerboseProc", PROPERTY_VERBOSE_PROC, "Version", PROPERTY_VERSION, "warnLevel", PROPERTY_WARN_LEVEL, "WarnLevel", PROPERTY_WARN_LEVEL, "labeling", PROPERTY_LABELLING, "Labeling", PROPERTY_LABELLING, "Labelling", PROPERTY_LABELLING, "ElisionThreshold", PROPERTY_DIGIT_ELISION_THRESHOLD, "elisionthreshold", PROPERTY_DIGIT_ELISION_THRESHOLD, "ElisionDigitsThreshold", PROPERTY_DIGIT_ELISION_THRESHOLD, "ElisionDigitsAfter", PROPERTY_DIGIT_ELISION_AFTER, "ElisionDigitsBefore", PROPERTY_DIGIT_ELISION_BEFORE, "TermElisionThreshold", PROPERTY_TERM_ELISION_THRESHOLD, "termelisionthreshold", PROPERTY_TERM_ELISION_THRESHOLD, "ElisionTermsThreshold", PROPERTY_TERM_ELISION_THRESHOLD, "elisiontermthreshold", PROPERTY_TERM_ELISION_THRESHOLD, "termelisionafter", PROPERTY_TERM_ELISION_AFTER, "termelisionbefore", PROPERTY_TERM_ELISION_BEFORE, "TermElisionAfter", PROPERTY_TERM_ELISION_AFTER, "TermElisionBefore", PROPERTY_TERM_ELISION_BEFORE, PROPERTY_TERM_ELISION_AFTER, PROPERTY_TERM_ELISION_AFTER, PROPERTY_TERM_ELISION_BEFORE, PROPERTY_TERM_ELISION_BEFORE, "ElisionTermsAfter", PROPERTY_TERM_ELISION_AFTER, "ElisionTermsBefore", PROPERTY_TERM_ELISION_BEFORE, "UseClientJVM", PROPERTY_USE_CLIENT_JVM, "Typesetting", PROPERTY_TYPESETTING, "plotDriver", PROPERTY_PLOT_DRIVER, "PlotDriver", PROPERTY_PLOT_DRIVER};
        aliasMap = new HashMap();
        validatorMap = new HashMap();
        retainedPropertySet = new HashSet();
        for (n = 0; n < aliasTable.length; ++n) {
            aliasMap.put(aliasTable[n], aliasTable[++n]);
        }
        for (n = 0; n < retainsValueOnReset.length; ++n) {
            retainedPropertySet.add(retainsValueOnReset[n]);
        }
    }

    protected static class TypesetValidator
    extends BaseValidator {
        protected TypesetValidator() {
        }

        public Dag validate(String string, Dag dag) {
            Dag dag2 = null;
            Dag dag3 = super.validate(string, dag);
            if (DagUtil.isNameNamed(dag3, KernelInterfaceProperties.PROPERTY_TYPESETTING_ON) || DagUtil.isNameNamed(dag3, KernelInterfaceProperties.PROPERTY_TYPESETTING_OFF)) {
                dag2 = dag3;
            } else if (DagUtil.isText(dag)) {
                String string2 = dag3.getData();
                if (KernelInterfaceProperties.PROPERTY_TYPESETTING_ON.equalsIgnoreCase(string2)) {
                    dag2 = DagUtil.createNameDag(KernelInterfaceProperties.PROPERTY_TYPESETTING_ON);
                } else if (KernelInterfaceProperties.PROPERTY_TYPESETTING_OFF.equalsIgnoreCase(string2)) {
                    dag2 = DagUtil.createNameDag(KernelInterfaceProperties.PROPERTY_TYPESETTING_OFF);
                }
            }
            if (dag2 == null) {
                dag2 = DagUtil.createErrorDag(string + " must be a string of " + KernelInterfaceProperties.PROPERTY_TYPESETTING_ON + " or " + KernelInterfaceProperties.PROPERTY_TYPESETTING_OFF);
            }
            return dag2;
        }
    }

    protected static class IntegerRangeValidator
    extends BaseValidator {
        int min = 0;
        int max = 0;

        protected IntegerRangeValidator(int n, int n2) {
            this.min = n;
            this.max = n2;
        }

        public Dag validate(String string, Dag dag) {
            int n;
            Dag dag2 = null;
            Dag dag3 = super.validate(string, dag);
            if (DagUtil.isInt(dag3) && (n = DagUtil.parseInt(dag3)) >= this.min && n <= this.max) {
                dag2 = dag3;
            }
            if (dag2 == null) {
                dag2 = DagUtil.createErrorDag(string + " must be an integer in the range " + this.min + ".." + this.max);
            }
            return dag2;
        }
    }

    protected static class InfinityPositiveIntegerValidator
    extends BaseValidator {
        protected InfinityPositiveIntegerValidator() {
        }

        public Dag validate(String string, Dag dag) {
            Dag dag2 = null;
            Dag dag3 = super.validate(string, dag);
            dag2 = DagUtil.isPosInt(dag3) || DagUtil.isPosInfinity(dag3) ? dag3 : DagUtil.createErrorDag(string + " must be a positive integer, or infinity");
            return dag2;
        }
    }

    protected static class PositiveIntegerValidator
    extends BaseValidator {
        protected PositiveIntegerValidator() {
        }

        public Dag validate(String string, Dag dag) {
            Dag dag2 = null;
            Dag dag3 = super.validate(string, dag);
            dag2 = DagUtil.isPosInt(dag3) ? dag3 : DagUtil.createErrorDag(string + " must be a positive integer");
            return dag2;
        }
    }

    protected static class ReadOnlyValidator
    implements Validator {
        protected ReadOnlyValidator() {
        }

        public Dag validate(String string, Dag dag) {
            return DagUtil.createErrorDag(string + " is Read Only");
        }
    }

    protected static class IntegerValidator
    extends BaseValidator {
        protected IntegerValidator() {
        }

        public Dag validate(String string, Dag dag) {
            Dag dag2 = null;
            Dag dag3 = super.validate(string, dag);
            dag2 = DagUtil.isInt(dag3) ? dag3 : DagUtil.createErrorDag(string + " must be an integer");
            return dag2;
        }
    }

    protected static class DoubleRangeValidator
    extends BaseValidator {
        double min = 0.0;
        double max = 0.0;

        protected DoubleRangeValidator(double d, double d2) {
            this.min = d;
            this.max = d2;
        }

        public Dag validate(String string, Dag dag) {
            double d;
            Dag dag2 = null;
            Dag dag3 = super.validate(string, dag);
            if (DagUtil.isFloat(dag3) && (d = (double)DagUtil.parseFloat(dag3)) >= this.min && d <= this.max) {
                dag2 = dag;
            }
            if (dag2 == null) {
                dag2 = DagUtil.createErrorDag(string + " must be a number in the range " + this.min + ".." + this.max);
            }
            return dag2;
        }
    }

    protected static class BooleanValidator
    extends BaseValidator {
        protected BooleanValidator() {
        }

        public Dag validate(String string, Dag dag) {
            Dag dag2 = null;
            Dag dag3 = super.validate(string, dag);
            if (DagUtil.isNameNamed(dag3, KernelInterfaceProperties.TRUE) || DagUtil.isNameNamed(dag3, KernelInterfaceProperties.FALSE)) {
                dag2 = dag3;
            } else if (DagUtil.isName(dag3)) {
                String string2 = dag3.getData();
                if (KernelInterfaceProperties.TRUE.equalsIgnoreCase(string2)) {
                    dag2 = DagUtil.createNameDag(KernelInterfaceProperties.TRUE);
                } else if (KernelInterfaceProperties.FALSE.equalsIgnoreCase(string2)) {
                    dag2 = DagUtil.createNameDag(KernelInterfaceProperties.FALSE);
                }
            }
            if (dag2 == null) {
                dag2 = DagUtil.createErrorDag(string + " must be true or false");
            }
            return dag2;
        }
    }

    protected static class BaseValidator
    implements Validator {
        protected BaseValidator() {
        }

        public Dag validate(String string, Dag dag) {
            Dag dag2 = null;
            dag2 = dag != null ? (DagUtil.isNameNamed(dag, "default") ? this.getDefaultValue(string) : dag) : DagUtil.createErrorDag("property " + string + " can not be set to NULL");
            return dag2;
        }

        protected Dag getDefaultValue(String string) {
            return (Dag)defaultMap.get(string);
        }
    }

    protected static interface Validator {
        public Dag validate(String var1, Dag var2);
    }
}

