/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client;

import com.maplesoft.client.KernelConnection;
import com.maplesoft.client.KernelListener;
import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.dag.DagConstants;
import com.maplesoft.client.dag.DotMParseError;

public class KernelEvent {
    private int theType;
    private KernelListener source;
    public static final String NULL_DAG_DOTM = "6\"";
    private String streamName;
    private String replyAsText;
    private String replyAsDotM;
    private Dag replyAsDAG;
    private String toKernel;
    private KernelConnection kernelConnection;

    public KernelEvent(int n, char[] cArray, boolean bl, KernelListener kernelListener) {
        if (bl) {
            this.replyAsDotM = new String(cArray);
        } else {
            String string = String.valueOf(cArray);
            this.replyAsText = string.substring(0, string.length() - 1);
            int n2 = this.replyAsText.indexOf(0);
            if (n2 >= 0) {
                this.replyAsText = this.replyAsText.substring(0, n2);
            }
        }
        this.theType = n;
        this.toKernel = null;
        this.source = kernelListener;
        this.streamName = null;
    }

    public KernelEvent(int n, String string, boolean bl, KernelListener kernelListener) {
        this.theType = n;
        if (bl) {
            this.replyAsDotM = string;
        } else {
            this.replyAsText = string;
        }
        this.toKernel = null;
        this.source = kernelListener;
        this.streamName = null;
    }

    public KernelListener getSource() {
        return this.source;
    }

    public void setKernelConnection(KernelConnection kernelConnection) {
        this.kernelConnection = kernelConnection;
    }

    public KernelConnection getKernelConnection() {
        return this.kernelConnection;
    }

    public int getKernelID() {
        return this.kernelConnection == null ? -1 : this.kernelConnection.getKernelID();
    }

    public int getType() {
        return this.theType;
    }

    public void setType(int n) {
        this.theType = n;
    }

    public String getStreamName() {
        return this.streamName;
    }

    public void setStreamName(String string) {
        this.streamName = string;
    }

    public boolean isStreamCall() {
        return this.streamName != null;
    }

    public String getText() {
        if (this.replyAsText == null) {
            this.buildText();
        }
        return this.replyAsText;
    }

    public String getDotm() {
        return this.replyAsDotM;
    }

    public Dag getDag() {
        if (this.replyAsDotM != null && this.replyAsDAG == null) {
            this.buildDAG();
        }
        return this.replyAsDAG;
    }

    public void buildDAG() {
        if (this.replyAsDotM != null && this.replyAsDAG == null) {
            try {
                if (this.replyAsDotM.length() > 16000000) {
                    byte[] byArray = new byte[this.replyAsDotM.length()];
                    this.replyAsDotM.getBytes(0, this.replyAsDotM.length(), byArray, 0);
                    this.replyAsDAG = DagBuilder.createDag(byArray);
                } else {
                    this.replyAsDAG = DagBuilder.createDag(this.replyAsDotM.getBytes());
                }
            }
            catch (DotMParseError dotMParseError) {
                throw dotMParseError;
            }
            catch (Exception exception) {
                this.replyAsDAG = DagConstants.EMPTY;
            }
        }
    }

    private void buildText() {
        if (this.replyAsText == null) {
            this.buildDAG();
            if (this.replyAsDAG != null) {
                Dag dag = DagBuilder.normalize(this.replyAsDAG);
                this.replyAsText = DagBuilder.lPrint(dag);
                if (this.replyAsText != null && this.streamName != null && this.streamName.equals("CHAR") && this.replyAsText.charAt(0) == '\"' && this.replyAsText.charAt(this.replyAsText.length() - 1) == '\"') {
                    this.replyAsText = this.replyAsText.substring(1, this.replyAsText.length() - 1);
                }
            }
        }
    }

    public String getReply() {
        return this.getText();
    }

    public void setResponseForKernel(String string) {
        this.toKernel = string;
    }

    public void setResponseAsDag(Dag dag) {
        this.toKernel = DagBuilder.createDotm(dag, false);
    }

    public void setResponseAsText(String string) {
        this.toKernel = string;
    }

    public void setResponseAsDotM(String string) {
        this.toKernel = string;
    }

    public String getResponseForKernel() {
        return this.toKernel;
    }
}

