/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client;

import com.maplesoft.client.KernelAdapter;
import com.maplesoft.client.KernelEvent;
import com.maplesoft.client.KernelListener;
import com.maplesoft.client.KernelProxy;
import com.maplesoft.client.kernelresult.KernelErrorResult;

public abstract class BlockingEvaluation {
    public static final int WARNING_RESULT = -3;
    public static final int WAITING_FOR_RESULT = -2;
    public static final int NO_RESULT = -1;
    public static final int ERROR_RESULT = 0;
    public static final int TEXT_RESULT = 1;
    public static final int CHAR_RESULT = 2;
    public static final int REAL_MATH_RESULT = 3;
    public static final int SYSTEM_RESULT = 4;
    public static final int PLOT_RESULT = 5;
    public static final int PLOT3D_RESULT = 6;
    public static final int SMARTPLOT_RESULT = 7;
    protected static final long DEFAULT_WAIT_TIMEOUT = 30000L;
    private static final int PROCESS_EVALUATE = 0;
    private static final int PROCESS_URGENT_EVALUATE = 1;
    private static final int PROCESS_INTERNAL_EVALUATE = 2;
    private Object result;
    private Object pendingResult = null;
    private int kernelID;
    private KernelListener parentListener;
    private int resultType = -2;
    private int pendingResultType = -2;
    private int how = 41;
    private long timeout = 30000L;

    protected BlockingEvaluation(int n, KernelListener kernelListener) {
        this.kernelID = n;
        this.parentListener = kernelListener;
    }

    protected BlockingEvaluation(int n, KernelListener kernelListener, int n2) {
        this.kernelID = n;
        this.parentListener = kernelListener;
        this.how = n2;
    }

    protected boolean formatErrorResults() {
        return false;
    }

    protected void setTimeout(long l) {
        this.timeout = l;
    }

    protected long getTimeout() {
        return this.timeout;
    }

    public Object getResult() {
        return this.result;
    }

    public KernelListener getParentListener() {
        return this.parentListener;
    }

    public synchronized void setResultType(int n) {
        this.resultType = n;
    }

    public int getResultType() {
        return this.resultType;
    }

    public synchronized void urgentProcess() {
        this.process(1);
    }

    public synchronized void internalProcess() {
        this.process(2);
    }

    public synchronized void process() {
        this.process(0);
    }

    private synchronized void process(int n) {
        this.result = null;
        KernelProxy kernelProxy = KernelProxy.getInstance();
        if (kernelProxy.isKernelConnectionValid(this.kernelID)) {
            switch (n) {
                case 0: {
                    kernelProxy.evaluate(this.kernelID, this.getBlockingListener(), this.getCommand(), this.how);
                    break;
                }
                case 1: {
                    kernelProxy.urgentEvaluate(this.kernelID, this.getBlockingListener(), this.getCommand(), this.how);
                    break;
                }
                case 2: {
                    kernelProxy.internalEvaluate(this.kernelID, this.getBlockingListener(), this.getCommand(), this.how);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("type of processing not recognized");
                }
            }
            try {
                while (kernelProxy.isKernelConnectionValid(this.kernelID) && this.resultType == -2) {
                    this.wait(this.timeout);
                }
                this.update();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    protected BlockingListener getBlockingListener() {
        return new BlockingListener(this);
    }

    protected abstract String getCommand();

    protected abstract void update();

    public synchronized void setResult(Object object) {
        this.result = object;
        this.notifyAll();
    }

    public synchronized void setPendingResult(Object object, int n) {
        this.pendingResult = object;
        this.pendingResultType = n;
    }

    public synchronized Object getPendingResult() {
        return this.pendingResult;
    }

    public synchronized int getPendingType() {
        return this.pendingResultType;
    }

    public static class BlockingListener
    extends KernelAdapter {
        protected BlockingEvaluation evaluator;

        protected BlockingListener(BlockingEvaluation blockingEvaluation) {
            this.evaluator = blockingEvaluation;
        }

        public boolean processWarning(KernelEvent kernelEvent) {
            String string = null;
            if (this.evaluator.formatErrorResults()) {
                try {
                    KernelErrorResult.FormattedErrorMessage formattedErrorMessage = KernelErrorResult.parseErrorMessage((KernelEvent)kernelEvent);
                    string = formattedErrorMessage.getText();
                }
                catch (Exception exception) {
                    string = "Warning";
                }
            } else {
                string = kernelEvent.getText();
            }
            this.evaluator.setPendingResult(string, -3);
            return true;
        }

        public boolean processError(KernelEvent kernelEvent) {
            this.evaluator.setResultType(0);
            String string = null;
            if (this.evaluator.formatErrorResults()) {
                try {
                    KernelErrorResult.FormattedErrorMessage formattedErrorMessage = KernelErrorResult.parseErrorMessage((KernelEvent)kernelEvent);
                    string = formattedErrorMessage.getText();
                }
                catch (Exception exception) {
                    string = "Error";
                }
            } else {
                string = kernelEvent.getText();
            }
            this.evaluator.setResult(string);
            return true;
        }

        public boolean processText(KernelEvent kernelEvent) {
            this.evaluator.setPendingResult(kernelEvent.getClass(), 1);
            return true;
        }

        public boolean processChar(KernelEvent kernelEvent) {
            this.evaluator.setPendingResult(kernelEvent.getText(), 2);
            return true;
        }

        public boolean processRealMath(KernelEvent kernelEvent) {
            this.evaluator.setPendingResult(kernelEvent.getDag(), 3);
            return true;
        }

        public boolean processSystem(KernelEvent kernelEvent) {
            this.evaluator.setResultType(4);
            this.evaluator.setResult(kernelEvent.getDag());
            return true;
        }

        public boolean processPlot(KernelEvent kernelEvent) {
            this.evaluator.setResultType(5);
            this.evaluator.setResult(kernelEvent.getDag());
            return true;
        }

        public boolean processPlot3D(KernelEvent kernelEvent) {
            System.out.println("process Plot 3D");
            this.evaluator.setResultType(6);
            this.evaluator.setResult(kernelEvent.getDag());
            return true;
        }

        public boolean processSmartPlot(KernelEvent kernelEvent) {
            this.evaluator.setResultType(7);
            this.evaluator.setResult(kernelEvent.getDag());
            return true;
        }

        public boolean processComputationStateChange(KernelEvent kernelEvent) {
            if ((kernelEvent.getStreamName().equals("EVALEND") || kernelEvent.getStreamName().equals("KERNELFAIL")) && this.evaluator.resultType == -2) {
                if (this.evaluator.getPendingResult() != null) {
                    this.evaluator.setResultType(this.evaluator.getPendingType());
                    this.evaluator.setResult(this.evaluator.getPendingResult());
                } else {
                    this.evaluator.setResultType(-1);
                    this.evaluator.setResult(kernelEvent.getDag());
                }
            }
            return true;
        }

        public KernelListener getParentListener() {
            return this.evaluator.getParentListener();
        }
    }
}

