/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.applets;

import com.maplesoft.mathdoc.components.WmiMathMLContextMenuManager;
import com.maplesoft.mathdoc.components.WmiMathMLEditorButtonMenu;
import com.maplesoft.mathdoc.controller.edit.WmiMathMLTransfer;
import com.maplesoft.mathdoc.controller.edit.WmiTransfer;
import com.maplesoft.mathdoc.controller.insert.WmiEntityListCommand;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiFormatException;
import com.maplesoft.mathdoc.exception.WmiModelIndexOutOfBoundsException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.exception.WmiParseException;
import com.maplesoft.mathdoc.io.mathml.WmiMathMLImportParser;
import com.maplesoft.mathdoc.io.mathml.export.WmiMathMLPresentationFormatter;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModelLock;
import com.maplesoft.mathdoc.model.WmiParagraphModel;
import com.maplesoft.mathdoc.model.math.WmiMathOperatorModel;
import com.maplesoft.mathdoc.util.WmiResourcePackage;
import com.maplesoft.mathdoc.view.WmiCaret;
import com.maplesoft.mathdoc.view.WmiMathMLEditorDocumentView;
import com.maplesoft.mathdoc.view.WmiParagraphView;
import com.maplesoft.mathdoc.view.WmiSelection;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import javax.swing.JApplet;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;

public class MathMLEditor
extends JApplet {
    private static final char DOLLAR_SIGN_CHAR = '$';
    private static final String DEFAULT_APPLICATION = "default";
    private static final String MAPLE_TA_APPLICATION = "mapleta";
    private static final String MAPLE_TA_APPLICATION_NO_ITALICS = "mapleta-noitalics";
    private static final String WIDTH_PARAMETER = "mathmlWidth";
    private static final String HEIGHT_PARAMETER = "mathmlHeight";
    private static final String MATHML_PARAMETER = "mathml";
    private static final String BREAK_WIDTH_PARAMETER = "breakWidth";
    private static final String EDITABLE_PARAMETER = "editable";
    private static final String PALETTE_PARAMETER = "palette";
    private static final String PALETTE_CONTENT_PARAMETER = "paletteContent";
    private static final String TOOLBAR_PARAMETER = "toolbar";
    private static final String TOOLTIP_PARAMETER = "tooltip";
    private static final String APPLICATION_PARAMETER = "application";
    private static final String DISABLE_STRETCHY_OPS_PARAMETER = "disableStretchyOperators";
    private static final String EXTENDED_PALETTE = "extended";
    private static final int DEFAULT_WIDTH = 300;
    private static final int DEFAULT_HEIGHT = 400;
    private static final boolean DEFAULT_EXTENDED_PALETTE = false;
    private static final String EMPTY_MATHML = "<math><mrow><mi></mi></mrow></math>";
    private static final String DEFAULT_TOOLTIP = "";
    private static final int WIDTH_ALLOWANCE = 5;
    private static final int HEIGHT_ALLOWANCE = 5;
    private static final int SCROLLBAR_ALLOWANCE = 35;
    private static final int TOOLBAR_BUTTON_WIDTH = 40;
    private static final String RESOURCES = "com.maplesoft.applets.resources.MathMLEditor";
    private WmiResourcePackage resources;
    private int mathmlWidth;
    private int mathmlHeight;
    private int breakWidth;
    private boolean editable;
    private boolean extendedPalette;
    private String mathml;
    private String paletteContent;
    private boolean useToolbar;
    private String tooltip;
    private String application;
    private boolean disableStretchyOperators;
    private WmiMathDocumentModel doc;
    private WmiMathMLEditorDocumentView view;

    public void init() {
        WmiCaret.resetTimer();
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    MathMLEditor.this.resources = WmiResourcePackage.getResourcePackage(MathMLEditor.RESOURCES);
                    MathMLEditor.this.createGUI();
                }
            });
        }
        catch (Exception exception) {
            WmiErrorLog.log(exception);
        }
    }

    public void start() {
        WmiCaret.resetTimer();
        MathMLEditor.disableFocusTraversal(this);
    }

    public static void disableFocusTraversal(Container container) {
        container.setFocusTraversalKeysEnabled(false);
        container.setFocusCycleRoot(true);
    }

    private void createGUI() {
        this.parseParameters();
        this.view = new WmiMathMLEditorDocumentView();
        WmiMathMLEditorDocumentView.setActiveDocumentView(this.view);
        this.view.setBreakWidth(this.breakWidth - 35);
        this.view.setToolTipText(this.tooltip);
        this.doc = (WmiMathDocumentModel)this.view.getModel();
        this.doc.setReadOnly(!this.editable);
        this.setEditAndDisplayOptions(this.application);
        WmiMathMLContextMenuManager wmiMathMLContextMenuManager = null;
        if (this.editable) {
            wmiMathMLContextMenuManager = this.paletteContent == null ? new WmiMathMLContextMenuManager(2, this.view, this.extendedPalette) : new WmiMathMLContextMenuManager(2, this.view, this.paletteContent);
            this.view.setContextManager(wmiMathMLContextMenuManager);
            this.view.addMouseListener(new EditorMouseListener());
        }
        Dimension dimension = new Dimension(this.mathmlWidth, this.mathmlHeight);
        this.view.setSize(dimension);
        this.view.setPreferredSize(dimension);
        this.view.setMinimumSize(dimension);
        this.view.setMaximumSize(dimension);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.setBackground(Color.white);
        JScrollPane jScrollPane = new JScrollPane(this.view, 20, 30);
        if (!this.editable) {
            jScrollPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        }
        JViewport jViewport = jScrollPane.getViewport();
        jPanel.add((Component)jScrollPane, "Center");
        int n = this.getWidth() > 0 ? Math.min(this.mathmlWidth, this.getWidth()) : this.mathmlWidth;
        int n2 = this.getHeight() > 0 ? Math.min(this.mathmlHeight, this.getHeight()) : this.mathmlHeight;
        dimension = new Dimension(n - 5, n2 - 5);
        jViewport.setSize(dimension);
        jViewport.setPreferredSize(dimension);
        jViewport.setMinimumSize(dimension);
        jViewport.setMaximumSize(dimension);
        this.getContentPane().add(jPanel);
        this.parseMathML(this.mathml);
        if (this.useToolbar && this.editable) {
            WmiParagraphModel wmiParagraphModel = new WmiParagraphModel(this.doc);
            WmiMathMLEditorButtonMenu wmiMathMLEditorButtonMenu = (WmiMathMLEditorButtonMenu)wmiMathMLContextMenuManager.getMenuForModel(wmiParagraphModel);
            wmiMathMLEditorButtonMenu.buildForToolbar = true;
            wmiMathMLEditorButtonMenu.setButtonWidth(40);
            wmiMathMLContextMenuManager.setContextForDocument(new WmiParagraphView(wmiParagraphModel, this.view));
            wmiMathMLContextMenuManager.buildMenu();
            wmiMathMLContextMenuManager.setPopupEnabled(false);
            JPanel jPanel2 = new JPanel();
            jPanel2.setBackground(Color.white);
            jPanel2.setLayout(new BorderLayout());
            jPanel2.add((Component)((WmiMathMLEditorButtonMenu)wmiMathMLContextMenuManager.getActiveContextualMenu()).buttonPanel, "Before");
            jPanel.add((Component)jPanel2, "First");
        }
    }

    private void setEditAndDisplayOptions(String string) {
        if (string.startsWith(MAPLE_TA_APPLICATION)) {
            this.view.registerIdentifierCharacter('$');
        }
        if (string.equals(MAPLE_TA_APPLICATION_NO_ITALICS)) {
            this.view.initializeItalicsMode(false);
        }
        if (this.disableStretchyOperators) {
            WmiMathOperatorModel.disableStretchyOps = true;
        }
    }

    private void parseParameters() {
        String string;
        String string2;
        String string3;
        String string4;
        String string5 = this.getParameter(WIDTH_PARAMETER);
        if (string5 != null) {
            try {
                this.mathmlWidth = Integer.parseInt(string5);
            }
            catch (NumberFormatException numberFormatException) {
                this.mathmlWidth = 300;
            }
        } else {
            this.mathmlWidth = 300;
        }
        if ((string4 = this.getParameter(HEIGHT_PARAMETER)) != null) {
            try {
                this.mathmlHeight = Integer.parseInt(string4);
            }
            catch (NumberFormatException numberFormatException) {
                this.mathmlHeight = 400;
            }
        } else {
            this.mathmlHeight = 400;
        }
        if ((string3 = this.getParameter(BREAK_WIDTH_PARAMETER)) != null) {
            try {
                this.breakWidth = Integer.parseInt(string3);
            }
            catch (NumberFormatException numberFormatException) {
                this.breakWidth = this.mathmlWidth;
            }
        } else {
            this.breakWidth = this.mathmlWidth;
        }
        if (this.breakWidth > this.mathmlWidth) {
            this.breakWidth = this.mathmlWidth;
        }
        this.editable = (string2 = this.getParameter(EDITABLE_PARAMETER)) == null || !string2.toLowerCase().equals("false");
        String string6 = this.getParameter(PALETTE_PARAMETER);
        this.extendedPalette = string6 != null && string6.toLowerCase().equals(EXTENDED_PALETTE);
        this.paletteContent = this.getParameter(PALETTE_CONTENT_PARAMETER);
        if (this.paletteContent != null && !this.paletteContent.startsWith("<tb>")) {
            this.paletteContent = this.readPaletteFile(this.paletteContent);
        }
        this.useToolbar = (string = this.getParameter(TOOLBAR_PARAMETER)) != null && string.toLowerCase().equals("true");
        String string7 = this.getParameter(APPLICATION_PARAMETER);
        this.application = string7 != null ? string7.trim().toLowerCase() : DEFAULT_APPLICATION;
        String string8 = this.getParameter(TOOLTIP_PARAMETER);
        this.tooltip = string8 != null ? string8.trim() : DEFAULT_APPLICATION;
        this.mathml = this.getParameter(MATHML_PARAMETER);
        if (this.mathml == null || this.mathml.trim().equals(DEFAULT_TOOLTIP)) {
            this.mathml = EMPTY_MATHML;
        } else if (this.mathml.startsWith("%")) {
            this.mathml = this.decodeMathML(this.mathml);
        }
        String string9 = this.getParameter(DISABLE_STRETCHY_OPS_PARAMETER);
        this.disableStretchyOperators = string9 != null && string9.toLowerCase().trim().equals("true");
    }

    private String readPaletteFile(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            File file = new File(string);
            FileReader fileReader = new FileReader(file);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            String string2 = bufferedReader.readLine();
            while (string2 != null) {
                if (!string2.startsWith("#")) {
                    stringBuffer.append(string2);
                }
                string2 = bufferedReader.readLine();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            WmiErrorLog.log(fileNotFoundException);
        }
        catch (IOException iOException) {
            WmiErrorLog.log(iOException);
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseMathML(String string) {
        block15: {
            Object var2_2 = null;
            if (WmiModelLock.writeLock(this.doc, true)) {
                try {
                    this.doc.removeChildren(0, this.doc.getChildCount());
                    WmiMathMLImportParser wmiMathMLImportParser = new WmiMathMLImportParser();
                    wmiMathMLImportParser.parse(new StringReader(WmiMathMLImportParser.formatInput(string, null, 0)), (WmiCompositeModel)this.doc, 0);
                    if (!WmiModelLock.readLock(this.doc, true)) break block15;
                    try {
                        this.view.updateView();
                    }
                    finally {
                        WmiModelLock.readUnlock(this.doc);
                    }
                }
                catch (WmiNoReadAccessException wmiNoReadAccessException) {
                    WmiErrorLog.log(wmiNoReadAccessException);
                }
                catch (WmiNoWriteAccessException wmiNoWriteAccessException) {
                    WmiErrorLog.log(wmiNoWriteAccessException);
                }
                catch (WmiParseException wmiParseException) {
                    WmiErrorLog.log(wmiParseException);
                }
                catch (WmiModelIndexOutOfBoundsException wmiModelIndexOutOfBoundsException) {
                    WmiErrorLog.log(wmiModelIndexOutOfBoundsException);
                }
                finally {
                    WmiModelLock.writeUnlock(this.doc);
                }
            }
        }
    }

    private String decodeMathML(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        StringBuffer stringBuffer2 = new StringBuffer("XX");
        block6: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '+': {
                    stringBuffer.append(' ');
                    continue block6;
                }
                case '%': {
                    try {
                        stringBuffer2.setCharAt(0, string.charAt(++i));
                        stringBuffer2.setCharAt(1, string.charAt(++i));
                        stringBuffer.append((char)Integer.valueOf(stringBuffer2.toString(), 16).intValue());
                        continue block6;
                    }
                    catch (Exception exception) {
                        return DEFAULT_TOOLTIP;
                    }
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMathML(String string) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiParseException, WmiModelIndexOutOfBoundsException {
        if (string == null || string.trim().equals(DEFAULT_TOOLTIP)) {
            string = EMPTY_MATHML;
        } else if (string.startsWith("%")) {
            string = this.decodeMathML(string);
        }
        Object var2_2 = null;
        boolean bl = false;
        boolean bl2 = false;
        WmiMathMLImportParser wmiMathMLImportParser = new WmiMathMLImportParser();
        try {
            bl = WmiModelLock.writeLock(this.doc, false);
            if (bl) {
                this.doc.removeChildren(0, this.doc.getChildCount());
                string = "<?xml version=\"1.0\" standalone=\"no\" ?>" + string.replaceAll("\\n", DEFAULT_TOOLTIP);
                wmiMathMLImportParser.parse(new StringReader(string), (WmiCompositeModel)this.doc, 0);
                this.view.updateView();
            }
        }
        catch (WmiParseException wmiParseException) {
            String string2 = "<math><mrow><merror>" + this.resources.getStringForKey("ParseErrorMessage") + "</merror></mrow></math>";
            wmiMathMLImportParser.parse(new StringReader(string2), (WmiCompositeModel)this.doc, 0);
            this.view.updateView();
        }
        finally {
            if (bl) {
                WmiModelLock.writeUnlock(this.doc);
            }
            if (bl2) {
                WmiModelLock.readUnlock(this.doc);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPresentationMathML() throws WmiFormatException, WmiNoReadAccessException {
        String string = DEFAULT_TOOLTIP;
        boolean bl = false;
        boolean bl2 = false;
        try {
            bl2 = WmiModelLock.readLock(this.doc, true);
            if (bl2) {
                WmiMathMLPresentationFormatter wmiMathMLPresentationFormatter = new WmiMathMLPresentationFormatter(this.view);
                StringWriter stringWriter = new StringWriter();
                wmiMathMLPresentationFormatter.format(stringWriter, this.doc);
                string = stringWriter.toString();
            }
        }
        finally {
            if (bl2) {
                WmiModelLock.readUnlock(this.doc);
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSelectionPresentationMathML() throws WmiFormatException, WmiNoReadAccessException {
        String string = DEFAULT_TOOLTIP;
        boolean bl = false;
        boolean bl2 = false;
        try {
            WmiSelection wmiSelection;
            WmiTransfer wmiTransfer;
            Object object;
            bl2 = WmiModelLock.readLock(this.doc, true);
            if (bl2 && (object = (wmiTransfer = WmiMathMLTransfer.createTransferable(wmiSelection = this.view.getSelection())).getTransferData(DataFlavor.stringFlavor)) != null && object instanceof String) {
                string = object.toString();
            }
        }
        finally {
            if (bl2) {
                WmiModelLock.readUnlock(this.doc);
            }
        }
        return string;
    }

    public class EditorMouseListener
    implements MouseListener {
        public void mouseClicked(MouseEvent mouseEvent) {
            WmiEntityListCommand.popDownList();
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }
    }
}

