<%@ page contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" language="java"%>

<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn"%>

<%@ taglib uri="http://www.rabago.net/tags-valid2" prefix="html2"%>

<%@ taglib uri="http://struts.apache.org/tags-bean" prefix="bean"%>
<%@ taglib uri="http://struts.apache.org/tags-logic" prefix="logic"%>
<%@ taglib uri="http://struts.apache.org/tags-tiles" prefix="tiles"%>

	<script type="text/javascript">
	var submitted = 0;
	
	function doSubmit(form) {
		if (submitted == 0 && validateAuthorizeActionForm(form)) {
			submitted = submitted+1;
			return true;
		} else {
			return false;
		}
	}
	function doRemoteSubmit() {
		if (submitted == 0) {
			submitted = submitted +1;
			return true;
		} else {
			return false;
		}
	}
	</script>

<fmt:bundle
	basename="com.maplesoft.mapleta.proctor.ApplicationResources">

	<html2:form action="/RequestAuthorization" method="post"
		focus="proctor_uid" validatorForm="AuthorizeActionForm" onsubmit="return doSubmit(this);">

		<%-- keep the parameters alive that allow for authorizations with subsequent requests --%>
		<%-- these are legacy parameters that are not mapped to the action form but need to be included
		 in the request --%>
		<html2:hidden property="requestedTest"
			value="${requestScope.requestedTest}" />
		<html2:hidden property="requestedTestId"
			value="${requestScope.requestedTestId}" />
		<html2:hidden property="showResults"
			value="${requestScope.showResults}" />

		<html2:hidden property="cid" />
		<html2:hidden property="asgn_id" />

		<c:if test="${!empty AuthorizeActionForm.authMessage}" var="msg">
			<table border=1 cellpadding=10 align="center">
				<tr>
					<td>
						<c:out value="${AuthorizeActionForm.authMessage}" escapeXml="false"/>
					</td>
				</tr>
			</table>
		</c:if>

		<%-- Table of student values --%>
		<table border="0" cellpadding="5" style="simple">
			<tr>
				<td>
					<table border="0">
						<html2:field property="studentName">
							<tr>
								<td>
									<html2:label bundle="proctor" />
								</td>
								<td align="right">
									&nbsp;
								</td>
								<td>
									<html2:hidden property="studentName" />
									<c:out value="${AuthorizeActionForm.studentName}" />
								</td>
							</tr>
						</html2:field>
						<html2:field property="sid">
							<tr>
								<td>
									<html2:label bundle="proctor" />
								</td>
								<td align="right">
									&nbsp;
								</td>
								<td>
									<html2:hidden property="studentID" />
									<c:out value="${AuthorizeActionForm.studentID} " />
								</td>
							</tr>
						</html2:field>
						<html2:field property="authType">
							<tr>
								<td>
									<html2:label bundle="proctor" />
								</td>
								<td align="right">
									&nbsp;
								</td>
								<td>
									<html2:hidden property="authType" />
									<fmt:message key="${AuthorizeActionForm.authType}" />
								</td>
							</tr>
						</html2:field>
						<html2:field property="asgnName">
							<tr>
								<td>
									<html2:label bundle="proctor" />
								</td>
								<td align="right">
									&nbsp;
								</td>
								<td>
									<html2:hidden property="asgnName" />
									<c:out value="${AuthorizeActionForm.asgnName }" />
									<%-- remote authorization passes through the legacy code, which uses testName as the key to which assignment is being authorized --%>
									<html2:hidden property="testName"
										value="${AuthorizeActionForm.asgnName}" />
									<html2:hidden property="testId"
										value="${AuthorizeActionForm.asgn_id}" />
								</td>
							</tr>
						</html2:field>
						<html2:field property="className">
							<tr>
								<td>
									<html2:label bundle="proctor" />
								</td>
								<td align="right">
									&nbsp;
								</td>
								<td>
									<html2:hidden property="className" />
									<c:out value="${AuthorizeActionForm.className }" />
								</td>
							</tr>
						</html2:field>
					</table>
				</td>
			</tr>
			<tr>
				<td>
					<hr>
				</td>
			</tr>

			<%-- render the main instruction message --%>

			<tr>
				<td>
					<em class="title"><fmt:message key="AuthorizeActionForm.instruction.msg" />
					</em>
				</td>
			</tr>

			<%--
			render the instruction message that explains a local proctor authorization
			--%>

			<tr>
				<td>
					<fmt:message key="AuthorizeActionForm.instruction1.msg" />
				</td>
			</tr>
			<tr>
				<td>

					<%-- render the proctor credentials table --%>

					<table border="0">

						<%-- render any errors about authorization here --%>
						<tr>
							<td width="150">
								&nbsp;
							</td>
							<td colspan="3">
								<logic:messagesPresent>
									<div class="errorStyle1">
										<html2:messages id="err" message="false" bundle="proctor">
											<c:out value="${err}" />
										</html2:messages>
									</div>
								</logic:messagesPresent>
							</td>
						</tr>
						<tr>
							<td width="150">
								&nbsp;
							</td>
							<td>
								<table border="0">
									<tr>
										<html2:field property="proctor_uid">
											<td>
												<html2:label bundle="proctor" />
											</td>
											<td align="right">
												&nbsp;
											</td>
											<td>
												<html2:text size="20" />
											</td>
										</html2:field>
									</tr>
									<tr>
										<html2:field property="proctor_pwd">
											<td>
												<html2:label bundle="proctor" />
											</td>
											<td align="right">
												&nbsp;
											</td>
											<td>
												<html2:password size="20" />
											</td>
										</html2:field>
									</tr>
								</table>
							</td>
							<td>
								<table>
									<%-- render any client-side validation errors --%>

									<tr>
										<html2:field property="proctor_uid">
											<td>
												&nbsp;
												<html2:error styleClass="errorStyle1" />
											</td>
										</html2:field>
									</tr>
									<tr>
										<html2:field property="proctor_pwd">
											<td>
												&nbsp;
												<html2:error styleClass="errorStyle1" />
											</td>
										</html2:field>
									</tr>
								</table>
							</td>
						</tr>
					</table>
				</td>
			</tr>
			<tr>
				<td>
					<div align="center">
						<fmt:message key="AuthorizeActionForm.submit_local.label"
							var="local" />
						<html2:submit property="authorizationMethod" value="${local}" />
					</div>
				</td>
			</tr>
		</table>
	</html2:form>

	<%-- render the instruction message that explains a remote proctor authorization --%>
	<html2:form action="/RequestAuthorization" method="post" onsubmit="return doRemoteSubmit();">

		<html2:hidden property="testName"
			value="${AuthorizeActionForm.asgnName}" />
		<html2:hidden property="testId"
			value="${AuthorizeActionForm.asgn_id}" />
		<html2:hidden property="modeRequested"
			value="${AuthorizeActionForm.authType}" />

		<table>
			<tr>
				<td>
					<fmt:message key="AuthorizeActionForm.instruction2.msg" />
				</td>
			</tr>

			<tr>
				<td align="center" colspan="3">
					<fmt:message key="AuthorizeActionForm.submit_remote.label"
						var="remote" />
					<html2:submit property="authorizationMethod" value="${remote}" />
				</td>
			</tr>
		</table>

	</html2:form>

</fmt:bundle>

<html2:html2Javascript xmlHttpRequest="false" />

